// primitive.cc
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-11-30 11:56:57 by piumarta on emilia.rd.wdi.disney.com


#include "debug.h"
#include "primitive.h"

#define	USE_FAST_PRIMITIVES


#ifdef NEW_PRIMITIVES
oop  primitiveArguments[56];
#endif


static void initFastPrims(int first, int last)
{
  for (int i= first; i <= last; ++i)
    primitiveFlags[i]|= FastPrimBit;
}


void prim_markArgs(void)
{
#ifdef NEW_PRIMITIVES
  for (int i= 0; i < 56; ++i)
    if (!primitiveArguments[i]->isInteger())
      primitiveArguments[i]->mark();
#endif
}

void prim_mapArgs(void)
{
#ifdef NEW_PRIMITIVES
  for (int i= 0; i < 56; ++i)
    if (!primitiveArguments[i]->isInteger())
      primitiveArguments[i]= primitiveArguments[i]->remap();
#endif
}


void prim_initialise(void)
{
  primitiveTable[250]= (primitive_t)j_clearProfile;
  primitiveTable[251]= (primitive_t)j_dumpProfile;
  primitiveTable[252]= (primitive_t)j_startProfiling;
  primitiveTable[253]= (primitive_t)j_stopProfiling;

  // a sanity check wouldn't hurt
  assert(primitiveTable[140] == primitiveBeep);

#ifdef USE_FAST_PRIMITIVES
  initFastPrims(  0,  69);
  initFastPrims( 73,  76);
  initFastPrims(110, 111);
  initFastPrims(135, 135);
  initFastPrims(138, 139);
  initFastPrims(143, 144);
  initFastPrims(148, 148);
  initFastPrims(256, 519);
#endif

#ifdef NEW_PRIMITIVES
  for (int i= 0; i < 56; ++i)
    primitiveArguments[i]= nilObj;
#endif
}
