/* label.h -- support for long-range labels
 *
 * last edited: Thu Mar 25 04:37:51 1999 by piumarta (Ian Piumarta) on felina
 */

#ifndef __label_h
#define __label_h


typedef struct LabelUse {
  int		   op;		/* encodes client insn */
  void		  *addr;	/* addr of client insn */
  struct LabelUse *next;	/* next label use or 0 */
} LabelUse;

typedef struct
{
  void	   *addr;	/* defined address of label or 0 (forward) */
  LabelUse *uses;	/* list of uses while forward */
} Label;

/* provided by label.c */

Label *lbl_new();
void  *lbl_use(void *pc, int type, Label *lbl);
void   lbl_define(Label *lbl, void *pc);
void   lbl_delete(Label *lbl);

/* provided by platform code generator */

void lbl_resolve(Label *lbl);


#endif /* __label_h */
