'From Squeak2.6 of 11 October 1999 [latest update: #1559] on 2 January 2000 at 10:56:02 pm'!
"Change Set:		Profiler
Date:			2 January 2000
Author:			Ian Piumarta

Support for runtime profiling of static VM code in Unix Squeak.  Requires the `Profiler' plugin which comes with the Unix distribution."!


!SystemDictionary methodsFor: 'profiling' stamp: 'ikp 1/2/2000 21:17'!
clearVMProfile
	"Clear the profile database."

	<primitive: 'clearProfile' module: 'Profiler'>
! !

!SystemDictionary methodsFor: 'profiling' stamp: 'ikp 1/2/2000 21:18'!
dumpVMProfile
	"Dump the profile database to a file."

	<primitive: 'dumpProfile' module: 'Profiler'>
! !

!SystemDictionary methodsFor: 'profiling' stamp: 'ikp 1/2/2000 21:19'!
startVMProfiling
	"Start profiling the virtual machine."

	<primitive: 'startProfiling' module: 'Profiler'>
! !

!SystemDictionary methodsFor: 'profiling' stamp: 'ikp 1/2/2000 21:19'!
stopVMProfiling
	"Stop profiling the virtual machine."

	<primitive: 'stopProfiling' module: 'Profiler'>
! !

!SystemDictionary methodsFor: 'profiling' stamp: 'ikp 1/2/2000 22:52'!
vmProfile: aBlock			"Smalltalk vmProfile: [26 benchFib]"
	"Make a virtual machine profile of the given block."
	"Note: Profiling support is provided so that VM implementors
	 can better understand and improve the efficiency of the virtual
	 machine. To use it, you must be running a version of the
	 virtual machine that supports the Profiler plugin (currently
	 only Unix, maybe others someday)."

	| answer |
	self stopVMProfiling.
	self clearVMProfile.
	self startVMProfiling.
	answer _ aBlock value.
	self stopVMProfiling.
	self dumpVMProfile.
	^answer! !


