/* Automatically generated from Squeak on #(12 February 2001 2:16:06 pm) */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
/*  The virtual machine proxy definition */
#include "sqVirtualMachine.h"
/* Configuration options */
#include "sqConfig.h"
/* Platform specific definitions */
#include "sqPlatformSpecific.h"

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */

/* memory access macros */
#define byteAt(i) (*((unsigned char *) (i)))
#define byteAtput(i, val) (*((unsigned char *) (i)) = val)
#define longAt(i) (*((int *) (i)))
#define longAtput(i, val) (*((int *) (i)) = val)

/*** Variables ***/
static int affectedB;
static int affectedL;
static int affectedR;
static int affectedT;
static int bbH;
static int bbW;
static int bitBltOop;
static int bitCount;
static int clipHeight;
static int clipWidth;
static int clipX;
static int clipY;
static int cmBitsPerColor;
static int cmBlueMask;
static int cmBlueShift;
static int cmDeltaBits;
static int cmGreenMask;
static int cmGreenShift;
static int cmRedMask;
static int cmRedShift;
static int colorMap;
static int combinationRule;
static int destBits;
static int destDelta;
static int destForm;
static int destHeight;
static int destIndex;
static int destMask;
static int destPitch;
static int destPixSize;
static int destWidth;
static int destX;
static int destY;
static const int ditherMatrix4x4[16] = {
0,	8,	2,	10,
12,	4,	14,	6,
3,	11,	1,	9,
15,	7,	13,	5
};
static const int ditherThresholds16[8] = { 0, 2, 4, 6, 8, 12, 14, 16 };
static const int ditherValues16[32] = {
0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30
};
static int dstBitShift;
static int dx;
static int dy;
static int hDir;
static int halftoneBase;
static int halftoneForm;
static int halftoneHeight;
static int hasSurfaceLock;
static int height;
static struct VirtualMachine* interpreterProxy;
static int mask1;
static int mask2;
static int maskTable[33] = {
0, 1, 3, 0, 15, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 65535,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1
};
static const char *moduleName = "BitBltPlugin 12 February 2001 (i)";
static int nWords;
static int noHalftone;
static int noSource;
static int opTable[36];
static int pixPerWord;
static int preload;
static int scanDisplayFlag;
static int scanRightX;
static int scanStart;
static int scanStop;
static int scanStopArray;
static int scanString;
static int scanXTable;
static int skew;
static int sourceAlpha;
static int sourceBits;
static int sourceDelta;
static int sourceForm;
static int sourceIndex;
static int sourcePitch;
static int sourcePixSize;
static int sourceX;
static int sourceY;
static int srcBitShift;
static int srcHeight;
static int srcWidth;
static int stopCode;
static int sx;
static int sy;
static int vDir;
static int warpAlignMask;
static int warpAlignShift;
static int warpBitShiftTable[32];
static int warpSrcMask;
static int warpSrcShift;
static int width;

/*** Function Prototypes ***/
static int OLDrgbDiffwith(int sourceWord, int destinationWord);
static int OLDtallyIntoMapwith(int sourceWord, int destinationWord);
static int addWordwith(int sourceWord, int destinationWord);
static int affectedBottom(void);
static int affectedLeft(void);
static int affectedRight(void);
static int affectedTop(void);
static int alphaBlendwith(int sourceWord, int destinationWord);
static int alphaBlendConstwith(int sourceWord, int destinationWord);
static int alphaBlendConstwithpaintMode(int sourceWord, int destinationWord, int paintMode);
static int alphaBlendScaledwith(int sourceWord, int destinationWord);
static int alphaPaintConstwith(int sourceWord, int destinationWord);
static int alphaSourceBlendBits16(void);
static int alphaSourceBlendBits32(void);
static int alphaSourceBlendBits8(void);
static int bitAndwith(int sourceWord, int destinationWord);
static int bitAndInvertwith(int sourceWord, int destinationWord);
static int bitInvertAndwith(int sourceWord, int destinationWord);
static int bitInvertAndInvertwith(int sourceWord, int destinationWord);
static int bitInvertDestinationwith(int sourceWord, int destinationWord);
static int bitInvertOrwith(int sourceWord, int destinationWord);
static int bitInvertOrInvertwith(int sourceWord, int destinationWord);
static int bitInvertSourcewith(int sourceWord, int destinationWord);
static int bitInvertXorwith(int sourceWord, int destinationWord);
static int bitOrwith(int sourceWord, int destinationWord);
static int bitOrInvertwith(int sourceWord, int destinationWord);
static int bitXorwith(int sourceWord, int destinationWord);
static int checkSourceOverlap(void);
static int clearWordwith(int source, int destination);
static int clipRange(void);
static int colormapAt(int idx);
static int colormapAtput(int idx, int value);
#pragma export on
EXPORT(int) BitBltPlugin_copyBits(void);
EXPORT(int) BitBltPlugin_copyBitsFromtoat(int startX, int stopX, int yValue);
#pragma export off
static int copyBitsLockedAndClipped(void);
static int copyLoop(void);
static int copyLoopNoSource(void);
static int copyLoopPixMap(void);
static unsigned int * default8To32Table(void);
static int deltaFromtonSteps(int x1, int x2, int n);
static int destMaskAndPointerInit(void);
static int destinationWordwith(int sourceWord, int destinationWord);
static int dither32To16threshold(int srcWord, int ditherValue);
static int drawLoopXY(int xDelta, int yDelta);
static int dstLongAt(int idx);
static int dstLongAtput(int idx, int value);
static int dstLongAtputmask(int idx, int srcValue, int dstMask);
static int fetchIntOrFloatofObject(int fieldIndex, int objectPointer);
static int fetchIntegerOrTruncFloatofObject(int fieldIndex, int objectPointer);
#pragma export on
EXPORT(const char*) BitBltPlugin_getModuleName(void);
#pragma export off
static int halftoneAt(int idx);
static int ignoreSourceOrHalftone(int formPointer);
static int initBBOpTable(void);
#pragma export on
EXPORT(int) BitBltPlugin_initialiseModule(void);
#pragma export off
static int loadBitBltDestForm(void);
#pragma export on
EXPORT(int) BitBltPlugin_loadBitBltFrom(int bbObj);
#pragma export off
static int loadBitBltFromwarping(int bbObj, int aBool);
static int loadBitBltSourceForm(void);
static int loadColorMap(int warping);
static int loadHalftoneForm(void);
static int loadScannerFromstartstopstringrightXstopArraydisplayFlag(int bbObj, int start, int stop, int string, int rightX, int stopArray, int displayFlag);
static int loadWarpBltFrom(int bbObj);
static int lockSurfaces(void);
static int mergewith(int sourceWord, int destinationWord);
static int partitionedANDtonBitsnPartitions(int word1, int word2, int nBits, int nParts);
static int partitionedAddtonBitsnPartitions(int word1, int word2, int nBits, int nParts);
static int partitionedMaxwithnBitsnPartitions(int word1, int word2, int nBits, int nParts);
static int partitionedMinwithnBitsnPartitions(int word1, int word2, int nBits, int nParts);
static int partitionedSubfromnBitsnPartitions(int word1, int word2, int nBits, int nParts);
static int performCopyLoop(void);
static int pickSourcePixelsnullMapsrcMaskdestMask(int nPixels, int nullMap, int srcMask, int dstMask);
static int pickWarpPixelAtXy(int xx, int yy);
static int pixMaskwith(int sourceWord, int destinationWord);
static int pixPaintwith(int sourceWord, int destinationWord);
#pragma export on
EXPORT(int) BitBltPlugin_primitiveCopyBits(void);
EXPORT(int) BitBltPlugin_primitiveDisplayString(void);
EXPORT(int) BitBltPlugin_primitiveDrawLoop(void);
EXPORT(int) BitBltPlugin_primitiveScanCharacters(void);
EXPORT(int) BitBltPlugin_primitiveWarpBits(void);
#pragma export off
static int queryDestSurface(int handle);
static int querySourceSurface(int handle);
static int returnAtlastIndexlefttop(int stopIndex, int lastIndex, int left, int top);
static int rgbAddwith(int sourceWord, int destinationWord);
static int rgbDiffwith(int sourceWord, int destinationWord);
static int rgbMap16downTo(int sourcePixel, int nBitsOut);
static int rgbMap16to(int sourcePixel, int nBitsOut);
static int rgbMap16upTo(int sourcePixel, int nBitsOut);
static int rgbMap16To32(int sourcePixel);
static int rgbMap16ToX(int sourcePixel);
static int rgbMap32to(int sourcePixel, int nBitsOut);
static int rgbMap32To32(int sourcePixel);
static int rgbMap32ToX(int sourcePixel);
static int rgbMap(int sourcePixel);
static int rgbMapfromto(int sourcePixel, int nBitsIn, int nBitsOut);
static int rgbMaxwith(int sourceWord, int destinationWord);
static int rgbMinwith(int sourceWord, int destinationWord);
static int rgbMinInvertwith(int wordToInvert, int destinationWord);
static int rgbSubwith(int sourceWord, int destinationWord);
static int scanCharacters(void);
static int scanCharactersLockedAndClipped(void);
#pragma export on
EXPORT(int) BitBltPlugin_setInterpreter(struct VirtualMachine* anInterpreter);
#pragma export off
static int setupColorMasks(void);
static int setupColorMasksFromto(int srcBits, int targetBits);
static int showDisplayBits(void);
static int smoothPixatXfyfdxhdyhdxvdyvpixPerWordpixelMasksourceMap(int n, int xf, int yf, int dxh, int dyh, int dxv, int dyv, int srcPixPerWord, int sourcePixMask, int sourceMap);
static int sourcePixAtXypixPerWord(int x, int y, int srcPixPerWord);
static int sourceSkewAndPointerInit(void);
static int sourceWordwith(int sourceWord, int destinationWord);
static int srcLongAt(int idx);
static int stopReason(void);
static int subWordwith(int sourceWord, int destinationWord);
static int tallyIntoMapwith(int sourceWord, int destinationWord);
static int tryCopyingBitsQuickly(void);
static int unlockSurfaces(void);
static int warpBits(void);
static int warpLoop(void);
static int warpPickSmoothPixelsxDeltahyDeltahxDeltavyDeltavsourceMapsmoothing(int nPixels, int xDeltah, int yDeltah, int xDeltav, int yDeltav, int sourceMap, int n);
static int warpPickSourcePixelsxDeltahyDeltahxDeltavyDeltav(int nPixels, int xDeltah, int yDeltah, int xDeltav, int yDeltav);
static int warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(int nPix, int xDeltah, int yDeltah, int xDeltav, int yDeltav, int n, int sourceMapOop);
static int xWarpLoop(void);


/*	Subract the pixels in the source and destination, color by color,
	and return the sum of the absolute value of all the differences.
	For non-rgb, XOR the two and return the number of differing pixels.
	Note that the region is not clipped to bit boundaries, but only to the
	nearest (enclosing) word.  This is because copyLoop does not do
	pre-merge masking.  For accurate results, you must subtract the
	values obtained from the left and right fringes. */

static int OLDrgbDiffwith(int sourceWord, int destinationWord) {
    int diff;
    int pixMask;

	if (destPixSize < 16) {
		diff = sourceWord ^ destinationWord;
		pixMask = maskTable[destPixSize];
		while (!(diff == 0)) {
			if ((diff & pixMask) != 0) {
				bitCount += 1;
			}
			diff = ((unsigned) diff) >> destPixSize;
		}
		return destinationWord;
	}
	if (destPixSize == 16) {
		diff = partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 5, 3);
		bitCount = ((bitCount + (diff & 31)) + ((((unsigned) diff) >> 5) & 31)) + ((((unsigned) diff) >> 10) & 31);
		diff = partitionedSubfromnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3);
		bitCount = ((bitCount + (diff & 31)) + ((((unsigned) diff) >> 5) & 31)) + ((((unsigned) diff) >> 10) & 31);
	} else {
		diff = partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 8, 3);
		bitCount = ((bitCount + (diff & 255)) + ((((unsigned) diff) >> 8) & 255)) + ((((unsigned) diff) >> 16) & 255);
	}
	return destinationWord;
}


/*	Tally pixels into the color map.  Note that the source should be 
	specified = destination, in order for the proper color map checks 
	to be performed at setup.
	Note that the region is not clipped to bit boundaries, but only to the
	nearest (enclosing) word.  This is because copyLoop does not do
	pre-merge masking.  For accurate results, you must subtract the
	values obtained from the left and right fringes. */

static int OLDtallyIntoMapwith(int sourceWord, int destinationWord) {
    int shiftWord;
    int i;
    int pixMask;
    int mapIndex;
    int srcPix;
    int destPix;
    int d;
    int mask;
    int srcPix1;
    int destPix1;
    int d1;
    int mask3;
    int srcPix2;
    int destPix2;
    int d2;
    int mask4;

	if (colorMap == null) {
		return destinationWord;
	}
	if (destPixSize < 16) {
		pixMask = maskTable[destPixSize];
		shiftWord = destinationWord;
		for (i = 1; i <= pixPerWord; i += 1) {
			mapIndex = shiftWord & pixMask;
			longAtput(colorMap + (mapIndex << 2), (longAt(colorMap + (mapIndex << 2))) + 1);
			shiftWord = ((unsigned) shiftWord) >> destPixSize;
		}
		return destinationWord;
	}
	if (destPixSize == 16) {
		/* begin rgbMap:from:to: */
		if ((d = cmBitsPerColor - 5) > 0) {
			mask = (1 << 5) - 1;
			srcPix = (destinationWord & 65535) << d;
			mask = mask << d;
			destPix = srcPix & mask;
			mask = mask << cmBitsPerColor;
			srcPix = srcPix << d;
			mapIndex = (destPix + (srcPix & mask)) + ((srcPix << d) & (mask << cmBitsPerColor));
			goto l1;
		} else {
			if (d == 0) {
				if (5 == 5) {
					mapIndex = (destinationWord & 65535) & 32767;
					goto l1;
				}
				if (5 == 8) {
					mapIndex = (destinationWord & 65535) & 16777215;
					goto l1;
				}
				mapIndex = destinationWord & 65535;
				goto l1;
			}
			if ((destinationWord & 65535) == 0) {
				mapIndex = destinationWord & 65535;
				goto l1;
			}
			d = 5 - cmBitsPerColor;
			mask = (1 << cmBitsPerColor) - 1;
			srcPix = ((unsigned) (destinationWord & 65535)) >> d;
			destPix = srcPix & mask;
			mask = mask << cmBitsPerColor;
			srcPix = ((unsigned) srcPix) >> d;
			destPix = (destPix + (srcPix & mask)) + ((((unsigned) srcPix) >> d) & (mask << cmBitsPerColor));
			if (destPix == 0) {
				mapIndex = 1;
				goto l1;
			}
			mapIndex = destPix;
			goto l1;
		}
	l1:	/* end rgbMap:from:to: */;
		longAtput(colorMap + (mapIndex << 2), (longAt(colorMap + (mapIndex << 2))) + 1);
		/* begin rgbMap:from:to: */
		if ((d1 = cmBitsPerColor - 5) > 0) {
			mask3 = (1 << 5) - 1;
			srcPix1 = (((unsigned) destinationWord) >> 16) << d1;
			mask3 = mask3 << d1;
			destPix1 = srcPix1 & mask3;
			mask3 = mask3 << cmBitsPerColor;
			srcPix1 = srcPix1 << d1;
			mapIndex = (destPix1 + (srcPix1 & mask3)) + ((srcPix1 << d1) & (mask3 << cmBitsPerColor));
			goto l2;
		} else {
			if (d1 == 0) {
				if (5 == 5) {
					mapIndex = (((unsigned) destinationWord) >> 16) & 32767;
					goto l2;
				}
				if (5 == 8) {
					mapIndex = (((unsigned) destinationWord) >> 16) & 16777215;
					goto l2;
				}
				mapIndex = ((unsigned) destinationWord) >> 16;
				goto l2;
			}
			if ((((unsigned) destinationWord) >> 16) == 0) {
				mapIndex = ((unsigned) destinationWord) >> 16;
				goto l2;
			}
			d1 = 5 - cmBitsPerColor;
			mask3 = (1 << cmBitsPerColor) - 1;
			srcPix1 = ((unsigned) (((unsigned) destinationWord) >> 16)) >> d1;
			destPix1 = srcPix1 & mask3;
			mask3 = mask3 << cmBitsPerColor;
			srcPix1 = ((unsigned) srcPix1) >> d1;
			destPix1 = (destPix1 + (srcPix1 & mask3)) + ((((unsigned) srcPix1) >> d1) & (mask3 << cmBitsPerColor));
			if (destPix1 == 0) {
				mapIndex = 1;
				goto l2;
			}
			mapIndex = destPix1;
			goto l2;
		}
	l2:	/* end rgbMap:from:to: */;
		longAtput(colorMap + (mapIndex << 2), (longAt(colorMap + (mapIndex << 2))) + 1);
	} else {
		/* begin rgbMap:from:to: */
		if ((d2 = cmBitsPerColor - 8) > 0) {
			mask4 = (1 << 8) - 1;
			srcPix2 = destinationWord << d2;
			mask4 = mask4 << d2;
			destPix2 = srcPix2 & mask4;
			mask4 = mask4 << cmBitsPerColor;
			srcPix2 = srcPix2 << d2;
			mapIndex = (destPix2 + (srcPix2 & mask4)) + ((srcPix2 << d2) & (mask4 << cmBitsPerColor));
			goto l3;
		} else {
			if (d2 == 0) {
				if (8 == 5) {
					mapIndex = destinationWord & 32767;
					goto l3;
				}
				if (8 == 8) {
					mapIndex = destinationWord & 16777215;
					goto l3;
				}
				mapIndex = destinationWord;
				goto l3;
			}
			if (destinationWord == 0) {
				mapIndex = destinationWord;
				goto l3;
			}
			d2 = 8 - cmBitsPerColor;
			mask4 = (1 << cmBitsPerColor) - 1;
			srcPix2 = ((unsigned) destinationWord) >> d2;
			destPix2 = srcPix2 & mask4;
			mask4 = mask4 << cmBitsPerColor;
			srcPix2 = ((unsigned) srcPix2) >> d2;
			destPix2 = (destPix2 + (srcPix2 & mask4)) + ((((unsigned) srcPix2) >> d2) & (mask4 << cmBitsPerColor));
			if (destPix2 == 0) {
				mapIndex = 1;
				goto l3;
			}
			mapIndex = destPix2;
			goto l3;
		}
	l3:	/* end rgbMap:from:to: */;
		longAtput(colorMap + (mapIndex << 2), (longAt(colorMap + (mapIndex << 2))) + 1);
	}
	return destinationWord;
}

static int addWordwith(int sourceWord, int destinationWord) {
	return sourceWord + destinationWord;
}

static int affectedBottom(void) {
	return affectedB;
}

static int affectedLeft(void) {
	return affectedL;
}

static int affectedRight(void) {
	return affectedR;
}

static int affectedTop(void) {
	return affectedT;
}


/*	Blend sourceWord with destinationWord, assuming both are 32-bit pixels.
	The source is assumed to have 255*alpha in the high 8 bits of each pixel,
	while the high 8 bits of the destinationWord will be ignored.
	The blend produced is alpha*source + (1-alpha)*dest, with
	the computation being performed independently on each color
	component.  The high byte of the result will be 0. */

static int alphaBlendwith(int sourceWord, int destinationWord) {
    int unAlpha;
    int i;
    int blend;
    int result;
    int colorMask;
    int alpha;
    int shift;


	/* High 8 bits of source pixel */

	alpha = ((unsigned) sourceWord) >> 24;
	if (alpha == 0) {
		return destinationWord;
	}
	if (alpha == 255) {
		return sourceWord;
	}
	unAlpha = 255 - alpha;
	colorMask = 255;

	/* ar 9/9/2000 - include alpha in computation */

	result = 0;
	for (i = 1; i <= 4; i += 1) {
		shift = (i - 1) * 8;
		blend = ((((((((unsigned) sourceWord) >> shift) & colorMask) * alpha) + (((((unsigned) destinationWord) >> shift) & colorMask) * unAlpha)) + 254) / 255) & colorMask;
		result = result | (blend << shift);
	}
	return result;
}

static int alphaBlendConstwith(int sourceWord, int destinationWord) {
	return alphaBlendConstwithpaintMode(sourceWord, destinationWord, 0);
}


/*	Blend sourceWord with destinationWord using a constant alpha.
	Alpha is encoded as 0 meaning 0.0, and 255 meaning 1.0.
	The blend produced is alpha*source + (1.0-alpha)*dest, with the
	computation being performed independently on each color component.
	This function could eventually blend into any depth destination,
	using the same color averaging and mapping as warpBlt.
	paintMode = true means do nothing if the source pixel value is zero. */
/*	This first implementation works with dest depths of 16 and 32 bits only.
	Normal color mapping will allow sources of lower depths in this case,
	and results can be mapped directly by truncation, so no extra color maps are needed.
	To allow storing into any depth will require subsequent addition of two other
	colormaps, as is the case with WarpBlt. */

static int alphaBlendConstwithpaintMode(int sourceWord, int destinationWord, int paintMode) {
    int unAlpha;
    int i;
    int blend;
    int sourceShifted;
    int result;
    int rgbMask;
    int destShifted;
    int j;
    int pixMask;
    int maskShifted;
    int shift;
    int pixBlend;
    int bitsPerColor;
    int sourcePixVal;
    int destPixVal;

	if (destPixSize < 16) {
		return destinationWord;
	}
	unAlpha = 255 - sourceAlpha;
	pixMask = maskTable[destPixSize];
	if (destPixSize == 16) {
		bitsPerColor = 5;
	} else {
		bitsPerColor = 8;
	}
	rgbMask = (1 << bitsPerColor) - 1;
	maskShifted = destMask;
	destShifted = destinationWord;
	sourceShifted = sourceWord;
	result = destinationWord;
	for (j = 1; j <= pixPerWord; j += 1) {
		sourcePixVal = sourceShifted & pixMask;
		if (!(((maskShifted & pixMask) == 0) || (paintMode && (sourcePixVal == 0)))) {
			destPixVal = destShifted & pixMask;
			pixBlend = 0;
			for (i = 1; i <= 3; i += 1) {
				shift = (i - 1) * bitsPerColor;
				blend = ((((((((unsigned) sourcePixVal) >> shift) & rgbMask) * sourceAlpha) + (((((unsigned) destPixVal) >> shift) & rgbMask) * unAlpha)) + 254) / 255) & rgbMask;
				pixBlend = pixBlend | (blend << shift);
			}
			if (destPixSize == 16) {
				result = (result & (~(pixMask << ((j - 1) * 16)))) | (pixBlend << ((j - 1) * 16));
			} else {
				result = pixBlend;
			}
		}
		maskShifted = ((unsigned) maskShifted) >> destPixSize;
		sourceShifted = ((unsigned) sourceShifted) >> destPixSize;
		destShifted = ((unsigned) destShifted) >> destPixSize;
	}
	return result;
}


/*	Blend sourceWord with destinationWord using the alpha value from sourceWord.
	Alpha is encoded as 0 meaning 0.0, and 255 meaning 1.0.
	In contrast to alphaBlend:with: the color produced is

		srcColor + (1-srcAlpha) * dstColor

	e.g., it is assumed that the source color is already scaled. */

static int alphaBlendScaledwith(int sourceWord, int destinationWord) {
    int unAlpha;
    int srcMask;
    int g;
    int b;
    int dstMask;
    int r;
    int a;


	/* High 8 bits of source pixel */

	unAlpha = 255 - (((unsigned) sourceWord) >> 24);
	dstMask = destinationWord;
	srcMask = sourceWord;
	b = (((unsigned) ((dstMask & 255) * unAlpha)) >> 8) + (srcMask & 255);
	if (b > 255) {
		b = 255;
	}
	dstMask = ((unsigned) dstMask) >> 8;
	srcMask = ((unsigned) srcMask) >> 8;
	g = (((unsigned) ((dstMask & 255) * unAlpha)) >> 8) + (srcMask & 255);
	if (g > 255) {
		g = 255;
	}
	dstMask = ((unsigned) dstMask) >> 8;
	srcMask = ((unsigned) srcMask) >> 8;
	r = (((unsigned) ((dstMask & 255) * unAlpha)) >> 8) + (srcMask & 255);
	if (r > 255) {
		r = 255;
	}
	dstMask = ((unsigned) dstMask) >> 8;
	srcMask = ((unsigned) srcMask) >> 8;
	a = (((unsigned) ((dstMask & 255) * unAlpha)) >> 8) + (srcMask & 255);
	if (a > 255) {
		a = 255;
	}
	return (((((a << 8) + r) << 8) + g) << 8) + b;
}

static int alphaPaintConstwith(int sourceWord, int destinationWord) {
	if (sourceWord == 0) {
		return destinationWord;
	}
	return alphaBlendConstwithpaintMode(sourceWord, destinationWord, 1);
}


/*	This version assumes 
		combinationRule = 34
		sourcePixSize = 32
		destPixSize = 16
		sourceForm ~= destForm.
	 */

static int alphaSourceBlendBits16(void) {
    int dstY;
    int ditherThreshold;
    int srcY;
    int sourceWord;
    int deltaY;
    int ditherBase;
    int dstIndex;
    int dstMask;
    int destWord;
    int srcIndex;
    int srcAlpha;
    int deltaX;
    int srcShift;
    int ditherIndex;
    int pv;
    int value;
    int out;
    int threshold;
    int pv1;
    int value1;
    int out1;
    int threshold1;
    int dstValue;
    int dstValue1;


	/* So we can pre-decrement */

	deltaY = bbH + 1;
	srcY = sy;
	dstY = dy;
	if ((dx & 1) == 0) {
		mask1 = 65535;
		srcShift = 16;
	} else {
		mask1 = 4294901760U;
		srcShift = 0;
	}
	while ((deltaY -= 1) != 0) {
		srcIndex = (sourceBits + (srcY * sourcePitch)) + (sx * 4);
		dstIndex = (destBits + (dstY * destPitch)) + ((((int) dx >> 1)) * 4);
		ditherBase = (dstY & 3) * 4;

		/* For pre-increment */

		ditherIndex = (sx & 3) - 1;

		/* So we can pre-decrement */

		deltaX = bbW + 1;
		dstMask = mask1;
		if (dstMask == 65535) {
			srcShift = 16;
		} else {
			srcShift = 0;
		}
		while ((deltaX -= 1) != 0) {
			ditherThreshold = ditherMatrix4x4[ditherBase + (ditherIndex = (ditherIndex + 1) & 3)];
			sourceWord = longAt(srcIndex);
			srcAlpha = ((unsigned) sourceWord) >> 24;
			if (srcAlpha == 255) {
				/* begin dither32To16:threshold: */
				pv = sourceWord & 255;
				threshold = ditherThresholds16[pv & 7];
				value = ditherValues16[((unsigned) pv >> 3)];
				if (ditherThreshold < threshold) {
					out = value + 1;
				} else {
					out = value;
				}
				pv = (((unsigned) sourceWord >> 8)) & 255;
				threshold = ditherThresholds16[pv & 7];
				value = ditherValues16[((unsigned) pv >> 3)];
				if (ditherThreshold < threshold) {
					out = out | (((unsigned) (value + 1) << 5));
				} else {
					out = out | (((unsigned) value << 5));
				}
				pv = (((unsigned) sourceWord >> 16)) & 255;
				threshold = ditherThresholds16[pv & 7];
				value = ditherValues16[((unsigned) pv >> 3)];
				if (ditherThreshold < threshold) {
					out = out | (((unsigned) (value + 1) << 10));
				} else {
					out = out | (((unsigned) value << 10));
				}
				sourceWord = out;
				if (sourceWord == 0) {
					sourceWord = 1;
				}

				/* Store masked value */

				sourceWord = sourceWord << srcShift;
				/* begin dstLongAt:put:mask: */
				dstValue = longAt(dstIndex);
				dstValue = dstValue & dstMask;
				dstValue = dstValue | sourceWord;
				longAtput(dstIndex, dstValue);
			} else {
				if (srcAlpha == 0) {
					null;
				} else {
					destWord = longAt(dstIndex);
					destWord = destWord & (~dstMask);

					/* Expand from 16 to 32 bit by adding zero bits */

					destWord = ((unsigned) destWord) >> srcShift;

					/* Mix colors */

					destWord = ((((unsigned) (destWord & 31744) << 9)) | (((unsigned) (destWord & 992) << 6))) | ((((unsigned) (destWord & 31) << 3)) | 4278190080U);

					/* And dither */

					sourceWord = alphaBlendScaledwith(sourceWord, destWord);
					/* begin dither32To16:threshold: */
					pv1 = sourceWord & 255;
					threshold1 = ditherThresholds16[pv1 & 7];
					value1 = ditherValues16[((unsigned) pv1 >> 3)];
					if (ditherThreshold < threshold1) {
						out1 = value1 + 1;
					} else {
						out1 = value1;
					}
					pv1 = (((unsigned) sourceWord >> 8)) & 255;
					threshold1 = ditherThresholds16[pv1 & 7];
					value1 = ditherValues16[((unsigned) pv1 >> 3)];
					if (ditherThreshold < threshold1) {
						out1 = out1 | (((unsigned) (value1 + 1) << 5));
					} else {
						out1 = out1 | (((unsigned) value1 << 5));
					}
					pv1 = (((unsigned) sourceWord >> 16)) & 255;
					threshold1 = ditherThresholds16[pv1 & 7];
					value1 = ditherValues16[((unsigned) pv1 >> 3)];
					if (ditherThreshold < threshold1) {
						out1 = out1 | (((unsigned) (value1 + 1) << 10));
					} else {
						out1 = out1 | (((unsigned) value1 << 10));
					}
					sourceWord = out1;
					if (sourceWord == 0) {
						sourceWord = 1;
					}

					/* Store back */

					sourceWord = sourceWord << srcShift;
					/* begin dstLongAt:put:mask: */
					dstValue1 = longAt(dstIndex);
					dstValue1 = dstValue1 & dstMask;
					dstValue1 = dstValue1 | sourceWord;
					longAtput(dstIndex, dstValue1);
				}
			}
			srcIndex += 4;
			if (srcShift == 0) {
				dstIndex += 4;
			}

			/* Toggle between 0 and 16 */

			srcShift = srcShift ^ 16;
			dstMask = ~dstMask;
		}
		srcY += 1;
		dstY += 1;
	}
}


/*	This version assumes 
		combinationRule = 34
		sourcePixSize = destPixSize = 32
		sourceForm ~= destForm.
	Note: The inner loop has been optimized for dealing
		with the special cases of srcAlpha = 0.0 and srcAlpha = 1.0 
	 */

static int alphaSourceBlendBits32(void) {
    int dstY;
    int srcY;
    register int sourceWord;
    int deltaY;
    register int dstIndex;
    int destWord;
    register int srcIndex;
    int srcAlpha;
    register int deltaX;


	/* So we can pre-decrement */

	deltaY = bbH + 1;
	srcY = sy;

	/* This is the outer loop */

	dstY = dy;
	while ((deltaY -= 1) != 0) {
		srcIndex = (sourceBits + (srcY * sourcePitch)) + (sx * 4);
		dstIndex = (destBits + (dstY * destPitch)) + (dx * 4);

		/* So we can pre-decrement */
		/* This is the inner loop */

		deltaX = bbW + 1;
		while ((deltaX -= 1) != 0) {
			sourceWord = longAt(srcIndex);
			srcAlpha = ((unsigned) sourceWord) >> 24;
			if (srcAlpha == 255) {
				longAtput(dstIndex, sourceWord);
				srcIndex += 4;

				/* Now copy as many words as possible with alpha = 255 */

				dstIndex += 4;
				while (((deltaX -= 1) != 0) && ((((unsigned) (sourceWord = longAt(srcIndex))) >> 24) == 255)) {
					longAtput(dstIndex, sourceWord);
					srcIndex += 4;
					dstIndex += 4;
				}
				deltaX += 1;
			} else {
				if (srcAlpha == 0) {
					srcIndex += 4;

					/* Now skip as many words as possible, */

					dstIndex += 4;
					while (((deltaX -= 1) != 0) && ((((unsigned) (sourceWord = longAt(srcIndex))) >> 24) == 0)) {
						srcIndex += 4;
						dstIndex += 4;
					}
					deltaX += 1;
				} else {
					destWord = longAt(dstIndex);
					destWord = alphaBlendScaledwith(sourceWord, destWord);
					longAtput(dstIndex, destWord);
					srcIndex += 4;
					dstIndex += 4;
				}
			}
		}
		srcY += 1;
		dstY += 1;
	}
}


/*	This version assumes 
		combinationRule = 34
		sourcePixSize = 32
		destPixSize = 8
		sourceForm ~= destForm.
	Note: This is not real blending since we don't have the source colors available.
	 */

static int alphaSourceBlendBits8(void) {
    int dstY;
    int srcY;
    int sourceWord;
    int deltaY;
    int dstIndex;
    int dstMask;
    int destWord;
    unsigned int *mappingTable;
    int srcIndex;
    int srcAlpha;
    int adjust;
    int deltaX;
    int srcShift;
    int srcPix;
    int destPix;
    int d;
    int mask;
    int dstValue;

	mappingTable = default8To32Table();

	/* So we can pre-decrement */

	deltaY = bbH + 1;
	srcY = sy;
	dstY = dy;
	mask1 = 24 - ((dx & 3) * 8);
	mask2 = 4294967295U ^ (255 << mask1);
	if ((dx & 1) == 0) {
		adjust = 0;
	} else {
		adjust = 522133279;
	}
	if ((dy & 1) == 0) {
		adjust = adjust ^ 522133279;
	}
	while ((deltaY -= 1) != 0) {
		adjust = adjust ^ 522133279;
		srcIndex = (sourceBits + (srcY * sourcePitch)) + (sx * 4);
		dstIndex = (destBits + (dstY * destPitch)) + ((((int) dx >> 2)) * 4);

		/* So we can pre-decrement */

		deltaX = bbW + 1;
		srcShift = mask1;

		/* This is the inner loop */

		dstMask = mask2;
		while ((deltaX -= 1) != 0) {
			sourceWord = ((longAt(srcIndex)) & (~adjust)) + adjust;
			srcAlpha = ((unsigned) sourceWord) >> 24;
			if (srcAlpha > 31) {
				if (srcAlpha < 224) {
					destWord = longAt(dstIndex);
					destWord = destWord & (~dstMask);
					destWord = ((unsigned) destWord) >> srcShift;
					destWord = mappingTable[destWord];
					sourceWord = alphaBlendScaledwith(sourceWord, destWord);
				}
				/* begin rgbMap:from:to: */
				if ((d = cmBitsPerColor - 8) > 0) {
					mask = (1 << 8) - 1;
					srcPix = sourceWord << d;
					mask = mask << d;
					destPix = srcPix & mask;
					mask = mask << cmBitsPerColor;
					srcPix = srcPix << d;
					sourceWord = (destPix + (srcPix & mask)) + ((srcPix << d) & (mask << cmBitsPerColor));
					goto l1;
				} else {
					if (d == 0) {
						if (8 == 5) {
							sourceWord = sourceWord & 32767;
							goto l1;
						}
						if (8 == 8) {
							sourceWord = sourceWord & 16777215;
							goto l1;
						}
						sourceWord = sourceWord;
						goto l1;
					}
					if (sourceWord == 0) {
						sourceWord = sourceWord;
						goto l1;
					}
					d = 8 - cmBitsPerColor;
					mask = (1 << cmBitsPerColor) - 1;
					srcPix = ((unsigned) sourceWord) >> d;
					destPix = srcPix & mask;
					mask = mask << cmBitsPerColor;
					srcPix = ((unsigned) srcPix) >> d;
					destPix = (destPix + (srcPix & mask)) + ((((unsigned) srcPix) >> d) & (mask << cmBitsPerColor));
					if (destPix == 0) {
						sourceWord = 1;
						goto l1;
					}
					sourceWord = destPix;
					goto l1;
				}
			l1:	/* end rgbMap:from:to: */;
				sourceWord = longAt(colorMap + (sourceWord << 2));

				/* Store back */

				sourceWord = sourceWord << srcShift;
				/* begin dstLongAt:put:mask: */
				dstValue = longAt(dstIndex);
				dstValue = dstValue & dstMask;
				dstValue = dstValue | sourceWord;
				longAtput(dstIndex, dstValue);
			}
			srcIndex += 4;
			if (srcShift == 0) {
				dstIndex += 4;
				srcShift = 24;
				dstMask = 16777215;
			} else {
				srcShift -= 8;
				dstMask = (((unsigned) dstMask) >> 8) | 4278190080U;
			}
			adjust = adjust ^ 522133279;
		}
		srcY += 1;
		dstY += 1;
	}
}

static int bitAndwith(int sourceWord, int destinationWord) {
	return sourceWord & destinationWord;
}

static int bitAndInvertwith(int sourceWord, int destinationWord) {
	return sourceWord & (~destinationWord);
}

static int bitInvertAndwith(int sourceWord, int destinationWord) {
	return (~sourceWord) & destinationWord;
}

static int bitInvertAndInvertwith(int sourceWord, int destinationWord) {
	return (~sourceWord) & (~destinationWord);
}

static int bitInvertDestinationwith(int sourceWord, int destinationWord) {
	return ~destinationWord;
}

static int bitInvertOrwith(int sourceWord, int destinationWord) {
	return (~sourceWord) | destinationWord;
}

static int bitInvertOrInvertwith(int sourceWord, int destinationWord) {
	return (~sourceWord) | (~destinationWord);
}

static int bitInvertSourcewith(int sourceWord, int destinationWord) {
	return ~sourceWord;
}

static int bitInvertXorwith(int sourceWord, int destinationWord) {
	return (~sourceWord) ^ destinationWord;
}

static int bitOrwith(int sourceWord, int destinationWord) {
	return sourceWord | destinationWord;
}

static int bitOrInvertwith(int sourceWord, int destinationWord) {
	return sourceWord | (~destinationWord);
}

static int bitXorwith(int sourceWord, int destinationWord) {
	return sourceWord ^ destinationWord;
}


/*	check for possible overlap of source and destination */
/*	ar 10/19/1999: This method requires surfaces to be locked. */

static int checkSourceOverlap(void) {
    int t;

	if ((sourceForm == destForm) && (dy >= sy)) {
		if (dy > sy) {
			vDir = -1;
			sy = (sy + bbH) - 1;
			dy = (dy + bbH) - 1;
		} else {
			if ((dy == sy) && (dx > sx)) {
				hDir = -1;

				/* start at right */

				sx = (sx + bbW) - 1;

				/* and fix up masks */

				dx = (dx + bbW) - 1;
				if (nWords > 1) {
					t = mask1;
					mask1 = mask2;
					mask2 = t;
				}
			}
		}
		destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
		destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	}
}

static int clearWordwith(int source, int destination) {
	return 0;
}


/*	clip and adjust source origin and extent appropriately */
/*	first in x */

static int clipRange(void) {
	if (destX >= clipX) {
		sx = sourceX;
		dx = destX;
		bbW = width;
	} else {
		sx = sourceX + (clipX - destX);
		bbW = width - (clipX - destX);
		dx = clipX;
	}
	if ((dx + bbW) > (clipX + clipWidth)) {
		bbW -= (dx + bbW) - (clipX + clipWidth);
	}
	if (destY >= clipY) {
		sy = sourceY;
		dy = destY;
		bbH = height;
	} else {
		sy = (sourceY + clipY) - destY;
		bbH = height - (clipY - destY);
		dy = clipY;
	}
	if ((dy + bbH) > (clipY + clipHeight)) {
		bbH -= (dy + bbH) - (clipY + clipHeight);
	}
	if (noSource) {
		return null;
	}
	if (sx < 0) {
		dx -= sx;
		bbW += sx;
		sx = 0;
	}
	if ((sx + bbW) > srcWidth) {
		bbW -= (sx + bbW) - srcWidth;
	}
	if (sy < 0) {
		dy -= sy;
		bbH += sy;
		sy = 0;
	}
	if ((sy + bbH) > srcHeight) {
		bbH -= (sy + bbH) - srcHeight;
	}
}


/*	Return the word at position idx from the colorMap */

static int colormapAt(int idx) {
	return longAt(colorMap + (idx << 2));
}


/*	Store the word at position idx in the colorMap */

static int colormapAtput(int idx, int value) {
	return longAtput(colorMap + (idx << 2), value);
}


/*	This function is exported for the Balloon engine */

EXPORT(int) BitBltPlugin_copyBits(void) {
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	clipRange();
	if ((bbW <= 0) || (bbH <= 0)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		return null;
	}
	if (!(lockSurfaces())) {
		return interpreterProxy->primitiveFail();
	}
	/* begin copyBitsLockedAndClipped */
	/* begin tryCopyingBitsQuickly */
	if (noSource) {
		done = 0;
		goto l1;
	}
	if (!(combinationRule == 34)) {
		done = 0;
		goto l1;
	}
	if (!(sourcePixSize == 32)) {
		done = 0;
		goto l1;
	}
	if (sourceForm == destForm) {
		done = 0;
		goto l1;
	}
	if (destPixSize < 8) {
		done = 0;
		goto l1;
	}
	if ((destPixSize == 8) && (colorMap == null)) {
		done = 0;
		goto l1;
	}
	if (destPixSize == 32) {
		alphaSourceBlendBits32();
	}
	if (destPixSize == 16) {
		alphaSourceBlendBits16();
	}
	if (destPixSize == 8) {
		alphaSourceBlendBits8();
	}
	affectedL = dx;
	affectedR = dx + bbW;
	affectedT = dy;
	affectedB = dy + bbH;
	done = 1;
l1:	/* end tryCopyingBitsQuickly */;
	if (done) {
		goto l2;
	}
	if ((combinationRule == 30) || (combinationRule == 31)) {
		if ((interpreterProxy->methodArgumentCount()) == 1) {
			sourceAlpha = interpreterProxy->stackIntegerValue(0);
			if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
				interpreterProxy->pop(1);
			} else {
				interpreterProxy->primitiveFail();
				goto l2;
			}
		} else {
			interpreterProxy->primitiveFail();
			goto l2;
		}
	}
	bitCount = 0;
	/* begin performCopyLoop */
	/* begin destMaskAndPointerInit */
	pixPerM11 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM11);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	if (noSource) {
		copyLoopNoSource();
	} else {
		/* begin checkSourceOverlap */
		if ((sourceForm == destForm) && (dy >= sy)) {
			if (dy > sy) {
				vDir = -1;
				sy = (sy + bbH) - 1;
				dy = (dy + bbH) - 1;
			} else {
				if ((dy == sy) && (dx > sx)) {
					hDir = -1;
					sx = (sx + bbW) - 1;
					dx = (dx + bbW) - 1;
					if (nWords > 1) {
						t = mask1;
						mask1 = mask2;
						mask2 = t;
					}
				}
			}
			destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
			destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
		}
		if ((sourcePixSize != destPixSize) || (colorMap != null)) {
			copyLoopPixMap();
		} else {
			/* begin sourceSkewAndPointerInit */
			pixPerM1 = pixPerWord - 1;
			sxLowBits = sx & pixPerM1;
			dxLowBits = dx & pixPerM1;
			if (hDir > 0) {
				dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
				preload = (sxLowBits + dWid) > pixPerM1;
			} else {
				dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
				preload = ((sxLowBits - dWid) + 1) < 0;
			}
			skew = (sxLowBits - dxLowBits) * destPixSize;
			if (preload) {
				if (skew < 0) {
					skew += 32;
				} else {
					skew -= 32;
				}
			}
			sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
			sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
			if (preload) {
				sourceDelta -= 4 * hDir;
			}
			copyLoop();
		}
	}
	if ((combinationRule == 22) || (combinationRule == 32)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		interpreterProxy->pop(1);
		interpreterProxy->pushInteger(bitCount);
		goto l2;
	}
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
l2:	/* end copyBitsLockedAndClipped */;
	unlockSurfaces();
}


/*	Support for the balloon engine. */

EXPORT(int) BitBltPlugin_copyBitsFromtoat(int startX, int stopX, int yValue) {
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	destX = startX;
	destY = yValue;
	sourceX = startX;
	width = stopX - startX;
	/* begin copyBits */
	clipRange();
	if ((bbW <= 0) || (bbH <= 0)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		goto l1;
	}
	if (!(lockSurfaces())) {
		interpreterProxy->primitiveFail();
		goto l1;
	}
	/* begin copyBitsLockedAndClipped */
	/* begin tryCopyingBitsQuickly */
	if (noSource) {
		done = 0;
		goto l2;
	}
	if (!(combinationRule == 34)) {
		done = 0;
		goto l2;
	}
	if (!(sourcePixSize == 32)) {
		done = 0;
		goto l2;
	}
	if (sourceForm == destForm) {
		done = 0;
		goto l2;
	}
	if (destPixSize < 8) {
		done = 0;
		goto l2;
	}
	if ((destPixSize == 8) && (colorMap == null)) {
		done = 0;
		goto l2;
	}
	if (destPixSize == 32) {
		alphaSourceBlendBits32();
	}
	if (destPixSize == 16) {
		alphaSourceBlendBits16();
	}
	if (destPixSize == 8) {
		alphaSourceBlendBits8();
	}
	affectedL = dx;
	affectedR = dx + bbW;
	affectedT = dy;
	affectedB = dy + bbH;
	done = 1;
l2:	/* end tryCopyingBitsQuickly */;
	if (done) {
		goto l3;
	}
	if ((combinationRule == 30) || (combinationRule == 31)) {
		if ((interpreterProxy->methodArgumentCount()) == 1) {
			sourceAlpha = interpreterProxy->stackIntegerValue(0);
			if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
				interpreterProxy->pop(1);
			} else {
				interpreterProxy->primitiveFail();
				goto l3;
			}
		} else {
			interpreterProxy->primitiveFail();
			goto l3;
		}
	}
	bitCount = 0;
	/* begin performCopyLoop */
	/* begin destMaskAndPointerInit */
	pixPerM11 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM11);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	if (noSource) {
		copyLoopNoSource();
	} else {
		/* begin checkSourceOverlap */
		if ((sourceForm == destForm) && (dy >= sy)) {
			if (dy > sy) {
				vDir = -1;
				sy = (sy + bbH) - 1;
				dy = (dy + bbH) - 1;
			} else {
				if ((dy == sy) && (dx > sx)) {
					hDir = -1;
					sx = (sx + bbW) - 1;
					dx = (dx + bbW) - 1;
					if (nWords > 1) {
						t = mask1;
						mask1 = mask2;
						mask2 = t;
					}
				}
			}
			destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
			destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
		}
		if ((sourcePixSize != destPixSize) || (colorMap != null)) {
			copyLoopPixMap();
		} else {
			/* begin sourceSkewAndPointerInit */
			pixPerM1 = pixPerWord - 1;
			sxLowBits = sx & pixPerM1;
			dxLowBits = dx & pixPerM1;
			if (hDir > 0) {
				dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
				preload = (sxLowBits + dWid) > pixPerM1;
			} else {
				dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
				preload = ((sxLowBits - dWid) + 1) < 0;
			}
			skew = (sxLowBits - dxLowBits) * destPixSize;
			if (preload) {
				if (skew < 0) {
					skew += 32;
				} else {
					skew -= 32;
				}
			}
			sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
			sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
			if (preload) {
				sourceDelta -= 4 * hDir;
			}
			copyLoop();
		}
	}
	if ((combinationRule == 22) || (combinationRule == 32)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		interpreterProxy->pop(1);
		interpreterProxy->pushInteger(bitCount);
		goto l3;
	}
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
l3:	/* end copyBitsLockedAndClipped */;
	unlockSurfaces();
l1:	/* end copyBits */;
	/* begin showDisplayBits */
	interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
}


/*	Perform the actual copyBits operation.
	Assume: Surfaces have been locked and clipping was performed. */

static int copyBitsLockedAndClipped(void) {
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	/* begin tryCopyingBitsQuickly */
	if (noSource) {
		done = 0;
		goto l1;
	}
	if (!(combinationRule == 34)) {
		done = 0;
		goto l1;
	}
	if (!(sourcePixSize == 32)) {
		done = 0;
		goto l1;
	}
	if (sourceForm == destForm) {
		done = 0;
		goto l1;
	}
	if (destPixSize < 8) {
		done = 0;
		goto l1;
	}
	if ((destPixSize == 8) && (colorMap == null)) {
		done = 0;
		goto l1;
	}
	if (destPixSize == 32) {
		alphaSourceBlendBits32();
	}
	if (destPixSize == 16) {
		alphaSourceBlendBits16();
	}
	if (destPixSize == 8) {
		alphaSourceBlendBits8();
	}
	affectedL = dx;
	affectedR = dx + bbW;
	affectedT = dy;
	affectedB = dy + bbH;
	done = 1;
l1:	/* end tryCopyingBitsQuickly */;
	if (done) {
		return null;
	}
	if ((combinationRule == 30) || (combinationRule == 31)) {
		if ((interpreterProxy->methodArgumentCount()) == 1) {
			sourceAlpha = interpreterProxy->stackIntegerValue(0);
			if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
				interpreterProxy->pop(1);
			} else {
				return interpreterProxy->primitiveFail();
			}
		} else {
			return interpreterProxy->primitiveFail();
		}
	}

	/* Choose and perform the actual copy loop. */

	bitCount = 0;
	/* begin performCopyLoop */
	/* begin destMaskAndPointerInit */
	pixPerM11 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM11);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	if (noSource) {
		copyLoopNoSource();
	} else {
		/* begin checkSourceOverlap */
		if ((sourceForm == destForm) && (dy >= sy)) {
			if (dy > sy) {
				vDir = -1;
				sy = (sy + bbH) - 1;
				dy = (dy + bbH) - 1;
			} else {
				if ((dy == sy) && (dx > sx)) {
					hDir = -1;
					sx = (sx + bbW) - 1;
					dx = (dx + bbW) - 1;
					if (nWords > 1) {
						t = mask1;
						mask1 = mask2;
						mask2 = t;
					}
				}
			}
			destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
			destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
		}
		if ((sourcePixSize != destPixSize) || (colorMap != null)) {
			copyLoopPixMap();
		} else {
			/* begin sourceSkewAndPointerInit */
			pixPerM1 = pixPerWord - 1;
			sxLowBits = sx & pixPerM1;
			dxLowBits = dx & pixPerM1;
			if (hDir > 0) {
				dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
				preload = (sxLowBits + dWid) > pixPerM1;
			} else {
				dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
				preload = ((sxLowBits - dWid) + 1) < 0;
			}
			skew = (sxLowBits - dxLowBits) * destPixSize;
			if (preload) {
				if (skew < 0) {
					skew += 32;
				} else {
					skew -= 32;
				}
			}
			sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
			sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
			if (preload) {
				sourceDelta -= 4 * hDir;
			}
			copyLoop();
		}
	}
	if ((combinationRule == 22) || (combinationRule == 32)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		interpreterProxy->pop(1);
		return interpreterProxy->pushInteger(bitCount);
	}
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
}


/*	This version of the inner loop assumes noSource = false. */

static int copyLoop(void) {
    int mergeWord;
    int skewMask;
    int notSkewMask;
    int word;
    int prevWord;
    int unskew;
    int i;
    int (*mergeFnwith)(int, int);
    int halftoneWord;
    int skewWord;
    int y;
    int destWord;
    int hInc;
    int thisWord;

	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;

	/* Byte delta */
	/* degenerate skew fixed for Sparc. 10/20/96 ikp */

	hInc = hDir * 4;
	if (skew == -32) {
		skew = unskew = skewMask = 0;
	} else {
		if (skew < 0) {
			unskew = skew + 32;
			skewMask = 4294967295U << (0 - skew);
		} else {
			if (skew == 0) {
				unskew = 0;
				skewMask = 4294967295U;
			} else {
				unskew = skew - 32;
				skewMask = ((unsigned) 4294967295U) >> skew;
			}
		}
	}
	notSkewMask = ~skewMask;
	if (noHalftone) {
		halftoneWord = 4294967295U;
		halftoneHeight = 0;
	} else {
		halftoneWord = longAt(halftoneBase + ((0 % halftoneHeight) * 4));
	}
	y = dy;
	for (i = 1; i <= bbH; i += 1) {
		if (halftoneHeight > 1) {
			halftoneWord = longAt(halftoneBase + ((y % halftoneHeight) * 4));
			y += vDir;
		}
		if (preload) {
			prevWord = longAt(sourceIndex);
			sourceIndex += hInc;
		} else {
			prevWord = 0;
		}
		destMask = mask1;

		/* pick up next word */

		thisWord = longAt(sourceIndex);
		sourceIndex += hInc;

		/* 32-bit rotate */

		skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
		prevWord = thisWord;
		destWord = longAt(destIndex);
		mergeWord = mergeFnwith(skewWord & halftoneWord, destWord);
		destWord = (destMask & mergeWord) | (destWord & (~destMask));
		longAtput(destIndex, destWord);

		/* This central horizontal loop requires no store masking */

		destIndex += hInc;
		destMask = 4294967295U;
		if (combinationRule == 3) {
			if ((skew == 0) && (halftoneWord == 4294967295U)) {
				for (word = 2; word <= (nWords - 1); word += 1) {
					longAtput(destIndex, prevWord);
					destIndex += hInc;
					prevWord = longAt(sourceIndex);
					sourceIndex += hInc;
				}
			} else {
				for (word = 2; word <= (nWords - 1); word += 1) {
					thisWord = longAt(sourceIndex);
					sourceIndex += hInc;

					/* 32-bit rotate */

					skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
					prevWord = thisWord;
					longAtput(destIndex, skewWord & halftoneWord);
					destIndex += hInc;
				}
			}
		} else {
			for (word = 2; word <= (nWords - 1); word += 1) {

				/* pick up next word */

				thisWord = longAt(sourceIndex);
				sourceIndex += hInc;

				/* 32-bit rotate */

				skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
				prevWord = thisWord;
				mergeWord = mergeFnwith(skewWord & halftoneWord, longAt(destIndex));
				longAtput(destIndex, mergeWord);
				destIndex += hInc;
			}
		}
		if (nWords > 1) {
			destMask = mask2;

			/* pick up next word */

			thisWord = longAt(sourceIndex);
			sourceIndex += hInc;

			/* 32-bit rotate */

			skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
			destWord = longAt(destIndex);
			mergeWord = mergeFnwith(skewWord & halftoneWord, destWord);
			destWord = (destMask & mergeWord) | (destWord & (~destMask));
			longAtput(destIndex, destWord);
			destIndex += hInc;
		}
		sourceIndex += sourceDelta;
		destIndex += destDelta;
	}
}


/*	Faster copyLoop when source not used.  hDir and vDir are both
	positive, and perload and skew are unused */

static int copyLoopNoSource(void) {
    int mergeWord;
    int word;
    int i;
    int (*mergeFnwith)(int, int);
    int halftoneWord;
    int destWord;

	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	for (i = 1; i <= bbH; i += 1) {
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}
		destMask = mask1;
		destWord = longAt(destIndex);
		mergeWord = mergeFnwith(halftoneWord, destWord);
		destWord = (destMask & mergeWord) | (destWord & (~destMask));
		longAtput(destIndex, destWord);

		/* This central horizontal loop requires no store masking */

		destIndex += 4;
		destMask = 4294967295U;
		if (combinationRule == 3) {
			destWord = halftoneWord;
			for (word = 2; word <= (nWords - 1); word += 1) {
				longAtput(destIndex, destWord);
				destIndex += 4;
			}
		} else {
			for (word = 2; word <= (nWords - 1); word += 1) {
				destWord = longAt(destIndex);
				mergeWord = mergeFnwith(halftoneWord, destWord);
				longAtput(destIndex, mergeWord);
				destIndex += 4;
			}
		}
		if (nWords > 1) {
			destMask = mask2;
			destWord = longAt(destIndex);
			mergeWord = mergeFnwith(halftoneWord, destWord);
			destWord = (destMask & mergeWord) | (destWord & (~destMask));
			longAtput(destIndex, destWord);
			destIndex += 4;
		}
		destIndex += destDelta;
	}
}


/*	This version of the inner loop maps source pixels
	to a destination form with different depth.  Because it is already
	unweildy, the loop is not unrolled as in the other versions.
	Preload, skew and skewMask are all overlooked, since pickSourcePixels
	delivers its destination word already properly aligned.
	Note that pickSourcePixels could be copied in-line at the top of
	the horizontal loop, and some of its inits moved out of the loop. */
/*	ar 12/7/1999:
	The loop has been rewritten to use only one pickSourcePixels call.
	The idea is that the call itself could be inlined. If we decide not
	to inline pickSourcePixels we could optimize the loop instead. */

static int copyLoopPixMap(void) {
    int mergeWord;
    int srcPixPerWord;
    int i;
    int (*mergeFnwith)(int, int);
    int destPixMask;
    int nPix;
    int endBits;
    int nSourceIncs;
    int halftoneWord;
    int sourcePixMask;
    int skewWord;
    int words;
    int destWord;
    int nullMap;
    int startBits;
    int dstShift;
    int srcShift;
    int scrStartBits;
    int sourcePix;
    int nPix1;
    int sourceWord;
    int destPix;
    int destWord1;
    int dstShift1;
    int srcShift1;
    int idx;
    int idx1;
    int idx2;

	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	srcPixPerWord = 32 / sourcePixSize;
	sourcePixMask = maskTable[sourcePixSize];
	destPixMask = maskTable[destPixSize];
	nullMap = colorMap == null;
	sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / srcPixPerWord) * 4);
	scrStartBits = srcPixPerWord - (sx & (srcPixPerWord - 1));
	if (bbW < scrStartBits) {
		nSourceIncs = 0;
	} else {
		nSourceIncs = ((bbW - scrStartBits) / srcPixPerWord) + 1;
	}

	/* Note following two items were already calculated in destmask setup! */

	sourceDelta = sourcePitch - (nSourceIncs * 4);
	startBits = pixPerWord - (dx & (pixPerWord - 1));
	endBits = (((dx + bbW) - 1) & (pixPerWord - 1)) + 1;
	if (bbW < startBits) {
		startBits = bbW;
	}
	srcShift = 32 - (((sx & (srcPixPerWord - 1)) + 1) * sourcePixSize);
	dstShift = 32 - (((dx & (pixPerWord - 1)) + 1) * destPixSize);
	for (i = 1; i <= bbH; i += 1) {
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}
		srcBitShift = srcShift;
		dstBitShift = dstShift;
		destMask = mask1;

		/* Here is the horizontal loop... */

		nPix = startBits;
		words = nWords;
		do {
			/* begin pickSourcePixels:nullMap:srcMask:destMask: */
			sourceWord = longAt(sourceIndex);
			destWord1 = 0;
			srcShift1 = srcBitShift;
			dstShift1 = dstBitShift;
			nPix1 = nPix;
			if (nullMap || (sourcePixSize > 8)) {
				if (sourcePixSize <= 8) {
					do {
						destWord1 = destWord1 | ((((((unsigned) sourceWord) >> srcShift1) & sourcePixMask) & destPixMask) << dstShift1);
						dstShift1 -= destPixSize;
						if ((srcShift1 -= sourcePixSize) < 0) {
							srcShift1 += 32;
							/* begin srcLongAt: */
							idx = sourceIndex += 4;
							sourceWord = longAt(idx);
						}
					} while(!((nPix1 -= 1) == 0));
				} else {
					do {
						sourcePix = (((unsigned) sourceWord) >> srcShift1) & sourcePixMask;
						if (cmDeltaBits == 0) {
							destPix = sourcePix;
						} else {
							/* begin rgbMap: */
							if (cmDeltaBits < 0) {
								destPix = (((unsigned) (sourcePix & cmRedMask)) >> cmRedShift) | ((((unsigned) (sourcePix & cmGreenMask)) >> cmGreenShift) | (((unsigned) (sourcePix & cmBlueMask)) >> cmBlueShift));
								goto l1;
							} else {
								destPix = ((sourcePix & cmRedMask) << cmRedShift) | (((sourcePix & cmGreenMask) << cmGreenShift) | ((sourcePix & cmBlueMask) << cmBlueShift));
								goto l1;
							}
						l1:	/* end rgbMap: */;
							if ((destPix == 0) && (sourcePix != 0)) {
								destPix = 1;
							}
						}
						if (!(nullMap)) {
							destPix = longAt(colorMap + (destPix << 2));
						}
						destWord1 = destWord1 | ((destPix & destPixMask) << dstShift1);
						dstShift1 -= destPixSize;
						if ((srcShift1 -= sourcePixSize) < 0) {
							srcShift1 += 32;
							/* begin srcLongAt: */
							idx1 = sourceIndex += 4;
							sourceWord = longAt(idx1);
						}
					} while(!((nPix1 -= 1) == 0));
				}
			} else {
				do {
					sourcePix = (((unsigned) sourceWord) >> srcShift1) & sourcePixMask;
					destPix = (longAt(colorMap + (sourcePix << 2))) & destPixMask;
					destWord1 = destWord1 | (destPix << dstShift1);
					dstShift1 -= destPixSize;
					if ((srcShift1 -= sourcePixSize) < 0) {
						srcShift1 += 32;
						/* begin srcLongAt: */
						idx2 = sourceIndex += 4;
						sourceWord = longAt(idx2);
					}
				} while(!((nPix1 -= 1) == 0));
			}
			srcBitShift = srcShift1;
			dstBitShift = 32 - destPixSize;
			skewWord = destWord1;
			if (destMask == 4294967295U) {
				mergeWord = mergeFnwith(skewWord & halftoneWord, longAt(destIndex));
				longAtput(destIndex, destMask & mergeWord);
			} else {
				destWord = longAt(destIndex);
				mergeWord = mergeFnwith(skewWord & halftoneWord, destWord & destMask);
				destWord = (destMask & mergeWord) | (destWord & (~destMask));
				longAtput(destIndex, destWord);
			}
			destIndex += 4;
			if (words == 2) {
				destMask = mask2;
				nPix = endBits;
			} else {
				destMask = 4294967295U;
				nPix = pixPerWord;
			}
		} while(!((words -= 1) == 0));
		sourceIndex += sourceDelta;
		destIndex += destDelta;
	}
}


/*	Return the default translation table from 1..8 bit indexed colors to 32bit */
/*	The table has been generated by the following statements */
/*	| pvs hex |
	String streamContents:[:s|
		s nextPutAll:'static unsigned int theTable[256] = { '.
		pvs _ (Color colorMapIfNeededFrom: 8 to: 32) asArray.
		1 to: pvs size do:[:i|
			i > 1 ifTrue:[s nextPutAll:', '].
			(i-1 \\ 8) = 0 ifTrue:[s cr].
			s nextPutAll:'0x'.
			hex _ (pvs at: i) printStringBase: 16.
			s nextPutAll: (hex copyFrom: 4 to: hex size).
		].
		s nextPutAll:'};'.
	]. */

static unsigned int * default8To32Table(void) {
    static unsigned int theTable[256] = { 
0x0, 0xFF000001, 0xFFFFFFFF, 0xFF808080, 0xFFFF0000, 0xFF00FF00, 0xFF0000FF, 0xFF00FFFF, 
0xFFFFFF00, 0xFFFF00FF, 0xFF202020, 0xFF404040, 0xFF606060, 0xFF9F9F9F, 0xFFBFBFBF, 0xFFDFDFDF, 
0xFF080808, 0xFF101010, 0xFF181818, 0xFF282828, 0xFF303030, 0xFF383838, 0xFF484848, 0xFF505050, 
0xFF585858, 0xFF686868, 0xFF707070, 0xFF787878, 0xFF878787, 0xFF8F8F8F, 0xFF979797, 0xFFA7A7A7, 
0xFFAFAFAF, 0xFFB7B7B7, 0xFFC7C7C7, 0xFFCFCFCF, 0xFFD7D7D7, 0xFFE7E7E7, 0xFFEFEFEF, 0xFFF7F7F7, 
0xFF000001, 0xFF003300, 0xFF006600, 0xFF009900, 0xFF00CC00, 0xFF00FF00, 0xFF000033, 0xFF003333, 
0xFF006633, 0xFF009933, 0xFF00CC33, 0xFF00FF33, 0xFF000066, 0xFF003366, 0xFF006666, 0xFF009966, 
0xFF00CC66, 0xFF00FF66, 0xFF000099, 0xFF003399, 0xFF006699, 0xFF009999, 0xFF00CC99, 0xFF00FF99, 
0xFF0000CC, 0xFF0033CC, 0xFF0066CC, 0xFF0099CC, 0xFF00CCCC, 0xFF00FFCC, 0xFF0000FF, 0xFF0033FF, 
0xFF0066FF, 0xFF0099FF, 0xFF00CCFF, 0xFF00FFFF, 0xFF330000, 0xFF333300, 0xFF336600, 0xFF339900, 
0xFF33CC00, 0xFF33FF00, 0xFF330033, 0xFF333333, 0xFF336633, 0xFF339933, 0xFF33CC33, 0xFF33FF33, 
0xFF330066, 0xFF333366, 0xFF336666, 0xFF339966, 0xFF33CC66, 0xFF33FF66, 0xFF330099, 0xFF333399, 
0xFF336699, 0xFF339999, 0xFF33CC99, 0xFF33FF99, 0xFF3300CC, 0xFF3333CC, 0xFF3366CC, 0xFF3399CC, 
0xFF33CCCC, 0xFF33FFCC, 0xFF3300FF, 0xFF3333FF, 0xFF3366FF, 0xFF3399FF, 0xFF33CCFF, 0xFF33FFFF, 
0xFF660000, 0xFF663300, 0xFF666600, 0xFF669900, 0xFF66CC00, 0xFF66FF00, 0xFF660033, 0xFF663333, 
0xFF666633, 0xFF669933, 0xFF66CC33, 0xFF66FF33, 0xFF660066, 0xFF663366, 0xFF666666, 0xFF669966, 
0xFF66CC66, 0xFF66FF66, 0xFF660099, 0xFF663399, 0xFF666699, 0xFF669999, 0xFF66CC99, 0xFF66FF99, 
0xFF6600CC, 0xFF6633CC, 0xFF6666CC, 0xFF6699CC, 0xFF66CCCC, 0xFF66FFCC, 0xFF6600FF, 0xFF6633FF, 
0xFF6666FF, 0xFF6699FF, 0xFF66CCFF, 0xFF66FFFF, 0xFF990000, 0xFF993300, 0xFF996600, 0xFF999900, 
0xFF99CC00, 0xFF99FF00, 0xFF990033, 0xFF993333, 0xFF996633, 0xFF999933, 0xFF99CC33, 0xFF99FF33, 
0xFF990066, 0xFF993366, 0xFF996666, 0xFF999966, 0xFF99CC66, 0xFF99FF66, 0xFF990099, 0xFF993399, 
0xFF996699, 0xFF999999, 0xFF99CC99, 0xFF99FF99, 0xFF9900CC, 0xFF9933CC, 0xFF9966CC, 0xFF9999CC, 
0xFF99CCCC, 0xFF99FFCC, 0xFF9900FF, 0xFF9933FF, 0xFF9966FF, 0xFF9999FF, 0xFF99CCFF, 0xFF99FFFF, 
0xFFCC0000, 0xFFCC3300, 0xFFCC6600, 0xFFCC9900, 0xFFCCCC00, 0xFFCCFF00, 0xFFCC0033, 0xFFCC3333, 
0xFFCC6633, 0xFFCC9933, 0xFFCCCC33, 0xFFCCFF33, 0xFFCC0066, 0xFFCC3366, 0xFFCC6666, 0xFFCC9966, 
0xFFCCCC66, 0xFFCCFF66, 0xFFCC0099, 0xFFCC3399, 0xFFCC6699, 0xFFCC9999, 0xFFCCCC99, 0xFFCCFF99, 
0xFFCC00CC, 0xFFCC33CC, 0xFFCC66CC, 0xFFCC99CC, 0xFFCCCCCC, 0xFFCCFFCC, 0xFFCC00FF, 0xFFCC33FF, 
0xFFCC66FF, 0xFFCC99FF, 0xFFCCCCFF, 0xFFCCFFFF, 0xFFFF0000, 0xFFFF3300, 0xFFFF6600, 0xFFFF9900, 
0xFFFFCC00, 0xFFFFFF00, 0xFFFF0033, 0xFFFF3333, 0xFFFF6633, 0xFFFF9933, 0xFFFFCC33, 0xFFFFFF33, 
0xFFFF0066, 0xFFFF3366, 0xFFFF6666, 0xFFFF9966, 0xFFFFCC66, 0xFFFFFF66, 0xFFFF0099, 0xFFFF3399, 
0xFFFF6699, 0xFFFF9999, 0xFFFFCC99, 0xFFFFFF99, 0xFFFF00CC, 0xFFFF33CC, 0xFFFF66CC, 0xFFFF99CC, 
0xFFFFCCCC, 0xFFFFFFCC, 0xFFFF00FF, 0xFFFF33FF, 0xFFFF66FF, 0xFFFF99FF, 0xFFFFCCFF, 0xFFFFFFFF};;

	return theTable;
}


/*	Utility routine for computing Warp increments. */

static int deltaFromtonSteps(int x1, int x2, int n) {
	if (x2 > x1) {
		return (((x2 - x1) + 16384) / (n + 1)) + 1;
	} else {
		if (x2 == x1) {
			return 0;
		}
		return 0 - ((((x1 - x2) + 16384) / (n + 1)) + 1);
	}
}


/*	Compute masks for left and right destination words */

static int destMaskAndPointerInit(void) {
    int pixPerM1;
    int endBits;
    int startBits;


	/* A mask, assuming power of two */
	/* how many pixels in first word */

	pixPerM1 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM1);

	/* how many pixels in last word */

	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM1) + 1;

	/* determine number of words stored per line; merge masks if only 1 */

	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM1) / pixPerWord) + 1;
	}

	/* defaults for no overlap with source */
	/* calculate byte addr and delta, based on first word of data */
	/* Note pitch is bytes and nWords is longs, not bytes */

	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
}

static int destinationWordwith(int sourceWord, int destinationWord) {
	return destinationWord;
}


/*	Dither the given 32bit word to 16 bit. Ignore alpha. */

static int dither32To16threshold(int srcWord, int ditherValue) {
    int pv;
    int value;
    int out;
    int threshold;

	pv = srcWord & 255;
	threshold = ditherThresholds16[pv & 7];
	value = ditherValues16[((unsigned) pv >> 3)];
	if (ditherValue < threshold) {
		out = value + 1;
	} else {
		out = value;
	}
	pv = (((unsigned) srcWord >> 8)) & 255;
	threshold = ditherThresholds16[pv & 7];
	value = ditherValues16[((unsigned) pv >> 3)];
	if (ditherValue < threshold) {
		out = out | (((unsigned) (value + 1) << 5));
	} else {
		out = out | (((unsigned) value << 5));
	}
	pv = (((unsigned) srcWord >> 16)) & 255;
	threshold = ditherThresholds16[pv & 7];
	value = ditherValues16[((unsigned) pv >> 3)];
	if (ditherValue < threshold) {
		out = out | (((unsigned) (value + 1) << 10));
	} else {
		out = out | (((unsigned) value << 10));
	}
	return out;
}


/*	This is the primitive implementation of the line-drawing loop.
	See the comments in BitBlt>>drawLoopX:Y: */

static int drawLoopXY(int xDelta, int yDelta) {
    int i;
    int py;
    int affL;
    int dy1;
    int affR;
    int affB;
    int affT;
    int dx1;
    int px;
    int P;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;
    int done1;
    int pixPerM12;
    int dxLowBits1;
    int dWid1;
    int sxLowBits1;
    int t1;
    int pixPerM111;
    int endBits1;
    int startBits1;

	if (xDelta > 0) {
		dx1 = 1;
	} else {
		if (xDelta == 0) {
			dx1 = 0;
		} else {
			dx1 = -1;
		}
	}
	if (yDelta > 0) {
		dy1 = 1;
	} else {
		if (yDelta == 0) {
			dy1 = 0;
		} else {
			dy1 = -1;
		}
	}
	px = abs(yDelta);
	py = abs(xDelta);

	/* init null rectangle */

	affL = affT = 9999;
	affR = affB = -9999;
	if (py > px) {
		P = ((int) py >> 1);
		for (i = 1; i <= py; i += 1) {
			destX += dx1;
			if ((P -= px) < 0) {
				destY += dy1;
				P += py;
			}
			if (i < py) {
				/* begin copyBits */
				clipRange();
				if ((bbW <= 0) || (bbH <= 0)) {
					affectedL = affectedR = affectedT = affectedB = 0;
					goto l1;
				}
				if (!(lockSurfaces())) {
					interpreterProxy->primitiveFail();
					goto l1;
				}
				/* begin copyBitsLockedAndClipped */
				/* begin tryCopyingBitsQuickly */
				if (noSource) {
					done = 0;
					goto l3;
				}
				if (!(combinationRule == 34)) {
					done = 0;
					goto l3;
				}
				if (!(sourcePixSize == 32)) {
					done = 0;
					goto l3;
				}
				if (sourceForm == destForm) {
					done = 0;
					goto l3;
				}
				if (destPixSize < 8) {
					done = 0;
					goto l3;
				}
				if ((destPixSize == 8) && (colorMap == null)) {
					done = 0;
					goto l3;
				}
				if (destPixSize == 32) {
					alphaSourceBlendBits32();
				}
				if (destPixSize == 16) {
					alphaSourceBlendBits16();
				}
				if (destPixSize == 8) {
					alphaSourceBlendBits8();
				}
				affectedL = dx;
				affectedR = dx + bbW;
				affectedT = dy;
				affectedB = dy + bbH;
				done = 1;
			l3:	/* end tryCopyingBitsQuickly */;
				if (done) {
					goto l4;
				}
				if ((combinationRule == 30) || (combinationRule == 31)) {
					if ((interpreterProxy->methodArgumentCount()) == 1) {
						sourceAlpha = interpreterProxy->stackIntegerValue(0);
						if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
							interpreterProxy->pop(1);
						} else {
							interpreterProxy->primitiveFail();
							goto l4;
						}
					} else {
						interpreterProxy->primitiveFail();
						goto l4;
					}
				}
				bitCount = 0;
				/* begin performCopyLoop */
				/* begin destMaskAndPointerInit */
				pixPerM11 = pixPerWord - 1;
				startBits = pixPerWord - (dx & pixPerM11);
				mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
				endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
				mask2 = 4294967295U << (32 - (endBits * destPixSize));
				if (bbW < startBits) {
					mask1 = mask1 & mask2;
					mask2 = 0;
					nWords = 1;
				} else {
					nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
				}
				hDir = vDir = 1;
				destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
				destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
				if (noSource) {
					copyLoopNoSource();
				} else {
					/* begin checkSourceOverlap */
					if ((sourceForm == destForm) && (dy >= sy)) {
						if (dy > sy) {
							vDir = -1;
							sy = (sy + bbH) - 1;
							dy = (dy + bbH) - 1;
						} else {
							if ((dy == sy) && (dx > sx)) {
								hDir = -1;
								sx = (sx + bbW) - 1;
								dx = (dx + bbW) - 1;
								if (nWords > 1) {
									t = mask1;
									mask1 = mask2;
									mask2 = t;
								}
							}
						}
						destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
						destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					}
					if ((sourcePixSize != destPixSize) || (colorMap != null)) {
						copyLoopPixMap();
					} else {
						/* begin sourceSkewAndPointerInit */
						pixPerM1 = pixPerWord - 1;
						sxLowBits = sx & pixPerM1;
						dxLowBits = dx & pixPerM1;
						if (hDir > 0) {
							dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
							preload = (sxLowBits + dWid) > pixPerM1;
						} else {
							dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
							preload = ((sxLowBits - dWid) + 1) < 0;
						}
						skew = (sxLowBits - dxLowBits) * destPixSize;
						if (preload) {
							if (skew < 0) {
								skew += 32;
							} else {
								skew -= 32;
							}
						}
						sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
						sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
						if (preload) {
							sourceDelta -= 4 * hDir;
						}
						copyLoop();
					}
				}
				if ((combinationRule == 22) || (combinationRule == 32)) {
					affectedL = affectedR = affectedT = affectedB = 0;
					interpreterProxy->pop(1);
					interpreterProxy->pushInteger(bitCount);
					goto l4;
				}
				if (hDir > 0) {
					affectedL = dx;
					affectedR = dx + bbW;
				} else {
					affectedL = (dx - bbW) + 1;
					affectedR = dx + 1;
				}
				if (vDir > 0) {
					affectedT = dy;
					affectedB = dy + bbH;
				} else {
					affectedT = (dy - bbH) + 1;
					affectedB = dy + 1;
				}
			l4:	/* end copyBitsLockedAndClipped */;
				unlockSurfaces();
			l1:	/* end copyBits */;
				if (interpreterProxy->failed()) {
					return null;
				}
				if ((affectedL < affectedR) && (affectedT < affectedB)) {
					affL = ((affL < affectedL) ? affL : affectedL);
					affR = ((affR < affectedR) ? affectedR : affR);
					affT = ((affT < affectedT) ? affT : affectedT);
					affB = ((affB < affectedB) ? affectedB : affB);
					if (((affR - affL) * (affB - affT)) > 4000) {
						affectedL = affL;
						affectedR = affR;
						affectedT = affT;
						affectedB = affB;
						/* begin showDisplayBits */
						interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);

						/* init null rectangle */

						affL = affT = 9999;
						affR = affB = -9999;
					}
				}
			}
		}
	} else {
		P = ((int) px >> 1);
		for (i = 1; i <= px; i += 1) {
			destY += dy1;
			if ((P -= py) < 0) {
				destX += dx1;
				P += px;
			}
			if (i < px) {
				/* begin copyBits */
				clipRange();
				if ((bbW <= 0) || (bbH <= 0)) {
					affectedL = affectedR = affectedT = affectedB = 0;
					goto l2;
				}
				if (!(lockSurfaces())) {
					interpreterProxy->primitiveFail();
					goto l2;
				}
				/* begin copyBitsLockedAndClipped */
				/* begin tryCopyingBitsQuickly */
				if (noSource) {
					done1 = 0;
					goto l5;
				}
				if (!(combinationRule == 34)) {
					done1 = 0;
					goto l5;
				}
				if (!(sourcePixSize == 32)) {
					done1 = 0;
					goto l5;
				}
				if (sourceForm == destForm) {
					done1 = 0;
					goto l5;
				}
				if (destPixSize < 8) {
					done1 = 0;
					goto l5;
				}
				if ((destPixSize == 8) && (colorMap == null)) {
					done1 = 0;
					goto l5;
				}
				if (destPixSize == 32) {
					alphaSourceBlendBits32();
				}
				if (destPixSize == 16) {
					alphaSourceBlendBits16();
				}
				if (destPixSize == 8) {
					alphaSourceBlendBits8();
				}
				affectedL = dx;
				affectedR = dx + bbW;
				affectedT = dy;
				affectedB = dy + bbH;
				done1 = 1;
			l5:	/* end tryCopyingBitsQuickly */;
				if (done1) {
					goto l6;
				}
				if ((combinationRule == 30) || (combinationRule == 31)) {
					if ((interpreterProxy->methodArgumentCount()) == 1) {
						sourceAlpha = interpreterProxy->stackIntegerValue(0);
						if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
							interpreterProxy->pop(1);
						} else {
							interpreterProxy->primitiveFail();
							goto l6;
						}
					} else {
						interpreterProxy->primitiveFail();
						goto l6;
					}
				}
				bitCount = 0;
				/* begin performCopyLoop */
				/* begin destMaskAndPointerInit */
				pixPerM111 = pixPerWord - 1;
				startBits1 = pixPerWord - (dx & pixPerM111);
				mask1 = ((unsigned) 4294967295U) >> (32 - (startBits1 * destPixSize));
				endBits1 = (((dx + bbW) - 1) & pixPerM111) + 1;
				mask2 = 4294967295U << (32 - (endBits1 * destPixSize));
				if (bbW < startBits1) {
					mask1 = mask1 & mask2;
					mask2 = 0;
					nWords = 1;
				} else {
					nWords = (((bbW - startBits1) + pixPerM111) / pixPerWord) + 1;
				}
				hDir = vDir = 1;
				destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
				destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
				if (noSource) {
					copyLoopNoSource();
				} else {
					/* begin checkSourceOverlap */
					if ((sourceForm == destForm) && (dy >= sy)) {
						if (dy > sy) {
							vDir = -1;
							sy = (sy + bbH) - 1;
							dy = (dy + bbH) - 1;
						} else {
							if ((dy == sy) && (dx > sx)) {
								hDir = -1;
								sx = (sx + bbW) - 1;
								dx = (dx + bbW) - 1;
								if (nWords > 1) {
									t1 = mask1;
									mask1 = mask2;
									mask2 = t1;
								}
							}
						}
						destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
						destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					}
					if ((sourcePixSize != destPixSize) || (colorMap != null)) {
						copyLoopPixMap();
					} else {
						/* begin sourceSkewAndPointerInit */
						pixPerM12 = pixPerWord - 1;
						sxLowBits1 = sx & pixPerM12;
						dxLowBits1 = dx & pixPerM12;
						if (hDir > 0) {
							dWid1 = ((bbW < (pixPerWord - dxLowBits1)) ? bbW : (pixPerWord - dxLowBits1));
							preload = (sxLowBits1 + dWid1) > pixPerM12;
						} else {
							dWid1 = ((bbW < (dxLowBits1 + 1)) ? bbW : (dxLowBits1 + 1));
							preload = ((sxLowBits1 - dWid1) + 1) < 0;
						}
						skew = (sxLowBits1 - dxLowBits1) * destPixSize;
						if (preload) {
							if (skew < 0) {
								skew += 32;
							} else {
								skew -= 32;
							}
						}
						sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
						sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
						if (preload) {
							sourceDelta -= 4 * hDir;
						}
						copyLoop();
					}
				}
				if ((combinationRule == 22) || (combinationRule == 32)) {
					affectedL = affectedR = affectedT = affectedB = 0;
					interpreterProxy->pop(1);
					interpreterProxy->pushInteger(bitCount);
					goto l6;
				}
				if (hDir > 0) {
					affectedL = dx;
					affectedR = dx + bbW;
				} else {
					affectedL = (dx - bbW) + 1;
					affectedR = dx + 1;
				}
				if (vDir > 0) {
					affectedT = dy;
					affectedB = dy + bbH;
				} else {
					affectedT = (dy - bbH) + 1;
					affectedB = dy + 1;
				}
			l6:	/* end copyBitsLockedAndClipped */;
				unlockSurfaces();
			l2:	/* end copyBits */;
				if (interpreterProxy->failed()) {
					return null;
				}
				if ((affectedL < affectedR) && (affectedT < affectedB)) {
					affL = ((affL < affectedL) ? affL : affectedL);
					affR = ((affR < affectedR) ? affectedR : affR);
					affT = ((affT < affectedT) ? affT : affectedT);
					affB = ((affB < affectedB) ? affectedB : affB);
					if (((affR - affL) * (affB - affT)) > 4000) {
						affectedL = affL;
						affectedR = affR;
						affectedT = affT;
						affectedB = affB;
						/* begin showDisplayBits */
						interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);

						/* init null rectangle */

						affL = affT = 9999;
						affR = affB = -9999;
					}
				}
			}
		}
	}
	affectedL = affL;
	affectedR = affR;
	affectedT = affT;

	/* store destX, Y back */

	affectedB = affB;
	interpreterProxy->storeIntegerofObjectwithValue(4, bitBltOop, destX);
	interpreterProxy->storeIntegerofObjectwithValue(5, bitBltOop, destY);
}

static int dstLongAt(int idx) {
	return longAt(idx);
}

static int dstLongAtput(int idx, int value) {
	return longAtput(idx, value);
}


/*	Store the given value back into destination form, using dstMask
	to mask out the bits to be modified. This is an essiantial
	read-modify-write operation on the destination form. */

static int dstLongAtputmask(int idx, int srcValue, int dstMask) {
    int dstValue;

	dstValue = longAt(idx);
	dstValue = dstValue & dstMask;
	dstValue = dstValue | srcValue;
	longAtput(idx, dstValue);
}


/*	Return the integer value of the given field of the given object. If the field contains a Float, truncate it and return its integral part. Fail if the given field does not contain a small integer or Float, or if the truncated Float is out of the range of small integers. */

static int fetchIntOrFloatofObject(int fieldIndex, int objectPointer) {
    double floatValue;
    int fieldOop;

	fieldOop = interpreterProxy->fetchPointerofObject(fieldIndex, objectPointer);
	if ((fieldOop & 1)) {
		return (fieldOop >> 1);
	}
	floatValue = interpreterProxy->floatValueOf(fieldOop);
	if (!((-2.147483648e9 <= floatValue) && (floatValue <= 2.147483647e9))) {
		interpreterProxy->primitiveFail();
		return 0;
	}
	return ((int) floatValue );
}


/*	Return the integer value of the given field of the given object. If the field contains a Float, truncate it and return its integral part. Fail if the given field does not contain a small integer or Float, or if the truncated Float is out of the range of small integers. */

static int fetchIntegerOrTruncFloatofObject(int fieldIndex, int objectPointer) {
    double floatValue;
    int fieldOop;

	fieldOop = interpreterProxy->fetchPointerofObject(fieldIndex, objectPointer);
	if ((fieldOop & 1)) {
		return (fieldOop >> 1);
	}
	floatValue = interpreterProxy->floatValueOf(fieldOop);
	if (!((-2.147483648e9 <= floatValue) && (floatValue <= 2.147483647e9))) {
		interpreterProxy->primitiveFail();
		return 0;
	}
	return ((int) floatValue );
}


/*	Note: This is hardcoded so it can be run from Squeak.
	The module name is used for validating a module *after*
	it is loaded to check if it does really contain the module
	we're thinking it contains. This is important! */

EXPORT(const char*) BitBltPlugin_getModuleName(void) {
	return moduleName;
}


/*	Return a value from the halftone pattern. */

static int halftoneAt(int idx) {
	return longAt(halftoneBase + ((idx % halftoneHeight) * 4));
}

static int ignoreSourceOrHalftone(int formPointer) {
	if (formPointer == (interpreterProxy->nilObject())) {
		return 1;
	}
	if (combinationRule == 0) {
		return 1;
	}
	if (combinationRule == 5) {
		return 1;
	}
	if (combinationRule == 10) {
		return 1;
	}
	if (combinationRule == 15) {
		return 1;
	}
	return 0;
}

static int initBBOpTable(void) {
	opTable[0+1] = (int)clearWordwith;
	opTable[1+1] = (int)bitAndwith;
	opTable[2+1] = (int)bitAndInvertwith;
	opTable[3+1] = (int)sourceWordwith;
	opTable[4+1] = (int)bitInvertAndwith;
	opTable[5+1] = (int)destinationWordwith;
	opTable[6+1] = (int)bitXorwith;
	opTable[7+1] = (int)bitOrwith;
	opTable[8+1] = (int)bitInvertAndInvertwith;
	opTable[9+1] = (int)bitInvertXorwith;
	opTable[10+1] = (int)bitInvertDestinationwith;
	opTable[11+1] = (int)bitOrInvertwith;
	opTable[12+1] = (int)bitInvertSourcewith;
	opTable[13+1] = (int)bitInvertOrwith;
	opTable[14+1] = (int)bitInvertOrInvertwith;
	opTable[15+1] = (int)destinationWordwith;
	opTable[16+1] = (int)destinationWordwith;
	opTable[17+1] = (int)destinationWordwith;
	opTable[18+1] = (int)addWordwith;
	opTable[19+1] = (int)subWordwith;
	opTable[20+1] = (int)rgbAddwith;
	opTable[21+1] = (int)rgbSubwith;
	opTable[22+1] = (int)OLDrgbDiffwith;
	opTable[23+1] = (int)OLDtallyIntoMapwith;
	opTable[24+1] = (int)alphaBlendwith;
	opTable[25+1] = (int)pixPaintwith;
	opTable[26+1] = (int)pixMaskwith;
	opTable[27+1] = (int)rgbMaxwith;
	opTable[28+1] = (int)rgbMinwith;
	opTable[29+1] = (int)rgbMinInvertwith;
	opTable[30+1] = (int)alphaBlendConstwith;
	opTable[31+1] = (int)alphaPaintConstwith;
	opTable[32+1] = (int)rgbDiffwith;
	opTable[33+1] = (int)tallyIntoMapwith;
	opTable[34+1] = (int)alphaBlendScaledwith;
}

EXPORT(int) BitBltPlugin_initialiseModule(void) {
	initBBOpTable();
	return 1;
}


/*	Load the dest form for BitBlt. Return false if anything is wrong, true otherwise. */

static int loadBitBltDestForm(void) {
    int destBitsSize;

	destBits = interpreterProxy->fetchPointerofObject(0, destForm);
	destWidth = interpreterProxy->fetchIntegerofObject(1, destForm);
	destHeight = interpreterProxy->fetchIntegerofObject(2, destForm);
	if (!((destWidth >= 0) && (destHeight >= 0))) {
		return 0;
	}

	/* Ignore an integer bits handle for Display in which case 
	the appropriate values will be obtained by calling ioLockSurfaceBits(). */

	destPixSize = interpreterProxy->fetchIntegerofObject(3, destForm);
	if ((destBits & 1)) {
				return 0;
;
		pixPerWord = 32 / destPixSize;
		destBits = destPitch = 0;
	} else {
		pixPerWord = 32 / destPixSize;
		destPitch = ((destWidth + (pixPerWord - 1)) / pixPerWord) * 4;
		destBitsSize = interpreterProxy->byteSizeOf(destBits);
		if (!((interpreterProxy->isWordsOrBytes(destBits)) && (destBitsSize == (destPitch * destHeight)))) {
			return 0;
		}
		destBits = ((int) (interpreterProxy->firstIndexableField(destBits)));
	}
	return 1;
}


/*	Load BitBlt from the oop.
	This function is exported for the Balloon engine. */

EXPORT(int) BitBltPlugin_loadBitBltFrom(int bbObj) {
	return loadBitBltFromwarping(bbObj, 0);
}


/*	Load context from BitBlt instance.  Return false if anything is amiss */
/*	NOTE this should all be changed to minX/maxX coordinates for simpler clipping
		-- once it works! */

static int loadBitBltFromwarping(int bbObj, int aBool) {
    int ok;
    int cmSize;
    int formPointer;
    int formPointer1;
    int halftoneBits;
    int sourceBitsSize;
    int sourcePixPerWord;
    int destBitsSize;

	bitBltOop = bbObj;

	/* Assume no color map */

	colorMap = null;
	combinationRule = interpreterProxy->fetchIntegerofObject(3, bitBltOop);
	if ((interpreterProxy->failed()) || ((combinationRule < 0) || (combinationRule > (36 - 2)))) {
		return 0;
	}
	if ((combinationRule >= 16) && (combinationRule <= 17)) {
		return 0;
	}
	sourceForm = interpreterProxy->fetchPointerofObject(1, bitBltOop);
	/* begin ignoreSourceOrHalftone: */
	formPointer = sourceForm;
	if (formPointer == (interpreterProxy->nilObject())) {
		noSource = 1;
		goto l2;
	}
	if (combinationRule == 0) {
		noSource = 1;
		goto l2;
	}
	if (combinationRule == 5) {
		noSource = 1;
		goto l2;
	}
	if (combinationRule == 10) {
		noSource = 1;
		goto l2;
	}
	if (combinationRule == 15) {
		noSource = 1;
		goto l2;
	}
	noSource = 0;
l2:	/* end ignoreSourceOrHalftone: */;
	halftoneForm = interpreterProxy->fetchPointerofObject(2, bitBltOop);
	/* begin ignoreSourceOrHalftone: */
	formPointer1 = halftoneForm;
	if (formPointer1 == (interpreterProxy->nilObject())) {
		noHalftone = 1;
		goto l3;
	}
	if (combinationRule == 0) {
		noHalftone = 1;
		goto l3;
	}
	if (combinationRule == 5) {
		noHalftone = 1;
		goto l3;
	}
	if (combinationRule == 10) {
		noHalftone = 1;
		goto l3;
	}
	if (combinationRule == 15) {
		noHalftone = 1;
		goto l3;
	}
	noHalftone = 0;
l3:	/* end ignoreSourceOrHalftone: */;
	destForm = interpreterProxy->fetchPointerofObject(0, bbObj);
	if (!((interpreterProxy->isPointers(destForm)) && ((interpreterProxy->slotSizeOf(destForm)) >= 4))) {
		return 0;
	}
	/* begin loadBitBltDestForm */
	destBits = interpreterProxy->fetchPointerofObject(0, destForm);
	destWidth = interpreterProxy->fetchIntegerofObject(1, destForm);
	destHeight = interpreterProxy->fetchIntegerofObject(2, destForm);
	if (!((destWidth >= 0) && (destHeight >= 0))) {
		ok = 0;
		goto l6;
	}
	destPixSize = interpreterProxy->fetchIntegerofObject(3, destForm);
	if ((destBits & 1)) {
				ok = 0;
		goto l6;
;
		pixPerWord = 32 / destPixSize;
		destBits = destPitch = 0;
	} else {
		pixPerWord = 32 / destPixSize;
		destPitch = ((destWidth + (pixPerWord - 1)) / pixPerWord) * 4;
		destBitsSize = interpreterProxy->byteSizeOf(destBits);
		if (!((interpreterProxy->isWordsOrBytes(destBits)) && (destBitsSize == (destPitch * destHeight)))) {
			ok = 0;
			goto l6;
		}
		destBits = ((int) (interpreterProxy->firstIndexableField(destBits)));
	}
	ok = 1;
l6:	/* end loadBitBltDestForm */;
	if (!(ok)) {
		return 0;
	}
	destX = fetchIntOrFloatofObject(4, bitBltOop);
	destY = fetchIntOrFloatofObject(5, bitBltOop);
	width = fetchIntOrFloatofObject(6, bitBltOop);
	height = fetchIntOrFloatofObject(7, bitBltOop);
	if (interpreterProxy->failed()) {
		return 0;
	}
	if (noSource) {
		sourceX = sourceY = 0;
	} else {
		if (!((interpreterProxy->isPointers(sourceForm)) && ((interpreterProxy->slotSizeOf(sourceForm)) >= 4))) {
			return 0;
		}
		/* begin loadBitBltSourceForm */
		sourceBits = interpreterProxy->fetchPointerofObject(0, sourceForm);
		srcWidth = fetchIntOrFloatofObject(1, sourceForm);
		srcHeight = fetchIntOrFloatofObject(2, sourceForm);
		if (!((srcWidth >= 0) && (srcHeight >= 0))) {
			ok = 0;
			goto l5;
		}
		sourcePixSize = interpreterProxy->fetchIntegerofObject(3, sourceForm);
		if ((sourceBits & 1)) {
						ok = 0;
			goto l5;
;
			sourcePixPerWord = 32 / sourcePixSize;
			sourceBits = sourcePitch = 0;
		} else {
			sourcePixPerWord = 32 / sourcePixSize;
			sourcePitch = ((srcWidth + (sourcePixPerWord - 1)) / sourcePixPerWord) * 4;
			sourceBitsSize = interpreterProxy->byteSizeOf(sourceBits);
			if (!((interpreterProxy->isWordsOrBytes(sourceBits)) && (sourceBitsSize == (sourcePitch * srcHeight)))) {
				ok = 0;
				goto l5;
			}
			sourceBits = ((int) (interpreterProxy->firstIndexableField(sourceBits)));
		}
		ok = 1;
	l5:	/* end loadBitBltSourceForm */;
		if (!(ok)) {
			return 0;
		}
		colorMap = interpreterProxy->fetchPointerofObject(14, bitBltOop);
		/* begin loadColorMap: */
		cmBitsPerColor = 0;
		if (colorMap == (interpreterProxy->nilObject())) {
			colorMap = null;
		} else {
			if (interpreterProxy->isWords(colorMap)) {
				cmSize = interpreterProxy->slotSizeOf(colorMap);
				if (cmSize == 512) {
					cmBitsPerColor = 3;
				}
				if (cmSize == 4096) {
					cmBitsPerColor = 4;
				}
				if (cmSize == 32768) {
					cmBitsPerColor = 5;
				}
				if (!(aBool)) {
					if (sourcePixSize <= 8) {
						if (!(cmSize == (1 << sourcePixSize))) {
							ok = 0;
							goto l1;
						}
					} else {
						if (cmBitsPerColor == 0) {
							ok = 0;
							goto l1;
						}
					}
				}
				colorMap = ((int) (interpreterProxy->firstIndexableField(colorMap)));
				setupColorMasks();
			} else {
				ok = 0;
				goto l1;
			}
		}
		ok = 1;
	l1:	/* end loadColorMap: */;
		if (!(ok)) {
			return 0;
		}
		setupColorMasks();
		sourceX = fetchIntOrFloatofObject(8, bitBltOop);
		sourceY = fetchIntOrFloatofObject(9, bitBltOop);
	}
	/* begin loadHalftoneForm */
	if (noHalftone) {
		halftoneBase = null;
		ok = 1;
		goto l4;
	}
	if ((interpreterProxy->isPointers(halftoneForm)) && ((interpreterProxy->slotSizeOf(halftoneForm)) >= 4)) {
		halftoneBits = interpreterProxy->fetchPointerofObject(0, halftoneForm);
		halftoneHeight = interpreterProxy->fetchIntegerofObject(2, halftoneForm);
		if (!(interpreterProxy->isWords(halftoneBits))) {
			noHalftone = 1;
		}
	} else {
		if (!((!(interpreterProxy->isPointers(halftoneForm))) && (interpreterProxy->isWords(halftoneForm)))) {
			ok = 0;
			goto l4;
		}
		halftoneBits = halftoneForm;
		halftoneHeight = interpreterProxy->slotSizeOf(halftoneBits);
	}
	halftoneBase = ((int) (interpreterProxy->firstIndexableField(halftoneBits)));
	ok = 1;
l4:	/* end loadHalftoneForm */;
	if (!(ok)) {
		return 0;
	}
	clipX = fetchIntOrFloatofObject(10, bitBltOop);
	clipY = fetchIntOrFloatofObject(11, bitBltOop);
	clipWidth = fetchIntOrFloatofObject(12, bitBltOop);
	clipHeight = fetchIntOrFloatofObject(13, bitBltOop);
	if (interpreterProxy->failed()) {
		return 0;
	}
	if (clipX < 0) {
		clipWidth += clipX;
		clipX = 0;
	}
	if (clipY < 0) {
		clipHeight += clipY;
		clipY = 0;
	}
	if ((clipX + clipWidth) > destWidth) {
		clipWidth = destWidth - clipX;
	}
	if ((clipY + clipHeight) > destHeight) {
		clipHeight = destHeight - clipY;
	}
	return 1;
}


/*	Load the source form for BitBlt. Return false if anything is wrong, true otherwise. */

static int loadBitBltSourceForm(void) {
    int sourceBitsSize;
    int sourcePixPerWord;

	sourceBits = interpreterProxy->fetchPointerofObject(0, sourceForm);
	srcWidth = fetchIntOrFloatofObject(1, sourceForm);
	srcHeight = fetchIntOrFloatofObject(2, sourceForm);
	if (!((srcWidth >= 0) && (srcHeight >= 0))) {
		return 0;
	}

	/* Ignore an integer bits handle for Display in which case 
	the appropriate values will be obtained by calling ioLockSurfaceBits(). */

	sourcePixSize = interpreterProxy->fetchIntegerofObject(3, sourceForm);
	if ((sourceBits & 1)) {
				return 0;
;
		sourcePixPerWord = 32 / sourcePixSize;
		sourceBits = sourcePitch = 0;
	} else {
		sourcePixPerWord = 32 / sourcePixSize;
		sourcePitch = ((srcWidth + (sourcePixPerWord - 1)) / sourcePixPerWord) * 4;
		sourceBitsSize = interpreterProxy->byteSizeOf(sourceBits);
		if (!((interpreterProxy->isWordsOrBytes(sourceBits)) && (sourceBitsSize == (sourcePitch * srcHeight)))) {
			return 0;
		}
		sourceBits = ((int) (interpreterProxy->firstIndexableField(sourceBits)));
	}
	return 1;
}


/*	ColorMap, if not nil, must be longWords, and 
	2^N long, where N = sourcePixSize for 1, 2, 4, 8 bits, 
	or N = 9, 12, or 15 (3, 4, 5 bits per color) for 16 or 32 bits. */

static int loadColorMap(int warping) {
    int cmSize;

	cmBitsPerColor = 0;
	if (colorMap == (interpreterProxy->nilObject())) {
		colorMap = null;
	} else {
		if (interpreterProxy->isWords(colorMap)) {
			cmSize = interpreterProxy->slotSizeOf(colorMap);
			if (cmSize == 512) {
				cmBitsPerColor = 3;
			}
			if (cmSize == 4096) {
				cmBitsPerColor = 4;
			}
			if (cmSize == 32768) {
				cmBitsPerColor = 5;
			}
			if (!(warping)) {
				if (sourcePixSize <= 8) {
					if (!(cmSize == (1 << sourcePixSize))) {
						return 0;
					}
				} else {
					if (cmBitsPerColor == 0) {
						return 0;
					}
				}
			}
			colorMap = ((int) (interpreterProxy->firstIndexableField(colorMap)));
			setupColorMasks();
		} else {
			return 0;
		}
	}
	return 1;
}


/*	Load the halftone form */

static int loadHalftoneForm(void) {
    int halftoneBits;

	if (noHalftone) {
		halftoneBase = null;
		return 1;
	}
	if ((interpreterProxy->isPointers(halftoneForm)) && ((interpreterProxy->slotSizeOf(halftoneForm)) >= 4)) {
		halftoneBits = interpreterProxy->fetchPointerofObject(0, halftoneForm);
		halftoneHeight = interpreterProxy->fetchIntegerofObject(2, halftoneForm);
		if (!(interpreterProxy->isWords(halftoneBits))) {
			noHalftone = 1;
		}
	} else {
		if (!((!(interpreterProxy->isPointers(halftoneForm))) && (interpreterProxy->isWords(halftoneForm)))) {
			return 0;
		}
		halftoneBits = halftoneForm;
		halftoneHeight = interpreterProxy->slotSizeOf(halftoneBits);
	}
	halftoneBase = ((int) (interpreterProxy->firstIndexableField(halftoneBits)));
	return 1;
}

static int loadScannerFromstartstopstringrightXstopArraydisplayFlag(int bbObj, int start, int stop, int string, int rightX, int stopArray, int displayFlag) {
	scanStart = start;
	scanStop = stop;
	scanString = string;
	scanRightX = rightX;
	scanStopArray = stopArray;
	scanDisplayFlag = displayFlag;
	interpreterProxy->success((interpreterProxy->isPointers(scanStopArray)) && ((interpreterProxy->slotSizeOf(scanStopArray)) >= 1));
	scanXTable = interpreterProxy->fetchPointerofObject(16, bbObj);
	interpreterProxy->success((interpreterProxy->isPointers(scanXTable)) && ((interpreterProxy->slotSizeOf(scanXTable)) >= 1));
	interpreterProxy->storeIntegerofObjectwithValue(6, bbObj, 0);
	interpreterProxy->storeIntegerofObjectwithValue(8, bbObj, 0);
	if (scanDisplayFlag) {
		interpreterProxy->success(loadBitBltFromwarping(bbObj, 0));
	} else {
		bitBltOop = bbObj;
		destX = fetchIntOrFloatofObject(4, bbObj);
	}
	return !(interpreterProxy->failed());
}

static int loadWarpBltFrom(int bbObj) {
	return loadBitBltFromwarping(bbObj, 1);
}


/*	Get a pointer to the bits of any OS surfaces. */
/*	Note: The VM support code must robustly handle multiple attempts to lock
	the same surface and return the same values since one might blt just a portion
	of the surface from one location to another (see below; ioLockSurfaceBits()
	is called twice if sourceForm == destForm). */
/*	Note: It is possible to query for the actual regions (e.g., after clipping)
	that might be affected by the BB operation during ioLockSurfaceBits since
	clipping is always performed before ioLockSurfaceBits is called. This
	might an improvement on some platforms (e.g., Unix w/ X-Windows) where
	getting actual bits requires a round-trip to the server. Right now we don't
	have accessors for these values (basically sx, sy, dx, dy, bbW, and bbH)
	but it would be trivial to add them -- iff somebody is interested... */
/*	ar 10/20/1999: Just noted that the above is not true for scanCharacters... */
/*	ar 10/19/1999: This *should* be inlined but how do we pass a pointer to the pitch
	of the surfaces in this case?! */

static int lockSurfaces(void) {
    int surfaceHandle;

	hasSurfaceLock = 0;
	if (destBits == 0) {

		/* destBits _ self cCode: 'ioLockSurfaceBits(surfaceHandle, &destPitch)'. */

		surfaceHandle = interpreterProxy->fetchIntegerofObject(0, destForm);
		hasSurfaceLock = 1;
	}
	if ((sourceBits == 0) && (!noSource)) {

		/* sourceBits _ self cCode:'ioLockSurfaceBits(surfaceHandle, &sourcePitch)'. */

		surfaceHandle = interpreterProxy->fetchIntegerofObject(0, sourceForm);
		hasSurfaceLock = 1;
	}
	return (destBits != 0) && ((sourceBits != 0) || (noSource));
}


/*	Sender warpLoop is too big to include this in-line */

static int mergewith(int sourceWord, int destinationWord) {
    int (*mergeFnwith)(int, int);

	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	return mergeFnwith(sourceWord, destinationWord);
}


/*	AND word1 to word2 as nParts partitions of nBits each.
	Any field of word1 not all-ones is treated as all-zeroes.
	Used for erasing, eg, brush shapes prior to ORing in a color */

static int partitionedANDtonBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int i;
    int result;
    int mask;


	/* partition mask starts at the right */

	mask = maskTable[nBits];
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		if ((word1 & mask) == mask) {
			result = result | (word2 & mask);
		}

		/* slide left to next partition */

		mask = mask << nBits;
	}
	return result;
}


/*	Add word1 to word2 as nParts partitions of nBits each.
	This is useful for packed pixels, or packed colors */

static int partitionedAddtonBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int i;
    int result;
    int mask;
    int sum;


	/* partition mask starts at the right */

	mask = maskTable[nBits];
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		sum = (word1 & mask) + (word2 & mask);
		if (sum <= mask) {
			result = result | sum;
		} else {
			result = result | mask;
		}

		/* slide left to next partition */

		mask = mask << nBits;
	}
	return result;
}


/*	Max word1 to word2 as nParts partitions of nBits each */

static int partitionedMaxwithnBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int i;
    int result;
    int mask;


	/* partition mask starts at the right */

	mask = maskTable[nBits];
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		result = result | ((((word2 & mask) < (word1 & mask)) ? (word1 & mask) : (word2 & mask)));

		/* slide left to next partition */

		mask = mask << nBits;
	}
	return result;
}


/*	Min word1 to word2 as nParts partitions of nBits each */

static int partitionedMinwithnBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int i;
    int result;
    int mask;


	/* partition mask starts at the right */

	mask = maskTable[nBits];
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		result = result | ((((word2 & mask) < (word1 & mask)) ? (word2 & mask) : (word1 & mask)));

		/* slide left to next partition */

		mask = mask << nBits;
	}
	return result;
}


/*	Subtract word1 from word2 as nParts partitions of nBits each.
	This is useful for packed pixels, or packed colors */

static int partitionedSubfromnBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int i;
    int p2;
    int result;
    int mask;
    int p1;


	/* partition mask starts at the right */

	mask = maskTable[nBits];
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		p1 = word1 & mask;
		p2 = word2 & mask;
		if (p1 < p2) {
			result = result | (p2 - p1);
		} else {
			result = result | (p1 - p2);
		}

		/* slide left to next partition */

		mask = mask << nBits;
	}
	return result;
}


/*	Based on the values provided during setup choose and
	perform the appropriate inner loop function. */

static int performCopyLoop(void) {
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	/* begin destMaskAndPointerInit */
	pixPerM11 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM11);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	if (noSource) {
		copyLoopNoSource();
	} else {
		/* begin checkSourceOverlap */
		if ((sourceForm == destForm) && (dy >= sy)) {
			if (dy > sy) {
				vDir = -1;
				sy = (sy + bbH) - 1;
				dy = (dy + bbH) - 1;
			} else {
				if ((dy == sy) && (dx > sx)) {
					hDir = -1;
					sx = (sx + bbW) - 1;
					dx = (dx + bbW) - 1;
					if (nWords > 1) {
						t = mask1;
						mask1 = mask2;
						mask2 = t;
					}
				}
			}
			destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
			destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
		}
		if ((sourcePixSize != destPixSize) || (colorMap != null)) {
			copyLoopPixMap();
		} else {
			/* begin sourceSkewAndPointerInit */
			pixPerM1 = pixPerWord - 1;
			sxLowBits = sx & pixPerM1;
			dxLowBits = dx & pixPerM1;
			if (hDir > 0) {
				dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
				preload = (sxLowBits + dWid) > pixPerM1;
			} else {
				dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
				preload = ((sxLowBits - dWid) + 1) < 0;
			}
			skew = (sxLowBits - dxLowBits) * destPixSize;
			if (preload) {
				if (skew < 0) {
					skew += 32;
				} else {
					skew -= 32;
				}
			}
			sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
			sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
			if (preload) {
				sourceDelta -= 4 * hDir;
			}
			copyLoop();
		}
	}
}


/*	Pick nPix pixels starting at srcBitIndex from the source, map by the
	color map, and justify them according to dstBitIndex in the resulting destWord.
	Incoming pixels of 16 or 32 bits are first reduced to cmBitsPerColor.
	With no color map, pixels are just masked or zero-filled or
	if 16- or 32-bit pixels, the r, g, and b are so treated individually. */
/*	ar 12/7/1999:
	- the method currently has a side effect (see at the end)
	- the idea is to inline this into a single sender and do 
	most of the color space stuff here
	- the '[...] whileFalse' is intended to generate 
	'do { ... } while(...)' loops which are faster */

static int pickSourcePixelsnullMapsrcMaskdestMask(int nPixels, int nullMap, int srcMask, int dstMask) {
    int sourcePix;
    int nPix;
    int sourceWord;
    int destPix;
    int destWord;
    int dstShift;
    int srcShift;
    int idx;
    int idx1;
    int idx2;

	sourceWord = longAt(sourceIndex);
	destWord = 0;

	/* Hint: Keep in register */

	srcShift = srcBitShift;

	/* Hint: Keep in register */

	dstShift = dstBitShift;

	/* always > 0 so we can use do { } while(--nPix); */

	nPix = nPixels;
	if (nullMap || (sourcePixSize > 8)) {
		if (sourcePixSize <= 8) {
			do {
				destWord = destWord | ((((((unsigned) sourceWord) >> srcShift) & srcMask) & dstMask) << dstShift);
				dstShift -= destPixSize;
				if ((srcShift -= sourcePixSize) < 0) {
					srcShift += 32;
					/* begin srcLongAt: */
					idx = sourceIndex += 4;
					sourceWord = longAt(idx);
				}
			} while(!((nPix -= 1) == 0));
		} else {
			do {

				/* map the pixel(either into colorMap or destFormat) */

				sourcePix = (((unsigned) sourceWord) >> srcShift) & srcMask;
				if (cmDeltaBits == 0) {
					destPix = sourcePix;
				} else {
					/* begin rgbMap: */
					if (cmDeltaBits < 0) {
						destPix = (((unsigned) (sourcePix & cmRedMask)) >> cmRedShift) | ((((unsigned) (sourcePix & cmGreenMask)) >> cmGreenShift) | (((unsigned) (sourcePix & cmBlueMask)) >> cmBlueShift));
						goto l1;
					} else {
						destPix = ((sourcePix & cmRedMask) << cmRedShift) | (((sourcePix & cmGreenMask) << cmGreenShift) | ((sourcePix & cmBlueMask) << cmBlueShift));
						goto l1;
					}
				l1:	/* end rgbMap: */;
					if ((destPix == 0) && (sourcePix != 0)) {
						destPix = 1;
					}
				}
				if (!(nullMap)) {
					destPix = longAt(colorMap + (destPix << 2));
				}
				destWord = destWord | ((destPix & dstMask) << dstShift);

				/* Adjust source if at pixel boundary */

				dstShift -= destPixSize;
				if ((srcShift -= sourcePixSize) < 0) {
					srcShift += 32;
					/* begin srcLongAt: */
					idx1 = sourceIndex += 4;
					sourceWord = longAt(idx1);
				}
			} while(!((nPix -= 1) == 0));
		}
	} else {
		do {

			/* Map it by color map */

			sourcePix = (((unsigned) sourceWord) >> srcShift) & srcMask;

			/* **** How do we find out if we have to do color space conversion here **** */
			/* Mix it in */

			destPix = (longAt(colorMap + (sourcePix << 2))) & dstMask;

			/* adjust shift */

			destWord = destWord | (destPix << dstShift);

			/* Adjust source if at pixel boundary */

			dstShift -= destPixSize;
			if ((srcShift -= sourcePixSize) < 0) {
				srcShift += 32;
				/* begin srcLongAt: */
				idx2 = sourceIndex += 4;
				sourceWord = longAt(idx2);
			}
		} while(!((nPix -= 1) == 0));
	}

	/* Store back */
	/* *** side effect *** */
	/* *** only the first pixel fetch can be unaligned *** */
	/* *** prepare the next one for aligned access *** */

	srcBitShift = srcShift;

	/* Shift towards leftmost pixel */

	dstBitShift = 32 - destPixSize;
	return destWord;
}


/*	Pick a single pixel from the source for WarpBlt.
	Note: This method is crucial for WarpBlt speed w/o smoothing
	and still relatively important when smoothing is used. */

static int pickWarpPixelAtXy(int xx, int yy) {
    int x;
    int sourcePix;
    int sourceWord;
    int y;
    int srcIndex;

	if ((xx < 0) || ((yy < 0) || (((x = ((unsigned) xx) >> 14) >= srcWidth) || ((y = ((unsigned) yy) >> 14) >= srcHeight)))) {
		return 0;
	}
	srcIndex = (sourceBits + (y * sourcePitch)) + ((((unsigned) x) >> warpAlignShift) * 4);

	/* Extract pixel from word */

	sourceWord = longAt(srcIndex);
	srcBitShift = warpBitShiftTable[x & warpAlignMask];
	sourcePix = (((unsigned) sourceWord) >> srcBitShift) & warpSrcMask;
	return sourcePix;
}

static int pixMaskwith(int sourceWord, int destinationWord) {
    int i;
    int result;
    int mask;

	/* begin partitionedAND:to:nBits:nPartitions: */
	mask = maskTable[destPixSize];
	result = 0;
	for (i = 1; i <= pixPerWord; i += 1) {
		if (((~sourceWord) & mask) == mask) {
			result = result | (destinationWord & mask);
		}
		mask = mask << destPixSize;
	}
	return result;
}

static int pixPaintwith(int sourceWord, int destinationWord) {
	if (sourceWord == 0) {
		return destinationWord;
	}
	return sourceWord | (partitionedANDtonBitsnPartitions(~sourceWord, destinationWord, destPixSize, pixPerWord));
}


/*	Invoke the copyBits primitive. If the destination is the display, then copy it to the screen. */

EXPORT(int) BitBltPlugin_primitiveCopyBits(void) {
    int rcvr;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	rcvr = interpreterProxy->stackValue(interpreterProxy->methodArgumentCount());
	if (!(loadBitBltFromwarping(rcvr, 0))) {
		return interpreterProxy->primitiveFail();
	}
	/* begin copyBits */
	clipRange();
	if ((bbW <= 0) || (bbH <= 0)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		goto l1;
	}
	if (!(lockSurfaces())) {
		interpreterProxy->primitiveFail();
		goto l1;
	}
	/* begin copyBitsLockedAndClipped */
	/* begin tryCopyingBitsQuickly */
	if (noSource) {
		done = 0;
		goto l2;
	}
	if (!(combinationRule == 34)) {
		done = 0;
		goto l2;
	}
	if (!(sourcePixSize == 32)) {
		done = 0;
		goto l2;
	}
	if (sourceForm == destForm) {
		done = 0;
		goto l2;
	}
	if (destPixSize < 8) {
		done = 0;
		goto l2;
	}
	if ((destPixSize == 8) && (colorMap == null)) {
		done = 0;
		goto l2;
	}
	if (destPixSize == 32) {
		alphaSourceBlendBits32();
	}
	if (destPixSize == 16) {
		alphaSourceBlendBits16();
	}
	if (destPixSize == 8) {
		alphaSourceBlendBits8();
	}
	affectedL = dx;
	affectedR = dx + bbW;
	affectedT = dy;
	affectedB = dy + bbH;
	done = 1;
l2:	/* end tryCopyingBitsQuickly */;
	if (done) {
		goto l3;
	}
	if ((combinationRule == 30) || (combinationRule == 31)) {
		if ((interpreterProxy->methodArgumentCount()) == 1) {
			sourceAlpha = interpreterProxy->stackIntegerValue(0);
			if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
				interpreterProxy->pop(1);
			} else {
				interpreterProxy->primitiveFail();
				goto l3;
			}
		} else {
			interpreterProxy->primitiveFail();
			goto l3;
		}
	}
	bitCount = 0;
	/* begin performCopyLoop */
	/* begin destMaskAndPointerInit */
	pixPerM11 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM11);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	if (noSource) {
		copyLoopNoSource();
	} else {
		/* begin checkSourceOverlap */
		if ((sourceForm == destForm) && (dy >= sy)) {
			if (dy > sy) {
				vDir = -1;
				sy = (sy + bbH) - 1;
				dy = (dy + bbH) - 1;
			} else {
				if ((dy == sy) && (dx > sx)) {
					hDir = -1;
					sx = (sx + bbW) - 1;
					dx = (dx + bbW) - 1;
					if (nWords > 1) {
						t = mask1;
						mask1 = mask2;
						mask2 = t;
					}
				}
			}
			destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
			destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
		}
		if ((sourcePixSize != destPixSize) || (colorMap != null)) {
			copyLoopPixMap();
		} else {
			/* begin sourceSkewAndPointerInit */
			pixPerM1 = pixPerWord - 1;
			sxLowBits = sx & pixPerM1;
			dxLowBits = dx & pixPerM1;
			if (hDir > 0) {
				dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
				preload = (sxLowBits + dWid) > pixPerM1;
			} else {
				dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
				preload = ((sxLowBits - dWid) + 1) < 0;
			}
			skew = (sxLowBits - dxLowBits) * destPixSize;
			if (preload) {
				if (skew < 0) {
					skew += 32;
				} else {
					skew -= 32;
				}
			}
			sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
			sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
			if (preload) {
				sourceDelta -= 4 * hDir;
			}
			copyLoop();
		}
	}
	if ((combinationRule == 22) || (combinationRule == 32)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		interpreterProxy->pop(1);
		interpreterProxy->pushInteger(bitCount);
		goto l3;
	}
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
l3:	/* end copyBitsLockedAndClipped */;
	unlockSurfaces();
l1:	/* end copyBits */;
	/* begin showDisplayBits */
	interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
}

EXPORT(int) BitBltPlugin_primitiveDisplayString(void) {
    int maxGlyph;
    int left;
    int sourceString;
    int glyphIndex;
    int stopIndex;
    int bbObj;
    int xTable;
    int kernDelta;
    int startIndex;
    int glyphMap;
    unsigned char * sourcePtr;
    int charIndex;
    int ascii;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	if (!((interpreterProxy->methodArgumentCount()) == 6)) {
		return interpreterProxy->primitiveFail();
	}
	kernDelta = interpreterProxy->stackIntegerValue(0);
	xTable = interpreterProxy->stackObjectValue(1);
	glyphMap = interpreterProxy->stackObjectValue(2);
	if (!(((interpreterProxy->fetchClassOf(xTable)) == (interpreterProxy->classArray())) && ((interpreterProxy->fetchClassOf(glyphMap)) == (interpreterProxy->classArray())))) {
		return interpreterProxy->primitiveFail();
	}
	if (!((interpreterProxy->slotSizeOf(glyphMap)) == 256)) {
		return interpreterProxy->primitiveFail();
	}
	if (interpreterProxy->failed()) {
		return null;
	}
	maxGlyph = (interpreterProxy->slotSizeOf(xTable)) - 2;
	stopIndex = interpreterProxy->stackIntegerValue(3);
	startIndex = interpreterProxy->stackIntegerValue(4);
	sourceString = interpreterProxy->stackObjectValue(5);
	if (!(interpreterProxy->isBytes(sourceString))) {
		return interpreterProxy->primitiveFail();
	}
	if (!((startIndex > 0) && ((stopIndex > 0) && (stopIndex <= (interpreterProxy->byteSizeOf(sourceString)))))) {
		return interpreterProxy->primitiveFail();
	}
	bbObj = interpreterProxy->stackObjectValue(6);
	if (!(loadBitBltFromwarping(bbObj, 0))) {
		return interpreterProxy->primitiveFail();
	}
	left = destX;
	sourcePtr = interpreterProxy->firstIndexableField(sourceString);
	for (charIndex = startIndex; charIndex <= stopIndex; charIndex += 1) {
		ascii = sourcePtr[charIndex - 1];
		glyphIndex = interpreterProxy->fetchIntegerofObject(ascii, glyphMap);
		if ((glyphIndex < 0) || (glyphIndex > maxGlyph)) {
			return interpreterProxy->primitiveFail();
		}
		sourceX = interpreterProxy->fetchIntegerofObject(glyphIndex, xTable);
		width = (interpreterProxy->fetchIntegerofObject(glyphIndex + 1, xTable)) - sourceX;
		if (interpreterProxy->failed()) {
			return null;
		}
		clipRange();
		if ((bbW > 0) && (bbH > 0)) {
			/* begin copyBits */
			clipRange();
			if ((bbW <= 0) || (bbH <= 0)) {
				affectedL = affectedR = affectedT = affectedB = 0;
				goto l1;
			}
			if (!(lockSurfaces())) {
				interpreterProxy->primitiveFail();
				goto l1;
			}
			/* begin copyBitsLockedAndClipped */
			/* begin tryCopyingBitsQuickly */
			if (noSource) {
				done = 0;
				goto l2;
			}
			if (!(combinationRule == 34)) {
				done = 0;
				goto l2;
			}
			if (!(sourcePixSize == 32)) {
				done = 0;
				goto l2;
			}
			if (sourceForm == destForm) {
				done = 0;
				goto l2;
			}
			if (destPixSize < 8) {
				done = 0;
				goto l2;
			}
			if ((destPixSize == 8) && (colorMap == null)) {
				done = 0;
				goto l2;
			}
			if (destPixSize == 32) {
				alphaSourceBlendBits32();
			}
			if (destPixSize == 16) {
				alphaSourceBlendBits16();
			}
			if (destPixSize == 8) {
				alphaSourceBlendBits8();
			}
			affectedL = dx;
			affectedR = dx + bbW;
			affectedT = dy;
			affectedB = dy + bbH;
			done = 1;
		l2:	/* end tryCopyingBitsQuickly */;
			if (done) {
				goto l3;
			}
			if ((combinationRule == 30) || (combinationRule == 31)) {
				if ((interpreterProxy->methodArgumentCount()) == 1) {
					sourceAlpha = interpreterProxy->stackIntegerValue(0);
					if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
						interpreterProxy->pop(1);
					} else {
						interpreterProxy->primitiveFail();
						goto l3;
					}
				} else {
					interpreterProxy->primitiveFail();
					goto l3;
				}
			}
			bitCount = 0;
			/* begin performCopyLoop */
			/* begin destMaskAndPointerInit */
			pixPerM11 = pixPerWord - 1;
			startBits = pixPerWord - (dx & pixPerM11);
			mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
			endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
			mask2 = 4294967295U << (32 - (endBits * destPixSize));
			if (bbW < startBits) {
				mask1 = mask1 & mask2;
				mask2 = 0;
				nWords = 1;
			} else {
				nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
			}
			hDir = vDir = 1;
			destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
			destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
			if (noSource) {
				copyLoopNoSource();
			} else {
				/* begin checkSourceOverlap */
				if ((sourceForm == destForm) && (dy >= sy)) {
					if (dy > sy) {
						vDir = -1;
						sy = (sy + bbH) - 1;
						dy = (dy + bbH) - 1;
					} else {
						if ((dy == sy) && (dx > sx)) {
							hDir = -1;
							sx = (sx + bbW) - 1;
							dx = (dx + bbW) - 1;
							if (nWords > 1) {
								t = mask1;
								mask1 = mask2;
								mask2 = t;
							}
						}
					}
					destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
					destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
				}
				if ((sourcePixSize != destPixSize) || (colorMap != null)) {
					copyLoopPixMap();
				} else {
					/* begin sourceSkewAndPointerInit */
					pixPerM1 = pixPerWord - 1;
					sxLowBits = sx & pixPerM1;
					dxLowBits = dx & pixPerM1;
					if (hDir > 0) {
						dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
						preload = (sxLowBits + dWid) > pixPerM1;
					} else {
						dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
						preload = ((sxLowBits - dWid) + 1) < 0;
					}
					skew = (sxLowBits - dxLowBits) * destPixSize;
					if (preload) {
						if (skew < 0) {
							skew += 32;
						} else {
							skew -= 32;
						}
					}
					sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
					sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
					if (preload) {
						sourceDelta -= 4 * hDir;
					}
					copyLoop();
				}
			}
			if ((combinationRule == 22) || (combinationRule == 32)) {
				affectedL = affectedR = affectedT = affectedB = 0;
				interpreterProxy->pop(1);
				interpreterProxy->pushInteger(bitCount);
				goto l3;
			}
			if (hDir > 0) {
				affectedL = dx;
				affectedR = dx + bbW;
			} else {
				affectedL = (dx - bbW) + 1;
				affectedR = dx + 1;
			}
			if (vDir > 0) {
				affectedT = dy;
				affectedB = dy + bbH;
			} else {
				affectedT = (dy - bbH) + 1;
				affectedB = dy + 1;
			}
		l3:	/* end copyBitsLockedAndClipped */;
			unlockSurfaces();
		l1:	/* end copyBits */;
		}
		if (interpreterProxy->failed()) {
			return null;
		}
		destX = (destX + width) + kernDelta;
	}
	affectedL = left;
	/* begin showDisplayBits */
	interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
	interpreterProxy->pop(6);
}


/*	Invoke the line drawing primitive. */

EXPORT(int) BitBltPlugin_primitiveDrawLoop(void) {
    int yDelta;
    int xDelta;
    int rcvr;
    int i;
    int py;
    int affL;
    int dy1;
    int affR;
    int affB;
    int affT;
    int dx1;
    int px;
    int P;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;
    int done1;
    int pixPerM12;
    int dxLowBits1;
    int dWid1;
    int sxLowBits1;
    int t1;
    int pixPerM111;
    int endBits1;
    int startBits1;

	rcvr = interpreterProxy->stackValue(2);
	xDelta = interpreterProxy->stackIntegerValue(1);
	yDelta = interpreterProxy->stackIntegerValue(0);
	if (!(loadBitBltFromwarping(rcvr, 0))) {
		return interpreterProxy->primitiveFail();
	}
	if (!(interpreterProxy->failed())) {
		/* begin drawLoopX:Y: */
		if (xDelta > 0) {
			dx1 = 1;
		} else {
			if (xDelta == 0) {
				dx1 = 0;
			} else {
				dx1 = -1;
			}
		}
		if (yDelta > 0) {
			dy1 = 1;
		} else {
			if (yDelta == 0) {
				dy1 = 0;
			} else {
				dy1 = -1;
			}
		}
		px = abs(yDelta);
		py = abs(xDelta);
		affL = affT = 9999;
		affR = affB = -9999;
		if (py > px) {
			P = ((int) py >> 1);
			for (i = 1; i <= py; i += 1) {
				destX += dx1;
				if ((P -= px) < 0) {
					destY += dy1;
					P += py;
				}
				if (i < py) {
					/* begin copyBits */
					clipRange();
					if ((bbW <= 0) || (bbH <= 0)) {
						affectedL = affectedR = affectedT = affectedB = 0;
						goto l1;
					}
					if (!(lockSurfaces())) {
						interpreterProxy->primitiveFail();
						goto l1;
					}
					/* begin copyBitsLockedAndClipped */
					/* begin tryCopyingBitsQuickly */
					if (noSource) {
						done = 0;
						goto l3;
					}
					if (!(combinationRule == 34)) {
						done = 0;
						goto l3;
					}
					if (!(sourcePixSize == 32)) {
						done = 0;
						goto l3;
					}
					if (sourceForm == destForm) {
						done = 0;
						goto l3;
					}
					if (destPixSize < 8) {
						done = 0;
						goto l3;
					}
					if ((destPixSize == 8) && (colorMap == null)) {
						done = 0;
						goto l3;
					}
					if (destPixSize == 32) {
						alphaSourceBlendBits32();
					}
					if (destPixSize == 16) {
						alphaSourceBlendBits16();
					}
					if (destPixSize == 8) {
						alphaSourceBlendBits8();
					}
					affectedL = dx;
					affectedR = dx + bbW;
					affectedT = dy;
					affectedB = dy + bbH;
					done = 1;
				l3:	/* end tryCopyingBitsQuickly */;
					if (done) {
						goto l4;
					}
					if ((combinationRule == 30) || (combinationRule == 31)) {
						if ((interpreterProxy->methodArgumentCount()) == 1) {
							sourceAlpha = interpreterProxy->stackIntegerValue(0);
							if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
								interpreterProxy->pop(1);
							} else {
								interpreterProxy->primitiveFail();
								goto l4;
							}
						} else {
							interpreterProxy->primitiveFail();
							goto l4;
						}
					}
					bitCount = 0;
					/* begin performCopyLoop */
					/* begin destMaskAndPointerInit */
					pixPerM11 = pixPerWord - 1;
					startBits = pixPerWord - (dx & pixPerM11);
					mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
					endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
					mask2 = 4294967295U << (32 - (endBits * destPixSize));
					if (bbW < startBits) {
						mask1 = mask1 & mask2;
						mask2 = 0;
						nWords = 1;
					} else {
						nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
					}
					hDir = vDir = 1;
					destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
					destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					if (noSource) {
						copyLoopNoSource();
					} else {
						/* begin checkSourceOverlap */
						if ((sourceForm == destForm) && (dy >= sy)) {
							if (dy > sy) {
								vDir = -1;
								sy = (sy + bbH) - 1;
								dy = (dy + bbH) - 1;
							} else {
								if ((dy == sy) && (dx > sx)) {
									hDir = -1;
									sx = (sx + bbW) - 1;
									dx = (dx + bbW) - 1;
									if (nWords > 1) {
										t = mask1;
										mask1 = mask2;
										mask2 = t;
									}
								}
							}
							destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
							destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
						}
						if ((sourcePixSize != destPixSize) || (colorMap != null)) {
							copyLoopPixMap();
						} else {
							/* begin sourceSkewAndPointerInit */
							pixPerM1 = pixPerWord - 1;
							sxLowBits = sx & pixPerM1;
							dxLowBits = dx & pixPerM1;
							if (hDir > 0) {
								dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
								preload = (sxLowBits + dWid) > pixPerM1;
							} else {
								dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
								preload = ((sxLowBits - dWid) + 1) < 0;
							}
							skew = (sxLowBits - dxLowBits) * destPixSize;
							if (preload) {
								if (skew < 0) {
									skew += 32;
								} else {
									skew -= 32;
								}
							}
							sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
							sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
							if (preload) {
								sourceDelta -= 4 * hDir;
							}
							copyLoop();
						}
					}
					if ((combinationRule == 22) || (combinationRule == 32)) {
						affectedL = affectedR = affectedT = affectedB = 0;
						interpreterProxy->pop(1);
						interpreterProxy->pushInteger(bitCount);
						goto l4;
					}
					if (hDir > 0) {
						affectedL = dx;
						affectedR = dx + bbW;
					} else {
						affectedL = (dx - bbW) + 1;
						affectedR = dx + 1;
					}
					if (vDir > 0) {
						affectedT = dy;
						affectedB = dy + bbH;
					} else {
						affectedT = (dy - bbH) + 1;
						affectedB = dy + 1;
					}
				l4:	/* end copyBitsLockedAndClipped */;
					unlockSurfaces();
				l1:	/* end copyBits */;
					if (interpreterProxy->failed()) {
						goto l7;
					}
					if ((affectedL < affectedR) && (affectedT < affectedB)) {
						affL = ((affL < affectedL) ? affL : affectedL);
						affR = ((affR < affectedR) ? affectedR : affR);
						affT = ((affT < affectedT) ? affT : affectedT);
						affB = ((affB < affectedB) ? affectedB : affB);
						if (((affR - affL) * (affB - affT)) > 4000) {
							affectedL = affL;
							affectedR = affR;
							affectedT = affT;
							affectedB = affB;
							/* begin showDisplayBits */
							interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
							affL = affT = 9999;
							affR = affB = -9999;
						}
					}
				}
			}
		} else {
			P = ((int) px >> 1);
			for (i = 1; i <= px; i += 1) {
				destY += dy1;
				if ((P -= py) < 0) {
					destX += dx1;
					P += px;
				}
				if (i < px) {
					/* begin copyBits */
					clipRange();
					if ((bbW <= 0) || (bbH <= 0)) {
						affectedL = affectedR = affectedT = affectedB = 0;
						goto l2;
					}
					if (!(lockSurfaces())) {
						interpreterProxy->primitiveFail();
						goto l2;
					}
					/* begin copyBitsLockedAndClipped */
					/* begin tryCopyingBitsQuickly */
					if (noSource) {
						done1 = 0;
						goto l5;
					}
					if (!(combinationRule == 34)) {
						done1 = 0;
						goto l5;
					}
					if (!(sourcePixSize == 32)) {
						done1 = 0;
						goto l5;
					}
					if (sourceForm == destForm) {
						done1 = 0;
						goto l5;
					}
					if (destPixSize < 8) {
						done1 = 0;
						goto l5;
					}
					if ((destPixSize == 8) && (colorMap == null)) {
						done1 = 0;
						goto l5;
					}
					if (destPixSize == 32) {
						alphaSourceBlendBits32();
					}
					if (destPixSize == 16) {
						alphaSourceBlendBits16();
					}
					if (destPixSize == 8) {
						alphaSourceBlendBits8();
					}
					affectedL = dx;
					affectedR = dx + bbW;
					affectedT = dy;
					affectedB = dy + bbH;
					done1 = 1;
				l5:	/* end tryCopyingBitsQuickly */;
					if (done1) {
						goto l6;
					}
					if ((combinationRule == 30) || (combinationRule == 31)) {
						if ((interpreterProxy->methodArgumentCount()) == 1) {
							sourceAlpha = interpreterProxy->stackIntegerValue(0);
							if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
								interpreterProxy->pop(1);
							} else {
								interpreterProxy->primitiveFail();
								goto l6;
							}
						} else {
							interpreterProxy->primitiveFail();
							goto l6;
						}
					}
					bitCount = 0;
					/* begin performCopyLoop */
					/* begin destMaskAndPointerInit */
					pixPerM111 = pixPerWord - 1;
					startBits1 = pixPerWord - (dx & pixPerM111);
					mask1 = ((unsigned) 4294967295U) >> (32 - (startBits1 * destPixSize));
					endBits1 = (((dx + bbW) - 1) & pixPerM111) + 1;
					mask2 = 4294967295U << (32 - (endBits1 * destPixSize));
					if (bbW < startBits1) {
						mask1 = mask1 & mask2;
						mask2 = 0;
						nWords = 1;
					} else {
						nWords = (((bbW - startBits1) + pixPerM111) / pixPerWord) + 1;
					}
					hDir = vDir = 1;
					destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
					destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					if (noSource) {
						copyLoopNoSource();
					} else {
						/* begin checkSourceOverlap */
						if ((sourceForm == destForm) && (dy >= sy)) {
							if (dy > sy) {
								vDir = -1;
								sy = (sy + bbH) - 1;
								dy = (dy + bbH) - 1;
							} else {
								if ((dy == sy) && (dx > sx)) {
									hDir = -1;
									sx = (sx + bbW) - 1;
									dx = (dx + bbW) - 1;
									if (nWords > 1) {
										t1 = mask1;
										mask1 = mask2;
										mask2 = t1;
									}
								}
							}
							destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
							destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
						}
						if ((sourcePixSize != destPixSize) || (colorMap != null)) {
							copyLoopPixMap();
						} else {
							/* begin sourceSkewAndPointerInit */
							pixPerM12 = pixPerWord - 1;
							sxLowBits1 = sx & pixPerM12;
							dxLowBits1 = dx & pixPerM12;
							if (hDir > 0) {
								dWid1 = ((bbW < (pixPerWord - dxLowBits1)) ? bbW : (pixPerWord - dxLowBits1));
								preload = (sxLowBits1 + dWid1) > pixPerM12;
							} else {
								dWid1 = ((bbW < (dxLowBits1 + 1)) ? bbW : (dxLowBits1 + 1));
								preload = ((sxLowBits1 - dWid1) + 1) < 0;
							}
							skew = (sxLowBits1 - dxLowBits1) * destPixSize;
							if (preload) {
								if (skew < 0) {
									skew += 32;
								} else {
									skew -= 32;
								}
							}
							sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
							sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
							if (preload) {
								sourceDelta -= 4 * hDir;
							}
							copyLoop();
						}
					}
					if ((combinationRule == 22) || (combinationRule == 32)) {
						affectedL = affectedR = affectedT = affectedB = 0;
						interpreterProxy->pop(1);
						interpreterProxy->pushInteger(bitCount);
						goto l6;
					}
					if (hDir > 0) {
						affectedL = dx;
						affectedR = dx + bbW;
					} else {
						affectedL = (dx - bbW) + 1;
						affectedR = dx + 1;
					}
					if (vDir > 0) {
						affectedT = dy;
						affectedB = dy + bbH;
					} else {
						affectedT = (dy - bbH) + 1;
						affectedB = dy + 1;
					}
				l6:	/* end copyBitsLockedAndClipped */;
					unlockSurfaces();
				l2:	/* end copyBits */;
					if (interpreterProxy->failed()) {
						goto l7;
					}
					if ((affectedL < affectedR) && (affectedT < affectedB)) {
						affL = ((affL < affectedL) ? affL : affectedL);
						affR = ((affR < affectedR) ? affectedR : affR);
						affT = ((affT < affectedT) ? affT : affectedT);
						affB = ((affB < affectedB) ? affectedB : affB);
						if (((affR - affL) * (affB - affT)) > 4000) {
							affectedL = affL;
							affectedR = affR;
							affectedT = affT;
							affectedB = affB;
							/* begin showDisplayBits */
							interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
							affL = affT = 9999;
							affR = affB = -9999;
						}
					}
				}
			}
		}
		affectedL = affL;
		affectedR = affR;
		affectedT = affT;
		affectedB = affB;
		interpreterProxy->storeIntegerofObjectwithValue(4, bitBltOop, destX);
		interpreterProxy->storeIntegerofObjectwithValue(5, bitBltOop, destY);
	l7:	/* end drawLoopX:Y: */;
		/* begin showDisplayBits */
		interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
	}
	if (!(interpreterProxy->failed())) {
		interpreterProxy->pop(2);
	}
}


/*	Invoke the scanCharacters primitive. */

EXPORT(int) BitBltPlugin_primitiveScanCharacters(void) {
    int start;
    int stop;
    int displayFlag;
    int stopArray;
    int rcvr;
    int string;
    int rightX;
    int lastIndex;
    int nextDestX;
    int left;
    int top;
    int charVal;
    int ascii;
    int sourceX2;
    int lastIndex1;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	rcvr = interpreterProxy->stackValue(6);
	start = interpreterProxy->stackIntegerValue(5);
	stop = interpreterProxy->stackIntegerValue(4);
	string = interpreterProxy->stackValue(3);
	rightX = interpreterProxy->stackIntegerValue(2);
	stopArray = interpreterProxy->stackValue(1);
	displayFlag = interpreterProxy->booleanValueOf(interpreterProxy->stackValue(0));
	if (interpreterProxy->failed()) {
		return null;
	}
	if (!(loadScannerFromstartstopstringrightXstopArraydisplayFlag(rcvr, start, stop, string, rightX, stopArray, displayFlag))) {
		return interpreterProxy->primitiveFail();
	}
	if (!(interpreterProxy->failed())) {
		/* begin scanCharacters */
		if (scanDisplayFlag) {
			clipRange();
			if ((combinationRule == 30) || (combinationRule == 31)) {
				interpreterProxy->primitiveFail();
				goto l1;
			}
			if (!(lockSurfaces())) {
				interpreterProxy->primitiveFail();
				goto l1;
			}
		}
		/* begin scanCharactersLockedAndClipped */
		if (scanDisplayFlag) {
			left = dx;
			top = dy;
		}
		lastIndex = scanStart;
		while (lastIndex <= scanStop) {
			charVal = interpreterProxy->stObjectat(scanString, lastIndex);
			ascii = (charVal >> 1);
			if (interpreterProxy->failed()) {
				goto l3;
			}
			stopCode = interpreterProxy->stObjectat(scanStopArray, ascii + 1);
			if (interpreterProxy->failed()) {
				goto l3;
			}
			if (!(stopCode == (interpreterProxy->nilObject()))) {
				/* begin returnAt:lastIndex:left:top: */
				stopCode = interpreterProxy->stObjectat(scanStopArray, ascii + 1);
				if (interpreterProxy->failed()) {
					goto l3;
				}
				interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
				if (scanDisplayFlag) {
					affectedL = left;
					affectedR = bbW + dx;
					affectedT = top;
					affectedB = bbH + dy;
				}
				goto l3;
			}
			sourceX = interpreterProxy->stObjectat(scanXTable, ascii + 1);
			sourceX2 = interpreterProxy->stObjectat(scanXTable, ascii + 2);
			if (interpreterProxy->failed()) {
				goto l3;
			}
			if (((sourceX & 1)) && ((sourceX2 & 1))) {
				sourceX = (sourceX >> 1);
				sourceX2 = (sourceX2 >> 1);
			} else {
				interpreterProxy->primitiveFail();
				goto l3;
			}
			nextDestX = destX + (width = sourceX2 - sourceX);
			if (nextDestX > scanRightX) {
				/* begin returnAt:lastIndex:left:top: */
				stopCode = interpreterProxy->stObjectat(scanStopArray, 258);
				if (interpreterProxy->failed()) {
					goto l3;
				}
				interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
				if (scanDisplayFlag) {
					affectedL = left;
					affectedR = bbW + dx;
					affectedT = top;
					affectedB = bbH + dy;
				}
				goto l3;
			}
			if (scanDisplayFlag) {
				clipRange();
				if ((bbW > 0) && (bbH > 0)) {
					/* begin copyBitsLockedAndClipped */
					/* begin tryCopyingBitsQuickly */
					if (noSource) {
						done = 0;
						goto l4;
					}
					if (!(combinationRule == 34)) {
						done = 0;
						goto l4;
					}
					if (!(sourcePixSize == 32)) {
						done = 0;
						goto l4;
					}
					if (sourceForm == destForm) {
						done = 0;
						goto l4;
					}
					if (destPixSize < 8) {
						done = 0;
						goto l4;
					}
					if ((destPixSize == 8) && (colorMap == null)) {
						done = 0;
						goto l4;
					}
					if (destPixSize == 32) {
						alphaSourceBlendBits32();
					}
					if (destPixSize == 16) {
						alphaSourceBlendBits16();
					}
					if (destPixSize == 8) {
						alphaSourceBlendBits8();
					}
					affectedL = dx;
					affectedR = dx + bbW;
					affectedT = dy;
					affectedB = dy + bbH;
					done = 1;
				l4:	/* end tryCopyingBitsQuickly */;
					if (done) {
						goto l5;
					}
					if ((combinationRule == 30) || (combinationRule == 31)) {
						if ((interpreterProxy->methodArgumentCount()) == 1) {
							sourceAlpha = interpreterProxy->stackIntegerValue(0);
							if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
								interpreterProxy->pop(1);
							} else {
								interpreterProxy->primitiveFail();
								goto l5;
							}
						} else {
							interpreterProxy->primitiveFail();
							goto l5;
						}
					}
					bitCount = 0;
					/* begin performCopyLoop */
					/* begin destMaskAndPointerInit */
					pixPerM11 = pixPerWord - 1;
					startBits = pixPerWord - (dx & pixPerM11);
					mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
					endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
					mask2 = 4294967295U << (32 - (endBits * destPixSize));
					if (bbW < startBits) {
						mask1 = mask1 & mask2;
						mask2 = 0;
						nWords = 1;
					} else {
						nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
					}
					hDir = vDir = 1;
					destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
					destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					if (noSource) {
						copyLoopNoSource();
					} else {
						/* begin checkSourceOverlap */
						if ((sourceForm == destForm) && (dy >= sy)) {
							if (dy > sy) {
								vDir = -1;
								sy = (sy + bbH) - 1;
								dy = (dy + bbH) - 1;
							} else {
								if ((dy == sy) && (dx > sx)) {
									hDir = -1;
									sx = (sx + bbW) - 1;
									dx = (dx + bbW) - 1;
									if (nWords > 1) {
										t = mask1;
										mask1 = mask2;
										mask2 = t;
									}
								}
							}
							destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
							destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
						}
						if ((sourcePixSize != destPixSize) || (colorMap != null)) {
							copyLoopPixMap();
						} else {
							/* begin sourceSkewAndPointerInit */
							pixPerM1 = pixPerWord - 1;
							sxLowBits = sx & pixPerM1;
							dxLowBits = dx & pixPerM1;
							if (hDir > 0) {
								dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
								preload = (sxLowBits + dWid) > pixPerM1;
							} else {
								dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
								preload = ((sxLowBits - dWid) + 1) < 0;
							}
							skew = (sxLowBits - dxLowBits) * destPixSize;
							if (preload) {
								if (skew < 0) {
									skew += 32;
								} else {
									skew -= 32;
								}
							}
							sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
							sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
							if (preload) {
								sourceDelta -= 4 * hDir;
							}
							copyLoop();
						}
					}
					if ((combinationRule == 22) || (combinationRule == 32)) {
						affectedL = affectedR = affectedT = affectedB = 0;
						interpreterProxy->pop(1);
						interpreterProxy->pushInteger(bitCount);
						goto l5;
					}
					if (hDir > 0) {
						affectedL = dx;
						affectedR = dx + bbW;
					} else {
						affectedL = (dx - bbW) + 1;
						affectedR = dx + 1;
					}
					if (vDir > 0) {
						affectedT = dy;
						affectedB = dy + bbH;
					} else {
						affectedT = (dy - bbH) + 1;
						affectedB = dy + 1;
					}
				l5:	/* end copyBitsLockedAndClipped */;
				}
			}
			destX = nextDestX;
			interpreterProxy->storeIntegerofObjectwithValue(4, bitBltOop, destX);
			lastIndex += 1;
		}
		/* begin returnAt:lastIndex:left:top: */
		lastIndex1 = scanStop;
		stopCode = interpreterProxy->stObjectat(scanStopArray, 257);
		if (interpreterProxy->failed()) {
			goto l2;
		}
		interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex1);
		if (scanDisplayFlag) {
			affectedL = left;
			affectedR = bbW + dx;
			affectedT = top;
			affectedB = bbH + dy;
		}
	l2:	/* end returnAt:lastIndex:left:top: */;
	l3:	/* end scanCharactersLockedAndClipped */;
		if (scanDisplayFlag) {
			unlockSurfaces();
		}
	l1:	/* end scanCharacters */;
	}
	if (!(interpreterProxy->failed())) {
		if (displayFlag) {
			/* begin showDisplayBits */
			interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
		}
		interpreterProxy->pop(7);
		interpreterProxy->push(stopCode);
	}
}


/*	Invoke the warpBits primitive. If the destination is the display, then copy it to the screen. */

EXPORT(int) BitBltPlugin_primitiveWarpBits(void) {
    int rcvr;
    int ns;
    int surfaceHandle;
    int pixPerM1;
    int endBits;
    int startBits;

	rcvr = interpreterProxy->stackValue(interpreterProxy->methodArgumentCount());
	if (!(loadBitBltFromwarping(rcvr, 1))) {
		return interpreterProxy->primitiveFail();
	}
	/* begin warpBits */
	ns = noSource;
	noSource = 1;
	clipRange();
	noSource = ns;
	if (noSource || ((bbW <= 0) || (bbH <= 0))) {
		affectedL = affectedR = affectedT = affectedB = 0;
		goto l1;
	}
	/* begin lockSurfaces */
	hasSurfaceLock = 0;
	if (destBits == 0) {
		surfaceHandle = interpreterProxy->fetchIntegerofObject(0, destForm);
		hasSurfaceLock = 1;
	}
	if ((sourceBits == 0) && (!noSource)) {
		surfaceHandle = interpreterProxy->fetchIntegerofObject(0, sourceForm);
		hasSurfaceLock = 1;
	}
	(destBits != 0) && ((sourceBits != 0) || (noSource));
	/* begin destMaskAndPointerInit */
	pixPerM1 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM1);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM1) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM1) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	xWarpLoop();
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
	unlockSurfaces();
l1:	/* end warpBits */;
	/* begin showDisplayBits */
	interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
}


/*	Query the dimension of an OS surface.
	This method is provided so that in case the inst vars of the
	source form are broken, *actual* values of the OS surface
	can be obtained. This might, for instance, happen if the user
	resizes the main window.
	Note: Moved to a separate function for better inlining of the caller. */
/*	^(self cCode:'ioGetSurfaceFormat(handle, &destWidth, &destHeight, &destPixSize, &dstFormat)')
		~~ 0 */

static int queryDestSurface(int handle) {
	return 0;
}


/*	Query the dimension of an OS surface.
	This method is provided so that in case the inst vars of the
	source form are broken, *actual* values of the OS surface
	can be obtained. This might, for instance, happen if the user
	resizes the main window.
	Note: Moved to a separate function for better inlining of the caller. */
/*	^(self cCode:'ioGetSurfaceFormat(handle, &srcWidth, &srcHeight, &sourcePixSize, &srcFormat)')
		~~ 0 */

static int querySourceSurface(int handle) {
	return 0;
}

static int returnAtlastIndexlefttop(int stopIndex, int lastIndex, int left, int top) {
	stopCode = interpreterProxy->stObjectat(scanStopArray, stopIndex);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
	if (scanDisplayFlag) {
		affectedL = left;
		affectedR = bbW + dx;
		affectedT = top;
		affectedB = bbH + dy;
	}
}

static int rgbAddwith(int sourceWord, int destinationWord) {
	if (destPixSize < 16) {
		return partitionedAddtonBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedAddtonBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedAddtonBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedAddtonBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}


/*	Subract the pixels in the source and destination, color by color,
	and return the sum of the absolute value of all the differences.
	For non-rgb, return the number of differing pixels. */

static int rgbDiffwith(int sourceWord, int destinationWord) {
    int i;
    int sourceShifted;
    int diff;
    int rgbMask;
    int destShifted;
    int pixMask;
    int maskShifted;
    int bitsPerColor;
    int sourcePixVal;
    int destPixVal;

	pixMask = maskTable[destPixSize];
	if (destPixSize == 16) {
		bitsPerColor = 5;
		rgbMask = 31;
	} else {
		bitsPerColor = 8;
		rgbMask = 255;
	}
	maskShifted = destMask;
	destShifted = destinationWord;
	sourceShifted = sourceWord;
	for (i = 1; i <= pixPerWord; i += 1) {
		if ((maskShifted & pixMask) > 0) {
			destPixVal = destShifted & pixMask;
			sourcePixVal = sourceShifted & pixMask;
			if (destPixSize < 16) {
				if (sourcePixVal == destPixVal) {
					diff = 0;
				} else {
					diff = 1;
				}
			} else {
				diff = partitionedSubfromnBitsnPartitions(sourcePixVal, destPixVal, bitsPerColor, 3);
				diff = ((diff & rgbMask) + ((((unsigned) diff) >> bitsPerColor) & rgbMask)) + ((((unsigned) (((unsigned) diff) >> bitsPerColor)) >> bitsPerColor) & rgbMask);
			}
			bitCount += diff;
		}
		maskShifted = ((unsigned) maskShifted) >> destPixSize;
		sourceShifted = ((unsigned) sourceShifted) >> destPixSize;
		destShifted = ((unsigned) destShifted) >> destPixSize;
	}
	return destinationWord;
}


/*	Convert the given 16bit pixel value to a color map index 
	using nBitsOut bits for each color component. 
	Note: This method is intended to deal with different source formats. */

static int rgbMap16downTo(int sourcePixel, int nBitsOut) {
    int delta;


	/* note: evaluated strictly left to right */

	delta = 5 - nBitsOut;
	return ((((((unsigned) ((((unsigned) sourcePixel) >> 10) & 31)) >> delta) << nBitsOut) + (((unsigned) ((((unsigned) sourcePixel) >> 5) & 31)) >> delta)) << nBitsOut) + (((unsigned) (sourcePixel & 31)) >> delta);
}


/*	Convert the given 16bit pixel value to a color map index 
	using nBitsOut bits for each color component. 
	Note: This method is intended to deal with different source formats. */

static int rgbMap16to(int sourcePixel, int nBitsOut) {
    int delta;
    int delta1;

	if (nBitsOut > 5) {
		/* begin rgbMap16:upTo: */
		delta = nBitsOut - 5;
		return ((((((((unsigned) sourcePixel) >> 10) & 31) << (5 + delta)) + ((((unsigned) sourcePixel) >> 5) & 31)) << (5 + delta)) + (sourcePixel & 31)) << delta;
	} else {
		/* begin rgbMap16:downTo: */
		delta1 = 5 - nBitsOut;
		return ((((((unsigned) ((((unsigned) sourcePixel) >> 10) & 31)) >> delta1) << nBitsOut) + (((unsigned) ((((unsigned) sourcePixel) >> 5) & 31)) >> delta1)) << nBitsOut) + (((unsigned) (sourcePixel & 31)) >> delta1);
	}
}


/*	Convert the given 16bit pixel value to a color map index 
	using nBitsOut bits for each color component. 
	Note: This method is intended to deal with different source formats. */

static int rgbMap16upTo(int sourcePixel, int nBitsOut) {
    int delta;


	/* note: evaluated strictly left to right */

	delta = nBitsOut - 5;
	return ((((((((unsigned) sourcePixel) >> 10) & 31) << (5 + delta)) + ((((unsigned) sourcePixel) >> 5) & 31)) << (5 + delta)) + (sourcePixel & 31)) << delta;
}


/*	Convert the given 16bit pixel value to a 32bit RGBA value.
 	Note: This method is intended to deal with different source formats. */

static int rgbMap16To32(int sourcePixel) {
	return (((sourcePixel & 31) << 3) | ((sourcePixel & 992) << 6)) | ((sourcePixel & 31744) << 9);
}


/*	Convert the given 16 pixel value to a color value in destination format.
	Note: This method is intended to deal with different destination formats. */

static int rgbMap16ToX(int sourcePixel) {
	if (destPixSize == 32) {
		return (((sourcePixel & 31) << 3) | ((sourcePixel & 992) << 6)) | ((sourcePixel & 31744) << 9);
	} else {
		return sourcePixel;
	}
}


/*	Convert the given 32bit pixel value to a color map index 
	using nBitsOut bits for each color component. 
	Note: This method is intended to deal with different source formats. */

static int rgbMap32to(int sourcePixel, int nBitsOut) {
    int delta;


	/* note: evaluated strictly left to right */

	delta = 8 - nBitsOut;
	return ((((((unsigned) ((((unsigned) sourcePixel) >> 16) & 255)) >> delta) << nBitsOut) + (((unsigned) ((((unsigned) sourcePixel) >> 8) & 255)) >> delta)) << nBitsOut) + (((unsigned) (sourcePixel & 255)) >> delta);
}


/*	Convert the given 32bit pixel value to a 32bit RGBA value.
 	Note: This method is intended to deal with different source formats. */

static int rgbMap32To32(int sourcePixel) {
	return sourcePixel;
}


/*	Convert the given 32bit pixel value to a color value in destination format.
	Note: This method is intended to deal with different destination formats. */

static int rgbMap32ToX(int sourcePixel) {
    int delta;

	if (destPixSize == 16) {
		/* begin rgbMap32:to: */
		delta = 8 - 5;
		return ((((((unsigned) ((((unsigned) sourcePixel) >> 16) & 255)) >> delta) << 5) + (((unsigned) ((((unsigned) sourcePixel) >> 8) & 255)) >> delta)) << 5) + (((unsigned) (sourcePixel & 255)) >> delta);
	} else {
		return sourcePixel;
	}
}


/*	Color map the given source pixel.
	Note: This relies on an accurate setup of the cmShifts and cmMasks
	by BitBlt and can therefore not be used from WarpBlt in smoothing
	mode (but hey, then we have to go over lots of different pixels
	before we even come to the output color conversion so that doesn't
	really matter). */

static int rgbMap(int sourcePixel) {
	if (cmDeltaBits < 0) {
		return (((unsigned) (sourcePixel & cmRedMask)) >> cmRedShift) | ((((unsigned) (sourcePixel & cmGreenMask)) >> cmGreenShift) | (((unsigned) (sourcePixel & cmBlueMask)) >> cmBlueShift));
	} else {
		return ((sourcePixel & cmRedMask) << cmRedShift) | (((sourcePixel & cmGreenMask) << cmGreenShift) | ((sourcePixel & cmBlueMask) << cmBlueShift));
	}
}


/*	Convert the given pixel value with nBitsIn bits for each color component to a pixel value with nBitsOut bits for each color component. Typical values for nBitsIn/nBitsOut are 3, 5, or 8. */

static int rgbMapfromto(int sourcePixel, int nBitsIn, int nBitsOut) {
    int srcPix;
    int destPix;
    int d;
    int mask;

	if ((d = nBitsOut - nBitsIn) > 0) {

		/* Transfer mask */

		mask = (1 << nBitsIn) - 1;
		srcPix = sourcePixel << d;
		mask = mask << d;
		destPix = srcPix & mask;
		mask = mask << nBitsOut;
		srcPix = srcPix << d;
		return (destPix + (srcPix & mask)) + ((srcPix << d) & (mask << nBitsOut));
	} else {
		if (d == 0) {
			if (nBitsIn == 5) {
				return sourcePixel & 32767;
			}
			if (nBitsIn == 8) {
				return sourcePixel & 16777215;
			}
			return sourcePixel;
		}
		if (sourcePixel == 0) {
			return sourcePixel;
		}
		d = nBitsIn - nBitsOut;

		/* Transfer mask */

		mask = (1 << nBitsOut) - 1;
		srcPix = ((unsigned) sourcePixel) >> d;
		destPix = srcPix & mask;
		mask = mask << nBitsOut;
		srcPix = ((unsigned) srcPix) >> d;
		destPix = (destPix + (srcPix & mask)) + ((((unsigned) srcPix) >> d) & (mask << nBitsOut));
		if (destPix == 0) {
			return 1;
		}
		return destPix;
	}
}

static int rgbMaxwith(int sourceWord, int destinationWord) {
    int i;
    int result;
    int mask;
    int i1;
    int result1;
    int mask3;

	if (destPixSize < 16) {
		/* begin partitionedMax:with:nBits:nPartitions: */
		mask = maskTable[destPixSize];
		result = 0;
		for (i = 1; i <= pixPerWord; i += 1) {
			result = result | ((((destinationWord & mask) < (sourceWord & mask)) ? (sourceWord & mask) : (destinationWord & mask)));
			mask = mask << destPixSize;
		}
		return result;
	}
	if (destPixSize == 16) {
		return (partitionedMaxwithnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedMaxwithnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		/* begin partitionedMax:with:nBits:nPartitions: */
		mask3 = maskTable[8];
		result1 = 0;
		for (i1 = 1; i1 <= 3; i1 += 1) {
			result1 = result1 | ((((destinationWord & mask3) < (sourceWord & mask3)) ? (sourceWord & mask3) : (destinationWord & mask3)));
			mask3 = mask3 << 8;
		}
		return result1;
	}
}

static int rgbMinwith(int sourceWord, int destinationWord) {
    int i;
    int result;
    int mask;
    int i1;
    int result1;
    int mask3;

	if (destPixSize < 16) {
		/* begin partitionedMin:with:nBits:nPartitions: */
		mask = maskTable[destPixSize];
		result = 0;
		for (i = 1; i <= pixPerWord; i += 1) {
			result = result | ((((destinationWord & mask) < (sourceWord & mask)) ? (destinationWord & mask) : (sourceWord & mask)));
			mask = mask << destPixSize;
		}
		return result;
	}
	if (destPixSize == 16) {
		return (partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedMinwithnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		/* begin partitionedMin:with:nBits:nPartitions: */
		mask3 = maskTable[8];
		result1 = 0;
		for (i1 = 1; i1 <= 3; i1 += 1) {
			result1 = result1 | ((((destinationWord & mask3) < (sourceWord & mask3)) ? (destinationWord & mask3) : (sourceWord & mask3)));
			mask3 = mask3 << 8;
		}
		return result1;
	}
}

static int rgbMinInvertwith(int wordToInvert, int destinationWord) {
    int sourceWord;
    int i;
    int result;
    int mask;
    int i1;
    int result1;
    int mask3;

	sourceWord = ~wordToInvert;
	if (destPixSize < 16) {
		/* begin partitionedMin:with:nBits:nPartitions: */
		mask = maskTable[destPixSize];
		result = 0;
		for (i = 1; i <= pixPerWord; i += 1) {
			result = result | ((((destinationWord & mask) < (sourceWord & mask)) ? (destinationWord & mask) : (sourceWord & mask)));
			mask = mask << destPixSize;
		}
		return result;
	}
	if (destPixSize == 16) {
		return (partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedMinwithnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		/* begin partitionedMin:with:nBits:nPartitions: */
		mask3 = maskTable[8];
		result1 = 0;
		for (i1 = 1; i1 <= 3; i1 += 1) {
			result1 = result1 | ((((destinationWord & mask3) < (sourceWord & mask3)) ? (destinationWord & mask3) : (sourceWord & mask3)));
			mask3 = mask3 << 8;
		}
		return result1;
	}
}

static int rgbSubwith(int sourceWord, int destinationWord) {
	if (destPixSize < 16) {
		return partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedSubfromnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}

static int scanCharacters(void) {
    int lastIndex;
    int nextDestX;
    int left;
    int top;
    int charVal;
    int ascii;
    int sourceX2;
    int lastIndex1;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	if (scanDisplayFlag) {
		clipRange();
		if ((combinationRule == 30) || (combinationRule == 31)) {
			return interpreterProxy->primitiveFail();
		}
		if (!(lockSurfaces())) {
			return interpreterProxy->primitiveFail();
		}
	}
	/* begin scanCharactersLockedAndClipped */
	if (scanDisplayFlag) {
		left = dx;
		top = dy;
	}
	lastIndex = scanStart;
	while (lastIndex <= scanStop) {
		charVal = interpreterProxy->stObjectat(scanString, lastIndex);
		ascii = (charVal >> 1);
		if (interpreterProxy->failed()) {
			goto l2;
		}
		stopCode = interpreterProxy->stObjectat(scanStopArray, ascii + 1);
		if (interpreterProxy->failed()) {
			goto l2;
		}
		if (!(stopCode == (interpreterProxy->nilObject()))) {
			/* begin returnAt:lastIndex:left:top: */
			stopCode = interpreterProxy->stObjectat(scanStopArray, ascii + 1);
			if (interpreterProxy->failed()) {
				goto l2;
			}
			interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
			if (scanDisplayFlag) {
				affectedL = left;
				affectedR = bbW + dx;
				affectedT = top;
				affectedB = bbH + dy;
			}
			goto l2;
		}
		sourceX = interpreterProxy->stObjectat(scanXTable, ascii + 1);
		sourceX2 = interpreterProxy->stObjectat(scanXTable, ascii + 2);
		if (interpreterProxy->failed()) {
			goto l2;
		}
		if (((sourceX & 1)) && ((sourceX2 & 1))) {
			sourceX = (sourceX >> 1);
			sourceX2 = (sourceX2 >> 1);
		} else {
			interpreterProxy->primitiveFail();
			goto l2;
		}
		nextDestX = destX + (width = sourceX2 - sourceX);
		if (nextDestX > scanRightX) {
			/* begin returnAt:lastIndex:left:top: */
			stopCode = interpreterProxy->stObjectat(scanStopArray, 258);
			if (interpreterProxy->failed()) {
				goto l2;
			}
			interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
			if (scanDisplayFlag) {
				affectedL = left;
				affectedR = bbW + dx;
				affectedT = top;
				affectedB = bbH + dy;
			}
			goto l2;
		}
		if (scanDisplayFlag) {
			clipRange();
			if ((bbW > 0) && (bbH > 0)) {
				/* begin copyBitsLockedAndClipped */
				/* begin tryCopyingBitsQuickly */
				if (noSource) {
					done = 0;
					goto l3;
				}
				if (!(combinationRule == 34)) {
					done = 0;
					goto l3;
				}
				if (!(sourcePixSize == 32)) {
					done = 0;
					goto l3;
				}
				if (sourceForm == destForm) {
					done = 0;
					goto l3;
				}
				if (destPixSize < 8) {
					done = 0;
					goto l3;
				}
				if ((destPixSize == 8) && (colorMap == null)) {
					done = 0;
					goto l3;
				}
				if (destPixSize == 32) {
					alphaSourceBlendBits32();
				}
				if (destPixSize == 16) {
					alphaSourceBlendBits16();
				}
				if (destPixSize == 8) {
					alphaSourceBlendBits8();
				}
				affectedL = dx;
				affectedR = dx + bbW;
				affectedT = dy;
				affectedB = dy + bbH;
				done = 1;
			l3:	/* end tryCopyingBitsQuickly */;
				if (done) {
					goto l4;
				}
				if ((combinationRule == 30) || (combinationRule == 31)) {
					if ((interpreterProxy->methodArgumentCount()) == 1) {
						sourceAlpha = interpreterProxy->stackIntegerValue(0);
						if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
							interpreterProxy->pop(1);
						} else {
							interpreterProxy->primitiveFail();
							goto l4;
						}
					} else {
						interpreterProxy->primitiveFail();
						goto l4;
					}
				}
				bitCount = 0;
				/* begin performCopyLoop */
				/* begin destMaskAndPointerInit */
				pixPerM11 = pixPerWord - 1;
				startBits = pixPerWord - (dx & pixPerM11);
				mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
				endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
				mask2 = 4294967295U << (32 - (endBits * destPixSize));
				if (bbW < startBits) {
					mask1 = mask1 & mask2;
					mask2 = 0;
					nWords = 1;
				} else {
					nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
				}
				hDir = vDir = 1;
				destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
				destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
				if (noSource) {
					copyLoopNoSource();
				} else {
					/* begin checkSourceOverlap */
					if ((sourceForm == destForm) && (dy >= sy)) {
						if (dy > sy) {
							vDir = -1;
							sy = (sy + bbH) - 1;
							dy = (dy + bbH) - 1;
						} else {
							if ((dy == sy) && (dx > sx)) {
								hDir = -1;
								sx = (sx + bbW) - 1;
								dx = (dx + bbW) - 1;
								if (nWords > 1) {
									t = mask1;
									mask1 = mask2;
									mask2 = t;
								}
							}
						}
						destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
						destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					}
					if ((sourcePixSize != destPixSize) || (colorMap != null)) {
						copyLoopPixMap();
					} else {
						/* begin sourceSkewAndPointerInit */
						pixPerM1 = pixPerWord - 1;
						sxLowBits = sx & pixPerM1;
						dxLowBits = dx & pixPerM1;
						if (hDir > 0) {
							dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
							preload = (sxLowBits + dWid) > pixPerM1;
						} else {
							dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
							preload = ((sxLowBits - dWid) + 1) < 0;
						}
						skew = (sxLowBits - dxLowBits) * destPixSize;
						if (preload) {
							if (skew < 0) {
								skew += 32;
							} else {
								skew -= 32;
							}
						}
						sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
						sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
						if (preload) {
							sourceDelta -= 4 * hDir;
						}
						copyLoop();
					}
				}
				if ((combinationRule == 22) || (combinationRule == 32)) {
					affectedL = affectedR = affectedT = affectedB = 0;
					interpreterProxy->pop(1);
					interpreterProxy->pushInteger(bitCount);
					goto l4;
				}
				if (hDir > 0) {
					affectedL = dx;
					affectedR = dx + bbW;
				} else {
					affectedL = (dx - bbW) + 1;
					affectedR = dx + 1;
				}
				if (vDir > 0) {
					affectedT = dy;
					affectedB = dy + bbH;
				} else {
					affectedT = (dy - bbH) + 1;
					affectedB = dy + 1;
				}
			l4:	/* end copyBitsLockedAndClipped */;
			}
		}
		destX = nextDestX;
		interpreterProxy->storeIntegerofObjectwithValue(4, bitBltOop, destX);
		lastIndex += 1;
	}
	/* begin returnAt:lastIndex:left:top: */
	lastIndex1 = scanStop;
	stopCode = interpreterProxy->stObjectat(scanStopArray, 257);
	if (interpreterProxy->failed()) {
		goto l1;
	}
	interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex1);
	if (scanDisplayFlag) {
		affectedL = left;
		affectedR = bbW + dx;
		affectedT = top;
		affectedB = bbH + dy;
	}
l1:	/* end returnAt:lastIndex:left:top: */;
l2:	/* end scanCharactersLockedAndClipped */;
	if (scanDisplayFlag) {
		unlockSurfaces();
	}
}


/*	Perform the actual scanCharacters operation.
	Assume: Surfaces have been locked and clipping was performed. */

static int scanCharactersLockedAndClipped(void) {
    int lastIndex;
    int nextDestX;
    int left;
    int top;
    int charVal;
    int ascii;
    int sourceX2;
    int lastIndex1;
    int done;
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;
    int t;
    int pixPerM11;
    int endBits;
    int startBits;

	if (scanDisplayFlag) {
		left = dx;
		top = dy;
	}
	lastIndex = scanStart;
	while (lastIndex <= scanStop) {
		charVal = interpreterProxy->stObjectat(scanString, lastIndex);
		ascii = (charVal >> 1);
		if (interpreterProxy->failed()) {
			return null;
		}
		stopCode = interpreterProxy->stObjectat(scanStopArray, ascii + 1);
		if (interpreterProxy->failed()) {
			return null;
		}
		if (!(stopCode == (interpreterProxy->nilObject()))) {
			/* begin returnAt:lastIndex:left:top: */
			stopCode = interpreterProxy->stObjectat(scanStopArray, ascii + 1);
			if (interpreterProxy->failed()) {
				return null;
			}
			interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
			if (scanDisplayFlag) {
				affectedL = left;
				affectedR = bbW + dx;
				affectedT = top;
				affectedB = bbH + dy;
			}
			return null;
		}
		sourceX = interpreterProxy->stObjectat(scanXTable, ascii + 1);
		sourceX2 = interpreterProxy->stObjectat(scanXTable, ascii + 2);
		if (interpreterProxy->failed()) {
			return null;
		}
		if (((sourceX & 1)) && ((sourceX2 & 1))) {
			sourceX = (sourceX >> 1);
			sourceX2 = (sourceX2 >> 1);
		} else {
			interpreterProxy->primitiveFail();
			return null;
		}
		nextDestX = destX + (width = sourceX2 - sourceX);
		if (nextDestX > scanRightX) {
			/* begin returnAt:lastIndex:left:top: */
			stopCode = interpreterProxy->stObjectat(scanStopArray, 258);
			if (interpreterProxy->failed()) {
				return null;
			}
			interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
			if (scanDisplayFlag) {
				affectedL = left;
				affectedR = bbW + dx;
				affectedT = top;
				affectedB = bbH + dy;
			}
			return null;
		}
		if (scanDisplayFlag) {
			clipRange();
			if ((bbW > 0) && (bbH > 0)) {
				/* begin copyBitsLockedAndClipped */
				/* begin tryCopyingBitsQuickly */
				if (noSource) {
					done = 0;
					goto l2;
				}
				if (!(combinationRule == 34)) {
					done = 0;
					goto l2;
				}
				if (!(sourcePixSize == 32)) {
					done = 0;
					goto l2;
				}
				if (sourceForm == destForm) {
					done = 0;
					goto l2;
				}
				if (destPixSize < 8) {
					done = 0;
					goto l2;
				}
				if ((destPixSize == 8) && (colorMap == null)) {
					done = 0;
					goto l2;
				}
				if (destPixSize == 32) {
					alphaSourceBlendBits32();
				}
				if (destPixSize == 16) {
					alphaSourceBlendBits16();
				}
				if (destPixSize == 8) {
					alphaSourceBlendBits8();
				}
				affectedL = dx;
				affectedR = dx + bbW;
				affectedT = dy;
				affectedB = dy + bbH;
				done = 1;
			l2:	/* end tryCopyingBitsQuickly */;
				if (done) {
					goto l3;
				}
				if ((combinationRule == 30) || (combinationRule == 31)) {
					if ((interpreterProxy->methodArgumentCount()) == 1) {
						sourceAlpha = interpreterProxy->stackIntegerValue(0);
						if ((!(interpreterProxy->failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
							interpreterProxy->pop(1);
						} else {
							interpreterProxy->primitiveFail();
							goto l3;
						}
					} else {
						interpreterProxy->primitiveFail();
						goto l3;
					}
				}
				bitCount = 0;
				/* begin performCopyLoop */
				/* begin destMaskAndPointerInit */
				pixPerM11 = pixPerWord - 1;
				startBits = pixPerWord - (dx & pixPerM11);
				mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
				endBits = (((dx + bbW) - 1) & pixPerM11) + 1;
				mask2 = 4294967295U << (32 - (endBits * destPixSize));
				if (bbW < startBits) {
					mask1 = mask1 & mask2;
					mask2 = 0;
					nWords = 1;
				} else {
					nWords = (((bbW - startBits) + pixPerM11) / pixPerWord) + 1;
				}
				hDir = vDir = 1;
				destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
				destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
				if (noSource) {
					copyLoopNoSource();
				} else {
					/* begin checkSourceOverlap */
					if ((sourceForm == destForm) && (dy >= sy)) {
						if (dy > sy) {
							vDir = -1;
							sy = (sy + bbH) - 1;
							dy = (dy + bbH) - 1;
						} else {
							if ((dy == sy) && (dx > sx)) {
								hDir = -1;
								sx = (sx + bbW) - 1;
								dx = (dx + bbW) - 1;
								if (nWords > 1) {
									t = mask1;
									mask1 = mask2;
									mask2 = t;
								}
							}
						}
						destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
						destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
					}
					if ((sourcePixSize != destPixSize) || (colorMap != null)) {
						copyLoopPixMap();
					} else {
						/* begin sourceSkewAndPointerInit */
						pixPerM1 = pixPerWord - 1;
						sxLowBits = sx & pixPerM1;
						dxLowBits = dx & pixPerM1;
						if (hDir > 0) {
							dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
							preload = (sxLowBits + dWid) > pixPerM1;
						} else {
							dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
							preload = ((sxLowBits - dWid) + 1) < 0;
						}
						skew = (sxLowBits - dxLowBits) * destPixSize;
						if (preload) {
							if (skew < 0) {
								skew += 32;
							} else {
								skew -= 32;
							}
						}
						sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
						sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
						if (preload) {
							sourceDelta -= 4 * hDir;
						}
						copyLoop();
					}
				}
				if ((combinationRule == 22) || (combinationRule == 32)) {
					affectedL = affectedR = affectedT = affectedB = 0;
					interpreterProxy->pop(1);
					interpreterProxy->pushInteger(bitCount);
					goto l3;
				}
				if (hDir > 0) {
					affectedL = dx;
					affectedR = dx + bbW;
				} else {
					affectedL = (dx - bbW) + 1;
					affectedR = dx + 1;
				}
				if (vDir > 0) {
					affectedT = dy;
					affectedB = dy + bbH;
				} else {
					affectedT = (dy - bbH) + 1;
					affectedB = dy + 1;
				}
			l3:	/* end copyBitsLockedAndClipped */;
			}
		}
		destX = nextDestX;
		interpreterProxy->storeIntegerofObjectwithValue(4, bitBltOop, destX);
		lastIndex += 1;
	}
	/* begin returnAt:lastIndex:left:top: */
	lastIndex1 = scanStop;
	stopCode = interpreterProxy->stObjectat(scanStopArray, 257);
	if (interpreterProxy->failed()) {
		goto l1;
	}
	interpreterProxy->storeIntegerofObjectwithValue(15, bitBltOop, lastIndex1);
	if (scanDisplayFlag) {
		affectedL = left;
		affectedR = bbW + dx;
		affectedT = top;
		affectedB = bbH + dy;
	}
l1:	/* end returnAt:lastIndex:left:top: */;
}


/*	Note: This is coded so that is can be run from Squeak. */

EXPORT(int) BitBltPlugin_setInterpreter(struct VirtualMachine* anInterpreter) {
    int ok;

	interpreterProxy = anInterpreter;
	ok = interpreterProxy->majorVersion() == VM_PROXY_MAJOR;
	if (ok == 0) {
		return 0;
	}
	ok = interpreterProxy->minorVersion() >= VM_PROXY_MINOR;
	return ok;
}

static int setupColorMasks(void) {
    int bits;
    int targetBits;
    int delta;
    int mask;

	bits = targetBits = 0;
	if (sourcePixSize <= 8) {
		return null;
	}
	if (sourcePixSize == 16) {
		bits = 5;
	}
	if (sourcePixSize == 32) {
		bits = 8;
	}
	if (colorMap == null) {
		if (destPixSize <= 8) {
			return null;
		}
		if (destPixSize == 16) {
			targetBits = 5;
		}
		if (destPixSize == 32) {
			targetBits = 8;
		}
	} else {
		targetBits = cmBitsPerColor;
	}
	/* begin setupColorMasksFrom:to: */
	cmDeltaBits = targetBits - bits;
	if (cmDeltaBits <= 0) {
		mask = (1 << targetBits) - 1;
		delta = bits - targetBits;
		cmRedMask = mask << ((bits * 2) - cmDeltaBits);
		cmGreenMask = mask << (bits - cmDeltaBits);
		cmBlueMask = mask << (0 - cmDeltaBits);
	} else {
		mask = (1 << bits) - 1;
		delta = targetBits - bits;
		cmRedMask = mask << (bits * 2);
		cmGreenMask = mask << bits;
		cmBlueMask = mask;
	}
	cmRedShift = delta * 3;
	cmGreenShift = delta * 2;
	cmBlueShift = delta;
}


/*	Setup color masks for converting an incoming RGB pixel value from srcBits to targetBits. */

static int setupColorMasksFromto(int srcBits, int targetBits) {
    int delta;
    int mask;

	cmDeltaBits = targetBits - srcBits;
	if (cmDeltaBits <= 0) {
		mask = (1 << targetBits) - 1;

		/* Mask for extracting a color part of the source */

		delta = srcBits - targetBits;
		cmRedMask = mask << ((srcBits * 2) - cmDeltaBits);
		cmGreenMask = mask << (srcBits - cmDeltaBits);
		cmBlueMask = mask << (0 - cmDeltaBits);
	} else {
		mask = (1 << srcBits) - 1;

		/* Mask for extracting a color part of the source */

		delta = targetBits - srcBits;
		cmRedMask = mask << (srcBits * 2);
		cmGreenMask = mask << srcBits;
		cmBlueMask = mask;
	}
	cmRedShift = delta * 3;
	cmGreenShift = delta * 2;
	cmBlueShift = delta;
}

static int showDisplayBits(void) {
	interpreterProxy->showDisplayBitsLeftTopRightBottom(destForm, affectedL, affectedT, affectedR, affectedB);
}

static int smoothPixatXfyfdxhdyhdxvdyvpixPerWordpixelMasksourceMap(int n, int xf, int yf, int dxh, int dyh, int dxv, int dyv, int srcPixPerWord, int sourcePixMask, int sourceMap) {
    int x;
    int g;
    int i;
    int sourcePix;
    int nPix;
    int maxPix;
    int b;
    int d;
    int y;
    int j;
    int r;
    int rgb;
    int bitsPerColor;
    int srcPix;
    int destPix;
    int d1;
    int mask;


	/* Separate r, g, b components */

	r = g = b = 0;
	maxPix = n * n;
	x = xf;
	y = yf;

	/* actual number of pixels (not clipped and not transparent) */

	nPix = 0;
	for (i = 0; i <= (n - 1); i += 1) {
		for (j = 0; j <= (n - 1); j += 1) {
			sourcePix = (sourcePixAtXypixPerWord(((unsigned) ((x + (dxh * i)) + (dxv * j))) >> 14, ((unsigned) ((y + (dyh * i)) + (dyv * j))) >> 14, srcPixPerWord)) & sourcePixMask;
			if (!((combinationRule == 25) && (sourcePix == 0))) {
				nPix += 1;
				if (sourcePixSize < 16) {
					rgb = (interpreterProxy->fetchWordofObject(sourcePix, sourceMap)) & 16777215;
				} else {
					if (sourcePixSize == 32) {
						rgb = sourcePix & 16777215;
					} else {
						/* begin rgbMap:from:to: */
						if ((d1 = 8 - 5) > 0) {
							mask = (1 << 5) - 1;
							srcPix = sourcePix << d1;
							mask = mask << d1;
							destPix = srcPix & mask;
							mask = mask << 8;
							srcPix = srcPix << d1;
							rgb = (destPix + (srcPix & mask)) + ((srcPix << d1) & (mask << 8));
							goto l1;
						} else {
							if (d1 == 0) {
								if (5 == 5) {
									rgb = sourcePix & 32767;
									goto l1;
								}
								if (5 == 8) {
									rgb = sourcePix & 16777215;
									goto l1;
								}
								rgb = sourcePix;
								goto l1;
							}
							if (sourcePix == 0) {
								rgb = sourcePix;
								goto l1;
							}
							d1 = 5 - 8;
							mask = (1 << 8) - 1;
							srcPix = ((unsigned) sourcePix) >> d1;
							destPix = srcPix & mask;
							mask = mask << 8;
							srcPix = ((unsigned) srcPix) >> d1;
							destPix = (destPix + (srcPix & mask)) + ((((unsigned) srcPix) >> d1) & (mask << 8));
							if (destPix == 0) {
								rgb = 1;
								goto l1;
							}
							rgb = destPix;
							goto l1;
						}
					l1:	/* end rgbMap:from:to: */;
					}
				}
				r += (((unsigned) rgb) >> 16) & 255;
				g += (((unsigned) rgb) >> 8) & 255;
				b += rgb & 255;
			}
		}
	}
	if ((nPix == 0) || ((combinationRule == 25) && (nPix < (((int) maxPix >> 1))))) {
		return 0;
	}
	if (colorMap != null) {
		bitsPerColor = cmBitsPerColor;
	} else {
		if (destPixSize == 16) {
			bitsPerColor = 5;
		}
		if (destPixSize == 32) {
			bitsPerColor = 8;
		}
	}
	d = 8 - bitsPerColor;
	rgb = (((((unsigned) (r / nPix)) >> d) << (bitsPerColor * 2)) + ((((unsigned) (g / nPix)) >> d) << bitsPerColor)) + (((unsigned) (b / nPix)) >> d);
	if (rgb == 0) {
		if (((r + g) + b) > 0) {
			rgb = 1;
		}
	}
	if (colorMap != null) {
		return longAt(colorMap + (rgb << 2));
	} else {
		return rgb;
	}
}

static int sourcePixAtXypixPerWord(int x, int y, int srcPixPerWord) {
    int sourceWord;
    int index;

	if ((x < 0) || (x >= srcWidth)) {
		return 0;
	}
	if ((y < 0) || (y >= srcHeight)) {
		return 0;
	}
	index = (y * sourcePitch) + ((x / srcPixPerWord) * 4);
	sourceWord = longAt(sourceBits + index);
	return ((unsigned) sourceWord) >> ((32 - sourcePixSize) - ((x % srcPixPerWord) * sourcePixSize));
}


/*	This is only used when source and dest are same depth,
	ie, when the barrel-shift copy loop is used. */

static int sourceSkewAndPointerInit(void) {
    int pixPerM1;
    int dxLowBits;
    int dWid;
    int sxLowBits;


	/* A mask, assuming power of two */

	pixPerM1 = pixPerWord - 1;
	sxLowBits = sx & pixPerM1;

	/* check if need to preload buffer
	(i.e., two words of source needed for first word of destination) */

	dxLowBits = dx & pixPerM1;
	if (hDir > 0) {
		dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
		preload = (sxLowBits + dWid) > pixPerM1;
	} else {
		dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
		preload = ((sxLowBits - dWid) + 1) < 0;
	}

	/*  -32..32  */

	skew = (sxLowBits - dxLowBits) * destPixSize;
	if (preload) {
		if (skew < 0) {
			skew += 32;
		} else {
			skew -= 32;
		}
	}

	/* calculate increments from end of 1 line to start of next */

	sourceIndex = (sourceBits + (sy * sourcePitch)) + ((sx / (32 / sourcePixSize)) * 4);
	sourceDelta = (sourcePitch * vDir) - (4 * (nWords * hDir));
	if (preload) {
		sourceDelta -= 4 * hDir;
	}
}

static int sourceWordwith(int sourceWord, int destinationWord) {
	return sourceWord;
}

static int srcLongAt(int idx) {
	return longAt(idx);
}

static int stopReason(void) {
	return stopCode;
}

static int subWordwith(int sourceWord, int destinationWord) {
	return sourceWord - destinationWord;
}


/*	Tally pixels into the color map.  Those tallied are exactly those
	in the destination rectangle.  Note that the source should be 
	specified == destination, in order for the proper color map checks 
	to be performed at setup. */

static int tallyIntoMapwith(int sourceWord, int destinationWord) {
    int i;
    int destShifted;
    int pixVal;
    int pixMask;
    int maskShifted;
    int mapIndex;
    int srcPix;
    int destPix;
    int d;
    int mask;
    int srcPix1;
    int destPix1;
    int d1;
    int mask3;

	if (colorMap == null) {
		return destinationWord;
	}
	pixMask = maskTable[destPixSize];
	destShifted = destinationWord;
	maskShifted = destMask;
	for (i = 1; i <= pixPerWord; i += 1) {
		if (!((maskShifted & pixMask) == 0)) {
			pixVal = destShifted & pixMask;
			if (destPixSize < 16) {
				mapIndex = pixVal;
			} else {
				if (destPixSize == 16) {
					/* begin rgbMap:from:to: */
					if ((d = cmBitsPerColor - 5) > 0) {
						mask = (1 << 5) - 1;
						srcPix = pixVal << d;
						mask = mask << d;
						destPix = srcPix & mask;
						mask = mask << cmBitsPerColor;
						srcPix = srcPix << d;
						mapIndex = (destPix + (srcPix & mask)) + ((srcPix << d) & (mask << cmBitsPerColor));
						goto l1;
					} else {
						if (d == 0) {
							if (5 == 5) {
								mapIndex = pixVal & 32767;
								goto l1;
							}
							if (5 == 8) {
								mapIndex = pixVal & 16777215;
								goto l1;
							}
							mapIndex = pixVal;
							goto l1;
						}
						if (pixVal == 0) {
							mapIndex = pixVal;
							goto l1;
						}
						d = 5 - cmBitsPerColor;
						mask = (1 << cmBitsPerColor) - 1;
						srcPix = ((unsigned) pixVal) >> d;
						destPix = srcPix & mask;
						mask = mask << cmBitsPerColor;
						srcPix = ((unsigned) srcPix) >> d;
						destPix = (destPix + (srcPix & mask)) + ((((unsigned) srcPix) >> d) & (mask << cmBitsPerColor));
						if (destPix == 0) {
							mapIndex = 1;
							goto l1;
						}
						mapIndex = destPix;
						goto l1;
					}
				l1:	/* end rgbMap:from:to: */;
				} else {
					/* begin rgbMap:from:to: */
					if ((d1 = cmBitsPerColor - 8) > 0) {
						mask3 = (1 << 8) - 1;
						srcPix1 = pixVal << d1;
						mask3 = mask3 << d1;
						destPix1 = srcPix1 & mask3;
						mask3 = mask3 << cmBitsPerColor;
						srcPix1 = srcPix1 << d1;
						mapIndex = (destPix1 + (srcPix1 & mask3)) + ((srcPix1 << d1) & (mask3 << cmBitsPerColor));
						goto l2;
					} else {
						if (d1 == 0) {
							if (8 == 5) {
								mapIndex = pixVal & 32767;
								goto l2;
							}
							if (8 == 8) {
								mapIndex = pixVal & 16777215;
								goto l2;
							}
							mapIndex = pixVal;
							goto l2;
						}
						if (pixVal == 0) {
							mapIndex = pixVal;
							goto l2;
						}
						d1 = 8 - cmBitsPerColor;
						mask3 = (1 << cmBitsPerColor) - 1;
						srcPix1 = ((unsigned) pixVal) >> d1;
						destPix1 = srcPix1 & mask3;
						mask3 = mask3 << cmBitsPerColor;
						srcPix1 = ((unsigned) srcPix1) >> d1;
						destPix1 = (destPix1 + (srcPix1 & mask3)) + ((((unsigned) srcPix1) >> d1) & (mask3 << cmBitsPerColor));
						if (destPix1 == 0) {
							mapIndex = 1;
							goto l2;
						}
						mapIndex = destPix1;
						goto l2;
					}
				l2:	/* end rgbMap:from:to: */;
				}
			}
			longAtput(colorMap + (mapIndex << 2), (longAt(colorMap + (mapIndex << 2))) + 1);
		}
		maskShifted = ((unsigned) maskShifted) >> destPixSize;
		destShifted = ((unsigned) destShifted) >> destPixSize;
	}
	return destinationWord;
}


/*	Shortcut for stuff that's being run from the balloon engine.
	Since we do this at each scan line we should avoid the expensive 
	setup for source and destination. */

static int tryCopyingBitsQuickly(void) {
	if (noSource) {
		return 0;
	}
	if (!(combinationRule == 34)) {
		return 0;
	}
	if (!(sourcePixSize == 32)) {
		return 0;
	}
	if (sourceForm == destForm) {
		return 0;
	}
	if (destPixSize < 8) {
		return 0;
	}
	if ((destPixSize == 8) && (colorMap == null)) {
		return 0;
	}
	if (destPixSize == 32) {
		alphaSourceBlendBits32();
	}
	if (destPixSize == 16) {
		alphaSourceBlendBits16();
	}
	if (destPixSize == 8) {
		alphaSourceBlendBits8();
	}
	affectedL = dx;
	affectedR = dx + bbW;
	affectedT = dy;
	affectedB = dy + bbH;
	return 1;
}


/*	Unlock the bits of any OS surfaces. */
/*	Note: It is possible to query for the dirty rectangle from ioUnlockSurfaceBits()
	since the affected regions are set before this method is called. This is currently
	not part of the InterpreterProxy interface but one can query for affectedLeft(),
	affectedRight(), affectedTop(), and affectedBottom() if the surface support
	is compiled with the VM. */

static int unlockSurfaces(void) {
    int surfaceHandle;

	if (hasSurfaceLock) {
		surfaceHandle = interpreterProxy->fetchPointerofObject(0, sourceForm);
		if ((surfaceHandle & 1)) {

			/* self ioUnlockSurfaceBits: surfaceHandle. */

			surfaceHandle = (surfaceHandle >> 1);
			sourceBits = sourcePitch = 0;
		}
		surfaceHandle = interpreterProxy->fetchPointerofObject(0, destForm);
		if ((surfaceHandle & 1)) {

			/* self ioUnlockSurfaceBits: surfaceHandle. */

			surfaceHandle = (surfaceHandle >> 1);
			destBits = destPitch = 0;
		}
		hasSurfaceLock = 0;
	}
}

static int warpBits(void) {
    int ns;
    int surfaceHandle;
    int pixPerM1;
    int endBits;
    int startBits;

	ns = noSource;
	noSource = 1;
	clipRange();
	noSource = ns;
	if (noSource || ((bbW <= 0) || (bbH <= 0))) {
		affectedL = affectedR = affectedT = affectedB = 0;
		return null;
	}
	/* begin lockSurfaces */
	hasSurfaceLock = 0;
	if (destBits == 0) {
		surfaceHandle = interpreterProxy->fetchIntegerofObject(0, destForm);
		hasSurfaceLock = 1;
	}
	if ((sourceBits == 0) && (!noSource)) {
		surfaceHandle = interpreterProxy->fetchIntegerofObject(0, sourceForm);
		hasSurfaceLock = 1;
	}
	(destBits != 0) && ((sourceBits != 0) || (noSource));
	/* begin destMaskAndPointerInit */
	pixPerM1 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM1);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM1) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM1) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + (dy * destPitch)) + ((dx / pixPerWord) * 4);
	destDelta = (destPitch * vDir) - (4 * (nWords * hDir));
	xWarpLoop();
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
	unlockSurfaces();
}


/*	ar 12/7/1999: This version is unused but kept as reference implemenation */
/*	This version of the inner loop traverses an arbirary quadrilateral
	source, thus producing a general affine transformation. */

static int warpLoop(void) {
    int mergeWord;
    int word;
    int i;
    int deltaP43x;
    int yDelta;
    int pBx;
    int deltaP12y;
    int xDelta;
    int halftoneWord;
    int smoothingCount;
    int pAy;
    int skewWord;
    int sourceMapOop;
    int startBits;
    int deltaP43y;
    int nSteps;
    int pBy;
    int deltaP12x;
    int t;
    int pAx;
    int dstValue;

	if (!((interpreterProxy->slotSizeOf(bitBltOop)) >= (15 + 12))) {
		return interpreterProxy->primitiveFail();
	}
	nSteps = height - 1;
	if (nSteps <= 0) {
		nSteps = 1;
	}
	pAx = fetchIntOrFloatofObject(15, bitBltOop);
	t = fetchIntOrFloatofObject(15 + 3, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (t > pAx) {
		deltaP12x = (((t - pAx) + 16384) / (nSteps + 1)) + 1;
		goto l3;
	} else {
		if (t == pAx) {
			deltaP12x = 0;
			goto l3;
		}
		deltaP12x = 0 - ((((pAx - t) + 16384) / (nSteps + 1)) + 1);
		goto l3;
	}
l3:	/* end deltaFrom:to:nSteps: */;
	if (deltaP12x < 0) {
		pAx = t - (nSteps * deltaP12x);
	}
	pAy = fetchIntOrFloatofObject(15 + 1, bitBltOop);
	t = fetchIntOrFloatofObject(15 + 4, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (t > pAy) {
		deltaP12y = (((t - pAy) + 16384) / (nSteps + 1)) + 1;
		goto l4;
	} else {
		if (t == pAy) {
			deltaP12y = 0;
			goto l4;
		}
		deltaP12y = 0 - ((((pAy - t) + 16384) / (nSteps + 1)) + 1);
		goto l4;
	}
l4:	/* end deltaFrom:to:nSteps: */;
	if (deltaP12y < 0) {
		pAy = t - (nSteps * deltaP12y);
	}
	pBx = fetchIntOrFloatofObject(15 + 9, bitBltOop);
	t = fetchIntOrFloatofObject(15 + 6, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (t > pBx) {
		deltaP43x = (((t - pBx) + 16384) / (nSteps + 1)) + 1;
		goto l5;
	} else {
		if (t == pBx) {
			deltaP43x = 0;
			goto l5;
		}
		deltaP43x = 0 - ((((pBx - t) + 16384) / (nSteps + 1)) + 1);
		goto l5;
	}
l5:	/* end deltaFrom:to:nSteps: */;
	if (deltaP43x < 0) {
		pBx = t - (nSteps * deltaP43x);
	}
	pBy = fetchIntOrFloatofObject(15 + 10, bitBltOop);
	t = fetchIntOrFloatofObject(15 + 7, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (t > pBy) {
		deltaP43y = (((t - pBy) + 16384) / (nSteps + 1)) + 1;
		goto l6;
	} else {
		if (t == pBy) {
			deltaP43y = 0;
			goto l6;
		}
		deltaP43y = 0 - ((((pBy - t) + 16384) / (nSteps + 1)) + 1);
		goto l6;
	}
l6:	/* end deltaFrom:to:nSteps: */;
	if (deltaP43y < 0) {
		pBy = t - (nSteps * deltaP43y);
	}
	if (interpreterProxy->failed()) {
		return 0;
	}
	if ((interpreterProxy->methodArgumentCount()) == 2) {
		smoothingCount = interpreterProxy->stackIntegerValue(1);
		sourceMapOop = interpreterProxy->stackValue(0);
		if (sourceMapOop == (interpreterProxy->nilObject())) {
			if (sourcePixSize < 16) {
				return interpreterProxy->primitiveFail();
			}
		} else {
			if ((interpreterProxy->slotSizeOf(sourceMapOop)) < (1 << sourcePixSize)) {
				return interpreterProxy->primitiveFail();
			}
		}
	} else {
		smoothingCount = 1;
		sourceMapOop = interpreterProxy->nilObject();
	}
	startBits = pixPerWord - (dx & (pixPerWord - 1));
	nSteps = width - 1;
	if (nSteps <= 0) {
		nSteps = 1;
	}
	for (i = destY; i <= (clipY - 1); i += 1) {
		pAx += deltaP12x;
		pAy += deltaP12y;
		pBx += deltaP43x;
		pBy += deltaP43y;
	}
	for (i = 1; i <= bbH; i += 1) {
		/* begin deltaFrom:to:nSteps: */
		if (pBx > pAx) {
			xDelta = (((pBx - pAx) + 16384) / (nSteps + 1)) + 1;
			goto l1;
		} else {
			if (pBx == pAx) {
				xDelta = 0;
				goto l1;
			}
			xDelta = 0 - ((((pAx - pBx) + 16384) / (nSteps + 1)) + 1);
			goto l1;
		}
	l1:	/* end deltaFrom:to:nSteps: */;
		if (xDelta >= 0) {
			sx = pAx;
		} else {
			sx = pBx - (nSteps * xDelta);
		}
		/* begin deltaFrom:to:nSteps: */
		if (pBy > pAy) {
			yDelta = (((pBy - pAy) + 16384) / (nSteps + 1)) + 1;
			goto l2;
		} else {
			if (pBy == pAy) {
				yDelta = 0;
				goto l2;
			}
			yDelta = 0 - ((((pAy - pBy) + 16384) / (nSteps + 1)) + 1);
			goto l2;
		}
	l2:	/* end deltaFrom:to:nSteps: */;
		if (yDelta >= 0) {
			sy = pAy;
		} else {
			sy = pBy - (nSteps * yDelta);
		}
		for (word = destX; word <= (clipX - 1); word += 1) {
			sx += xDelta;
			sy += yDelta;
		}
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}

		/* pick up first word */

		destMask = mask1;
		if (bbW < startBits) {
			skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(bbW, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
			skewWord = ((((startBits - bbW) * destPixSize) < 0) ? ((unsigned) skewWord >> -((startBits - bbW) * destPixSize)) : ((unsigned) skewWord << ((startBits - bbW) * destPixSize)));
		} else {
			skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(startBits, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
		}
		for (word = 1; word <= nWords; word += 1) {
			mergeWord = mergewith(skewWord & halftoneWord, (longAt(destIndex)) & destMask);
			/* begin dstLongAt:put:mask: */
			dstValue = longAt(destIndex);
			dstValue = dstValue & (~destMask);
			dstValue = dstValue | (destMask & mergeWord);
			longAtput(destIndex, dstValue);
			destIndex += 4;
			if (word >= (nWords - 1)) {
				if (!(word == nWords)) {
					destMask = mask2;
					skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(pixPerWord, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
				}
			} else {
				destMask = 4294967295U;
				skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(pixPerWord, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
			}
		}
		pAx += deltaP12x;
		pAy += deltaP12y;
		pBx += deltaP43x;
		pBy += deltaP43y;
		destIndex += destDelta;
	}
}


/*	Pick n (sub-) pixels from the source form, mapped by sourceMap,
	average the RGB values, map by colorMap and return the new word.
	This version is only called from WarpBlt with smoothingCount > 1 */

static int warpPickSmoothPixelsxDeltahyDeltahxDeltavyDeltavsourceMapsmoothing(int nPixels, int xDeltah, int yDeltah, int xDeltav, int yDeltav, int sourceMap, int n) {
    int x;
    int g;
    int i;
    int k;
    int nPix;
    int b;
    int yy;
    int ydv;
    int dstMask;
    int ydh;
    int y;
    int destWord;
    int xx;
    int xdv;
    int j;
    int xdh;
    int rgb;
    int a;
    int r;
    int x1;
    int sourcePix;
    int sourceWord;
    int y1;
    int srcIndex;
    int delta;
    int delta1;

	dstMask = maskTable[destPixSize];
	destWord = 0;
	if (n == 2) {
		xdh = ((int) xDeltah >> 1);
		ydh = ((int) yDeltah >> 1);
		xdv = ((int) xDeltav >> 1);
		ydv = ((int) yDeltav >> 1);
	} else {
		xdh = xDeltah / n;
		ydh = yDeltah / n;
		xdv = xDeltav / n;
		ydv = yDeltav / n;
	}
	i = nPixels;
	do {
		x = sx;
		y = sy;

		/* Pick and average n*n subpixels */

		a = r = g = b = 0;

		/* actual number of pixels (not clipped and not transparent) */

		nPix = 0;
		j = n;
		do {
			xx = x;
			yy = y;
			k = n;
			do {
				/* begin pickWarpPixelAtX:y: */
				if ((xx < 0) || ((yy < 0) || (((x1 = ((unsigned) xx) >> 14) >= srcWidth) || ((y1 = ((unsigned) yy) >> 14) >= srcHeight)))) {
					rgb = 0;
					goto l1;
				}
				srcIndex = (sourceBits + (y1 * sourcePitch)) + ((((unsigned) x1) >> warpAlignShift) * 4);
				sourceWord = longAt(srcIndex);
				srcBitShift = warpBitShiftTable[x1 & warpAlignMask];
				sourcePix = (((unsigned) sourceWord) >> srcBitShift) & warpSrcMask;
				rgb = sourcePix;
			l1:	/* end pickWarpPixelAtX:y: */;
				if (!((combinationRule == 25) && (rgb == 0))) {
					nPix += 1;
					if (sourcePixSize < 16) {
						rgb = longAt(sourceMap + (rgb << 2));
					} else {
						if (sourcePixSize == 16) {
							rgb = (((rgb & 31) << 3) | ((rgb & 992) << 6)) | ((rgb & 31744) << 9);
						} else {
							rgb = rgb;
						}
					}
					b += rgb & 255;
					g += (((unsigned) rgb) >> 8) & 255;
					r += (((unsigned) rgb) >> 16) & 255;
					a += ((unsigned) rgb) >> 24;
				}
				xx += xdh;
				yy += ydh;
			} while(!((k -= 1) == 0));
			x += xdv;
			y += ydv;
		} while(!((j -= 1) == 0));
		if ((nPix == 0) || ((combinationRule == 25) && (nPix < (((int) (n * n) >> 1))))) {

			/* All pixels were 0, or most were transparent */

			rgb = 0;
		} else {
			if (nPix == 4) {
				r = ((unsigned) r) >> 2;
				g = ((unsigned) g) >> 2;
				b = ((unsigned) b) >> 2;
				a = ((unsigned) a) >> 2;
			} else {
				r = r / nPix;
				g = g / nPix;
				b = b / nPix;
				a = a / nPix;
			}

			/* map the pixel */

			rgb = (((a << 24) + (r << 16)) + (g << 8)) + b;
			if (colorMap == null) {
				/* begin rgbMap32ToX: */
				if (destPixSize == 16) {
					/* begin rgbMap32:to: */
					delta = 8 - 5;
					rgb = ((((((unsigned) ((((unsigned) rgb) >> 16) & 255)) >> delta) << 5) + (((unsigned) ((((unsigned) rgb) >> 8) & 255)) >> delta)) << 5) + (((unsigned) (rgb & 255)) >> delta);
					goto l2;
				} else {
					rgb = rgb;
					goto l2;
				}
			l2:	/* end rgbMap32ToX: */;
			} else {
				/* begin rgbMap32:to: */
				delta1 = 8 - cmBitsPerColor;
				rgb = ((((((unsigned) ((((unsigned) rgb) >> 16) & 255)) >> delta1) << cmBitsPerColor) + (((unsigned) ((((unsigned) rgb) >> 8) & 255)) >> delta1)) << cmBitsPerColor) + (((unsigned) (rgb & 255)) >> delta1);
			}
			if (rgb == 0) {
				if ((((r + g) + b) + a) > 0) {
					rgb = 1;
				}
			}
			if (!(colorMap == null)) {
				rgb = longAt(colorMap + (rgb << 2));
			}
		}
		destWord = destWord | ((rgb & dstMask) << dstBitShift);
		dstBitShift -= destPixSize;
		sx += xDeltah;
		sy += yDeltah;
	} while(!((i -= 1) == 0));

	/* Shift towards leftmost pixel */

	dstBitShift = 32 - destPixSize;
	return destWord;
}


/*	Pick n pixels from the source form,
	map by colorMap and return aligned by dstBitShift.
	This version is only called from WarpBlt with smoothingCount = 1 */

static int warpPickSourcePixelsxDeltahyDeltahxDeltavyDeltav(int nPixels, int xDeltah, int yDeltah, int xDeltav, int yDeltav) {
    int sourcePix;
    int nPix;
    int destPix;
    int dstMask;
    int destWord;
    int x;
    int sourcePix1;
    int sourceWord;
    int y;
    int srcIndex;

	dstMask = maskTable[destPixSize];
	destWord = 0;
	nPix = nPixels;
	do {
		/* begin pickWarpPixelAtX:y: */
		if ((sx < 0) || ((sy < 0) || (((x = ((unsigned) sx) >> 14) >= srcWidth) || ((y = ((unsigned) sy) >> 14) >= srcHeight)))) {
			sourcePix = 0;
			goto l2;
		}
		srcIndex = (sourceBits + (y * sourcePitch)) + ((((unsigned) x) >> warpAlignShift) * 4);
		sourceWord = longAt(srcIndex);
		srcBitShift = warpBitShiftTable[x & warpAlignMask];
		sourcePix1 = (((unsigned) sourceWord) >> srcBitShift) & warpSrcMask;
		sourcePix = sourcePix1;
	l2:	/* end pickWarpPixelAtX:y: */;
		destPix = sourcePix;
		if (sourcePixSize > 8) {
			if (!(cmDeltaBits == 0)) {
				/* begin rgbMap: */
				if (cmDeltaBits < 0) {
					destPix = (((unsigned) (sourcePix & cmRedMask)) >> cmRedShift) | ((((unsigned) (sourcePix & cmGreenMask)) >> cmGreenShift) | (((unsigned) (sourcePix & cmBlueMask)) >> cmBlueShift));
					goto l1;
				} else {
					destPix = ((sourcePix & cmRedMask) << cmRedShift) | (((sourcePix & cmGreenMask) << cmGreenShift) | ((sourcePix & cmBlueMask) << cmBlueShift));
					goto l1;
				}
			l1:	/* end rgbMap: */;
				if ((destPix == 0) && (sourcePix != 0)) {
					destPix = 1;
				}
			}
		}
		if (!(colorMap == null)) {
			destPix = longAt(colorMap + (destPix << 2));
		}
		destWord = destWord | ((destPix & dstMask) << dstBitShift);
		dstBitShift -= destPixSize;
		sx += xDeltah;
		sy += yDeltah;
	} while(!((nPix -= 1) == 0));

	/* Shift towards leftmost pixel */

	dstBitShift = 32 - destPixSize;
	return destWord;
}


/*	Pick nPix pixels using these x- and y-incs, and map color if necess. */

static int warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(int nPix, int xDeltah, int yDeltah, int xDeltav, int yDeltav, int n, int sourceMapOop) {
    int srcPixPerWord;
    int i;
    int sourcePix;
    int destPixMask;
    int destPix;
    int sourcePixMask;
    int destWord;
    int srcPix;
    int destPix1;
    int d;
    int mask;
    int srcPix1;
    int destPix2;
    int d1;
    int mask3;
    int srcPix2;
    int destPix3;
    int d2;
    int mask4;
    int srcPix3;
    int destPix4;
    int d3;
    int mask5;

	sourcePixMask = maskTable[sourcePixSize];
	destPixMask = maskTable[destPixSize];
	srcPixPerWord = 32 / sourcePixSize;
	destWord = 0;
	for (i = 1; i <= nPix; i += 1) {
		if (n > 1) {
			destPix = (smoothPixatXfyfdxhdyhdxvdyvpixPerWordpixelMasksourceMap(n, sx, sy, xDeltah / n, yDeltah / n, xDeltav / n, yDeltav / n, srcPixPerWord, sourcePixMask, sourceMapOop)) & destPixMask;
		} else {
			sourcePix = (sourcePixAtXypixPerWord(((unsigned) sx) >> 14, ((unsigned) sy) >> 14, srcPixPerWord)) & sourcePixMask;
			if (colorMap == null) {
				if (destPixSize == sourcePixSize) {
					destPix = sourcePix;
				} else {
					if (sourcePixSize >= 16) {
						if (sourcePixSize == 16) {
							/* begin rgbMap:from:to: */
							if ((d = 8 - 5) > 0) {
								mask = (1 << 5) - 1;
								srcPix = sourcePix << d;
								mask = mask << d;
								destPix1 = srcPix & mask;
								mask = mask << 8;
								srcPix = srcPix << d;
								destPix = (destPix1 + (srcPix & mask)) + ((srcPix << d) & (mask << 8));
								goto l1;
							} else {
								if (d == 0) {
									if (5 == 5) {
										destPix = sourcePix & 32767;
										goto l1;
									}
									if (5 == 8) {
										destPix = sourcePix & 16777215;
										goto l1;
									}
									destPix = sourcePix;
									goto l1;
								}
								if (sourcePix == 0) {
									destPix = sourcePix;
									goto l1;
								}
								d = 5 - 8;
								mask = (1 << 8) - 1;
								srcPix = ((unsigned) sourcePix) >> d;
								destPix1 = srcPix & mask;
								mask = mask << 8;
								srcPix = ((unsigned) srcPix) >> d;
								destPix1 = (destPix1 + (srcPix & mask)) + ((((unsigned) srcPix) >> d) & (mask << 8));
								if (destPix1 == 0) {
									destPix = 1;
									goto l1;
								}
								destPix = destPix1;
								goto l1;
							}
						l1:	/* end rgbMap:from:to: */;
						} else {
							/* begin rgbMap:from:to: */
							if ((d1 = 5 - 8) > 0) {
								mask3 = (1 << 8) - 1;
								srcPix1 = sourcePix << d1;
								mask3 = mask3 << d1;
								destPix2 = srcPix1 & mask3;
								mask3 = mask3 << 5;
								srcPix1 = srcPix1 << d1;
								destPix = (destPix2 + (srcPix1 & mask3)) + ((srcPix1 << d1) & (mask3 << 5));
								goto l2;
							} else {
								if (d1 == 0) {
									if (8 == 5) {
										destPix = sourcePix & 32767;
										goto l2;
									}
									if (8 == 8) {
										destPix = sourcePix & 16777215;
										goto l2;
									}
									destPix = sourcePix;
									goto l2;
								}
								if (sourcePix == 0) {
									destPix = sourcePix;
									goto l2;
								}
								d1 = 8 - 5;
								mask3 = (1 << 5) - 1;
								srcPix1 = ((unsigned) sourcePix) >> d1;
								destPix2 = srcPix1 & mask3;
								mask3 = mask3 << 5;
								srcPix1 = ((unsigned) srcPix1) >> d1;
								destPix2 = (destPix2 + (srcPix1 & mask3)) + ((((unsigned) srcPix1) >> d1) & (mask3 << 5));
								if (destPix2 == 0) {
									destPix = 1;
									goto l2;
								}
								destPix = destPix2;
								goto l2;
							}
						l2:	/* end rgbMap:from:to: */;
						}
					} else {
						destPix = sourcePix & destPixMask;
					}
				}
			} else {
				if (sourcePixSize >= 16) {
					if (sourcePixSize == 16) {
						/* begin rgbMap:from:to: */
						if ((d2 = cmBitsPerColor - 5) > 0) {
							mask4 = (1 << 5) - 1;
							srcPix2 = sourcePix << d2;
							mask4 = mask4 << d2;
							destPix3 = srcPix2 & mask4;
							mask4 = mask4 << cmBitsPerColor;
							srcPix2 = srcPix2 << d2;
							sourcePix = (destPix3 + (srcPix2 & mask4)) + ((srcPix2 << d2) & (mask4 << cmBitsPerColor));
							goto l3;
						} else {
							if (d2 == 0) {
								if (5 == 5) {
									sourcePix = sourcePix & 32767;
									goto l3;
								}
								if (5 == 8) {
									sourcePix = sourcePix & 16777215;
									goto l3;
								}
								sourcePix = sourcePix;
								goto l3;
							}
							if (sourcePix == 0) {
								sourcePix = sourcePix;
								goto l3;
							}
							d2 = 5 - cmBitsPerColor;
							mask4 = (1 << cmBitsPerColor) - 1;
							srcPix2 = ((unsigned) sourcePix) >> d2;
							destPix3 = srcPix2 & mask4;
							mask4 = mask4 << cmBitsPerColor;
							srcPix2 = ((unsigned) srcPix2) >> d2;
							destPix3 = (destPix3 + (srcPix2 & mask4)) + ((((unsigned) srcPix2) >> d2) & (mask4 << cmBitsPerColor));
							if (destPix3 == 0) {
								sourcePix = 1;
								goto l3;
							}
							sourcePix = destPix3;
							goto l3;
						}
					l3:	/* end rgbMap:from:to: */;
					} else {
						/* begin rgbMap:from:to: */
						if ((d3 = cmBitsPerColor - 8) > 0) {
							mask5 = (1 << 8) - 1;
							srcPix3 = sourcePix << d3;
							mask5 = mask5 << d3;
							destPix4 = srcPix3 & mask5;
							mask5 = mask5 << cmBitsPerColor;
							srcPix3 = srcPix3 << d3;
							sourcePix = (destPix4 + (srcPix3 & mask5)) + ((srcPix3 << d3) & (mask5 << cmBitsPerColor));
							goto l4;
						} else {
							if (d3 == 0) {
								if (8 == 5) {
									sourcePix = sourcePix & 32767;
									goto l4;
								}
								if (8 == 8) {
									sourcePix = sourcePix & 16777215;
									goto l4;
								}
								sourcePix = sourcePix;
								goto l4;
							}
							if (sourcePix == 0) {
								sourcePix = sourcePix;
								goto l4;
							}
							d3 = 8 - cmBitsPerColor;
							mask5 = (1 << cmBitsPerColor) - 1;
							srcPix3 = ((unsigned) sourcePix) >> d3;
							destPix4 = srcPix3 & mask5;
							mask5 = mask5 << cmBitsPerColor;
							srcPix3 = ((unsigned) srcPix3) >> d3;
							destPix4 = (destPix4 + (srcPix3 & mask5)) + ((((unsigned) srcPix3) >> d3) & (mask5 << cmBitsPerColor));
							if (destPix4 == 0) {
								sourcePix = 1;
								goto l4;
							}
							sourcePix = destPix4;
							goto l4;
						}
					l4:	/* end rgbMap:from:to: */;
					}
				}
				destPix = (longAt(colorMap + (sourcePix << 2))) & destPixMask;
			}
		}
		if (destPixSize == 32) {
			destWord = destPix;
		} else {
			destWord = (destWord << destPixSize) | destPix;
		}
		sx += xDeltah;
		sy += yDeltah;
	}
	return destWord;
}


/*	This version of the inner loop traverses an arbirary quadrilateral
	source, thus producing a general affine transformation. */

static int xWarpLoop(void) {
    int mergeWord;
    int i;
    int deltaP43x;
    int (*mergeFnwith)(int, int);
    int yDelta;
    int nPix;
    int endBits;
    int pBx;
    int deltaP12y;
    int xDelta;
    int halftoneWord;
    int smoothingCount;
    int pAy;
    int skewWord;
    int words;
    int sourceMapOop;
    int destWord;
    int startBits;
    int deltaP43y;
    int nSteps;
    int pBy;
    int deltaP12x;
    int pAx;
    int sourcePix;
    int nPix1;
    int destPix;
    int dstMask;
    int destWord1;
    int x;
    int sourcePix1;
    int sourceWord;
    int y;
    int srcIndex;

	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	if (!((interpreterProxy->slotSizeOf(bitBltOop)) >= (15 + 12))) {
		return interpreterProxy->primitiveFail();
	}
	nSteps = height - 1;
	if (nSteps <= 0) {
		nSteps = 1;
	}
	pAx = fetchIntOrFloatofObject(15, bitBltOop);
	words = fetchIntOrFloatofObject(15 + 3, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (words > pAx) {
		deltaP12x = (((words - pAx) + 16384) / (nSteps + 1)) + 1;
		goto l3;
	} else {
		if (words == pAx) {
			deltaP12x = 0;
			goto l3;
		}
		deltaP12x = 0 - ((((pAx - words) + 16384) / (nSteps + 1)) + 1);
		goto l3;
	}
l3:	/* end deltaFrom:to:nSteps: */;
	if (deltaP12x < 0) {
		pAx = words - (nSteps * deltaP12x);
	}
	pAy = fetchIntOrFloatofObject(15 + 1, bitBltOop);
	words = fetchIntOrFloatofObject(15 + 4, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (words > pAy) {
		deltaP12y = (((words - pAy) + 16384) / (nSteps + 1)) + 1;
		goto l4;
	} else {
		if (words == pAy) {
			deltaP12y = 0;
			goto l4;
		}
		deltaP12y = 0 - ((((pAy - words) + 16384) / (nSteps + 1)) + 1);
		goto l4;
	}
l4:	/* end deltaFrom:to:nSteps: */;
	if (deltaP12y < 0) {
		pAy = words - (nSteps * deltaP12y);
	}
	pBx = fetchIntOrFloatofObject(15 + 9, bitBltOop);
	words = fetchIntOrFloatofObject(15 + 6, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (words > pBx) {
		deltaP43x = (((words - pBx) + 16384) / (nSteps + 1)) + 1;
		goto l5;
	} else {
		if (words == pBx) {
			deltaP43x = 0;
			goto l5;
		}
		deltaP43x = 0 - ((((pBx - words) + 16384) / (nSteps + 1)) + 1);
		goto l5;
	}
l5:	/* end deltaFrom:to:nSteps: */;
	if (deltaP43x < 0) {
		pBx = words - (nSteps * deltaP43x);
	}
	pBy = fetchIntOrFloatofObject(15 + 10, bitBltOop);
	words = fetchIntOrFloatofObject(15 + 7, bitBltOop);
	/* begin deltaFrom:to:nSteps: */
	if (words > pBy) {
		deltaP43y = (((words - pBy) + 16384) / (nSteps + 1)) + 1;
		goto l6;
	} else {
		if (words == pBy) {
			deltaP43y = 0;
			goto l6;
		}
		deltaP43y = 0 - ((((pBy - words) + 16384) / (nSteps + 1)) + 1);
		goto l6;
	}
l6:	/* end deltaFrom:to:nSteps: */;
	if (deltaP43y < 0) {
		pBy = words - (nSteps * deltaP43y);
	}
	if (interpreterProxy->failed()) {
		return 0;
	}
	if ((interpreterProxy->methodArgumentCount()) == 2) {
		smoothingCount = interpreterProxy->stackIntegerValue(1);
		sourceMapOop = interpreterProxy->stackValue(0);
		if (sourceMapOop == (interpreterProxy->nilObject())) {
			if (sourcePixSize < 16) {
				return interpreterProxy->primitiveFail();
			}
		} else {
			if ((interpreterProxy->slotSizeOf(sourceMapOop)) < (1 << sourcePixSize)) {
				return interpreterProxy->primitiveFail();
			}
			sourceMapOop = ((int) (interpreterProxy->firstIndexableField(sourceMapOop)));
		}
	} else {
		smoothingCount = 1;
		sourceMapOop = interpreterProxy->nilObject();
	}
	nSteps = width - 1;
	if (nSteps <= 0) {
		nSteps = 1;
	}
	startBits = pixPerWord - (dx & (pixPerWord - 1));
	endBits = (((dx + bbW) - 1) & (pixPerWord - 1)) + 1;
	if (bbW < startBits) {
		startBits = bbW;
	}
	if (destY < clipY) {
		pAx += (clipY - destY) * deltaP12x;
		pAy += (clipY - destY) * deltaP12y;
		pBx += (clipY - destY) * deltaP43x;
		pBy += (clipY - destY) * deltaP43y;
	}
	warpSrcShift = 0;

	/* recycle temp */

	words = sourcePixSize;
	while (!(words == 1)) {
		warpSrcShift += 1;
		words = ((unsigned) words) >> 1;
	}

	/* warpAlignShift: Shift for aligning x position to word boundary */

	warpSrcMask = maskTable[sourcePixSize];

	/* warpAlignMask: Mask for extracting the pixel position from an x position */

	warpAlignShift = 5 - warpSrcShift;

	/* Setup the lookup table for source bit shifts */
	/* warpBitShiftTable: given an sub-word x value what's the bit shift? */

	warpAlignMask = (1 << warpAlignShift) - 1;
	for (i = 0; i <= warpAlignMask; i += 1) {
		warpBitShiftTable[i] = (32 - ((i + 1) << warpSrcShift));
	}
	for (i = 1; i <= bbH; i += 1) {
		/* begin deltaFrom:to:nSteps: */
		if (pBx > pAx) {
			xDelta = (((pBx - pAx) + 16384) / (nSteps + 1)) + 1;
			goto l1;
		} else {
			if (pBx == pAx) {
				xDelta = 0;
				goto l1;
			}
			xDelta = 0 - ((((pAx - pBx) + 16384) / (nSteps + 1)) + 1);
			goto l1;
		}
	l1:	/* end deltaFrom:to:nSteps: */;
		if (xDelta >= 0) {
			sx = pAx;
		} else {
			sx = pBx - (nSteps * xDelta);
		}
		/* begin deltaFrom:to:nSteps: */
		if (pBy > pAy) {
			yDelta = (((pBy - pAy) + 16384) / (nSteps + 1)) + 1;
			goto l2;
		} else {
			if (pBy == pAy) {
				yDelta = 0;
				goto l2;
			}
			yDelta = 0 - ((((pAy - pBy) + 16384) / (nSteps + 1)) + 1);
			goto l2;
		}
	l2:	/* end deltaFrom:to:nSteps: */;
		if (yDelta >= 0) {
			sy = pAy;
		} else {
			sy = pBy - (nSteps * yDelta);
		}
		dstBitShift = 32 - (((dx & (pixPerWord - 1)) + 1) * destPixSize);
		if (destX < clipX) {
			sx += (clipX - destX) * xDelta;
			sy += (clipX - destX) * yDelta;
		}
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}
		destMask = mask1;

		/* Here is the inner loop... */

		nPix = startBits;
		words = nWords;
		do {
			if (smoothingCount == 1) {
				/* begin warpPickSourcePixels:xDeltah:yDeltah:xDeltav:yDeltav: */
				dstMask = maskTable[destPixSize];
				destWord1 = 0;
				nPix1 = nPix;
				do {
					/* begin pickWarpPixelAtX:y: */
					if ((sx < 0) || ((sy < 0) || (((x = ((unsigned) sx) >> 14) >= srcWidth) || ((y = ((unsigned) sy) >> 14) >= srcHeight)))) {
						sourcePix = 0;
						goto l8;
					}
					srcIndex = (sourceBits + (y * sourcePitch)) + ((((unsigned) x) >> warpAlignShift) * 4);
					sourceWord = longAt(srcIndex);
					srcBitShift = warpBitShiftTable[x & warpAlignMask];
					sourcePix1 = (((unsigned) sourceWord) >> srcBitShift) & warpSrcMask;
					sourcePix = sourcePix1;
				l8:	/* end pickWarpPixelAtX:y: */;
					destPix = sourcePix;
					if (sourcePixSize > 8) {
						if (!(cmDeltaBits == 0)) {
							/* begin rgbMap: */
							if (cmDeltaBits < 0) {
								destPix = (((unsigned) (sourcePix & cmRedMask)) >> cmRedShift) | ((((unsigned) (sourcePix & cmGreenMask)) >> cmGreenShift) | (((unsigned) (sourcePix & cmBlueMask)) >> cmBlueShift));
								goto l7;
							} else {
								destPix = ((sourcePix & cmRedMask) << cmRedShift) | (((sourcePix & cmGreenMask) << cmGreenShift) | ((sourcePix & cmBlueMask) << cmBlueShift));
								goto l7;
							}
						l7:	/* end rgbMap: */;
							if ((destPix == 0) && (sourcePix != 0)) {
								destPix = 1;
							}
						}
					}
					if (!(colorMap == null)) {
						destPix = longAt(colorMap + (destPix << 2));
					}
					destWord1 = destWord1 | ((destPix & dstMask) << dstBitShift);
					dstBitShift -= destPixSize;
					sx += xDelta;
					sy += yDelta;
				} while(!((nPix1 -= 1) == 0));
				dstBitShift = 32 - destPixSize;
				skewWord = destWord1;
			} else {
				skewWord = warpPickSmoothPixelsxDeltahyDeltahxDeltavyDeltavsourceMapsmoothing(nPix, xDelta, yDelta, deltaP12x, deltaP12y, sourceMapOop, smoothingCount);
			}
			if (destMask == 4294967295U) {
				mergeWord = mergeFnwith(skewWord & halftoneWord, longAt(destIndex));
				longAtput(destIndex, destMask & mergeWord);
			} else {
				destWord = longAt(destIndex);
				mergeWord = mergeFnwith(skewWord & halftoneWord, destWord & destMask);
				destWord = (destMask & mergeWord) | (destWord & (~destMask));
				longAtput(destIndex, destWord);
			}
			destIndex += 4;
			if (words == 2) {
				destMask = mask2;
				nPix = endBits;
			} else {
				destMask = 4294967295U;
				nPix = pixPerWord;
			}
		} while(!((words -= 1) == 0));
		pAx += deltaP12x;
		pAy += deltaP12y;
		pBx += deltaP43x;
		pBy += deltaP43y;
		destIndex += destDelta;
	}
}
