// atcache.h -- support for cached response to primitives #at:[put:]
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-10-17 12:45:29 by piumarta on emilia.rd.wdi.disney.com

// NOTE: this is NOT the same at cache as used by the Interpreter.  It's
// really an indirect inline cache that matches on object identity instead
// of class, and which just happens to remember the indexable size of the
// target object too.  This is the original design from "way back when" (j2
// or maybe even j1) that was adapted (read: broken ;-) for use in the
// Interpreter.

#ifndef _j_atcache_h
#define _j_atcache_h


#include "Object.h"

#include "archdep.h"	// memberOffset


const size_t AtHashLowBit=	3;
const size_t AtHashBitWidth=	3;

const size_t AtCacheEntries=	(1 << AtHashBitWidth);


struct AtCacheLine
{
  oop	   object;
  unsigned indexableSize;

  static AtCacheLine *allocateFor(oop object);
  static void clearAll(void);
};


extern AtCacheLine j_atCache[];


const size_t acl_object_off= memberOffset(AtCacheLine, object);
const size_t acl_size_off=   memberOffset(AtCacheLine, indexableSize);


#endif // _j_atcache_h
