/* Yo, Emacs!  Let's pretend that this is -*- C++ -*- 
 *
 * lexer.l -- flex ONLY scanner spec (start conditions will probably confuse lex)
 *
 * last edited: Thu Mar 25 03:31:54 1999 by piumarta (Ian Piumarta) on felina
 */

			/**** declarations ****/

%{
#define YY_ALWAYS_INTERACTIVE 1
#include <stdio.h>
#include "yy.h"
#include "parser.h"
int yylineno= 0;
char *yyfilename;
int yyerrcount= 0;
char stringBuf[4096];
char *stringPtr;
%}

DIGIT		[0-9]
LETTER		[a-zA-Z]
SPECIAL		[()\[\]+\-\*/<>=;,?:{}!]

%x string
%x comment

%%			/**** patterns ****/

while		{ return WHILE; }
if		{ return IF; }
else		{ return ELSE; }
local		{ return LOCAL; }
new		{ return NEW; }
delete		{ return DELETE; }
print		{ return PRINT; }
return		{ return RETURN; }

{DIGIT}+			{ return NUMBER; }
{LETTER}({LETTER}|{DIGIT})*	{ return IDENTIFIER; }

"/*"		{ BEGIN(comment); }
<comment>{
[^*\n]*
"*"+[^*/\n]*
\n		{ ++yylineno; }
"*"+"/"		{ BEGIN(INITIAL); }
}

\<\=		{ return LEQ; }
\=\=		{ return EQL; }
\!\=		{ return NEQ; }
\>\=		{ return GEQ; }

{SPECIAL}			{ return *yytext; }

[ \t]+		/* eat whitespace */
\n		{ ++yylineno; }

.		{ yyerror("illegal character"); }

%%			/**** functions ****/

int yyerror(char *s)
{
  ++yyerrcount;
  fprintf(stderr, "%s(%d): %s near token `%s'\n", yyfilename, yylineno, s, yytext);
  exit(1);
}


extern int verbose;

int main(int argc, char **argv)
{
  ++argv; --argc;  /* program name */

  while (argc > 0 && **argv == '-') {
    if (!strcmp(*argv, "--")) { --argc; ++argv; break; }
    if (!strcmp(*argv, "-")) break;
    if (!strcmp(*argv, "-v")) { ++verbose; --argc, ++argv; continue; }
    if (!strcmp(*argv, "-vv")) { verbose+= 2; --argc, ++argv; continue; }
    if (!strcmp(*argv, "-vvv")) { verbose+= 3; --argc, ++argv; continue; }
    if (!strcmp(*argv, "-vvvv")) { verbose+= 4; --argc, ++argv; continue; }
    fprintf(stderr, "Unrecognised option: %s\n", *argv);
    exit(1);
  }

  if (argc == 0) goto doStdin;	// (don't look where this ends up! ;)

  while (argc > 0) {
    if (!strcmp(*argv, "-")) {
    doStdin:
      yyfilename= "<stdin>";
      yyin= stdin;
    } else {
      yyfilename= *argv;
      yyin= fopen(*argv, "r");
      if (yyin == 0) {
	fprintf(stderr, "%s: no such file\n", *argv);
	goto skipIt;
      }
    }
    yylineno= 1;
    yyparse();
  skipIt:
    --argc;
    ++argv;
  }
  return 0;
}
