// generate.h -- code generation support (implemented in <arch>-generate.ccg)
//
// Author: ian.piumarta@inria.fr
//
// Last edited: 2000-10-22 20:39:40 by piumarta on emilia.rd.wdi.disney.com

#ifndef _j_generate_h
#define _j_generate_h


#include "archdep.h"

#ifdef __MPW__
# ifndef size_t
#   define size_t unsigned int	// go figure...
# endif
#endif

class CompiledMethod;
class NativeMethod;
class Class;


extern void   gen_initialise(void);
extern void   gen_reload(void);
extern void   gen_release(void);

extern insn  *gen_linkTo(insn *senderIP, insn *methodEntry, unsigned arg);
extern insn  *gen_linkDeferredTo(insn *senderIP, insn *methodEntry, unsigned arg);

extern void   gen_relink(NativeMethod *nMeth);

extern void   gen_activate(NativeMethod *nMeth);

extern void   gen_blockActivate(NativeMethod *nMeth, size_t nArgs);

extern size_t gen_codeSize(size_t nBytecodes);

extern void   gen_flushEntry(insn *entry, insn *relink);
extern void   gen_flushMethod(CompiledMethod *);
extern bool   gen_flushClass(Class *);

extern void   gen_flush(insn *first, insn *last);

extern void   gen_profile(size_t expected, float elapsed);


extern insn
  *g_Pop, *g_Dup,
  *g_LdSelf, *g_bLdSelf, *g_LdTrue, *g_LdFalse, *g_LdNil, *g_LdInt,
  *g_LdThisContext,
  *g_LdLit, *g_bLdLit,
  *g_LdInst, *g_bLdInst,  *g_pLdInst, *g_bpLdInst,
  *g_StInst, *g_bStInst,  *g_pStInst, *g_bpStInst,
  *g_PopInst, *g_bPopInst,  *g_pPopInst, *g_bpPopInst,
  *g_LdTemp, *g_bLdTemp, *g_StTemp, *g_bStTemp,
  *g_LdLitInd, *g_bLdLitInd, *g_StLitInd, *g_bStLitInd,
  *g_Jmp, *g_JmpF, *g_JmpT,
  *g_SuperUnlinked, *g_SendUnlinked, *g_SpecialUnlinked, *g_SpecialDeferred,
  *g_LocalRetTop, *g_RemoteRetTop,
  *g_Add, *g_Subtract,
  *g_LessThan, *g_GreaterThan, *g_LessOrEqual, *g_GreaterOrEqual,
  *g_Equal, *g_NotEqual, *g_Multiply, *g_Divide, *g_Mod,
  *g_MakePoint, *g_BitShift, *g_Div, *g_BitAnd, *g_BitOr, 
  *g_Equivalent, *g_Class,
  *g_BlockCopy, *g_bBlockCopy,
  *g_Lambda, *g_bLambda,
  // used to "escape" from primDoPrimWithArgs on success
  *g_primitiveEpilogue,
  // test if unchecked store is ok
  *g_storeCheck, *g_beRoot, *g_fetchClass,
  // linked send through indirect inline cache
  *g_sendLinkedIndirect;

extern insn
  *si_add_trap, *si_sub_trap, *tf_trap;


#endif // _j_generate_h
