// cases.h -- expand case ranges for non-GNU compilers
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: Tue Dec 21 02:42:59 1999 by piumarta (Ian Piumarta) on aria

#ifndef _j_cases_h
#define _j_cases_h

#define cases2(BASE)	case(BASE):     case(BASE+1)
#define cases4(BASE)	cases2(BASE):   cases2(BASE+2)
#define cases8(BASE)	cases4(BASE):   cases4(BASE+4)
#define cases16(BASE)	cases8(BASE):   cases8(BASE+8)
#define cases32(BASE)	cases16(BASE):  cases16(BASE+16)
#define cases64(BASE)	cases32(BASE):  cases32(BASE+32)
#define cases128(BASE)	cases64(BASE):  cases64(BASE+64)
#define cases256(BASE)	cases128(BASE): cases128(BASE+128)

#endif // _j_cases_h
