/* generate.c -- code generator (and they say compilers are difficult?!? ;^)
 *
 * last edited: Thu Mar 25 04:42:40 1999 by piumarta (Ian Piumarta) on felina
 */

#define DEBUG	0

#define MAX_SYMBOLS	32
#define MAX_LABELS	32
#define MAX_GLOBALS	32
#define MAX_ARGUMENTS	32
#define MAX_LOCALS	32
#define MEM_SIZE	16*1024	/* words */

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "generate.h"
#include "opcodes.h"
#include "vmc_gen.h"

extern void *asm_pc;

int verbose= DEBUG;

#if (DEBUG==0)
# define PRINTF(X)
#else
# define PRINTF(X)	do { if (verbose) printf X; } while (0)
#endif

#define ERROR(FMTARGS)	do { printf FMTARGS; abort(); } while (0)


int memory[MEM_SIZE];


char *symbols[MAX_SYMBOLS];
int nextSymbol= 0;

typedef struct globalRec {
  int symbol;
  int value;
} globalRec;

globalRec globals[MAX_GLOBALS];
int nextGlobal= 0;

typedef struct localRec {
  int symbol;
} localRec;

localRec arguments[MAX_ARGUMENTS];
int nextArgument= 0;

localRec locals[MAX_LOCALS];
int nextLocal= 0;

Label  *labels[MAX_LABELS];
Label **currLabel= labels + MAX_LABELS;
Label  *labelList= 0;
int nextLabel= 0;

int currFunction= -1;


int newSymbol(char *name)
{
  int i;
  for (i= 0; i < nextSymbol; i++)
    if (strcmp(name, symbols[i]) == 0)
      return i;
  symbols[nextSymbol]= strdup(name);
  return nextSymbol++;
}


void defGlobal(int symbol, int value)
{
  if (nextGlobal == MAX_GLOBALS) ERROR(("too many globals\n"));
  globals[nextGlobal].symbol= symbol;
  globals[nextGlobal].value= value;
  nextGlobal++;
}


static int getGlobal(int symbol)
{
  int i;
  for (i= 0; i < nextGlobal; i++)
    if (symbol == globals[i].symbol)
      return i;
  return -1;	/* not found */
}


void defArgument(int symbol)
{
  if (nextArgument == MAX_ARGUMENTS) ERROR(("too many arguments\n"));
  arguments[nextArgument].symbol= symbol;
  nextArgument++;
}


static int getArgument(int symbol)
{
  int i;
  for (i= 0; i < nextArgument; i++)
    if (symbol == arguments[i].symbol)
      return i;
  return -1;	/* not found */
}


void defLocal(int symbol)
{
  if (nextLocal == MAX_LOCALS) ERROR(("too many locals\n"));
  locals[nextLocal].symbol= symbol;
  nextLocal++;
}


static int getLocal(int symbol)
{
  int i;
  for (i= 0; i < nextLocal; i++)
    if (symbol == locals[i].symbol)
      return i;
  return -1;	/* not found */
}


void newLabel(void)		{ *--currLabel= lbl_new(); }
void defLabel(int index)	{ lbl_define(currLabel[index], asm_pc); }
void popLabel(void)		{ lbl_delete(*currLabel++); }


void fixLabels(void)
{
  if (currLabel != (labels + MAX_LABELS)) {
    ERROR(("label stack not empty at end of compilation\n"));
  }
}


int initialised= 0;

void startFunction(int symbol)
{
  void *fnAddr;
  /* perform one-time code generator initialisation */
  if (!initialised) {
    gen_init(memory);
    initialised= 1;
  }
  /* reset per-function state to initial conditions */
  nextArgument= 0;
  currLabel= labels + MAX_LABELS;
  fnAddr= gen_function();
  defGlobal(symbol, (int)fnAddr);
  PRINTF(("%s = %p\n", symbols[symbol], fnAddr));
  currFunction= symbol;
}


void endFunction(int symbol)
{
  emit_push(0);
  emit_return();
}


void emit_variable(int symbol)
{
  int index;
  if ((index= getLocal(symbol)) != -1)
    emit_pushLocal(index);
  else if ((index= getArgument(symbol)) != -1)
    /* need to adjust for left->right argument evaluation */
    emit_pushArg(nextArgument - index - 1);
  else if ((index= getGlobal(symbol)) != -1)
    emit_push(globals[index].value);
  else
    ERROR(("undefined variable: %s\n", symbols[symbol]));
}


void emit_assign(int symbol)
{
  int index;
  if ((index= getLocal(symbol)) != -1)
    emit_assignLocal(index);
  else if ((index= getArgument(symbol)) != -1)
    /* need to adjust for left->right argument evaluation */
    emit_assignArg(nextArgument - index - 1);
  else
    ERROR(("undefined variable: %s\n", symbols[symbol]));
}


void emit_locals(void)
{
  if (nextLocal == 0) ERROR(("reserving no locals?\n"));
  gen_locals(nextLocal);
}


void emit_halt(void)			{ gen_halt(); }
void emit_push(int value)		{ gen_push(value); }
void emit_pushArg(int index)		{ gen_pushArg(index); }
void emit_pushLocal(int index)		{ gen_pushLocal(index); }
void emit_pop(void)			{ gen_pop(); }
void emit_assignArg(int index)		{ gen_assignArg(index); }
void emit_assignLocal(int index)	{ gen_assignLocal(index); }
void emit_less(void)			{ gen_less(); }
void emit_lessEqual(void)		{ gen_lessEqual(); }
void emit_equal(void)			{ gen_equal(); }
void emit_notEqual(void)		{ gen_notEqual(); }
void emit_greaterEqual(void)		{ gen_greaterEqual(); }
void emit_greater(void)			{ gen_greater(); }
void emit_add(void)			{ gen_add(); }
void emit_subtract(void)		{ gen_subtract(); }
void emit_multiply(void)		{ gen_multiply(); }
void emit_divide(void)			{ gen_divide(); }
void emit_negate(void)			{ gen_negate(); }
void emit_call(int numArgs)		{ gen_call(numArgs); }

void emit_return()
{
  if (currFunction == newSymbol("main"))
    gen_halt();
  else
    gen_return();
}

void emit_jump(int label)		{ gen_jump(currLabel[label]); }
void emit_jumpIfFalse(int label)	{ gen_jumpIfFalse(currLabel[label]); }
void emit_new(void)			{ gen_new(); }
void emit_delete(void)			{ gen_delete(); }
void emit_get(void)			{ gen_get(); }
void emit_put(void)			{ gen_put(); }
void emit_print(void)			{ gen_print(); }


int stack[128];

void execute(void)
{
  typedef int (*pvfi)(void);
  int symbol= newSymbol("main");
  int index= getGlobal(symbol);
  int initialIP;
  pvfi prog;
  int result;

  if (index == -1) ERROR(("function `main' not defined\n"));

  /* address of main */
  initialIP= globals[index].value;
  /* generate C linkage into the dynamic code */
  prog= (pvfi)gen_start((void *)initialIP, stack);
  PRINTF(("start = %p\n", prog));
  /* run the code */
  result= prog();

  PRINTF(("result is "));
  printf("%d\n", result);
}
