/* some J3 support stuff */
#include <stdio.h>

int ioMSecs(void);
int ioLowResMSecs(void) {
  return ioMSecs();
}


void *j3Stack = NULL;
static int j3StackTrap = 0;

void CRASH() {
  *((int*)NULL) = 0;
}

void *stackAlloc(size_t lbs) {
  printf("Allocating j3 stack (%x)\n", j3Stack);
  /* we can only use the pre-allocated stack size so ignore lbs */
  if(j3StackTrap) {
    printf("stackAlloc: Stack was already allocated\n");
    CRASH();
  }
  if(!j3Stack) {
    printf("stackAlloc: No preallocated j3 stack\n");
    CRASH();
  }
  j3StackTrap = 1;
  return j3Stack;
}

void stackFree(void *ptr) {
  if(!j3StackTrap) {
    printf("stackFree: Stack was not allocated\n");
    CRASH();
  }
  if(ptr != j3Stack) {
    printf("stackFree: Stack is not j3 stack\n");
    CRASH();
  }
  j3StackTrap = 0;
}

#define j3StackSize (4*1024*1024)
#define SAFE_REGION 1024

int j_runInterpret()
{
    j3Stack = alloca(j3StackSize + SAFE_REGION);
    if(!j3Stack) {
      printf("j_runInterpret: Failed to alloca() j3 stack frame\n");
      CRASH();
    }
    j_interpret();
}
