/****************************************************************************
*   PROJECT: Squeak port for Win32 CE (NT / Win95)
*   FILE:    sqWinCETime.c
*   CONTENT: Time routines is not included in the WCE CRT.
*
*   AUTHOR:  Blair McGlashan
*   ADDRESS: Intuitive Systems Ltd, Stevenage, Herts SG1 3EE, UK
*   EMAIL:   blair@intuitive.co.uk
*   RCSID:   
*
*   NOTES:
*			To keep the size of these routines down, they do not implement
*			necessarily implement the full, (or even the same) functionality 
*			as the real C runtime library routine. Error checking, in particular, 
*			is omitted.
*
*****************************************************************************/
#include <windows.h>
#include "time.h"

static const __int64 unixEpochFILETIME = 116444736000000000;	// 100s of nanoseconds between 1601 and 1970
static const __int64 FT_TICS_PER_SEC = 10000000;

static struct tm tmLocal;

// Exported variables
long _timezone = 0;		// GMT
int _daylight = 0;		// non-zero if daylight saving time

/* Only these routines required by Squeak at present */
clock_t __cdecl clock(void)
{
	return GetTickCount();
}

time_t __cdecl time(time_t *out)
{
	SYSTEMTIME sysTime;
	FILETIME fileTime;
	time_t diff;

	tzset();
	GetSystemTime(&sysTime);
	SystemTimeToFileTime(&sysTime, &fileTime);
	/* Unix epoch is Jan 1, 1970.	FILETIME epoch is Jan 1, 1601, also
		FILETIME is measured in 100nS intervals */
	diff = (time_t)((*(__int64*)&fileTime - unixEpochFILETIME )/FT_TICS_PER_SEC);
	if (out)
		*out = diff;
	return diff;
}

void __cdecl tzset()
{
	static int dunnit = 0;

	if (!dunnit)
	{
		FILETIME ftLocal;
		FILETIME ftUTC;

		dunnit++;

		// Note that we cheat in that we include the daylight saving time in the
		// timezone. This is sufficient for Squeak's purposes.
		memset(&ftLocal, 0, sizeof(ftLocal));
		LocalFileTimeToFileTime(&ftLocal, &ftUTC);

		_timezone = (long)((*(__int64*)&ftUTC)/10000000);
	}
}

/*UnusedUnusedUnusedUnusedUnusedUnused

struct tm* __cdecl localtime(const time_t* timer)
{
	FILETIME ftUTC;
	FILETIME ftLocal;
	SYSTEMTIME stLocal;

	// Init.
	tzset();

	*((__int64*)&ftUTC) =  (*(__int64*)timer)*FT_TICS_PER_SEC + unixEpochFILETIME;

	FileTimeToLocalFileTime(&ftUTC, &ftLocal);
	FileTimeToSystemTime(&ftLocal, &stLocal);

	tmLocal.tm_sec		= stLocal.wSecond;
	tmLocal.tm_min		= stLocal.wMinute;
	tmLocal.tm_hour		= stLocal.wHour;
	tmLocal.tm_mday		= stLocal.wDay;
	// tm_mon is months since January (i.e. 0..11), whereas wMonth is month number.
	tmLocal.tm_mon		= stLocal.wMonth-1;
	// tm_year is years since 1900
	tmLocal.tm_year		= stLocal.wYear - 1900;
	tmLocal.tm_wday		= stLocal.wDayOfWeek;
	tmLocal.tm_yday		= -1;						// Not implemented at present
	tmLocal.tm_isdst	= _daylight;				// Will be corect when tzset() sets it

	return &tmLocal;
}

UnusedUnusedUnusedUnusedUnusedUnused*/