/****************************************************************************
*   PROJECT: Squeak port for Win32 CE (NT / Win95)
*   FILE:    sqWinCEString.c
*   CONTENT: Routines to replace C runtime library string manipulation
*			 routines
*
*   AUTHOR:  Blair McGlashan
*   ADDRESS: Intuitive Systems Ltd, Stevenage, Herts SG1 3EE, UK
*   EMAIL:   blair@intuitive.co.uk
*   RCSID:   
*
*   NOTES:
*			To keep the size of these routines down, they do not necessarily
*			implement the full functionality of the associated C runtime library
*			routine, Error checking, in particular, is omitted.
*
*****************************************************************************/
#define __NOSQMALLOC
#include "sq.h"

// N.B. We must include windows.h, otherwise we may pick up the wrong functions
// under the emulator.
#include <windows.h>

// Answer pointer to last occurrence of char in string
char *  __cdecl strrchr(const char *s, int ch)
{
	char* last = NULL;
	while (*s)
	{
		if (*s == ch)
			last = (char*)s;
		s++;
	}
	return last;
}

/*UnusedUnusedUnusedUnusedUnusedUnused
int __cdecl stricmp(const char *s1, const char *s2)
{
	TCHAR* ws1 = toUnicode(s1);
	TCHAR* ws2 = toUnicode(s2);
	int ret = lstrcmpi(ws1, ws2);
	free(ws1);
	free(ws2);
}

UnusedUnusedUnusedUnusedUnusedUnused*/