/****************************************************************************
*   PROJECT: Squeak port for Win32 (WinCE)
*   FILE:    sqWin32CE.c
*   CONTENT: Special support stuff only for WinCE on SHx
*
*   AUTHOR:  Alejandro F. Reimondo (afr)
*   ADDRESS: SUGAR - Argentina
*   EMAIL:   aleReimondo@sugarWeb.com
*   RCSID:   $Id: sqWin32CE.c,v 1.2 2001/02/10 08:58:48 anonymous Exp $
*
*   NOTES:
*    1) Support code for VM under WindowsCE 2.00 (_WIN32_WCE)
*	 2) Most of the stuff that has been in this file has now
*	    been moved to sqWin32Window.c (it was very useful in
*	    general - thanks Alejandro!) - ar
*****************************************************************************/
#include <windows.h>
#include <commdlg.h>
#include "sq.h"

/*** Variables -- Imported from Virtual Machine ***/
extern int fullScreenFlag;
extern int interruptKeycode;

/* Import from the Virtual Machine */
int byteSwapped(int);

/* Import from sqWin32Alloc.c */
LONG CALLBACK sqExceptionFilter(LPEXCEPTION_POINTERS exp);

/*** Variables -- command line */
#ifndef MAX_OPTIONS
#define MAX_OPTIONS 8
#endif

char *initialCmdLine;
int  numOptionsVM = 0;
char *(vmOptions[MAX_OPTIONS]);
int  numOptionsImage = 0;
char *(imageOptions[MAX_OPTIONS]);

/****************************************************************************/
/*                           Jitter Stuff                                   */
/****************************************************************************/

/* Jitter is not supported directly by this VM */


/****************************************************************************/
/*                      Console Window functions                            */
/****************************************************************************/

/* Note: Console output is not supported by this VM */


EXPORT(int) xxxTestFunction(void)
{
}
/****************************************************************************/
/*                          main                                            */
/****************************************************************************/
static HANDLE hSqueakModule=0; /* Cached handle for Squeak */

int PASCAL WinMain (HINSTANCE hInst,
                    HINSTANCE hPrevInstance,
                    LPTSTR  lpCmdLine,
                    int    nCmdShow)
{ int virtualMemory;
  sqImageFile imageFile;
  int imageSize;

  hSqueakModule = (HANDLE) hInst;

  /* IMPORTANT: Allow the OS to fix alignment problems for us! */
  SetErrorMode(SEM_NOALIGNMENTFAULTEXCEPT);

  /* fetch us the name of the executable */
  GetModuleFileName(hInst, vmName, MAX_PATH);

  /* get us the instance handle */
  hInstance = hInst;

  // If no command line, search for an image file or pop up an open file dialog
  if(*lpCmdLine == 0)
	{
	  if(!findImageFile())
		  if(!openImageFile())
			  return -1;
	}
  else
  {
	/* parse command line args - this should be done a little  more sophisticated*/
	strcpy(imageName, fromUnicode(lpCmdLine));
  }
  // Hard code the path name (this is not a great hardship in a driveless 4Mb filestore)
  lstrcpy(vmPath, TEXT("\\"));

  //SetupFilesAndPath();
  // Set the wait cursor because reading the image can take a 
  // long time on CE.
  SetCursor((HCURSOR)IDC_WAIT);

  /* initialisation */
  SetupKeymap();
  SetupWindows();
  SetupPixmaps();
  SetupPrinter();
  SetupTimer();
#ifndef NO_MIDI
  SetupMIDI();
#endif
  sqFileInit();
#ifndef NO_JOYSTICK
  joystickInit();
#endif

  /* check the interpreter's size assumptions for basic data types */
  if (sizeof(int) != 4)    error("This C compiler's integers are not 32 bits.");
  if (sizeof(double) != 8) error("This C compiler's floats are not 64 bits.");
  if (sizeof(time_t) != 4) error("This C compiler's time_t's are not 32 bits.");

  imageSize = SqueakImageLength(toUnicode(imageName));
  if(imageSize == 0)
  {
	  printUsage(2);
	  exit(1);
  }
  /* allocate the synchronization mutex before anything is going to happen */
  vmSemaphoreMutex = CreateMutex(NULL, 0, NULL);
  vmWakeUpEvent = CreateEvent(NULL, 1, 0, NULL);

#ifdef NO_VIRTUAL_MEMORY
  if(!dwMemorySize) dwMemorySize = 4;

#if defined(_WIN32_WCE)
  virtualMemory = initializeCEMemorySpace(imageSize);
#else //  defined(_WIN32_WCE)
  virtualMemory = (int)imageSize + max(imageSize, dwMemorySize * 0x00100000);
#endif //  defined(_WIN32_WCE)

#else // NO_VIRTUAL_MEMORY

#if defined(_WIN32_WCE)
  if(!dwMemorySize) dwMemorySize = 4;
  virtualMemory = initializeCEMemorySpace(imageSize);
#else //  defined(_WIN32_WCE)
  if(!dwMemorySize) dwMemorySize = MAX_VIRTUAL_MEMORY;
  virtualMemory = max((int)dwMemorySize * 0x00100000, (int) 2*imageSize);
#endif // defined(_WIN32_WCE)

  /* The exception handler. 
     Everything happening in here will be caught by the handler at the end */
  __try { 

#endif // NO_VIRTUAL_MEMORY

  /* open and read the image file */
  imageFile = sqImageFileOpen(imageName,"rb");
  readImageFromFileHeapSize(imageFile, virtualMemory);
  sqImageFileClose(imageFile);

  ioSetFullScreen(fullScreenFlag);

  /* Note: There is good reason for putting the prefs here. */
  //SetupPreferences();
  interruptKeycode = 27; /* Escape as default interrupt key */
  fDeferredUpdate = 0; /* No deferred update under CE */
  fReduceCPUUsage = 0; /* Should we reduce CPU usage? */
  fBufferMouse = 0;    /* Should we buffer mouse input? */

  /* Restore normal cursor */
  SetCursor(NULL);

  /* display the main window */
  //SetWindowSize();   unused under CE
  if(!fHeadlessImage) {
    ShowWindow(stWindow,nCmdShow);
	BringWindowToTop(stWindow);
  }

  /* run Squeak */
  interpret();

#ifndef NO_VIRTUAL_MEMORY
  } __except(sqExceptionFilter(GetExceptionInformation())) {
    /* if we get this far our app has finally crashed */
    abortMessage(TEXT("Squeak has crashed!"));
  }
#endif
}

/****************************************************************************/
/*                      System Attributes                                   */
/****************************************************************************/
char * GetVMOption(int id) { return "";}
char * GetImageOption(int id) { return "";}


/****************************************************************************/
/*                           main                                           */
/****************************************************************************/

/* Uh - that's again a main function?! How many do we have? And why?

   The answer is that windows function can run either as a GUI
   application or as a console application. GUI apps are started
   via WinMain(), console apps via main(). Since some people might
   want to run Squeak as console app (imagine a small Squeak calculator)
   this main() function is given as a wrapper for WinMain.
*/

#ifdef _CONSOLE
int main(int argc, char **argv)
{ char *cmdLine;
  cmdLine = GetCommandLine();
  cmdLine += strlen(argv[0]);
  return WinMain(GetModuleHandle(NULL), NULL, cmdLine, SW_SHOW);
}
#endif


/****************************************************************************/
/*                           Other                                          */
/****************************************************************************/

/////////////////////////////////////////////////////////////////////////////////////////////
//  NOTE: Assumes that the library is already loaded and mapped into our address space.
//        We are really only interested in the DLL's handle.
HMODULE GetModuleHandle( LPCTSTR lpModuleName )
{
	HINSTANCE hInst;

	if(!lpModuleName)
		return hSqueakModule;

	hInst = LoadLibrary( lpModuleName );

	// Decrement reference count.
	if (hInst)
		FreeLibrary( hInst );

	return (HMODULE)(hInst);
}
