/****************************************************************************
*   PROJECT: Squeak port for Win32 CE (NT / Win95)
*   FILE:    time.h
*   CONTENT: time.h is not included in the WCE SDK.
*
*   AUTHOR:  Blair McGlashan
*   ADDRESS: Intuitive Systems Ltd, Stevenage, Herts SG1 3EE, UK
*   EMAIL:   blair@intuitive.co.uk
*   RCSID:   
*
*   NOTES:
*			To keep the size of these routines down, they do not implement
*			necessarily implement the full, (or even the same) functionality 
*			as the real C runtime library routine. Error checking, in particular, 
*			is omitted.
*
*****************************************************************************/
#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _INC_TIME
#define _INC_TIME

#ifndef _WIN32_WCE
	#error ERROR: For WinCE only!
#endif

#ifndef _CLOCK_T_DEFINED
	typedef long clock_t;
	#define _CLOCK_T_DEFINED
#endif

#ifndef _TIME_T_DEFINED
	typedef long time_t;
	#define _TIME_T_DEFINED
#endif

#ifndef _TM_DEFINED
	struct tm 
	{
		int tm_sec;
		int tm_min;
		int tm_hour;
		int tm_mday;
		int tm_mon;
		int tm_year;
		int tm_wday;
		int tm_yday;
		int tm_isdst;
	};
	#define _TM_DEFINED
#endif

/* Only these routines required by Squeak at present */
clock_t __cdecl clock(void);
time_t __cdecl time(time_t *);
long _timezone;
void __cdecl tzset();

char* __cdecl asctime(const struct tm*);
char* __cdecl ctime(const time_t*);
struct tm* __cdecl localtime(const time_t*);


/* Clock ticks macro - ANSI version */
#define CLOCKS_PER_SEC  1000

#endif  /* _INC_TIME */
