#ifdef PROFILE
#include <windows.h>
#include "sqGnu.h"

int profilerInitialized = 0;
int profilerActive = 0;

unsigned int bcProfileLow;
unsigned int bcProfileHigh;
unsigned int bcProfileCurrent = 256;
unsigned int bcProfileCountTable[257];
unsigned long long int bcProfileTable[257];

unsigned int primProfileLow;
unsigned int primProfileHigh;
unsigned int primProfileCurrent;
unsigned int primProfileCountTable[2048];
unsigned long long int primProfileTable[2048];

int startProfiling(void) {
	if(!profilerInitialized) {
		clearProfile();
		profilerInitialized = 1;
	}
	if(!profilerActive) {
		profilerActive = 1;
		bcProfileCurrent = 256;
		PROFILE_PRIMITIVE(252);
	}
	return 1;
}

int stopProfiling(void) {
	profilerActive = 0;
	return 1;
}

int clearProfile(void) {
	int i;
	for(i=0; i<257;i++) {
		bcProfileTable[i] = bcProfileCountTable[i] = 0;
	}
	for(i=0; i<2048;i++) {
		primProfileTable[i] = primProfileCountTable[i] = 0;
	}
}


static void printTable(unsigned long long int *timeTable, unsigned int *countTable, int size)
{
	double time, sumTime;
	unsigned count, sumCount;
	int i;

	sumTime = 0.0;
	sumCount = 0;
	for(i=0; i< size;i++) {
		sumTime = sumTime + timeTable[i];
		sumCount = sumCount + countTable[i];
	}
	for(i=0; i< size;i++) {
		if(countTable[i]) {
			time = timeTable[i];
			count = countTable[i];
			printf("%d\t%u\t%.3f\t%.0lf\t%.3f\n",i,
				count, (double) count / (double) sumCount * 100.0,
				time, time / sumTime * 100.0);
		}
	}
	fflush(stdout);
}

int dumpProfile(void) {
	double value, sum;
	int i;

	printf("Bytecode\tcount\tpercent1\ttime\tpercent2n");
	printTable(bcProfileTable, bcProfileCountTable, 256);
	printf("\nPrimitive\tcount\tpercent1\ttime\tpercent2n");
	printTable(primProfileTable, primProfileCountTable, 256);
	return 1;
}

#endif
