

/*
	DO_SETUP
	Defines an optional macro that is called directly
	at the beginning of the conversion function.
*/

/*
	PIXEL_ALIGN
	Determines how many pixels we want to align.
	Usually PIXEL_ALIGN should be defined as
		display depth		PIXEL_ALIGN
			8					4
			16					2
			32					1
	but it may be different when we wish to work
	on more than one pixel per inner loop.
*/

/*
	SRC_PPW
	Defines the # of pixels per 32bit word in the source; e.g.
		display depth		SRC_PPW
			8					4
			16					2
			32					1
*/

/*
	SRC_BPP
	Defines # of bytes per pixel in the source; e.g.
		display depth		SRC_BPP
			8					1
			16					2
			32					4
	(this is the inverse of SRC_PPW)
*/

/*
	SRC_WIDTH
	Defines the actual (pixel) width of the source.
*/

/*
	SRC_BITS
	Defines the actual source bits.
*/
{
	DDSURFACEDESC ddsd;
	HRESULT hRes;
	RECT inRect;
	DWORD inPitch, outPitch;
	DWORD inBits, outBits;
	int nWords, j;

	DO_SETUP;
	/* Adjust the dxRect to pixel word boundaries */
	inRect = dxRect;
	inRect.left &= ~(PIXEL_ALIGN-1);
	inRect.right = (inRect.right + (PIXEL_ALIGN-1)) & ~(PIXEL_ALIGN-1);
	/* Lock the surface */
	ddsd.dwSize = sizeof(ddsd);

	/* <--- WARNING WARNING WARNING ---> */
	/*  No breakpoints after this point  */
	hRes = lpddDevice->lpVtbl->Lock(lpddDevice, &inRect, &ddsd, DDLOCK_WAIT, 0);
	if(FAILED(hRes)) return hRes;

	/* get the pointer and pitch for the surface */
	outBits = (DWORD) ddsd.lpSurface;
	outPitch = ddsd.lPitch;
	/* get the pointer and pitch for the Squeak form */
	inBits = SRC_BITS;
	inPitch = ((SRC_WIDTH + (SRC_PPW-1)) & ~(SRC_PPW-1)) * SRC_BPP;

	/* Compute the # of pixel words */
	nWords = (inRect.right / SRC_BPP) - (inRect.left / SRC_BPP);

	/* adjust the pointers to start at the first word in scan line */
	/* Note: DirectX returns a pointer to the first pixel in the rect;
	         so there are no offsets to compute (which is nice) */
	inBits  += (inRect.top *  inPitch) + (inRect.left * SRC_BPP);

	/* and go copying the bits */
	for(j = inRect.top; j < inRect.bottom; 
		j++, outBits += outPitch, inBits += inPitch) {
			DO_INNER_LOOP(inBits, outBits, nWords);
	}

	/* Unlock the surface */
	hRes = lpddDevice->lpVtbl->Unlock(lpddDevice, ddsd.lpSurface);
	if(FAILED(hRes)) return hRes;
	/* <--- WARNING WARNING WARNING ---> */
	/*  No breakpoints before this point  */
	return DD_OK;
}

#undef DO_SETUP
#undef PIXEL_ALIGN
#undef SRC_PPW
#undef SRC_BPP
#undef SRC_WIDTH
#undef SRC_BITS
