/****************************************************************************
*   PROJECT: Squeak port for Win32 (NT / Win95)
*   FILE:    sqWin32Intel.c
*   CONTENT: Generic support stuff
*
*   AUTHOR:  Andreas Raab (ar)
*   ADDRESS: University of Magdeburg, Germany
*   EMAIL:   raab@isg.cs.uni-magdeburg.de
*   RCSID:   $Id: sqWin32Generic.c,v 1.1.1.1 2001/02/04 23:27:52 anonymous Exp $
*
*   NOTES:
*       The support code provided here makes no assumption about the
*       actual Win32 implementation or the processor type.
*       It is intended to provide a starting point when writing the
*       support code for a certain Win32 implementation; such as:
*         * Windows95
*         * Windows NT (x86 or Alpha)
*         * Windows CE
*****************************************************************************/
#include <windows.h>
#include "sq.h"

/*** Variables -- Imported from Virtual Machine ***/
extern int fullScreenFlag;

/* Import from the Virtual Machine */
int byteSwapped(int);

/* Import from sqWin32Alloc.c */
LONG CALLBACK sqExceptionFilter(LPEXCEPTION_POINTERS exp);

/****************************************************************************/
/*                           Jitter Stuff                                   */
/****************************************************************************/

/* Jitter is not supported directly by the generic VM */


/****************************************************************************/
/*                      Console Window functions                            */
/****************************************************************************/

/* Note: Console output is not supported with generic VM */


/****************************************************************************/
/*                          main                                            */
/****************************************************************************/

int PASCAL WinMain (HINSTANCE hInst,
                    HINSTANCE hPrevInstance,
                    LPSTR  lpCmdLine,
                    int    nCmdShow)
{ int virtualMemory;
  sqImageFile imageFile;
  int imageSize;

  /* fetch us the name of the executable */
  GetModuleFileName(hInst, vmName, MAX_PATH);

  /* get us the instance handle */
  hInstance = hInst;

  /* a quick check if we have any argument at all */
  if(lpCmdLine == NULL || *lpCmdLine == 0) return printUsage(0);

  /* parse command line args - this should be done a little  more sophisticated*/
  strcpy(imageName, lpCmdLine);


  SetupFilesAndPath();

  /* initialisation */
  SetupKeymap();
  SetupWindows();
  SetupPixmaps();
  SetupPrinter();
  SetupTimer();
#ifndef NO_MIDI
  SetupMIDI();
#endif
  sqFileInit();
#ifndef NO_JOYSTICK
  joystickInit();
#endif

  /* check the interpreter's size assumptions for basic data types */
  if (sizeof(int) != 4)    error("This C compiler's integers are not 32 bits.");
  if (sizeof(double) != 8) error("This C compiler's floats are not 64 bits.");
  if (sizeof(time_t) != 4) error("This C compiler's time_t's are not 32 bits.");

  imageSize = SqueakImageLength(toUnicode(imageName));
  if(imageSize == 0) printUsage(2);
  /* allocate the synchronization mutex before anything is going to happen */
  vmSemaphoreMutex = CreateMutex(NULL, 0, NULL);

#ifdef NO_VIRTUAL_MEMORY
  if(!dwMemorySize) dwMemorySize = 4;
  virtualMemory = (int)imageSize + max(imageSize, dwMemorySize * 0x00100000);
#else

  if(!dwMemorySize) dwMemorySize = MAX_VIRTUAL_MEMORY;
  virtualMemory = max((int)dwMemorySize * 0x00100000, (int) 2*imageSize);
  /* The exception handler. 
     Everything happening in here will be caught by the handler at the end */
  __try { 

#endif

  /* open and read the image file */
  imageFile = sqImageFileOpen(imageName,"rb");
  readImageFromFileHeapSize(imageFile, virtualMemory);
  sqImageFileClose(imageFile);

  /* display the main window */
  SetWindowSize();
  if(!fHeadlessImage) 
    ShowWindow(stWindow,nCmdShow);

  ioSetFullScreen(fullScreenFlag);

  /* Note: There is good reason for putting the prefs here. */
  SetupPreferences();

  /* run Squeak */
  interpret();

#ifndef NO_VIRTUAL_MEMORY
  } __except(sqExceptionFilter(GetExceptionInformation())) {
    /* if we get this far our app has finally crashed */
    abortMessage(TEXT("Squeak has crashed!"));
  }
#endif
}

/****************************************************************************/
/*                      System Attributes                                   */
/****************************************************************************/
char * GetVMOption(int id) { return "";}
char * GetImageOption(int id) { return "";}


/****************************************************************************/
/*                           main                                           */
/****************************************************************************/

/* Uh - that's again a main function?! How many do we have? And why?

   The answer is that windows function can run either as a GUI
   application or as a console application. GUI apps are started
   via WinMain(), console apps via main(). Since some people might
   want to run Squeak as console app (imagine a small Squeak calculator)
   this main() function is given as a wrapper for WinMain.
*/

#ifdef _CONSOLE
int main(int argc, char **argv)
{ char *cmdLine;
  cmdLine = GetCommandLine();
  cmdLine += strlen(argv[0]);
  return WinMain(GetModuleHandle(NULL), NULL, cmdLine, SW_SHOW);
}
#endif
