// hooks.h -- notification of interesting Interpreter events
//
// Author: ian.piumarta@inria.fr
//
// Last edited: 2000-10-26 16:13:33 by piumarta on emilia.rd.wdi.disney.com


#ifndef _j_hooks_h
#define _j_hooks_h


// the version of VM proxy to which we know how to talk

#define HOOK_MAJOR	1
#define HOOK_MINOR	2


class CompiledMethod;
class Object;
class Process;

typedef Object *oop;


extern "C" {
  // module initialiser
  int  setInterpreter(struct VirtualMachine *squeak);
  // compiler entry points
  void j_undefinedHook(void);
  void j_translateMethodHook(void);
  void j_flushCacheHook(Object *target);
  void j_preGCHook(int fullGCFlag);
  void j_mapHook(int memStart, int memEnd);
  void j_postGCHook(void);
  void j_processChangeHook(Process *oldProc, Process *newProc);
  void j_preSnapshotHook(void);
  void j_postSnapshotHook(void);
  void j_markHook(void);
  void j_createActualMessageHook(Message *aMessage, Array *argArray);
  void j_preStoreImageSegment(void);
  void j_postStoreImageSegment(void);
};


#endif // _j_hooks_h














