// genQuick.cc -- Quick method prologue generation		-*- C++ -*-
// 
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: Thu Jan 13 03:22:59 2000 by piumarta (Ian Piumarta) on pingu

#include "Object.h"

#include "machine.h"
#include "emit.h"

#include "genQuick.h"


void genPushSelf(NativeMethod *nMeth, insn *fail)
{
  const unsigned nArgs= nMeth->argumentCount;
  if (nArgs > 0)
    {
      emit_drop(nArgs);
    }
  emit_resume();
}


void genPushTrue(NativeMethod *nMeth, insn *fail)
{
  emit_move_1_r(tmp[0]);
  emit_move_r_popS(tmp[0], nMeth->argumentCount);
  emit_resume();
}


void genPushFalse(NativeMethod *nMeth, insn *fail)
{
  emit_move_0_r(tmp[0]);
  emit_move_r_popS(tmp[0], nMeth->argumentCount);
  emit_resume();
}


void genPushNil(NativeMethod *nMeth, insn *fail)
{
  emit_move_N_r(tmp[0]);
  emit_move_r_popS(tmp[0], nMeth->argumentCount);
  emit_resume();
}


void genPushInteger(NativeMethod *nMeth, insn *fail)
{
  const unsigned primIndex= nMeth->primitiveIndex;
  emit_move_i_r((int)(Object::integer(primIndex - 261)), tmp[0]);
  emit_move_r_popS(tmp[0], nMeth->argumentCount);
  emit_resume();
}


void genLoadInstVar(NativeMethod *nMeth, insn *fail)
{
  const unsigned primIndex= nMeth->primitiveIndex;
  emit_move_popS_r(nMeth->argumentCount, tmp[0]);
  emit_get_i_r_r(((primIndex - 264 + 1) * 4), tmp[0], tmp[0]);
  emit_move_r_S(tmp[0], 0);
  emit_resume();
}
