// genArray.h -- Array method prologue generation		-*- C++ -*-
// 
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2000-11-06 16:00:57 by piumarta on emilia.rd.wdi.disney.com

#ifndef j_genArrays_h
#define j_genArrays_h

#include "cachebits.h"

// generate inlined cached responses in Array/Stream primitive prologues
#undef	CACHED_AT

// generate inlined responses in Array/Stream primitive prologues
#undef	INLINED_AT


#if defined(INLINED_AT) || defined(CACHED_AT)

typedef enum {
  noFields=   0,
  charFields= 1,
  byteFields= 2,
  oopFields=  3,
  wordFields= 4
} fieldType_t;

static inline bool byteIndexed(fieldType_t ft)
{
  return ft < oopFields;
}

extern fieldType_t fieldTypeOfFormat(const unsigned instSpec);

#endif // INLINED_AT || CACHED_AT


#ifdef CACHED_AT

extern void genCachedAt(NativeMethod *nMeth,
			const unsigned instSize, fieldType_t fieldType,
			bool putFlag, insn *fail);

#endif


#ifdef INLINED_AT

extern void genPrimitiveAccessor(int instSize, fieldType_t fieldType,
				 bool putFlag, insn *fail);
extern void genPrimitiveAt(NativeMethod *nMeth, bool stringy, bool putFlag, insn *fail);
extern void genPrimitiveSize(NativeMethod *nMeth, insn *fail);

#endif // INLINED_AT


#endif // j_genArrays_h
