// debug.cc -- error handling and debugging stuff
//
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: 2/26/01 by marcus@ira.uka.de


#include <stdio.h>
#include <stdarg.h>

#include "debug.h"

#include "Frame.h"

extern "C" { int ioBeep(void); }

extern Frame *activeFrame;

void myBreak(void) {
}

static char *basename(char *name)
{
  char *in= name, *out= name;
  while (*in != '\0') if (*in++ == '/') out= in;
  return out;
}


void assertionFail(char *file, int line, char *func, char *expr)
{
  fflush(stdout);
  fprintf(stderr, "\n%s: in `%s'", basename(file), func);
  fprintf(stderr, "\n%s:%d: assertion failed: `%s'\n\n", basename(file), line, expr);
  fprintf(stderr, "PRESS <ENTER> TO CONTINUE OR ^D TO EXIT\n");
  int c= getchar();
  if (EOF == c)
    exit(1);
}


char *errFile= 0;
int   errLine= 0;
char *errFunc= 0;


int fatalError(char *fmt, ...)
{
  fflush(stdout);
  fprintf(stderr, "\n%s: in `%s'", basename(errFile), errFunc);
  fprintf(stderr, "\n%s:%d: ", basename(errFile), errLine);
  va_list ap;
  va_start(ap, fmt);
  vfprintf(stderr, fmt, ap);
  va_end(ap);
  fprintf(stderr, "\n\n");
  if (activeFrame != 0)
    activeFrame->printBacktrace();
  abort();
  return 0;
}
