// dcg.cc -- static stuff from dcg.h (buggy compiler on MacOS)
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-11-10 08:22:20 by piumarta on emilia.rd.wdi.disney.com

#include "Object.h"

#include "archdep.h"

#include "debug.h"
#include "specials.h"
#include "compile.h"
#include "optimise.h"
#include "generate.h"
#include "machine.h"

#include ARCHDEP(defs.h)
#include ARCHDEP(emit.h)

#include "Frame.h"

#include "dcg.h"


DeferredSend DeferredSend::deferredSends[MAX_DEFERRED];

size_t DeferredSend::deferredSendCount= 0;


Condition Condition::Tr(TR);
Condition Condition::Lt(LT);
Condition Condition::Le(LE);
Condition Condition::Eq(EQ);
Condition Condition::Ne(NE);
Condition Condition::Gt(GT);
Condition Condition::Ge(GE);
Condition Condition::Fa(FA);


void Condition::initialise(void)
{
  Tr= Condition(TR);
  Lt= Condition(LT);
  Le= Condition(LE);
  Eq= Condition(EQ);
  Ne= Condition(NE);
  Gt= Condition(GT);
  Ge= Condition(GE);
  Fa= Condition(FA);
}


void dcg_initialise(void)
{
  Condition::initialise();
}


char *Descriptor::printString(void) const
{
  static char bufs[4][32];
  static int bidx= 0;
  char *buf= bufs[bidx++ % 4], *ptr= buf;
  switch (type)
    {
    case Stack::Type:
      ptr+= sprintf(ptr, "Stack");
      break;
    case Integer::Type:
      ptr+= sprintf(ptr, "Integer(%d)", value);
      break;
    case Register::Type:
      ptr+= sprintf(ptr, "Register(%d)", value);
      break;
    case Condition::Type:
      ptr+= sprintf(ptr, "Condition(%s)", Condition::name(value));
      break;
    default:
      fatal("this cannot happen (%d)", type);
      break;
    }
  if (flags)
    {
      *ptr++= '[';
      if (isTagged()) *ptr++= 't';
      if (isSelf())   *ptr++= 's';
      *ptr++= ']';
    }
  *ptr++= '\0';
  return buf;
}


