// xmalloc.cc -- MacOS-proof version of malloc()
//
// Last edited: 2000-12-06 14:36:59 by piumarta on emilia.rd.wdi.disney.com

#include "xmalloc.h"
#include "debug.h"

#ifdef __macintosh__
# include <MacMemory.h>
# define malloc(lbs)	NewPtrSys(lbs)
# define free(ptr)	DisposePtr((Ptr)ptr)
#else
# include <stdlib.h>
#endif


void *xmalloc(size_t lbs)
{
  void *addr= malloc(lbs);
  if (addr == 0)
    { 
      fatal("malloc(%d) failed\n", lbs);
    }
  //fprintf(stderr, "xmalloc %d %p\n", lbs, addr);
  return addr;
}


void xfree(void *addr)
{
  //fprintf(stderr, "xmalloc free %p\n", addr);
  free(addr);
}
