// atcache.cc -- support for cached response to primitives #at:[put:]
// 
// Author: Ian.Piumarta@INRIA.Fr
// 
// Last edited: 2000-10-17 12:49:13 by piumarta on emilia.rd.wdi.disney.com

#include "atcache.h"

#include <string.h>

AtCacheLine j_atCache[AtCacheEntries * 2];


AtCacheLine *AtCacheLine::allocateFor(oop obj)
{
  assert(!obj->isInteger());
  unsigned format= obj->_format();
  if (format < 2)
    return 0;		// no indexable fields
  assert(sizeof(AtCacheLine) == (1 << AtHashLowBit));
  // NOTE: this MUST agree with the NAM implementation in prologue.cc!!!
  unsigned lineIndex= (((unsigned)obj >> AtHashLowBit) & (AtCacheEntries - 1));
  AtCacheLine *acl= j_atCache + lineIndex;
  unsigned size= obj->_sizeBits();
  if (format >= 8)
    size-= (format & 3);
  acl->object= obj;
  acl->indexableSize= size; 
  return acl;
}


void AtCacheLine::clearAll(void)
{
  memset((void *)j_atCache, 0, sizeof(j_atCache));
}
