#ifndef __vmc_ppc_h
#define __vmc_ppc_h


#include "label.h"

void  gen_init(void *codeCache);
void *gen_start(void *initialIP, int *stack);
void  gen_end(void);
void *gen_function(void);

void gen_halt(void);
void gen_locals(int index);
void gen_push(int literal);
void gen_pushArg(int index);
void gen_pushLocal(int index);
void gen_pop(void);
void gen_assignArg(int index);
void gen_less(void); 
void gen_lessEqual(void); 
void gen_equal(void); 
void gen_notEqual(void); 
void gen_greaterEqual(void); 
void gen_greater(void); 
void gen_add(void); 
void gen_subtract(void); 
void gen_multiply(void); 
void gen_divide(void); 
void gen_assignLocal(int index);
void gen_negate(void);
void gen_call(int numArgs);
void gen_return(void);
void gen_jump(Label *label);
void gen_jumpIfFalse(Label *label);
void gen_new(void);
void gen_delete(void);
void gen_get(void);
void gen_put(void);
void gen_print(void);


#endif __vmc_ppc_h
