/* mkimage.c -- generate gas source for initialised data
 * 
 * @copyright@
 */

/* Last edited: Mon Aug 21 01:47:04 2000 by piumarta (Ian Piumarta) on emilia
 */

#include <stdio.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
  if (argc != 2)
    {
      fprintf(stderr, "usage: %s sectionName\n", argv[0]);
      exit(1);
    }
  printf("\n\t.data");
  printf("\n\t.globl %s_start", argv[1]);
  printf("\n%s_start:", argv[1]);
  {
    unsigned char buf[8192];
    int nBytes= 0;
    while ((nBytes= read(0, buf, sizeof(buf))) > 0)
      {
	unsigned char *ptr= buf;
	int pos= 0;
	while (nBytes > 3)
	  {
	    if (pos == 0)
	      printf("\n\t.long\t");
	    else
	      printf(", ");
	    printf("%ld", *(long *)ptr);
	    if (++pos == 16)
	      pos= 0;
	    ptr+= 4;
	    nBytes-= 4;
	  }
	pos= 0;
	while (nBytes)
	  {
	    if (pos == 0)
	      printf("\n\t.byte\t");
	    else
	      printf(", ");
	    printf("%d", *ptr);
	    if (++pos == 16)
	      pos= 0;
	    ++ptr;
	    --nBytes;
	  }
      }
  }
  printf("\n\t.globl %s_end", argv[1]);
  printf("\n%s_end:\n", argv[1]);
  return 0;
}
