/* system.c -- trivial access to Unix `system' library call
 * 
 * @copyright@
 */

#include <stdio.h>
#include <stdlib.h>

#include "sqVirtualMachine.h"

struct VirtualMachine *interp;

int primitiveSystem(void)
{
  int receiver= interp->stackValue(0);
  int size= interp->stSizeOf(receiver);
  char buf[1024];
  int i;

  interp->success(1);

  if ((interp->methodArgumentCount() != 0) ||
      (interp->fetchClassOf(receiver) != interp->classString()))
    {
      printf("argcnt = %d\n", interp->methodArgumentCount());
      printf("rcvcls = %d, string = %d\n",
	     interp->fetchClassOf(receiver),
	     interp->classString());
      return interp->success(0);
    }

  for (i= 0; i < size; ++i)
    buf[i]= ((char *)receiver)[i + 4];
  buf[size]= '\0';

  system(buf);
  return 1;
}

int setInterpreter(struct VirtualMachine *proxy)
{
  interp= proxy;
  return 1;
}

