#   File:       Makefiles.make
#   Target:     Makefiles
# 
#   build the Makefile.
#


SRCDIR			= ::
GeneratedSRC	= {SRCDIR}generated:
j3SRCDIR       	= {SRCDIR}SqueakCompiler:
MacOSSRC		= {SRCDIR}macos:
SqueakMPWDir    = {MacOSSRC}mpw:

builddir        = {SRCDIR}build:

Includes        = -I{GUSI}include -I{MPW}:  -I{builddir} -I:{SRCDIR} -I{CIncludes} -I{GeneratedSRC} -I{J3SRCDIR} -I"{CCG}" -I"{MacOSSRC}" -I"{SqueakMPWDir}" -I"{MPW}":PluginSDK:Include
Defines         = -D__MPW__ -D__powerpc__ -D_macintosh_  -Dmacintosh -DTYPE_BOOL -Dpascal= 


### Source Files ### 

GeneratedHeaders = {builddir}ppc-defs.h {builddir}ppc-emit.h

SrcFilesJ3		= 
				  {j3SRCDIR}xmalloc.cc 
				  {j3SRCDIR}tramp.cc 
				  {j3SRCDIR}RelinkCache.cc 
				  {j3SRCDIR}prologue.cc 
				  {j3SRCDIR}primValue.cc 
				  {j3SRCDIR}primProfile.cc 
				  {j3SRCDIR}Profiler.cc 
				  {j3SRCDIR}spy.cc 
				  {j3SRCDIR}primProcess.cc 
				  {j3SRCDIR}primPerform.cc 
				  {j3SRCDIR}primitives.cc 
				  {j3SRCDIR}primitive.cc 
				  {j3SRCDIR}primExtern.cc 
				  {j3SRCDIR}primAccess.cc 
				  {j3SRCDIR}optimise.cc 
				  {j3SRCDIR}Object.cc 
				  {j3SRCDIR}NativeProcess.cc 
				  {j3SRCDIR}NativeMethod.cc 
				  {j3SRCDIR}ppc-Frame.cc 
				  {builddir}ppc-emit.cc 
				  {builddir}ppc-generate.cc 
				  {builddir}ppc-tramp.cc 
				  {j3SRCDIR}main.cc 
				  {j3SRCDIR}machine.cc 
				  {j3SRCDIR}interp.cc 
				  {j3SRCDIR}genValue.cc 
				  {j3SRCDIR}genSmallInteger.cc 
				  {j3SRCDIR}genQuick.cc 
				  {j3SRCDIR}genPrimitive.cc 
				  {j3SRCDIR}genObject.cc 
				  {j3SRCDIR}genFloat.cc 
				  {j3SRCDIR}generate.cc 
				  {j3SRCDIR}genCache.cc 
				  {j3SRCDIR}genArray.cc 
				  {j3SRCDIR}Frame.cc 
				  {j3SRCDIR}debug.cc 
				  {j3SRCDIR}compile.cc 
				  {j3SRCDIR}ppc-dis.cc 
				  {j3SRCDIR}Cache.cc 
				  {j3SRCDIR}atcache.cc 
				  {j3SRCDIR}dcg.cc

SrcFilesGenerated = 
				  {GeneratedSRC}ADPCMCodecPlugin.c 
				  {GeneratedSRC}AsynchFilePlugin.c 
				  {GeneratedSRC}sqVirtualMachine.c 
#				  {GeneratedSRC}SqueakFFIPrims.c 
				  {GeneratedSRC}Squeak3D.c 
				  {GeneratedSRC}SecurityPlugin.c 
				  {GeneratedSRC}DropPlugin.c 
				  {GeneratedSRC}DSAPrims.c 
				  {GeneratedSRC}SecurityPlugin.c 
				  {GeneratedSRC}sqOldSoundPrims.c 
				  {GeneratedSRC}sqNamedPrims.c 
				  {GeneratedSRC}MiscPrimitivePlugin.c 
				  {GeneratedSRC}sqGSMCodecPlugin.c 
				  {GeneratedSRC}sqFilePrims.c 
				  {GeneratedSRC}SoundPlugin.c 
				  {GeneratedSRC}SoundCodecPrims.c 
				  {GeneratedSRC}SoundGenerationPlugin.c 
				  {GeneratedSRC}SocketPlugin.c 
				  {GeneratedSRC}SerialPlugin.c 
				  {GeneratedSRC}MIDIPlugin.c 
				  {GeneratedSRC}Matrix2x3Plugin.c 
				  {GeneratedSRC}LargeIntegers.c 
				  {GeneratedSRC}Klatt.c 
				  {GeneratedSRC}JoystickTabletPlugin.c 
				  {GeneratedSRC}FloatArrayPlugin.c 
				  {GeneratedSRC}FilePlugin.c 
				  {GeneratedSRC}FFTPlugin.c 
				  {GeneratedSRC}BitBltPlugin.c 
				  {GeneratedSRC}JPEGReaderPlugin.c 
				  {GeneratedSRC}StarSqueakPlugin.c 
				  {GeneratedSRC}b3dRemap.c 
				  {GeneratedSRC}b3dMain.c 
				  {GeneratedSRC}b3dInit.c 
				  {GeneratedSRC}b3dDraw.c 
				  {GeneratedSRC}b3dAlloc.c 
				  {GeneratedSRC}B2DPlugin.c 
				  {GeneratedSRC}SurfacePlugin.c 
				  {GeneratedSRC}ZipPlugin.c 
				  {GeneratedSRC}AsynchFilePlugin.c 
				  {builddir}gnu-interp.c 

SrcFilesSqueak = 
#				  {MacOSSRC}sqMacFFIPPC.c 
				  {MacOSSRC}sqMacWindow.c 
				  {MacOSSRC}sqMacSound.c 
				  {MacOSSRC}sqMacSerialAndMIDIPort.c 
				  {MacOSSRC}sqMacNetwork.c 
				  {MacOSSRC}sqMacJoystickAndTablet.c 
				  {MacOSSRC}sqMacDirectory.c 
				  {MacOSSRC}sqMacAsyncFilePrims.c 
				  {MacOSSRC}sqMacDragDrop.c 
				  {MacOSSRC}sqMacSecurity.c 
				  {MacOSSRC}sqMacNSPlugin.c 
				  {MacOSSRC}dnr.c 
				  {MacOSSRC}gusi.cc
				  

### Default Rules ###

c  .cg
	{CCG}ccg -o {targDir}{default}.c  {depDir}{default}.cg

.cc  .ccg
	{CCG}ccg -o {targDir}{default}.cc  {depDir}{default}.ccg

.h  .hg
	{CCG}ccg -o {targDir}{default}.h  {depDir}{default}.hg


### Build Rules ###	

Makefiles  {builddir}clean.make {builddir}depends.squeak {builddir}depends.j3 {builddir}J3.make {builddir}Squeak.make 
			{builddir}SqueakInBrowser.make {builddir}J3InBrowser.make


{builddir}depends.squeak  {SrcFilesGenerated} 
	Gc -M -H {Includes} {Defines} {SrcFilesGenerated} {SrcFilesSqueak}  |  
	   StreamEdit -e '/:\// Replace // ":" -c ; 
					   /\// Replace // ":" -c ; 
					   /\\/ Replace // "" -c ; 
					  /.o:/ Replace // ".c.x  " -c ' > {builddir}depends.squeak
		
		

{builddir}depends.j3  {GeneratedHeaders} {SrcFilesJ3}  
	Gc -M -H {Includes} {Defines} {SrcFilesJ3} |  
	   StreamEdit -e '/:\// Replace // ":" -c ; 
					   /\// Replace // ":" -c ; 
					   /\\/ Replace // "" -c ; 
					  /.o:/ Replace // ".cc.x  " -c ' > {builddir}depends.j3
					  
{builddir}J3.make  J3.make.in {builddir}depends.squeak {builddir}depends.j3
	catenate J3.make.in {builddir}depends.squeak {builddir}depends.j3 > {builddir}J3.make
	

{builddir}Squeak.make  Squeak.make.in {builddir}depends.squeak 
	catenate Squeak.make.in {builddir}depends.squeak > {builddir}Squeak.make

{builddir}SqueakInBrowser.make  SqueakInBrowser.make.in {builddir}depends.squeak 
	catenate SqueakInBrowser.make.in {builddir}depends.squeak > {builddir}SqueakInBrowser.make

{builddir}J3InBrowser.make  J3InBrowser.make.in {builddir}depends.squeak  {builddir}depends.j3 
	catenate J3InBrowser.make.in {builddir}depends.squeak {builddir}depends.j3 > {builddir}J3InBrowser.make

{builddir}clean.make  clean.make.in
	duplicate clean.make.in {builddir}clean.make

### dependencies ###

{builddir}ppc-defs.h  {j3SRCDIR}ppc-defs.hg
	{CCG}ccg -o {builddir}ppc-defs.h {j3SRCDIR}ppc-defs.hg

{builddir}ppc-emit.h  {j3SRCDIR}ppc-emit.hg
	{CCG}ccg -o {builddir}ppc-emit.h {j3SRCDIR}ppc-emit.hg

{builddir}ppc-emit.cc   {j3SRCDIR}ppc-emit.ccg
				
{builddir}ppc-generate.cc  {j3SRCDIR}ppc-generate.ccg

{builddir}ppc-tramp.cc  {j3SRCDIR}ppc-tramp.ccg

{builddir}gnu-interp.c  {GeneratedSRC}interp.c
	gawk -f {SRC}unix:util:gnuify {GeneratedSRC}interp.c > {builddir}gnu-interp.c

