/* Automatically generated from Squeak on #(21 October 2001 9:18:01 pm) */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
/*  The virtual machine proxy definition */
#include "sqVirtualMachine.h"
/* Configuration options */
#include "sqConfig.h"
/* Platform specific definitions */
#include "sqPlatformSpecific.h"

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */
#include "MIDIPlugin.h"

/* memory access macros */
#define byteAt(i) (*((unsigned char *) (i)))
#define byteAtput(i, val) (*((unsigned char *) (i)) = val)
#define longAt(i) (*((int *) (i)))
#define longAtput(i, val) (*((int *) (i)) = val)

/*** Variables ***/
static struct VirtualMachine* interpreterProxy;
static const char *moduleName = "MIDIPlugin 21 October 2001 (i)";

/*** Function Prototypes ***/
#pragma export on
EXPORT(const char*) MIDIPlugin_getModuleName(void);
EXPORT(int) MIDIPlugin_initialiseModule(void);
EXPORT(int) MIDIPlugin_primitiveMIDIClosePort(void);
EXPORT(int) MIDIPlugin_primitiveMIDIGetClock(void);
EXPORT(int) MIDIPlugin_primitiveMIDIGetPortCount(void);
EXPORT(int) MIDIPlugin_primitiveMIDIGetPortDirectionality(void);
EXPORT(int) MIDIPlugin_primitiveMIDIGetPortName(void);
EXPORT(int) MIDIPlugin_primitiveMIDIOpenPort(void);
EXPORT(int) MIDIPlugin_primitiveMIDIParameterGet(void);
EXPORT(int) MIDIPlugin_primitiveMIDIParameterGetOrSet(void);
EXPORT(int) MIDIPlugin_primitiveMIDIParameterSet(void);
EXPORT(int) MIDIPlugin_primitiveMIDIRead(void);
EXPORT(int) MIDIPlugin_primitiveMIDIWrite(void);
EXPORT(int) MIDIPlugin_setInterpreter(struct VirtualMachine* anInterpreter);
EXPORT(int) MIDIPlugin_shutdownModule(void);
#pragma export off


/*	Note: This is hardcoded so it can be run from Squeak.
	The module name is used for validating a module *after*
	it is loaded to check if it does really contain the module
	we're thinking it contains. This is important! */

EXPORT(const char*) MIDIPlugin_getModuleName(void) {
	return moduleName;
}

EXPORT(int) MIDIPlugin_initialiseModule(void) {
	return midiInit();
}

EXPORT(int) MIDIPlugin_primitiveMIDIClosePort(void) {
	int portNum;

	portNum = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	sqMIDIClosePort(portNum);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->pop(1);
	return null;
}


/*	Return the value of the MIDI clock as a SmallInteger. The range is limited to SmallInteger maxVal / 2 to allow scheduling MIDI events into the future without overflowing a SmallInteger. The sqMIDIGetClock function is assumed to wrap at or before 16r20000000. */

EXPORT(int) MIDIPlugin_primitiveMIDIGetClock(void) {
	int clockValue;
	int _return_value;

	clockValue = (sqMIDIGetClock()) & 536870911;
	_return_value = interpreterProxy->integerObjectOf(clockValue);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(1, _return_value);
	return null;
}

EXPORT(int) MIDIPlugin_primitiveMIDIGetPortCount(void) {
	int n;
	int _return_value;

	n = sqMIDIGetPortCount();
	_return_value = interpreterProxy->integerObjectOf(n);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(1, _return_value);
	return null;
}

EXPORT(int) MIDIPlugin_primitiveMIDIGetPortDirectionality(void) {
	int dir;
	int portNum;
	int _return_value;

	portNum = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	dir = sqMIDIGetPortDirectionality(portNum);
	_return_value = interpreterProxy->integerObjectOf(dir);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(2, _return_value);
	return null;
}

EXPORT(int) MIDIPlugin_primitiveMIDIGetPortName(void) {
	char portName[256];
	int nameObj;
	int sz;
	char * namePtr;
	int portNum;

	portNum = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	sz = sqMIDIGetPortName(portNum, (int) &portName, 255);
	nameObj = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classString(), sz);
	if (interpreterProxy->failed()) {
		return null;
	}
	namePtr = ((char *) interpreterProxy->firstIndexableField(nameObj));
	memcpy(namePtr, portName, sz);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(2, nameObj);
	return null;
}

EXPORT(int) MIDIPlugin_primitiveMIDIOpenPort(void) {
	int portNum;
	int semaIndex;
	int clockRate;

	portNum = interpreterProxy->stackIntegerValue(2);
	semaIndex = interpreterProxy->stackIntegerValue(1);
	clockRate = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	sqMIDIOpenPort(portNum, semaIndex, clockRate);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->pop(3);
	return null;
}


/*	read parameter */

EXPORT(int) MIDIPlugin_primitiveMIDIParameterGet(void) {
	int currentValue;
	int whichParameter;
	int _return_value;

	whichParameter = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	currentValue = sqMIDIParameterGet(whichParameter);
	_return_value = interpreterProxy->integerObjectOf(currentValue);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(2, _return_value);
	return null;
}


/*	Backward compatibility */

EXPORT(int) MIDIPlugin_primitiveMIDIParameterGetOrSet(void) {
	if ((interpreterProxy->methodArgumentCount()) == 1) {
		return MIDIPlugin_primitiveMIDIParameterGet();
	} else {
		return MIDIPlugin_primitiveMIDIParameterSet();
	}
}


/*	write parameter */

EXPORT(int) MIDIPlugin_primitiveMIDIParameterSet(void) {
	int whichParameter;
	int newValue;

	whichParameter = interpreterProxy->stackIntegerValue(1);
	newValue = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	sqMIDIParameterSet(whichParameter, newValue);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->pop(2);
	return null;
}

EXPORT(int) MIDIPlugin_primitiveMIDIRead(void) {
	int bytesRead;
	int arrayLength;
	int portNum;
	char *array;
	int _return_value;

	portNum = interpreterProxy->stackIntegerValue(1);
	interpreterProxy->success(interpreterProxy->isBytes(interpreterProxy->stackValue(0)));
	array = ((char *) (interpreterProxy->firstIndexableField(interpreterProxy->stackValue(0))));
	if (interpreterProxy->failed()) {
		return null;
	}
	arrayLength = interpreterProxy->byteSizeOf(((int) (array) -4));
	bytesRead = sqMIDIPortReadInto(portNum, arrayLength, ((int) array ));
	_return_value = interpreterProxy->integerObjectOf(bytesRead);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(3, _return_value);
	return null;
}

EXPORT(int) MIDIPlugin_primitiveMIDIWrite(void) {
	int bytesWritten;
	int arrayLength;
	int portNum;
	char *array;
	int time;
	int _return_value;

	portNum = interpreterProxy->stackIntegerValue(2);
	interpreterProxy->success(interpreterProxy->isBytes(interpreterProxy->stackValue(1)));
	array = ((char *) (interpreterProxy->firstIndexableField(interpreterProxy->stackValue(1))));
	time = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	arrayLength = interpreterProxy->byteSizeOf(((int) (array) -4));
	bytesWritten = sqMIDIPortWriteFromAt(portNum, arrayLength, ((int) array ), time);
	_return_value = interpreterProxy->integerObjectOf(bytesWritten);
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(4, _return_value);
	return null;
}


/*	Note: This is coded so that is can be run from Squeak. */

EXPORT(int) MIDIPlugin_setInterpreter(struct VirtualMachine* anInterpreter) {
	int ok;

	interpreterProxy = anInterpreter;
	ok = interpreterProxy->majorVersion() == VM_PROXY_MAJOR;
	if (ok == 0) {
		return 0;
	}
	ok = interpreterProxy->minorVersion() >= VM_PROXY_MINOR;
	return ok;
}

EXPORT(int) MIDIPlugin_shutdownModule(void) {
	return midiShutdown();
}
