// emit.h -- instruction output macros and support
//
// Author: Ian.Piumarta@INRIA.Fr
//
// Last edited: Thu Jan 13 03:45:44 2000 by piumarta (Ian Piumarta) on pingu


#ifndef _j_emit_h
#define _j_emit_h


#include "archdep.h"

#include ARCHDEP(emit.h)


#define declareLabel(LABEL)			\
  insn *LABEL= asm_pc

#define defineLabel(LABEL)			\
  LABEL= asm_pc


#define twoPass(CODE)				\
  {						\
    insn *asm_org= asm_pc;			\
    for (asm_pass= 1; asm_pass < 3; ++asm_pass) \
      {						\
        asm_pc= asm_org;			\
        CODE					\
      }						\
    asm_pass= 0;				\
  }

#endif // _j_emit_h
