/* Automatically generated from Squeak on (18 December 1998 9:33:30 pm ) */

#include "sq.h"
#include "sqMachDep.h"  /* needed only by the JIT virtual machine */

/* memory access macros */
#define byteAt(i) (*((unsigned char *) (i)))
#define byteAtput(i, val) (*((unsigned char *) (i)) = val)
#define longAt(i) (*((int *) (i)))
#define longAtput(i, val) (*((int *) (i)) = val)

int printCallStack(void);
void error(char *s);
void error(char *s) {
	/* Print an error message and exit. */
	static int printingStack = false;

	printf("\n%s\n\n", s);
	if (!printingStack) {
		/* flag prevents recursive error when trying to print a broken stack */
		printingStack = true;
		printCallStack();
	}
	exit(-1);
}

/*** Variables ***/
int activeContext;
int affectedB;
int affectedL;
int affectedR;
int affectedT;
int allocationCount;
int allocationsBetweenGCs;
int argumentCount;
int bbH;
int bbW;
int bitBltOop;
int bitCount;
int checkAssertions;
int child;
int clipHeight;
int clipWidth;
int clipX;
int clipY;
int cmBitsPerColor;
int colorMap;
int combinationRule;
int compEnd;
int compStart;
int currentBytecode;
int deferDisplayUpdates;
int destBits;
int destDelta;
int destForm;
int destIndex;
int destMask;
int destPixSize;
int destRaster;
int destX;
int destY;
int displayBits;
int dx;
int dy;
int endOfMemory;
int falseObj;
int field;
int freeBlock;
int freeLargeContexts;
int freeSmallContexts;
int fullScreenFlag;
int fwdTableLast;
int fwdTableNext;
int hDir;
int halftoneBase;
int halftoneForm;
int halftoneHeight;
int height;
int instructionPointer;
int interpreterProxy;
int interruptCheckCounter;
int interruptKeycode;
int interruptPending;
int lastHash;
int lastTick;
char * localIP;
char * localSP;
int lowSpaceThreshold;
int mask1;
int mask2;
int mcProbe;
unsigned char *memory;
int memoryLimit;
int messageSelector;
int method;
int methodCache[2049];
int nWords;
int newMethod;
int nextPollTick;
int nextWakeupTick;
int nilObj;
int noHalftone;
int noSource;
int opTable[35];
int parentField;
int pixPerWord;
int preload;
int primitiveIndex;
int receiver;
int reclaimableContextCount;
int remapBuffer[26];
int remapBufferCount;
int rootTable[1001];
int rootTableCount;
int savedWindowSize;
int scanDisplayFlag;
int scanRightX;
int scanStart;
int scanStop;
int scanStopArray;
int scanString;
int scanXTable;
int semaphoresToSignal[26];
int semaphoresToSignalCount;
int signalLowSpace;
int skew;
int sourceAlpha;
int sourceBits;
int sourceDelta;
int sourceForm;
int sourceIndex;
int sourcePixSize;
int sourceRaster;
int sourceX;
int sourceY;
int specialObjectsOop;
int srcBitIndex;
int srcHeight;
int srcWidth;
int stackPointer;
int statFullGCMSecs;
int statFullGCs;
int statIncrGCMSecs;
int statIncrGCs;
int statRootTableOverflows;
int statTenures;
int stopCode;
int successFlag;
int sx;
int sy;
int tenuringThreshold;
int theHomeContext;
int trueObj;
int vDir;
int width;
int youngStart;

/*** Function Prototypes ***/
int OLDrgbDiffwith(int sourceWord, int destinationWord);
int OLDtallyIntoMapwith(int sourceWord, int destinationWord);
int aComment(void);
int accessibleObjectAfter(int oop);
int activateNewMethod(void);
int addLastLinktoList(int proc, int aList);
int addToMethodCacheSelclassmethodprimIndex(int selector, int class, int meth, int primIndex);
int addWordwith(int sourceWord, int destinationWord);
int adjustAllOopsBy(int bytesToShift);
int adjustFieldsAndClassOfby(int oop, int offsetBytes);
int affectedBottom(void);
int affectedLeft(void);
int affectedRight(void);
int affectedTop(void);
int allAccessibleObjectsOkay(void);
int allYoungand(int array1, int array2);
int allocateheaderSizeh1h2h3fill(int byteSize, int hdrSize, int baseHeader, int classOop, int extendedSize, int fillWord);
int allocateChunk(int byteSize);
int allocateOrRecycleContext(int smallContextWanted);
int alphaBlendwith(int sourceWord, int destinationWord);
int alphaBlendConstwith(int sourceWord, int destinationWord);
int alphaBlendConstwithpaintMode(int sourceWord, int destinationWord, int paintMode);
int alphaPaintConstwith(int sourceWord, int destinationWord);
int areIntegersand(int oop1, int oop2);
int argCount(void);
int argumentCountOf(int methodPointer);
int argumentCountOfBlock(int blockPointer);
void * arrayValueOf(int arrayOop);
int asciiDirectoryDelimiter(void);
int asciiOfCharacter(int characterObj);
int assertClassOfis(int oop, int classOop);
int assertFloatand(int oop1, int oop2);
AsyncFile * asyncFileValueOf(int oop);
int baseHeader(int oop);
int beRootIfOld(int oop);
int beRootWhileForwarding(int oop);
int becomewith(int array1, int array2);
int bitAndwith(int sourceWord, int destinationWord);
int bitAndInvertwith(int sourceWord, int destinationWord);
int bitInvertAndwith(int sourceWord, int destinationWord);
int bitInvertAndInvertwith(int sourceWord, int destinationWord);
int bitInvertDestinationwith(int sourceWord, int destinationWord);
int bitInvertOrwith(int sourceWord, int destinationWord);
int bitInvertOrInvertwith(int sourceWord, int destinationWord);
int bitInvertSourcewith(int sourceWord, int destinationWord);
int bitInvertXorwith(int sourceWord, int destinationWord);
int bitOrwith(int sourceWord, int destinationWord);
int bitOrInvertwith(int sourceWord, int destinationWord);
int bitXorwith(int sourceWord, int destinationWord);
int booleanCheat(int cond);
int booleanValueOf(int obj);
int byteLengthOf(int oop);
int byteSwapByteObjects(void);
int byteSwapped(int w);
int bytecodePrimAdd(void);
int bytecodePrimAt(void);
int bytecodePrimAtEnd(void);
int bytecodePrimAtPut(void);
int bytecodePrimBitAnd(void);
int bytecodePrimBitOr(void);
int bytecodePrimBitShift(void);
int bytecodePrimBlockCopy(void);
int bytecodePrimClass(void);
int bytecodePrimDiv(void);
int bytecodePrimDivide(void);
int bytecodePrimDo(void);
int bytecodePrimEqual(void);
int bytecodePrimEquivalent(void);
int bytecodePrimGreaterOrEqual(void);
int bytecodePrimGreaterThan(void);
int bytecodePrimLessOrEqual(void);
int bytecodePrimLessThan(void);
int bytecodePrimMakePoint(void);
int bytecodePrimMod(void);
int bytecodePrimMultiply(void);
int bytecodePrimNew(void);
int bytecodePrimNewWithArg(void);
int bytecodePrimNext(void);
int bytecodePrimNextPut(void);
int bytecodePrimNotEqual(void);
int bytecodePrimPointX(void);
int bytecodePrimPointY(void);
int bytecodePrimSize(void);
int bytecodePrimSubtract(void);
int bytecodePrimValue(void);
int bytecodePrimValueWithArg(void);
int caller(void);
int characterForAscii(int integerObj);
int checkAddress(int byteAddress);
int checkBooleanResultfrom(int result, int primIndex);
int checkForInterrupts(void);
int checkImageVersionFrom(sqImageFile f);
int checkIntegerResultfrom(int integerResult, int primIndex);
int checkSourceOverlap(void);
int checkedByteAt(int byteAddress);
int checkedByteAtput(int byteAddress, int byte);
int checkedIntegerValueOf(int intOop);
int checkedLongAt(int byteAddress);
int checkedLongAtput(int byteAddress, int a32BitInteger);
int chunkFromOop(int oop);
int classHeader(int oop);
int clearRootsTable(void);
int clearWordwith(int source, int destination);
int clipRange(void);
int clone(int oop);
int commonAt(int stringy);
int commonAtPut(int stringy);
int compare31or32Bitsequal(int obj1, int obj2);
int containOnlyOopsand(int array1, int array2);
int copyBits(void);
int copyLoop(void);
int copyLoopNoSource(void);
int copyLoopPixMap(void);
int cr(void);
int createActualMessage(void);
int deltaFromtonSteps(int x1, int x2, int n);
int destMaskAndPointerInit(void);
int destinationWordwith(int sourceWord, int destinationWord);
int doubleExtendedDoAnythingBytecode(void);
int drawLoopXY(int xDelta, int yDelta);
int duplicateTopBytecode(void);
int exchangeHashBitswith(int oop1, int oop2);
int executeNewMethod(void);
int experimentalBytecode(void);
int extendedPushBytecode(void);
int extendedStoreAndPopBytecode(void);
int extendedStoreBytecode(void);
int externalizeIPandSP(void);
int extraHeaderBytes(int oopOrChunk);
int failSpecialPrim(int primIndex);
int failed(void);
void * fetchArrayofObject(int fieldIndex, int objectPointer);
int fetchByte(void);
int fetchByteofObject(int byteIndex, int oop);
int fetchClassOf(int oop);
int fetchContextRegisters(int activeCntx);
double fetchFloatofObject(int fieldIndex, int objectPointer);
int fetchIntegerofObject(int fieldIndex, int objectPointer);
int fetchIntegerOrTruncFloatofObject(int fieldIndex, int objectPointer);
int fetchPointerofObject(int fieldIndex, int oop);
int fetchWordofObject(int fieldIndex, int oop);
int fetchWordLengthOf(int objectPointer);
int fileRecordSize(void);
SQFile * fileValueOf(int objectPointer);
int findClassOfMethodforReceiver(int meth, int rcvr);
int findNewMethodInClass(int class);
int findSelectorOfMethodforReceiver(int meth, int rcvr);
int firstAccessibleObject(void);
int firstObject(void);
int fixedFieldsOfformatlength(int oop, int fmt, int wordLength);
double floatValueOf(int oop);
int flushMethodCache(void);
int formatOf(int oop);
int formatOfClass(int classPointer);
int fullCompaction(void);
int fullDisplayUpdate(void);
int fullGC(void);
int fwdBlockGet(void);
int fwdBlockValidate(int addr);
int fwdTableInit(void);
int getCurrentBytecode(void);
int getLongFromFileswap(sqImageFile f, int swapFlag);
int hashBitsOf(int oop);
int headerOf(int methodPointer);
int headerType(int oop);
int ignoreSourceOrHalftone(int formPointer);
int imageFormatVersion(void);
int incCompBody(void);
int incCompMakeFwd(void);
int incCompMove(int bytesFreed);
int incrementalCompaction(void);
int incrementalGC(void);
int initBBOpTable(void);
int initForwardBlockmappingto(int fwdBlock, int oop, int newOop);
int initialInstanceOf(int classPointer);
int initializeInterpreter(int bytesToShift);
int initializeMemoryFirstFree(int firstFree);
int initializeObjectMemory(int bytesToShift);
int instanceAfter(int objectPointer);
int instantiateClassindexableSize(int classPointer, int size);
int instantiateSmallClasssizeInBytesfill(int classPointer, int sizeInBytes, int fillValue);
int intToNetAddress(int addr);
int integerObjectOf(int value);
int integerValueOf(int objectPointer);
int internalFetchContextRegisters(int activeCntx);
int internalPop(int nItems);
int internalPopthenPush(int nItems, int oop);
int internalPush(int object);
int internalQuickCheckForInterrupts(void);
int internalStackTop(void);
int internalStackValue(int offset);
int internalizeIPandSP(void);
int interpret(void);
int isBytes(int oop);
int isEmptyList(int aLinkedList);
int isFreeObject(int oop);
int isIntegerObject(int objectPointer);
int isIntegerValue(int intValue);
int isObjectForwarded(int oop);
int isPointers(int oop);
int isWords(int oop);
int isWordsOrBytes(int oop);
int jump(int offset);
int jumplfFalseBy(int offset);
int jumplfTrueBy(int offset);
int lastPointerOf(int objectPointer);
int lastPointerWhileForwarding(int oop);
int lengthOf(int oop);
int lengthOfbaseHeaderformat(int oop, int hdr, int fmt);
int literal(int offset);
int literalofMethod(int offset, int methodPointer);
int literalCountOf(int methodPointer);
int literalCountOfHeader(int headerPointer);
int loadBitBltFrom(int bbObj);
int loadInitialContext(void);
int loadScannerFromstartstopstringrightXstopArraydisplayFlag(int bbObj, int start, int stop, int string, int rightX, int stopArray, int displayFlag);
int longJumpIfFalse(void);
int longJumpIfTrue(void);
int longUnconditionalJump(void);
int lookupInMethodCacheSelclass(int selector, int class);
int lookupMethodInClass(int class);
int lookupMethodInDictionary(int dictionary);
int lowestFreeAfter(int chunk);
int makeDirEntryNamesizecreateDatemodDateisDirfileSize(char *entryName, int entryNameSize, int createDate, int modifiedDate, int dirFlag, int fileSize);
int makePointwithxValueyValue(int xValue, int yValue);
int mapInterpreterOops(void);
int mapPointersInObjectsFromto(int memStart, int memEnd);
int markAndTrace(int oop);
int markAndTraceInterpreterOops(void);
int markPhase(void);
int mergewith(int sourceWord, int destinationWord);
int methodClassOf(int methodPointer);
int netAddressToInt(int oop);
int newActiveContext(int aContext);
int newObjectHash(void);
int nilObject(void);
int normalSend(void);
int objectAfter(int oop);
int objectAfterWhileForwarding(int oop);
int okArrayClass(int cl);
int okStreamArrayClass(int cl);
int okayActiveProcessStack(void);
int okayFields(int oop);
int okayInterpreterObjects(void);
int okayOop(int oop);
int oopFromChunk(int chunk);
int oopHasOkayClass(int oop);
int partitionedANDtonBitsnPartitions(int word1, int word2, int nBits, int nParts);
int partitionedAddtonBitsnPartitions(int word1, int word2, int nBits, int nParts);
int partitionedMaxwithnBitsnPartitions(int word1, int word2, int nBits, int nParts);
int partitionedMinwithnBitsnPartitions(int word1, int word2, int nBits, int nParts);
int partitionedSubfromnBitsnPartitions(int word1, int word2, int nBits, int nParts);
int pickSourcePixelsnullMapsrcMaskdestMask(int nPix, int nullMap, int sourcePixMask, int destPixMask);
int pickSourcePixelssrcMaskdestMask(int nPix, int sourcePixMask, int destPixMask);
int pickSourcePixelsNullMapsrcMaskdestMask(int nPix, int sourcePixMask, int destPixMask);
int pickSourcePixelsRGBnullMapsrcMaskdestMask(int nPix, int nullMap, int sourcePixMask, int destPixMask);
int pixMaskwith(int sourceWord, int destinationWord);
int pixPaintwith(int sourceWord, int destinationWord);
int pop(int nItems);
int popthenPush(int nItems, int oop);
double popFloat(void);
int popInteger(void);
int popPos32BitInteger(void);
int popRemappableOop(void);
int popStack(void);
int popStackBytecode(void);
int positive32BitIntegerFor(int integerValue);
int positive32BitValueOf(int oop);
int possibleRootStoreIntovalue(int oop, int valueObj);
int postGCAction(void);
int preGCAction(int fullGCFlag);
int prepareForwardingTableForBecomingwith(int array1, int array2);
int primIndex(void);
int primitiveAdd(void);
int primitiveArctan(void);
int primitiveArrayBecome(void);
int primitiveAsFloat(void);
int primitiveAsOop(void);
int primitiveAsyncFileClose(void);
int primitiveAsyncFileOpen(void);
int primitiveAsyncFileReadResult(void);
int primitiveAsyncFileReadStart(void);
int primitiveAsyncFileWriteResult(void);
int primitiveAsyncFileWriteStart(void);
int primitiveAt(void);
int primitiveAtEnd(void);
int primitiveAtPut(void);
int primitiveBeCursor(void);
int primitiveBeDisplay(void);
int primitiveBeep(void);
int primitiveBitAnd(void);
int primitiveBitOr(void);
int primitiveBitShift(void);
int primitiveBitXor(void);
int primitiveBlockCopy(void);
int primitiveBytesLeft(void);
int primitiveClass(void);
int primitiveClipboardText(void);
int primitiveClone(void);
int primitiveConstantFill(void);
int primitiveCopyBits(void);
int primitiveDeferDisplayUpdates(void);
int primitiveDirectoryCreate(void);
int primitiveDirectoryDelimitor(void);
int primitiveDirectoryLookup(void);
int primitiveDirectorySetMacTypeAndCreator(void);
int primitiveDiv(void);
int primitiveDivide(void);
int primitiveDoPrimitiveWithArgs(void);
int primitiveDrawLoop(void);
int primitiveEqual(void);
int primitiveEquivalent(void);
int primitiveExitToDebugger(void);
int primitiveExp(void);
int primitiveExponent(void);
int primitiveFail(void);
int primitiveFileAtEnd(void);
int primitiveFileClose(void);
int primitiveFileDelete(void);
int primitiveFileGetPosition(void);
int primitiveFileOpen(void);
int primitiveFileRead(void);
int primitiveFileRename(void);
int primitiveFileSetPosition(void);
int primitiveFileSize(void);
int primitiveFileWrite(void);
int primitiveFloatAdd(void);
int primitiveFloatDivide(void);
int primitiveFloatEqual(void);
int primitiveFloatGreaterOrEqual(void);
int primitiveFloatGreaterThan(void);
int primitiveFloatLessOrEqual(void);
int primitiveFloatLessThan(void);
int primitiveFloatMultiply(void);
int primitiveFloatNotEqual(void);
int primitiveFloatSubtract(void);
int primitiveFlushCache(void);
int primitiveFlushCacheSelective(void);
int primitiveForceDisplayUpdate(void);
int primitiveFormPrint(void);
int primitiveFractionalPart(void);
int primitiveFullGC(void);
int primitiveGetAttribute(void);
int primitiveGreaterOrEqual(void);
int primitiveGreaterThan(void);
int primitiveImageName(void);
int primitiveIncrementalGC(void);
int primitiveIndexOf(int methodPointer);
int primitiveInitializeNetwork(void);
int primitiveInputSemaphore(void);
int primitiveInputWord(void);
int primitiveInstVarAt(void);
int primitiveInstVarAtPut(void);
int primitiveInterruptSemaphore(void);
int primitiveKbdNext(void);
int primitiveKbdPeek(void);
int primitiveLessOrEqual(void);
int primitiveLessThan(void);
int primitiveLoadInstVar(void);
int primitiveLogN(void);
int primitiveLowSpaceSemaphore(void);
int primitiveMIDIClosePort(void);
int primitiveMIDIGetClock(void);
int primitiveMIDIGetPortCount(void);
int primitiveMIDIGetPortDirectionality(void);
int primitiveMIDIGetPortName(void);
int primitiveMIDIOpenPort(void);
int primitiveMIDIParameterGetOrSet(void);
int primitiveMIDIRead(void);
int primitiveMIDIWrite(void);
int primitiveMakePoint(void);
int primitiveMillisecondClock(void);
int primitiveMod(void);
int primitiveMouseButtons(void);
int primitiveMousePoint(void);
int primitiveMultiply(void);
int primitiveNew(void);
int primitiveNewMethod(void);
int primitiveNewWithArg(void);
int primitiveNext(void);
int primitiveNextInstance(void);
int primitiveNextObject(void);
int primitiveNextPut(void);
int primitiveNoop(void);
int primitiveNotEqual(void);
int primitiveObjectAt(void);
int primitiveObjectAtPut(void);
int primitiveObjectPointsTo(void);
int primitivePerform(void);
int primitivePerformWithArgs(void);
int primitivePointX(void);
int primitivePointY(void);
int primitivePushFalse(void);
int primitivePushMinusOne(void);
int primitivePushNil(void);
int primitivePushOne(void);
int primitivePushSelf(void);
int primitivePushTrue(void);
int primitivePushTwo(void);
int primitivePushZero(void);
int primitiveQuit(void);
int primitiveQuo(void);
int primitiveReadJoystick(void);
int primitiveRelinquishProcessor(void);
int primitiveResolverAbortLookup(void);
int primitiveResolverAddressLookupResult(void);
int primitiveResolverError(void);
int primitiveResolverLocalAddress(void);
int primitiveResolverNameLookupResult(void);
int primitiveResolverStartAddressLookup(void);
int primitiveResolverStartNameLookup(void);
int primitiveResolverStatus(void);
int primitiveResponse(void);
int primitiveResume(void);
int primitiveScanCharacters(void);
int primitiveScreenSize(void);
int primitiveSecondsClock(void);
int primitiveSerialPortClose(void);
int primitiveSerialPortOpen(void);
int primitiveSerialPortRead(void);
int primitiveSerialPortWrite(void);
int primitiveSetFullScreen(void);
int primitiveSetInterruptKey(void);
int primitiveShortAt(void);
int primitiveShortAtPut(void);
int primitiveShowDisplayRect(void);
int primitiveSignal(void);
int primitiveSignalAtBytesLeft(void);
int primitiveSignalAtMilliseconds(void);
int primitiveSine(void);
int primitiveSize(void);
int primitiveSnapshot(void);
int primitiveSocketAbortConnection(void);
int primitiveSocketCloseConnection(void);
int primitiveSocketConnectToPort(void);
int primitiveSocketConnectionStatus(void);
int primitiveSocketCreate(void);
int primitiveSocketDestroy(void);
int primitiveSocketError(void);
int primitiveSocketListenOnPort(void);
int primitiveSocketLocalAddress(void);
int primitiveSocketLocalPort(void);
int primitiveSocketReceiveDataAvailable(void);
int primitiveSocketReceiveDataBufCount(void);
int primitiveSocketRemoteAddress(void);
int primitiveSocketRemotePort(void);
int primitiveSocketSendDataBufCount(void);
int primitiveSocketSendDone(void);
int primitiveSomeInstance(void);
int primitiveSomeObject(void);
int primitiveSoundAvailableSpace(void);
int primitiveSoundGetRecordingSampleRate(void);
int primitiveSoundInsertSamples(void);
int primitiveSoundPlaySamples(void);
int primitiveSoundPlaySilence(void);
int primitiveSoundRecordSamples(void);
int primitiveSoundSetRecordLevel(void);
int primitiveSoundStart(void);
int primitiveSoundStartRecording(void);
int primitiveSoundStartWithSemaphore(void);
int primitiveSoundStop(void);
int primitiveSoundStopRecording(void);
int primitiveSpecialObjectsOop(void);
int primitiveSquareRoot(void);
int primitiveStringAt(void);
int primitiveStringAtPut(void);
int primitiveStringReplace(void);
int primitiveSubtract(void);
int primitiveSuspend(void);
int primitiveTimesTwoPower(void);
int primitiveTruncated(void);
int primitiveVMParameter(void);
int primitiveVMPath(void);
int primitiveValue(void);
int primitiveValueWithArgs(void);
int primitiveWait(void);
int primitiveWarpBits(void);
int print(char *s);
int printCallStack(void);
int printChar(int aByte);
int printNameOfClasscount(int classOop, int cnt);
int printNum(int n);
int printStringOf(int oop);
int push(int object);
int pushActiveContextBytecode(void);
int pushBool(int trueOrFalse);
int pushConstantFalseBytecode(void);
int pushConstantMinusOneBytecode(void);
int pushConstantNilBytecode(void);
int pushConstantOneBytecode(void);
int pushConstantTrueBytecode(void);
int pushConstantTwoBytecode(void);
int pushConstantZeroBytecode(void);
int pushFloat(double f);
int pushInteger(int integerValue);
int pushLiteralConstant(int literalIndex);
int pushLiteralConstantBytecode(void);
int pushLiteralVariable(int literalIndex);
int pushLiteralVariableBytecode(void);
int pushReceiverBytecode(void);
int pushReceiverVariable(int fieldIndex);
int pushReceiverVariableBytecode(void);
int pushRemappableOop(int oop);
int pushTemporaryVariable(int temporaryIndex);
int pushTemporaryVariableBytecode(void);
int putLongtoFile(int n, sqImageFile f);
int putToSleep(int aProcess);
int quickCheckForInterrupts(void);
int quickFetchIntegerofObject(int fieldIndex, int objectPointer);
int readImageFromFileHeapSize(sqImageFile f, int desiredHeapSize);
int recycleContextIfPossiblemethodContextClass(int cntxOop, int methodCntxClass);
int remap(int oop);
int remapClassOf(int oop);
int remapFieldsAndClassOf(int oop);
int removeFirstLinkOfList(int aList);
int reportContexts(void);
int restoreHeaderOf(int oop);
int restoreHeadersAfterBecomingwith(int list1, int list2);
int resume(int aProcess);
int returnAtlastIndexlefttop(int stopIndex, int lastIndex, int left, int top);
int returnFalse(void);
int returnNil(void);
int returnReceiver(void);
int returnTopFromBlock(void);
int returnTopFromMethod(void);
int returnTrue(void);
int returnValueto(int resultObj, int returnContext);
int reverseBytesFromto(int startAddr, int stopAddr);
int reverseBytesInImage(void);
int rgbAddwith(int sourceWord, int destinationWord);
int rgbDiffwith(int sourceWord, int destinationWord);
int rgbMapfromto(int sourcePixel, int nBitsIn, int nBitsOut);
int rgbMaxwith(int sourceWord, int destinationWord);
int rgbMinwith(int sourceWord, int destinationWord);
int rgbMinInvertwith(int wordToInvert, int destinationWord);
int rgbSubwith(int sourceWord, int destinationWord);
int rightType(int headerWord);
int scanCharacters(void);
int schedulerPointer(void);
int secondExtendedSendBytecode(void);
int sendLiteralSelectorBytecode(void);
int sendSelectorToClass(int classPointer);
int sender(void);
int setInterpreter(int anInterpreter);
int setSizeOfFreeto(int chunk, int byteSize);
int shortConditionalJump(void);
int shortUnconditionalJump(void);
int showDisplayBits(void);
int signExtend16(int int16);
int signalSemaphoreWithIndex(int index);
int singleExtendedSendBytecode(void);
int singleExtendedSuperBytecode(void);
int sizeBitsOf(int oop);
int sizeBitsOfSafe(int oop);
int sizeHeader(int oop);
int sizeOfFree(int oop);
int sizeOfSTArrayFromCPrimitive(void *cPtr);
int smoothPixatXfyfdxhdyhdxvdyvpixPerWordpixelMasksourceMap(int n, int xf, int yf, int dxh, int dyh, int dxv, int dyv, int srcPixPerWord, int sourcePixMask, int sourceMap);
int socketRecordSize(void);
SQSocket * socketValueOf(int socketOop);
int sourcePixAtXypixPerWord(int x, int y, int srcPixPerWord);
int sourceSkewAndPointerInit(void);
int sourceWordwith(int sourceWord, int destinationWord);
int specialSelector(int index);
int splObj(int index);
int stObjectat(int array, int index);
int stObjectatput(int array, int index, int value);
int stSizeOf(int oop);
int stackIntegerValue(int offset);
int stackObjectValue(int offset);
int stackPointerIndex(void);
int stackTop(void);
int stackValue(int offset);
int startField(void);
int startObj(void);
int startOfMemory(void);
int stopReason(void);
int storeAndPopReceiverVariableBytecode(void);
int storeAndPopTemporaryVariableBytecode(void);
int storeByteofObjectwithValue(int byteIndex, int oop, int valueByte);
int storeContextRegisters(int activeCntx);
int storeInstructionPointerValueinContext(int value, int contextPointer);
int storeIntegerofObjectwithValue(int fieldIndex, int objectPointer, int integerValue);
int storePointerofObjectwithValue(int fieldIndex, int oop, int valuePointer);
int storePointerUncheckedofObjectwithValue(int fieldIndex, int oop, int valuePointer);
int storeStackPointerValueinContext(int value, int contextPointer);
int storeWordofObjectwithValue(int fieldIndex, int oop, int valueWord);
int subWordwith(int sourceWord, int destinationWord);
int subscriptwithformat(int array, int index, int fmt);
int subscriptwithstoringformat(int array, int index, int oopToStore, int fmt);
int success(int successValue);
int sufficientSpaceAfterGC(int minFree);
int sufficientSpaceToAllocate(int bytes);
int sufficientSpaceToInstantiateindexableSize(int classOop, int size);
int superclassOf(int classPointer);
int superclassSend(void);
int sweepPhase(void);
int synchronousSignal(int aSemaphore);
int tallyIntoMapwith(int sourceWord, int destinationWord);
int targetForm(void);
int temporary(int offset);
int transferfromIndexofObjecttoIndexofObject(int count, int firstFrom, int fromOop, int firstTo, int toOop);
int transferTo(int newProc);
int unPop(int nItems);
int unknownBytecode(void);
int upward(void);
int wakeHighestPriority(void);
int warpBits(void);
int warpLoop(void);
int warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(int nPix, int xDeltah, int yDeltah, int xDeltav, int yDeltav, int n, int sourceMapOop);
int writeImageFile(int imageBytes);

int OLDrgbDiffwith(int sourceWord, int destinationWord) {
    int diff;
    int pixMask;

	/* inline: false */;
	if (destPixSize < 16) {
		diff = sourceWord ^ destinationWord;
		pixMask = (((destPixSize < 0) ? ((unsigned) 1 >> -destPixSize) : ((unsigned) 1 << destPixSize))) - 1;
		while (!(diff == 0)) {
			if ((diff & pixMask) != 0) {
				bitCount += 1;
			}
			diff = ((unsigned) diff) >> destPixSize;
		}
		return destinationWord;
	}
	if (destPixSize == 16) {
		diff = partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 5, 3);
		bitCount = ((bitCount + (diff & 31)) + ((((unsigned) diff) >> 5) & 31)) + ((((unsigned) diff) >> 10) & 31);
		diff = partitionedSubfromnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3);
		bitCount = ((bitCount + (diff & 31)) + ((((unsigned) diff) >> 5) & 31)) + ((((unsigned) diff) >> 10) & 31);
	} else {
		diff = partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 8, 3);
		bitCount = ((bitCount + (diff & 255)) + ((((unsigned) diff) >> 8) & 255)) + ((((unsigned) diff) >> 16) & 255);
	}
	return destinationWord;
}

int OLDtallyIntoMapwith(int sourceWord, int destinationWord) {
    int mapIndex;
    int pixMask;
    int shiftWord;
    int i;

	if (colorMap == (nilObject())) {
		return destinationWord;
	}
	if (destPixSize < 16) {
		pixMask = (1 << destPixSize) - 1;
		shiftWord = destinationWord;
		for (i = 1; i <= pixPerWord; i += 1) {
			mapIndex = shiftWord & pixMask;
			storeWordofObjectwithValue(mapIndex, colorMap, (fetchWordofObject(mapIndex, colorMap)) + 1);
			shiftWord = ((unsigned) shiftWord) >> destPixSize;
		}
		return destinationWord;
	}
	if (destPixSize == 16) {
		mapIndex = rgbMapfromto(destinationWord & 65535, 5, cmBitsPerColor);
		storeWordofObjectwithValue(mapIndex, colorMap, (fetchWordofObject(mapIndex, colorMap)) + 1);
		mapIndex = rgbMapfromto(((unsigned) destinationWord) >> 16, 5, cmBitsPerColor);
		storeWordofObjectwithValue(mapIndex, colorMap, (fetchWordofObject(mapIndex, colorMap)) + 1);
	} else {
		mapIndex = rgbMapfromto(destinationWord, 8, cmBitsPerColor);
		storeWordofObjectwithValue(mapIndex, colorMap, (fetchWordofObject(mapIndex, colorMap)) + 1);
	}
	return destinationWord;
}

int aComment(void) {
}

int accessibleObjectAfter(int oop) {
    int obj;

	/* inline: false */;
	obj = objectAfter(oop);
	while (obj < endOfMemory) {
		if (!(isFreeObject(obj))) {
			return obj;
		}
		obj = objectAfter(obj);
	}
	return null;
}

int activateNewMethod(void) {
    int methodHeader;
    int smallContext;
    char * toIndex;
    int nilOop;
    int tempCount;
    int newContext;
    int initialIP;
    char * fromIndex;
    char * lastIndex;

	/* inline: false */;
	methodHeader = headerOf(newMethod);
	smallContext = ((((unsigned) methodHeader) >> 18) & 1) == 0;
	newContext = allocateOrRecycleContext(smallContext);
	initialIP = ((1 + (literalCountOfHeader(methodHeader))) * 4) + 1;
	tempCount = (((unsigned) methodHeader) >> 19) & 63;
	storePointerUncheckedofObjectwithValue(0, newContext, activeContext);
	storeWordofObjectwithValue(1, newContext, ((initialIP << 1) | 1));
	storeWordofObjectwithValue(2, newContext, ((tempCount << 1) | 1));
	storePointerUncheckedofObjectwithValue(3, newContext, newMethod);
	fromIndex = (((char *) activeContext)) + (((stackPointerIndex()) - argumentCount) * 4);
	toIndex = (((char *) newContext)) + (5 * 4);
	lastIndex = fromIndex + ((argumentCount + 1) * 4);
	while (fromIndex < lastIndex) {
		fromIndex += 4;
		toIndex += 4;
		longAtput(toIndex, longAt(fromIndex));
	}
	nilOop = nilObj;
	if (smallContext) {
		lastIndex = ((((char *) newContext)) + 76) - 4;
	} else {
		lastIndex = ((((char *) newContext)) + 156) - 4;
	}
	while (toIndex < lastIndex) {
		toIndex += 4;
		longAtput(toIndex, nilOop);
	}
	pop(argumentCount + 1);
	reclaimableContextCount += 1;
	newActiveContext(newContext);
}

int addLastLinktoList(int proc, int aList) {
    int lastLink;

	if (isEmptyList(aList)) {
		storePointerofObjectwithValue(0, aList, proc);
	} else {
		lastLink = fetchPointerofObject(1, aList);
		storePointerofObjectwithValue(0, lastLink, proc);
	}
	storePointerofObjectwithValue(1, aList, proc);
	storePointerofObjectwithValue(3, proc, aList);
}

int addToMethodCacheSelclassmethodprimIndex(int selector, int class, int meth, int primIndex) {
    int probe;

	/* inline: false */;
	mcProbe = (mcProbe + 1) % 3;
	probe = ((((unsigned) (selector ^ class)) >> (mcProbe + 2)) & 511) + 1;
	methodCache[probe] = selector;
	methodCache[probe + 512] = class;
	methodCache[probe + (512 * 2)] = meth;
	methodCache[probe + (512 * 3)] = primIndex;
}

int addWordwith(int sourceWord, int destinationWord) {
	return sourceWord + destinationWord;
}

int adjustAllOopsBy(int bytesToShift) {
    int oop;
    int last;

	if (bytesToShift == 0) {
		return null;
	}
	oop = firstObject();
	while (oop < endOfMemory) {
		if (!(isFreeObject(oop))) {
			adjustFieldsAndClassOfby(oop, bytesToShift);
		}
		last = oop;
		oop = objectAfter(oop);
	}
}

int adjustFieldsAndClassOfby(int oop, int offsetBytes) {
    int newClassOop;
    int fieldAddr;
    int fieldOop;
    int classHeader;

	fieldAddr = oop + (lastPointerOf(oop));
	while (fieldAddr > oop) {
		fieldOop = longAt(fieldAddr);
		if (!((fieldOop & 1))) {
			longAtput(fieldAddr, fieldOop + offsetBytes);
		}
		fieldAddr -= 4;
	}
	if ((headerType(oop)) != 3) {
		classHeader = longAt(oop - 4);
		newClassOop = (classHeader & 4294967292U) + offsetBytes;
		longAtput(oop - 4, newClassOop | (classHeader & 3));
	}
}

int affectedBottom(void) {
	return affectedB;
}

int affectedLeft(void) {
	return affectedL;
}

int affectedRight(void) {
	return affectedR;
}

int affectedTop(void) {
	return affectedT;
}

int allAccessibleObjectsOkay(void) {
    int oop;

	oop = firstAccessibleObject();
	while (!(oop == null)) {
		okayFields(oop);
		oop = accessibleObjectAfter(oop);
	}
}

int allYoungand(int array1, int array2) {
    int fieldOffset;

	if (array1 < youngStart) {
		return false;
	}
	if (array2 < youngStart) {
		return false;
	}
	fieldOffset = lastPointerOf(array1);
	while (fieldOffset >= 4) {
		if ((longAt(array1 + fieldOffset)) < youngStart) {
			return false;
		}
		if ((longAt(array2 + fieldOffset)) < youngStart) {
			return false;
		}
		fieldOffset -= 4;
	}
	return true;
}

int allocateheaderSizeh1h2h3fill(int byteSize, int hdrSize, int baseHeader, int classOop, int extendedSize, int fillWord) {
    int i;
    int newObj;
    int remappedClassOop;
    int end;

	/* inline: true */;
	if (hdrSize > 1) {
		pushRemappableOop(classOop);
	}
	newObj = allocateChunk(byteSize + ((hdrSize - 1) * 4));
	if (hdrSize > 1) {
		remappedClassOop = popRemappableOop();
	}
	if (hdrSize == 3) {
		longAtput(newObj, extendedSize | 0);
		longAtput(newObj + 4, remappedClassOop | 0);
		longAtput(newObj + 8, baseHeader | 0);
		newObj += 8;
	}
	if (hdrSize == 2) {
		longAtput(newObj, remappedClassOop | 1);
		longAtput(newObj + 4, baseHeader | 1);
		newObj += 4;
	}
	if (hdrSize == 1) {
		longAtput(newObj, baseHeader | 3);
	}
	end = newObj + byteSize;
	i = newObj + 4;
	while (i < end) {
		longAtput(i, fillWord);
		i += 4;
	}
	if (checkAssertions) {
		okayOop(newObj);
		oopHasOkayClass(newObj);
		if (!((objectAfter(newObj)) == freeBlock)) {
			error("allocate bug: did not set header of new oop correctly");
		}
		if (!((objectAfter(freeBlock)) == endOfMemory)) {
			error("allocate bug: did not set header of freeBlock correctly");
		}
	}
	return newObj;
}

int allocateChunk(int byteSize) {
    int newFreeSize;
    int enoughSpace;
    int newChunk;

	/* inline: true */;
	if (allocationCount >= allocationsBetweenGCs) {
		incrementalGC();
	}
	enoughSpace = sufficientSpaceToAllocate(byteSize);
	if (!(enoughSpace)) {
		signalLowSpace = true;
		lowSpaceThreshold = 0;
		interruptCheckCounter = 0;
	}
	if ((sizeOfFree(freeBlock)) < (byteSize + 4)) {
		error("out of memory");
	}
	newFreeSize = (sizeOfFree(freeBlock)) - byteSize;
	newChunk = freeBlock;
	freeBlock += byteSize;
	setSizeOfFreeto(freeBlock, newFreeSize);
	allocationCount += 1;
	return newChunk;
}

int allocateOrRecycleContext(int smallContextWanted) {
    int cntxt;

	/* inline: true */;
	if (smallContextWanted) {
		if (freeSmallContexts != 1) {
			cntxt = freeSmallContexts;
			freeSmallContexts = fetchPointerofObject(0, cntxt);
		} else {
			cntxt = instantiateSmallClasssizeInBytesfill(splObj(10), 76, nilObj);
		}
	} else {
		if (freeLargeContexts != 1) {
			cntxt = freeLargeContexts;
			freeLargeContexts = fetchPointerofObject(0, cntxt);
		} else {
			cntxt = instantiateSmallClasssizeInBytesfill(splObj(10), 156, nilObj);
		}
	}
	return cntxt;
}

int alphaBlendwith(int sourceWord, int destinationWord) {
    int shift;
    int alpha;
    int i;
    int blend;
    int unAlpha;
    int result;
    int colorMask;

	/* inline: false */;
	alpha = ((unsigned) sourceWord) >> 24;
	unAlpha = 255 - alpha;
	colorMask = 255;
	result = 0;
	for (i = 1; i <= 3; i += 1) {
		shift = (i - 1) * 8;
		blend = ((((((((unsigned) sourceWord) >> shift) & colorMask) * alpha) + (((((unsigned) destinationWord) >> shift) & colorMask) * unAlpha)) + 254) / 255) & colorMask;
		result = result | (blend << shift);
	}
	return result;
}

int alphaBlendConstwith(int sourceWord, int destinationWord) {
	return alphaBlendConstwithpaintMode(sourceWord, destinationWord, false);
}

int alphaBlendConstwithpaintMode(int sourceWord, int destinationWord, int paintMode) {
    int j;
    int destPixVal;
    int pixMask;
    int destShifted;
    int sourceShifted;
    int sourcePixVal;
    int pixBlend;
    int shift;
    int blend;
    int maskShifted;
    int bitsPerColor;
    int i;
    int unAlpha;
    int result;
    int rgbMask;

	/* inline: false */;
	if (destPixSize < 16) {
		return destinationWord;
	}
	unAlpha = 255 - sourceAlpha;
	pixMask = (1 << destPixSize) - 1;
	if (destPixSize == 16) {
		bitsPerColor = 5;
	} else {
		bitsPerColor = 8;
	}
	rgbMask = (1 << bitsPerColor) - 1;
	maskShifted = destMask;
	destShifted = destinationWord;
	sourceShifted = sourceWord;
	result = destinationWord;
	for (j = 1; j <= pixPerWord; j += 1) {
		sourcePixVal = sourceShifted & pixMask;
		if (!(((maskShifted & pixMask) == 0) || (paintMode && (sourcePixVal == 0)))) {
			destPixVal = destShifted & pixMask;
			pixBlend = 0;
			for (i = 1; i <= 3; i += 1) {
				shift = (i - 1) * bitsPerColor;
				blend = ((((((((unsigned) sourcePixVal) >> shift) & rgbMask) * sourceAlpha) + (((((unsigned) destPixVal) >> shift) & rgbMask) * unAlpha)) + 254) / 255) & rgbMask;
				pixBlend = pixBlend | (blend << shift);
			}
			if (destPixSize == 16) {
				result = (result & (~(pixMask << ((j - 1) * 16)))) | (pixBlend << ((j - 1) * 16));
			} else {
				result = pixBlend;
			}
		}
		maskShifted = ((unsigned) maskShifted) >> destPixSize;
		sourceShifted = ((unsigned) sourceShifted) >> destPixSize;
		destShifted = ((unsigned) destShifted) >> destPixSize;
	}
	return result;
}

int alphaPaintConstwith(int sourceWord, int destinationWord) {
	if (sourceWord == 0) {
		return destinationWord;
	}
	return alphaBlendConstwithpaintMode(sourceWord, destinationWord, true);
}

int areIntegersand(int oop1, int oop2) {
	return ((oop1 & oop2) & 1) != 0;
}

int argCount(void) {
	return argumentCount;
}

int argumentCountOf(int methodPointer) {
	return (((unsigned) (headerOf(methodPointer))) >> 25) & 31;
}

int argumentCountOfBlock(int blockPointer) {
    int argCount;

	argCount = fetchPointerofObject(3, blockPointer);
	if ((argCount & 1)) {
		return (argCount >> 1);
	} else {
		primitiveFail();
		return 0;
	}
}

void * arrayValueOf(int arrayOop) {
	if ((!((arrayOop & 1))) && (isWordsOrBytes(arrayOop))) {
		return (void *) (arrayOop + 4);
	}
	primitiveFail();
}

int asciiDirectoryDelimiter(void) {
	return dir_Delimitor();
}

int asciiOfCharacter(int characterObj) {
	/* inline: false */;
	assertClassOfis(characterObj, splObj(19));
	if (successFlag) {
		return fetchPointerofObject(0, characterObj);
	} else {
		return 1;
	}
}

int assertClassOfis(int oop, int classOop) {
    int ccIndex;
    int cl;

	/* inline: true */;
	if ((oop & 1)) {
		successFlag = false;
		return null;
	}
	ccIndex = (((unsigned) (baseHeader(oop))) >> 12) & 31;
	if (ccIndex == 0) {
		cl = (classHeader(oop)) & 4294967292U;
	} else {
		cl = fetchPointerofObject(ccIndex - 1, fetchPointerofObject(28, specialObjectsOop));
	}
	success(cl == classOop);
}

int assertFloatand(int oop1, int oop2) {
    int floatClass;

	if (((oop1 | oop2) & 1) != 0) {
		successFlag = false;
	} else {
		floatClass = splObj(9);
		assertClassOfis(oop1, floatClass);
		assertClassOfis(oop2, floatClass);
	}
}

AsyncFile * asyncFileValueOf(int oop) {
	success((!((oop & 1))) && ((isBytes(oop)) && ((lengthOf(oop)) == (sizeof(AsyncFile)))));
	if (!(successFlag)) {
		return null;
	}
	return (AsyncFile *) (oop + 4);
}

int baseHeader(int oop) {
	return longAt(oop);
}

int beRootIfOld(int oop) {
    int header;

	/* inline: false */;
	if ((oop < youngStart) && (!((oop & 1)))) {
		header = longAt(oop);
		if ((header & 1073741824) == 0) {
			if (rootTableCount < 1000) {
				rootTableCount += 1;
				rootTable[rootTableCount] = oop;
				longAtput(oop, header | 1073741824);
			}
		}
	}
}

int beRootWhileForwarding(int oop) {
    int fwdBlock;
    int forwarding;
    int header;
    int newHeader;

	header = longAt(oop);
	if ((header & 2147483648U) != 0) {
		forwarding = true;
		fwdBlock = header & 2147483644;
		if (checkAssertions) {
			fwdBlockValidate(fwdBlock);
		}
		header = longAt(fwdBlock + 4);
	} else {
		forwarding = false;
	}
	if ((header & 1073741824) == 0) {
		if (rootTableCount < 1000) {
			rootTableCount += 1;
			rootTable[rootTableCount] = oop;
			newHeader = header | 1073741824;
			if (forwarding) {
				longAtput(fwdBlock + 4, newHeader);
			} else {
				longAtput(oop, newHeader);
			}
		}
	}
}

int becomewith(int array1, int array2) {
	if (!((fetchClassOf(array1)) == (splObj(7)))) {
		return false;
	}
	if (!((fetchClassOf(array2)) == (splObj(7)))) {
		return false;
	}
	if (!((lastPointerOf(array1)) == (lastPointerOf(array2)))) {
		return false;
	}
	if (!(containOnlyOopsand(array1, array2))) {
		return false;
	}
	if (!(prepareForwardingTableForBecomingwith(array1, array2))) {
		return false;
	}
	if (allYoungand(array1, array2)) {
		mapPointersInObjectsFromto(youngStart, endOfMemory);
	} else {
		mapPointersInObjectsFromto(startOfMemory(), endOfMemory);
	}
	restoreHeadersAfterBecomingwith(array1, array2);
	initializeMemoryFirstFree(freeBlock);
	return true;
}

int bitAndwith(int sourceWord, int destinationWord) {
	return sourceWord & destinationWord;
}

int bitAndInvertwith(int sourceWord, int destinationWord) {
	return sourceWord & (~destinationWord);
}

int bitInvertAndwith(int sourceWord, int destinationWord) {
	return (~sourceWord) & destinationWord;
}

int bitInvertAndInvertwith(int sourceWord, int destinationWord) {
	return (~sourceWord) & (~destinationWord);
}

int bitInvertDestinationwith(int sourceWord, int destinationWord) {
	return ~destinationWord;
}

int bitInvertOrwith(int sourceWord, int destinationWord) {
	return (~sourceWord) | destinationWord;
}

int bitInvertOrInvertwith(int sourceWord, int destinationWord) {
	return (~sourceWord) | (~destinationWord);
}

int bitInvertSourcewith(int sourceWord, int destinationWord) {
	return ~sourceWord;
}

int bitInvertXorwith(int sourceWord, int destinationWord) {
	return (~sourceWord) ^ destinationWord;
}

int bitOrwith(int sourceWord, int destinationWord) {
	return sourceWord | destinationWord;
}

int bitOrInvertwith(int sourceWord, int destinationWord) {
	return sourceWord | (~destinationWord);
}

int bitXorwith(int sourceWord, int destinationWord) {
	return sourceWord ^ destinationWord;
}

int booleanCheat(int cond) {
    int bytecode;
    int offset;

	/* inline: true */;
	bytecode = fetchByte();
	internalPop(2);
	if ((bytecode < 160) && (bytecode > 151)) {
		if (cond) {
			return null;
		} else {
			return jump(bytecode - 151);
		}
	}
	if (bytecode == 172) {
		offset = fetchByte();
		if (cond) {
			return null;
		} else {
			return jump(offset);
		}
	}
	localIP -= 1;
	if (cond) {
		internalPush(trueObj);
	} else {
		internalPush(falseObj);
	}
}

int booleanValueOf(int obj) {
	if (obj == trueObj) {
		return true;
	}
	if (obj == falseObj) {
		return false;
	}
	successFlag = false;
	return null;
}

int byteLengthOf(int oop) {
    int sz;
    int header;
    int fmt;

	header = baseHeader(oop);
	if ((header & 3) == 0) {
		sz = (sizeHeader(oop)) & 4294967292U;
	} else {
		sz = header & 252;
	}
	fmt = (((unsigned) header) >> 8) & 15;
	if (fmt < 8) {
		return sz - 4;
	} else {
		return (sz - 4) - (fmt & 3);
	}
}

int byteSwapByteObjects(void) {
    int methodHeader;
    int wordAddr;
    int oop;
    int fmt;

	oop = firstObject();
	while (oop < endOfMemory) {
		if (!(isFreeObject(oop))) {
			fmt = formatOf(oop);
			if (fmt >= 8) {
				wordAddr = oop + 4;
				if (fmt >= 12) {
					methodHeader = longAt(oop + 4);
					wordAddr = (wordAddr + 4) + (((((unsigned) methodHeader) >> 10) & 255) * 4);
				}
				reverseBytesFromto(wordAddr, oop + (sizeBitsOf(oop)));
			}
		}
		oop = objectAfter(oop);
	}
}

int byteSwapped(int w) {
	return ((((((unsigned) w >> 24)) & 255) + ((((unsigned) w >> 8)) & 65280)) + ((((unsigned) w << 8)) & 16711680)) + ((((unsigned) w << 24)) & 4278190080U);
}

int bytecodePrimAdd(void) {
    int arg;
    int result;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		result = ((rcvr >> 1)) + ((arg >> 1));
		if (isIntegerValue(result)) {
			longAtput(localSP -= 4, ((result << 1) | 1));
			return null;
		}
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatAdd();
	if (!(successFlag)) {
		successFlag = true;
		primitiveAdd();
	}
	internalizeIPandSP();
}

int bytecodePrimAt(void) {
    int stringy;
    int index;
    int result;
    int rcvr;
    int rcvrClass;

	index = internalStackTop();
	rcvr = internalStackValue(1);
	successFlag = (index & 1);
	if (successFlag) {
		rcvrClass = fetchClassOf(rcvr);
		stringy = rcvrClass == (splObj(6));
		if (!(stringy || (okArrayClass(rcvrClass)))) {
			successFlag = false;
		}
	}
	if (successFlag) {
		index = (index >> 1);
		externalizeIPandSP();
		result = stObjectat(rcvr, index);
		internalizeIPandSP();
		if (stringy && (successFlag)) {
			result = characterForAscii(result);
		}
	}
	if (successFlag) {
		internalPopthenPush(2, result);
	} else {
		messageSelector = specialSelector(16);
		argumentCount = 1;
		normalSend();
	}
}

int bytecodePrimAtEnd(void) {
	messageSelector = specialSelector(21);
	argumentCount = 0;
	normalSend();
}

int bytecodePrimAtPut(void) {
    int stringy;
    int value;
    int valToStore;
    int index;
    int rcvr;
    int rcvrClass;

	value = valToStore = internalStackTop();
	index = internalStackValue(1);
	rcvr = internalStackValue(2);
	successFlag = (index & 1);
	if (successFlag) {
		rcvrClass = fetchClassOf(rcvr);
		stringy = rcvrClass == (splObj(6));
		if (!(stringy || (okArrayClass(rcvrClass)))) {
			successFlag = false;
		}
	}
	if (successFlag) {
		index = (index >> 1);
		if (stringy) {
			valToStore = asciiOfCharacter(value);
		}
		stObjectatput(rcvr, index, valToStore);
	}
	if (successFlag) {
		internalPopthenPush(3, value);
	} else {
		messageSelector = specialSelector(17);
		argumentCount = 2;
		normalSend();
	}
}

int bytecodePrimBitAnd(void) {
	externalizeIPandSP();
	primitiveBitAnd();
	internalizeIPandSP();
}

int bytecodePrimBitOr(void) {
	externalizeIPandSP();
	primitiveBitOr();
	internalizeIPandSP();
}

int bytecodePrimBitShift(void) {
	externalizeIPandSP();
	primitiveBitShift();
	internalizeIPandSP();
}

int bytecodePrimBlockCopy(void) {
    int rcvrClass;

	rcvrClass = fetchClassOf(internalStackValue(1));
	successFlag = true;
	success((rcvrClass == (splObj(11))) || (rcvrClass == (splObj(10))));
	if (successFlag) {
		externalizeIPandSP();
		primitiveBlockCopy();
		internalizeIPandSP();
	}
	if (!(successFlag)) {
		messageSelector = specialSelector(24);
		argumentCount = 1;
		return normalSend();
	}
}

int bytecodePrimClass(void) {
	externalizeIPandSP();
	primitiveClass();
	internalizeIPandSP();
}

int bytecodePrimDiv(void) {
	externalizeIPandSP();
	primitiveDiv();
	internalizeIPandSP();
}

int bytecodePrimDivide(void) {
    int arg;
    int result;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		rcvr = (rcvr >> 1);
		arg = (arg >> 1);
		if ((arg != 0) && ((rcvr % arg) == 0)) {
			result = rcvr / arg;
			if (isIntegerValue(result)) {
				longAtput(localSP -= 4, ((result << 1) | 1));
				return null;
			}
		}
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatDivide();
	if (!(successFlag)) {
		successFlag = true;
		primitiveDivide();
	}
	internalizeIPandSP();
}

int bytecodePrimDo(void) {
	messageSelector = specialSelector(27);
	argumentCount = 1;
	normalSend();
}

int bytecodePrimEqual(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		return booleanCheat(rcvr == arg);
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatEqual();
	if (!(successFlag)) {
		successFlag = true;
		primitiveEqual();
	}
	internalizeIPandSP();
}

int bytecodePrimEquivalent(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	booleanCheat(rcvr == arg);
}

int bytecodePrimGreaterOrEqual(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		return booleanCheat(rcvr >= arg);
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatGreaterOrEqual();
	if (!(successFlag)) {
		successFlag = true;
		primitiveGreaterOrEqual();
	}
	internalizeIPandSP();
}

int bytecodePrimGreaterThan(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		return booleanCheat(rcvr > arg);
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatGreaterThan();
	if (!(successFlag)) {
		successFlag = true;
		primitiveGreaterThan();
	}
	internalizeIPandSP();
}

int bytecodePrimLessOrEqual(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		return booleanCheat(rcvr <= arg);
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatLessOrEqual();
	if (!(successFlag)) {
		successFlag = true;
		primitiveLessOrEqual();
	}
	internalizeIPandSP();
}

int bytecodePrimLessThan(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		return booleanCheat(rcvr < arg);
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatLessThan();
	if (!(successFlag)) {
		successFlag = true;
		primitiveLessThan();
	}
	internalizeIPandSP();
}

int bytecodePrimMakePoint(void) {
	externalizeIPandSP();
	primitiveMakePoint();
	internalizeIPandSP();
}

int bytecodePrimMod(void) {
	externalizeIPandSP();
	primitiveMod();
	internalizeIPandSP();
}

int bytecodePrimMultiply(void) {
    int arg;
    int result;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		rcvr = (rcvr >> 1);
		arg = (arg >> 1);
		result = rcvr * arg;
		if (((arg == 0) || ((result / arg) == rcvr)) && (isIntegerValue(result))) {
			longAtput(localSP -= 4, ((result << 1) | 1));
			return null;
		}
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatMultiply();
	if (!(successFlag)) {
		successFlag = true;
		primitiveMultiply();
	}
	internalizeIPandSP();
}

int bytecodePrimNew(void) {
	messageSelector = specialSelector(28);
	argumentCount = 0;
	normalSend();
}

int bytecodePrimNewWithArg(void) {
	messageSelector = specialSelector(29);
	argumentCount = 1;
	normalSend();
}

int bytecodePrimNext(void) {
	messageSelector = specialSelector(19);
	argumentCount = 0;
	normalSend();
}

int bytecodePrimNextPut(void) {
	messageSelector = specialSelector(20);
	argumentCount = 1;
	normalSend();
}

int bytecodePrimNotEqual(void) {
    int arg;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		return booleanCheat(rcvr != arg);
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatNotEqual();
	if (!(successFlag)) {
		successFlag = true;
		primitiveNotEqual();
	}
	internalizeIPandSP();
}

int bytecodePrimPointX(void) {
	externalizeIPandSP();
	primitivePointX();
	internalizeIPandSP();
}

int bytecodePrimPointY(void) {
	externalizeIPandSP();
	primitivePointY();
	internalizeIPandSP();
}

int bytecodePrimSize(void) {
    int arrayClass;

	externalizeIPandSP();
	successFlag = true;
	arrayClass = fetchClassOf(stackValue(0));
	if (okStreamArrayClass(arrayClass)) {
		primitiveSize();
	} else {
		failSpecialPrim(0);
	}
	internalizeIPandSP();
}

int bytecodePrimSubtract(void) {
    int arg;
    int result;
    int rcvr;

	rcvr = internalStackValue(1);
	arg = internalStackValue(0);
	if (areIntegersand(rcvr, arg)) {
		result = ((rcvr >> 1)) - ((arg >> 1));
		if (isIntegerValue(result)) {
			longAtput(localSP -= 4, ((result << 1) | 1));
			return null;
		}
	}
	externalizeIPandSP();
	successFlag = true;
	primitiveFloatSubtract();
	if (!(successFlag)) {
		successFlag = true;
		primitiveSubtract();
	}
	internalizeIPandSP();
}

int bytecodePrimValue(void) {
    int block;

	block = internalStackTop();
	successFlag = true;
	argumentCount = 0;
	assertClassOfis(block, splObj(11));
	if (successFlag) {
		externalizeIPandSP();
		primitiveValue();
		internalizeIPandSP();
	}
	if (!(successFlag)) {
		messageSelector = specialSelector(25);
		argumentCount = 0;
		return normalSend();
	}
}

int bytecodePrimValueWithArg(void) {
    int block;

	block = internalStackValue(1);
	successFlag = true;
	argumentCount = 1;
	assertClassOfis(block, splObj(11));
	if (successFlag) {
		externalizeIPandSP();
		primitiveValue();
		internalizeIPandSP();
	}
	if (!(successFlag)) {
		messageSelector = specialSelector(26);
		argumentCount = 1;
		return normalSend();
	}
}

int caller(void) {
	return fetchPointerofObject(0, activeContext);
}

int characterForAscii(int integerObj) {
	return fetchPointerofObject((integerObj >> 1), splObj(24));
}

int checkAddress(int byteAddress) {
	if (byteAddress < (startOfMemory())) {
		error("bad address: negative");
	}
	if (byteAddress >= memoryLimit) {
		error("bad address: past end of heap");
	}
}

int checkBooleanResultfrom(int result, int primIndex) {
	if (successFlag) {
		pushBool(result);
	} else {
		unPop(2);
		failSpecialPrim(primIndex);
	}
}

int checkForInterrupts(void) {
    int sema;
    int semaClass;
    int i;
    int now;
    int externalObjects;
    int index;

	/* inline: false */;
	interruptCheckCounter = 1000;
	now = (ioMSecs()) & 536870911;
	if (now < lastTick) {
		nextPollTick = now + (nextPollTick - lastTick);
		if (nextWakeupTick != 0) {
			nextWakeupTick = now + (nextWakeupTick - lastTick);
		}
	}
	lastTick = now;
	if (signalLowSpace) {
		signalLowSpace = false;
		sema = splObj(17);
		if (!(sema == nilObj)) {
			synchronousSignal(sema);
		}
	}
	if (now >= nextPollTick) {
		ioProcessEvents();
		nextPollTick = now + 500;
	}
	if (interruptPending) {
		interruptPending = false;
		sema = splObj(30);
		if (!(sema == nilObj)) {
			synchronousSignal(sema);
		}
	}
	if ((nextWakeupTick != 0) && (now >= nextWakeupTick)) {
		nextWakeupTick = 0;
		sema = splObj(29);
		if (!(sema == nilObj)) {
			synchronousSignal(sema);
		}
	}
	if (semaphoresToSignalCount > 0) {
		externalObjects = splObj(38);
		semaClass = splObj(18);
		for (i = 1; i <= semaphoresToSignalCount; i += 1) {
			index = semaphoresToSignal[i];
			sema = fetchPointerofObject(index - 1, externalObjects);
			if ((fetchClassOf(sema)) == semaClass) {
				synchronousSignal(sema);
			}
		}
		semaphoresToSignalCount = 0;
	}
}

int checkImageVersionFrom(sqImageFile f) {
    int version;
    int expectedVersion;
    int firstVersion;

	expectedVersion = imageFormatVersion();
	sqImageFileSeek(f, 0);
	version = firstVersion = getLongFromFileswap(f, false);
	if (version == expectedVersion) {
		return false;
	}
	sqImageFileSeek(f, 0);
	version = getLongFromFileswap(f, true);
	if (version == expectedVersion) {
		return true;
	}
	sqImageFileSeek(f, 512);
	version = getLongFromFileswap(f, false);
	if (version == expectedVersion) {
		return false;
	}
	sqImageFileSeek(f, 512);
	version = getLongFromFileswap(f, true);
	if (version == expectedVersion) {
		return true;
	}
	print("This interpreter (vers. ");
	printNum(expectedVersion);
	print(" cannot read image file (vers. ");
	printNum(firstVersion);
	cr();
	ioExit();
}

int checkIntegerResultfrom(int integerResult, int primIndex) {
	if (successFlag && (isIntegerValue(integerResult))) {
		pushInteger(integerResult);
	} else {
		unPop(2);
		failSpecialPrim(primIndex);
	}
}

int checkSourceOverlap(void) {
    int t;

	if ((sourceForm == destForm) && (dy >= sy)) {
		if (dy > sy) {
			vDir = -1;
			sy = (sy + bbH) - 1;
			dy = (dy + bbH) - 1;
		} else {
			if ((dy == sy) && (dx > sx)) {
				hDir = -1;
				sx = (sx + bbW) - 1;
				dx = (dx + bbW) - 1;
				if (nWords > 1) {
					t = mask1;
					mask1 = mask2;
					mask2 = t;
				}
			}
		}
		destIndex = (destBits + 4) + (((dy * destRaster) + (dx / pixPerWord)) * 4);
		destDelta = 4 * ((destRaster * vDir) - (nWords * hDir));
	}
}

int checkedByteAt(int byteAddress) {
	checkAddress(byteAddress);
	return byteAt(byteAddress);
}

int checkedByteAtput(int byteAddress, int byte) {
	checkAddress(byteAddress);
	byteAtput(byteAddress, byte);
}

int checkedIntegerValueOf(int intOop) {
	if ((intOop & 1)) {
		return (intOop >> 1);
	} else {
		primitiveFail();
		return 0;
	}
}

int checkedLongAt(int byteAddress) {
	checkAddress(byteAddress);
	checkAddress(byteAddress + 3);
	return longAt(byteAddress);
}

int checkedLongAtput(int byteAddress, int a32BitInteger) {
	checkAddress(byteAddress);
	checkAddress(byteAddress + 3);
	longAtput(byteAddress, a32BitInteger);
}

int chunkFromOop(int oop) {
    int extra;

	extra = extraHeaderBytes(oop);
	return oop - extra;
}

int classHeader(int oop) {
	return longAt(oop - 4);
}

int clearRootsTable(void) {
    int oop;
    int i;

	for (i = 1; i <= rootTableCount; i += 1) {
		oop = rootTable[i];
		longAtput(oop, (longAt(oop)) & 3221225471U);
		rootTable[i] = 0;
	}
	rootTableCount = 0;
}

int clearWordwith(int source, int destination) {
	return 0;
}

int clipRange(void) {
	if (destX >= clipX) {
		sx = sourceX;
		dx = destX;
		bbW = width;
	} else {
		sx = sourceX + (clipX - destX);
		bbW = width - (clipX - destX);
		dx = clipX;
	}
	if ((dx + bbW) > (clipX + clipWidth)) {
		bbW -= (dx + bbW) - (clipX + clipWidth);
	}
	if (destY >= clipY) {
		sy = sourceY;
		dy = destY;
		bbH = height;
	} else {
		sy = (sourceY + clipY) - destY;
		bbH = height - (clipY - destY);
		dy = clipY;
	}
	if ((dy + bbH) > (clipY + clipHeight)) {
		bbH -= (dy + bbH) - (clipY + clipHeight);
	}
	if (noSource) {
		return null;
	}
	if (sx < 0) {
		dx -= sx;
		bbW += sx;
		sx = 0;
	}
	if ((sx + bbW) > srcWidth) {
		bbW -= (sx + bbW) - srcWidth;
	}
	if (sy < 0) {
		dy -= sy;
		bbH += sy;
		sy = 0;
	}
	if ((sy + bbH) > srcHeight) {
		bbH -= (sy + bbH) - srcHeight;
	}
}

int clone(int oop) {
    int newOop;
    int header;
    int hash;
    int fromIndex;
    int lastFrom;
    int extraHdrBytes;
    int bytes;
    int remappedOop;
    int newChunk;
    int toIndex;

	/* inline: false */;
	extraHdrBytes = extraHeaderBytes(oop);
	bytes = sizeBitsOf(oop);
	bytes += extraHdrBytes;
	pushRemappableOop(oop);
	newChunk = allocateChunk(bytes);
	remappedOop = popRemappableOop();
	toIndex = newChunk - 4;
	fromIndex = (remappedOop - extraHdrBytes) - 4;
	lastFrom = fromIndex + bytes;
	while (fromIndex < lastFrom) {
		longAtput(toIndex += 4, longAt(fromIndex += 4));
	}
	newOop = newChunk + extraHdrBytes;
	hash = newObjectHash();
	header = (longAt(newOop)) & 131071;
	header = header | ((hash << 17) & 536739840);
	longAtput(newOop, header);
	return newOop;
}

int commonAt(int stringy) {
    int index;
    int result;
    int rcvr;

	/* inline: true */;
	index = stackTop();
	rcvr = stackValue(1);
	if (((index & 1)) && (!((rcvr & 1)))) {
		index = (index >> 1);
		result = stObjectat(rcvr, index);
		if (stringy && (successFlag)) {
			result = characterForAscii(result);
		}
	} else {
		successFlag = false;
	}
	if (successFlag) {
		popthenPush(2, result);
	} else {
		if (stringy) {
			failSpecialPrim(63);
		} else {
			failSpecialPrim(60);
		}
	}
}

int commonAtPut(int stringy) {
    int value;
    int valToStore;
    int index;
    int rcvr;

	/* inline: true */;
	value = valToStore = stackTop();
	index = stackValue(1);
	rcvr = stackValue(2);
	if (((index & 1)) && (!((rcvr & 1)))) {
		index = (index >> 1);
		if (stringy) {
			valToStore = asciiOfCharacter(value);
		}
		stObjectatput(rcvr, index, valToStore);
	} else {
		successFlag = false;
	}
	if (successFlag) {
		popthenPush(3, value);
	} else {
		if (stringy) {
			failSpecialPrim(64);
		} else {
			failSpecialPrim(61);
		}
	}
}

int compare31or32Bitsequal(int obj1, int obj2) {
	if (((obj1 & 1)) && ((obj2 & 1))) {
		return obj1 == obj2;
	}
	return (positive32BitValueOf(obj1)) == (positive32BitValueOf(obj2));
}

int containOnlyOopsand(int array1, int array2) {
    int fieldOffset;

	fieldOffset = lastPointerOf(array1);
	while (fieldOffset >= 4) {
		if (((longAt(array1 + fieldOffset)) & 1)) {
			return false;
		}
		if (((longAt(array2 + fieldOffset)) & 1)) {
			return false;
		}
		fieldOffset -= 4;
	}
	return true;
}

int copyBits(void) {
	clipRange();
	if ((bbW <= 0) || (bbH <= 0)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		return null;
	}
	destMaskAndPointerInit();
	bitCount = 0;
	if ((combinationRule == 30) || (combinationRule == 31)) {
		if ((argCount()) == 1) {
			sourceAlpha = stackIntegerValue(0);
			if ((!(failed())) && ((sourceAlpha >= 0) && (sourceAlpha <= 255))) {
				pop(1);
			} else {
				return primitiveFail();
			}
		} else {
			return primitiveFail();
		}
	}
	if (noSource) {
		copyLoopNoSource();
	} else {
		checkSourceOverlap();
		if ((sourcePixSize != destPixSize) || (colorMap != (nilObject()))) {
			copyLoopPixMap();
		} else {
			sourceSkewAndPointerInit();
			copyLoop();
		}
	}
	if ((combinationRule == 22) || (combinationRule == 32)) {
		affectedL = affectedR = affectedT = affectedB = 0;
		pop(1);
		return pushInteger(bitCount);
	}
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
}

int copyLoop(void) {
    int y;
    int prevWord;
    int skewWord;
    int mergeWord;
    int skewMask;
    int (*mergeFnwith)(int, int);
    int hInc;
    int i;
    int thisWord;
    int word;
    int halftoneWord;
    int notSkewMask;
    int unskew;

	/* inline: false */;
	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	hInc = hDir * 4;
	if (skew == -32) {
		skew = unskew = skewMask = 0;
	} else {
		if (skew < 0) {
			unskew = skew + 32;
			skewMask = 4294967295U << (0 - skew);
		} else {
			if (skew == 0) {
				unskew = 0;
				skewMask = 4294967295U;
			} else {
				unskew = skew - 32;
				skewMask = ((unsigned) 4294967295U) >> skew;
			}
		}
	}
	notSkewMask = ~skewMask;
	if (noHalftone) {
		halftoneWord = 4294967295U;
		halftoneHeight = 0;
	} else {
		halftoneWord = longAt(halftoneBase);
	}
	y = dy;
	for (i = 1; i <= bbH; i += 1) {
		if (halftoneHeight > 1) {
			halftoneWord = longAt(halftoneBase + ((y % halftoneHeight) * 4));
			y += vDir;
		}
		if (preload) {
			prevWord = longAt(sourceIndex);
			sourceIndex += hInc;
		} else {
			prevWord = 0;
		}
		destMask = mask1;
		thisWord = longAt(sourceIndex);
		sourceIndex += hInc;
		skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
		prevWord = thisWord;
		mergeWord = mergeFnwith(skewWord & halftoneWord, longAt(destIndex));
		longAtput(destIndex, (destMask & mergeWord) | ((~destMask) & (longAt(destIndex))));
		destIndex += hInc;
		destMask = 4294967295U;
		if (combinationRule == 3) {
			if (noHalftone && (notSkewMask == 0)) {
				for (word = 2; word <= (nWords - 1); word += 1) {
					thisWord = longAt(sourceIndex);
					sourceIndex += hInc;
					longAtput(destIndex, thisWord);
					destIndex += hInc;
				}
			} else {
				for (word = 2; word <= (nWords - 1); word += 1) {
					thisWord = longAt(sourceIndex);
					sourceIndex += hInc;
					skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
					prevWord = thisWord;
					longAtput(destIndex, skewWord & halftoneWord);
					destIndex += hInc;
				}
			}
		} else {
			for (word = 2; word <= (nWords - 1); word += 1) {
				thisWord = longAt(sourceIndex);
				sourceIndex += hInc;
				skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
				prevWord = thisWord;
				mergeWord = mergeFnwith(skewWord & halftoneWord, longAt(destIndex));
				longAtput(destIndex, mergeWord);
				destIndex += hInc;
			}
		}
		if (nWords > 1) {
			destMask = mask2;
			thisWord = longAt(sourceIndex);
			sourceIndex += hInc;
			skewWord = (((unskew < 0) ? ((unsigned) (prevWord & notSkewMask) >> -unskew) : ((unsigned) (prevWord & notSkewMask) << unskew))) | (((skew < 0) ? ((unsigned) (thisWord & skewMask) >> -skew) : ((unsigned) (thisWord & skewMask) << skew)));
			mergeWord = mergeFnwith(skewWord & halftoneWord, longAt(destIndex));
			longAtput(destIndex, (destMask & mergeWord) | ((~destMask) & (longAt(destIndex))));
			destIndex += hInc;
		}
		sourceIndex += sourceDelta;
		destIndex += destDelta;
	}
}

int copyLoopNoSource(void) {
    int mergeWord;
    int (*mergeFnwith)(int, int);
    int i;
    int word;
    int halftoneWord;

	/* inline: false */;
	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	for (i = 1; i <= bbH; i += 1) {
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}
		destMask = mask1;
		mergeWord = mergeFnwith(halftoneWord, longAt(destIndex));
		longAtput(destIndex, (destMask & mergeWord) | ((~destMask) & (longAt(destIndex))));
		destIndex += 4;
		destMask = 4294967295U;
		if (combinationRule == 3) {
			for (word = 2; word <= (nWords - 1); word += 1) {
				longAtput(destIndex, halftoneWord);
				destIndex += 4;
			}
		} else {
			for (word = 2; word <= (nWords - 1); word += 1) {
				mergeWord = mergeFnwith(halftoneWord, longAt(destIndex));
				longAtput(destIndex, mergeWord);
				destIndex += 4;
			}
		}
		if (nWords > 1) {
			destMask = mask2;
			mergeWord = mergeFnwith(halftoneWord, longAt(destIndex));
			longAtput(destIndex, (destMask & mergeWord) | ((~destMask) & (longAt(destIndex))));
			destIndex += 4;
		}
		destIndex += destDelta;
	}
}

int copyLoopPixMap(void) {
    int skewWord;
    int mergeWord;
    int srcPixPerWord;
    int scrStartBits;
    int nSourceIncs;
    int startBits;
    int sourcePixMask;
    int destPixMask;
    int nullMap;
    int endBits;
    int (*mergeFnwith)(int, int);
    int halftoneWord;
    int i;
    int word;

	/* inline: false */;
	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	srcPixPerWord = 32 / sourcePixSize;
	if (sourcePixSize == 32) {
		sourcePixMask = -1;
	} else {
		sourcePixMask = (1 << sourcePixSize) - 1;
	}
	if (destPixSize == 32) {
		destPixMask = -1;
	} else {
		destPixMask = (1 << destPixSize) - 1;
	}
	nullMap = colorMap == (nilObject());
	sourceIndex = (sourceBits + 4) + (((sy * sourceRaster) + (sx / srcPixPerWord)) * 4);
	scrStartBits = srcPixPerWord - (sx & (srcPixPerWord - 1));
	if (bbW < scrStartBits) {
		nSourceIncs = 0;
	} else {
		nSourceIncs = ((bbW - scrStartBits) / srcPixPerWord) + 1;
	}
	sourceDelta = (sourceRaster - nSourceIncs) * 4;
	startBits = pixPerWord - (dx & (pixPerWord - 1));
	endBits = (((dx + bbW) - 1) & (pixPerWord - 1)) + 1;
	for (i = 1; i <= bbH; i += 1) {
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}
		srcBitIndex = (sx & (srcPixPerWord - 1)) * sourcePixSize;
		destMask = mask1;
		if (bbW < startBits) {
			skewWord = pickSourcePixelsnullMapsrcMaskdestMask(bbW, nullMap, sourcePixMask, destPixMask);
			skewWord = ((((startBits - bbW) * destPixSize) < 0) ? ((unsigned) skewWord >> -((startBits - bbW) * destPixSize)) : ((unsigned) skewWord << ((startBits - bbW) * destPixSize)));
		} else {
			skewWord = pickSourcePixelsnullMapsrcMaskdestMask(startBits, nullMap, sourcePixMask, destPixMask);
		}
		for (word = 1; word <= nWords; word += 1) {
			mergeWord = mergeFnwith(skewWord & halftoneWord, (longAt(destIndex)) & destMask);
			longAtput(destIndex, (destMask & mergeWord) | ((~destMask) & (longAt(destIndex))));
			destIndex += 4;
			if (word >= (nWords - 1)) {
				if (!(word == nWords)) {
					destMask = mask2;
					skewWord = pickSourcePixelsnullMapsrcMaskdestMask(endBits, nullMap, sourcePixMask, destPixMask);
					skewWord = ((((pixPerWord - endBits) * destPixSize) < 0) ? ((unsigned) skewWord >> -((pixPerWord - endBits) * destPixSize)) : ((unsigned) skewWord << ((pixPerWord - endBits) * destPixSize)));
				}
			} else {
				destMask = 4294967295U;
				skewWord = pickSourcePixelsnullMapsrcMaskdestMask(pixPerWord, nullMap, sourcePixMask, destPixMask);
			}
		}
		sourceIndex += sourceDelta;
		destIndex += destDelta;
	}
}

int cr(void) {
	printf("\n");
}

int createActualMessage(void) {
    int argumentArray;
    int message;

	argumentArray = instantiateClassindexableSize(splObj(7), argumentCount);
	pushRemappableOop(argumentArray);
	message = instantiateClassindexableSize(splObj(15), 0);
	argumentArray = popRemappableOop();
	if (argumentArray < youngStart) {
		beRootIfOld(argumentArray);
	}
	storePointerofObjectwithValue(0, message, messageSelector);
	storePointerofObjectwithValue(1, message, argumentArray);
	transferfromIndexofObjecttoIndexofObject(argumentCount, (stackPointerIndex()) - (argumentCount - 1), activeContext, 0, argumentArray);
	pop(argumentCount);
	push(message);
	argumentCount = 1;
}

int deltaFromtonSteps(int x1, int x2, int n) {
	if (x2 > x1) {
		return (((x2 - x1) + 16384) / (n + 1)) + 1;
	} else {
		if (x2 == x1) {
			return 0;
		}
		return 0 - ((((x1 - x2) + 16384) / (n + 1)) + 1);
	}
}

int destMaskAndPointerInit(void) {
    int startBits;
    int endBits;
    int pixPerM1;

	pixPerM1 = pixPerWord - 1;
	startBits = pixPerWord - (dx & pixPerM1);
	mask1 = ((unsigned) 4294967295U) >> (32 - (startBits * destPixSize));
	endBits = (((dx + bbW) - 1) & pixPerM1) + 1;
	mask2 = 4294967295U << (32 - (endBits * destPixSize));
	if (bbW < startBits) {
		mask1 = mask1 & mask2;
		mask2 = 0;
		nWords = 1;
	} else {
		nWords = (((bbW - startBits) + pixPerM1) / pixPerWord) + 1;
	}
	hDir = vDir = 1;
	destIndex = (destBits + 4) + (((dy * destRaster) + (dx / pixPerWord)) * 4);
	destDelta = 4 * ((destRaster * vDir) - (nWords * hDir));
}

int destinationWordwith(int sourceWord, int destinationWord) {
	return destinationWord;
}

int doubleExtendedDoAnythingBytecode(void) {
    int byte2;
    int byte3;
    int top;
    int opType;

	byte2 = fetchByte();
	byte3 = fetchByte();
	opType = ((unsigned) byte2) >> 5;
	if (opType == 0) {
		messageSelector = literal(byte3);
		argumentCount = byte2 & 31;
		return normalSend();
	}
	if (opType == 1) {
		messageSelector = literal(byte3);
		argumentCount = byte2 & 31;
		return superclassSend();
	}
	if (opType == 2) {
		return pushReceiverVariable(byte3);
	}
	if (opType == 3) {
		return pushLiteralConstant(byte3);
	}
	if (opType == 4) {
		return pushLiteralVariable(byte3);
	}
	if (opType == 5) {
		top = internalStackTop();
		return storePointerofObjectwithValue(byte3, receiver, top);
	}
	if (opType == 6) {
		top = internalStackTop();
		internalPop(1);
		return storePointerofObjectwithValue(byte3, receiver, top);
	}
	if (opType == 7) {
		top = internalStackTop();
		return storePointerofObjectwithValue(1, literal(byte3), top);
	}
}

int drawLoopXY(int xDelta, int yDelta) {
    int affL;
    int dx1;
    int dy1;
    int px;
    int py;
    int affR;
    int affT;
    int affB;
    int i;
    int P;

	if (xDelta > 0) {
		dx1 = 1;
	} else {
		if (xDelta == 0) {
			dx1 = 0;
		} else {
			dx1 = -1;
		}
	}
	if (yDelta > 0) {
		dy1 = 1;
	} else {
		if (yDelta == 0) {
			dy1 = 0;
		} else {
			dy1 = -1;
		}
	}
	px = abs(yDelta);
	py = abs(xDelta);
	affL = affT = 9999;
	affR = affB = -9999;
	if (py > px) {
		P = ((int) py >> 1);
		for (i = 1; i <= py; i += 1) {
			destX += dx1;
			if ((P -= px) < 0) {
				destY += dy1;
				P += py;
			}
			if (i < py) {
				copyBits();
				if ((affectedL < affectedR) && (affectedT < affectedB)) {
					affL = ((affL < affectedL) ? affL : affectedL);
					affR = ((affR < affectedR) ? affectedR : affR);
					affT = ((affT < affectedT) ? affT : affectedT);
					affB = ((affB < affectedB) ? affectedB : affB);
					if (((affR - affL) * (affB - affT)) > 4000) {
						affectedL = affL;
						affectedR = affR;
						affectedT = affT;
						affectedB = affB;
						showDisplayBits();
						affL = affT = 9999;
						affR = affB = -9999;
					}
				}
			}
		}
	} else {
		P = ((int) px >> 1);
		for (i = 1; i <= px; i += 1) {
			destY += dy1;
			if ((P -= py) < 0) {
				destX += dx1;
				P += px;
			}
			if (i < px) {
				copyBits();
				if ((affectedL < affectedR) && (affectedT < affectedB)) {
					affL = ((affL < affectedL) ? affL : affectedL);
					affR = ((affR < affectedR) ? affectedR : affR);
					affT = ((affT < affectedT) ? affT : affectedT);
					affB = ((affB < affectedB) ? affectedB : affB);
					if (((affR - affL) * (affB - affT)) > 4000) {
						affectedL = affL;
						affectedR = affR;
						affectedT = affT;
						affectedB = affB;
						showDisplayBits();
						affL = affT = 9999;
						affR = affB = -9999;
					}
				}
			}
		}
	}
	affectedL = affL;
	affectedR = affR;
	affectedT = affT;
	affectedB = affB;
	storeIntegerofObjectwithValue(4, bitBltOop, destX);
	storeIntegerofObjectwithValue(5, bitBltOop, destY);
}

int duplicateTopBytecode(void) {
	internalPush(internalStackTop());
}

int exchangeHashBitswith(int oop1, int oop2) {
    int hdr1;
    int hdr2;

	hdr1 = longAt(oop1);
	hdr2 = longAt(oop2);
	longAtput(oop1, (hdr1 & 3758227455U) | (hdr2 & 536739840));
	longAtput(oop2, (hdr2 & 3758227455U) | (hdr1 & 536739840));
}

int executeNewMethod(void) {
	if ((primitiveIndex == 0) || (!(primitiveResponse()))) {
		activateNewMethod();
		quickCheckForInterrupts();
	}
}

int experimentalBytecode(void) {
    int arg1Val;
    int arg1;
    int arg2Val;
    int byte2;
    int byte3;
    int byte4;
    int offset;
    int result;

	arg1 = temporary(currentBytecode - 138);
	byte2 = byteAt(localIP + 1);
	byte3 = byteAt(localIP + 2);
	byte4 = byteAt(localIP + 3);
	if ((arg1 & 1)) {
		arg1Val = (arg1 >> 1);
	} else {
		return internalPush(arg1);
	}
	if (byte2 < 32) {
		arg2Val = temporary(byte2 & 15);
		if ((arg2Val & 1)) {
			arg2Val = (arg2Val >> 1);
		} else {
			return internalPush(arg1);
		}
	} else {
		if (byte2 > 64) {
			arg2Val = 1;
		} else {
			arg2Val = literal(byte2 & 31);
			if ((arg2Val & 1)) {
				arg2Val = (arg2Val >> 1);
			} else {
				return internalPush(arg1);
			}
		}
	}
	if (byte3 < 178) {
		result = arg1Val + arg2Val;
		if (isIntegerValue(result)) {
			if ((byte4 > 103) && (byte4 < 112)) {
				localIP += 3;
				storePointerUncheckedofObjectwithValue((byte4 & 7) + 6, theHomeContext, ((result << 1) | 1));
			} else {
				localIP += 2;
				internalPush(((result << 1) | 1));
			}
		} else {
			return internalPush(arg1);
		}
	} else {
		offset = byteAt(localIP + 4);
		if (arg1Val <= arg2Val) {
			localIP = (localIP + 3) + 1;
		} else {
			localIP = ((localIP + 3) + 1) + offset;
		}
	}
}

int extendedPushBytecode(void) {
    int descriptor;
    int variableType;
    int variableIndex;

	descriptor = fetchByte();
	variableType = (((unsigned) descriptor) >> 6) & 3;
	variableIndex = descriptor & 63;
	if (variableType == 0) {
		return pushReceiverVariable(variableIndex);
	}
	if (variableType == 1) {
		return pushTemporaryVariable(variableIndex);
	}
	if (variableType == 2) {
		return pushLiteralConstant(variableIndex);
	}
	if (variableType == 3) {
		return pushLiteralVariable(variableIndex);
	}
}

int extendedStoreAndPopBytecode(void) {
	extendedStoreBytecode();
	popStackBytecode();
}

int extendedStoreBytecode(void) {
    int descriptor;
    int variableType;
    int variableIndex;
    int association;

	/* inline: true */;
	descriptor = fetchByte();
	variableType = (((unsigned) descriptor) >> 6) & 3;
	variableIndex = descriptor & 63;
	if (variableType == 0) {
		return storePointerofObjectwithValue(variableIndex, receiver, internalStackTop());
	}
	if (variableType == 1) {
		return storePointerUncheckedofObjectwithValue(variableIndex + 6, theHomeContext, internalStackTop());
	}
	if (variableType == 2) {
		error("illegal store");
	}
	if (variableType == 3) {
		association = literal(variableIndex);
		return storePointerofObjectwithValue(1, association, internalStackTop());
	}
}

int externalizeIPandSP(void) {
	instructionPointer = ((int) localIP);
	stackPointer = ((int) localSP);
}

int extraHeaderBytes(int oopOrChunk) {
    int type;
    int extra;

	/* inline: true */;
	type = headerType(oopOrChunk);
	if (type > 1) {
		extra = 0;
	} else {
		if (type == 1) {
			extra = 4;
		} else {
			extra = 8;
		}
	}
	return extra;
}

int failSpecialPrim(int primIndex) {
    int selectorIndex;
    int bytecode;
    int newReceiver;
    int rcvrClass;

	bytecode = getCurrentBytecode();
	if ((bytecode < 176) || (bytecode > 207)) {
		return primitiveFail();
	}
	selectorIndex = (bytecode - 176) * 2;
	messageSelector = fetchPointerofObject(selectorIndex, splObj(23));
	argumentCount = quickFetchIntegerofObject(selectorIndex + 1, splObj(23));
	newReceiver = stackValue(argumentCount);
	rcvrClass = fetchClassOf(newReceiver);
	findNewMethodInClass(rcvrClass);
	if ((primitiveIndex > 37) && (primitiveIndex != primIndex)) {
		executeNewMethod();
	} else {
		activateNewMethod();
	}
}

int failed(void) {
	return !successFlag;
}

void * fetchArrayofObject(int fieldIndex, int objectPointer) {
    int arrayOop;

	arrayOop = fetchPointerofObject(fieldIndex, objectPointer);
	return arrayValueOf(arrayOop);
}

int fetchByte(void) {
	return byteAt(++localIP);
}

int fetchByteofObject(int byteIndex, int oop) {
	return byteAt(((((char *) oop)) + 4) + byteIndex);
}

int fetchClassOf(int oop) {
    int ccIndex;

	/* inline: true */;
	if ((oop & 1)) {
		return splObj(5);
	}
	ccIndex = ((((unsigned) (baseHeader(oop))) >> 12) & 31) - 1;
	if (ccIndex < 0) {
		return (classHeader(oop)) & 4294967292U;
	} else {
		return fetchPointerofObject(ccIndex, fetchPointerofObject(28, specialObjectsOop));
	}
}

int fetchContextRegisters(int activeCntx) {
    int tmp;

	/* inline: true */;
	tmp = fetchPointerofObject(3, activeCntx);
	if ((tmp & 1)) {
		tmp = fetchPointerofObject(5, activeCntx);
		if (tmp < youngStart) {
			beRootIfOld(tmp);
		}
	} else {
		tmp = activeCntx;
	}
	theHomeContext = tmp;
	receiver = fetchPointerofObject(5, tmp);
	method = fetchPointerofObject(3, tmp);
	tmp = quickFetchIntegerofObject(1, activeCntx);
	instructionPointer = ((method + tmp) + 4) - 2;
	tmp = quickFetchIntegerofObject(2, activeCntx);
	stackPointer = (activeCntx + 4) + (((6 + tmp) - 1) * 4);
}

double fetchFloatofObject(int fieldIndex, int objectPointer) {
    int floatOop;

	floatOop = fetchPointerofObject(fieldIndex, objectPointer);
	return floatValueOf(floatOop);
}

int fetchIntegerofObject(int fieldIndex, int objectPointer) {
    int intOop;

	/* inline: false */;
	intOop = fetchPointerofObject(fieldIndex, objectPointer);
	if ((intOop & 1)) {
		return (intOop >> 1);
	} else {
		primitiveFail();
		return 0;
	}
}

int fetchIntegerOrTruncFloatofObject(int fieldIndex, int objectPointer) {
    double trunc;
    double frac;
    double floatVal;
    int intOrFloat;

	/* inline: false */;
	intOrFloat = fetchPointerofObject(fieldIndex, objectPointer);
	if ((intOrFloat & 1)) {
		return (intOrFloat >> 1);
	}
	assertClassOfis(intOrFloat, splObj(9));
	if (successFlag) {
		fetchFloatAtinto(intOrFloat + 4, floatVal);
		frac = modf(floatVal, &trunc);
		success((-2147483648.0 <= trunc) && (trunc <= 2147483647.0));
	}
	if (successFlag) {
		return ((int) trunc);
	} else {
		return 0;
	}
}

int fetchPointerofObject(int fieldIndex, int oop) {
	return longAt(((((char *) oop)) + 4) + (fieldIndex << 2));
}

int fetchWordofObject(int fieldIndex, int oop) {
	return longAt(((((char *) oop)) + 4) + (fieldIndex << 2));
}

int fetchWordLengthOf(int objectPointer) {
    int sz;

	sz = sizeBitsOf(objectPointer);
	return ((unsigned) (sz - 4)) >> 2;
}

int fileRecordSize(void) {
	return sizeof(SQFile);
}

SQFile * fileValueOf(int objectPointer) {
    int fileIndex;

	success((isBytes(objectPointer)) && ((lengthOf(objectPointer)) == (fileRecordSize())));
	if (successFlag) {
		fileIndex = objectPointer + 4;
		return (SQFile *) fileIndex;
	} else {
		return null;
	}
}

int findClassOfMethodforReceiver(int meth, int rcvr) {
    int methodArray;
    int done;
    int i;
    int classDict;
    int currClass;
    int classDictSize;

	currClass = fetchClassOf(rcvr);
	done = false;
	while (!(done)) {
		classDict = fetchPointerofObject(1, currClass);
		classDictSize = fetchWordLengthOf(classDict);
		methodArray = fetchPointerofObject(1, classDict);
		i = 0;
		while (i < (classDictSize - 2)) {
			if (meth == (fetchPointerofObject(i, methodArray))) {
				return currClass;
			}
			i += 1;
		}
		currClass = fetchPointerofObject(0, currClass);
		done = currClass == nilObj;
	}
	return fetchClassOf(rcvr);
}

int findNewMethodInClass(int class) {
    int ok;

	/* inline: true */;
	ok = lookupInMethodCacheSelclass(messageSelector, class);
	if (!(ok)) {
		lookupMethodInClass(class);
		primitiveIndex = primitiveIndexOf(newMethod);
		addToMethodCacheSelclassmethodprimIndex(messageSelector, class, newMethod, primitiveIndex);
	}
}

int findSelectorOfMethodforReceiver(int meth, int rcvr) {
    int methodArray;
    int done;
    int i;
    int classDict;
    int currClass;
    int classDictSize;

	currClass = fetchClassOf(rcvr);
	done = false;
	while (!(done)) {
		classDict = fetchPointerofObject(1, currClass);
		classDictSize = fetchWordLengthOf(classDict);
		methodArray = fetchPointerofObject(1, classDict);
		i = 0;
		while (i <= (classDictSize - 2)) {
			if (meth == (fetchPointerofObject(i, methodArray))) {
				return fetchPointerofObject(i + 2, classDict);
			}
			i += 1;
		}
		currClass = fetchPointerofObject(0, currClass);
		done = currClass == nilObj;
	}
	return splObj(20);
}

int firstAccessibleObject(void) {
    int obj;

	obj = firstObject();
	while (obj < endOfMemory) {
		if (!(isFreeObject(obj))) {
			return obj;
		}
		obj = objectAfter(obj);
	}
	error("heap is empty");
}

int firstObject(void) {
	return oopFromChunk(startOfMemory());
}

int fixedFieldsOfformatlength(int oop, int fmt, int wordLength) {
    int classFormat;
    int class;

	/* inline: true */;
	if ((fmt > 3) || (fmt == 2)) {
		return 0;
	}
	if (fmt < 2) {
		return wordLength;
	}
	class = fetchClassOf(oop);
	classFormat = formatOfClass(class);
	return (((((unsigned) classFormat) >> 11) & 192) + ((((unsigned) classFormat) >> 2) & 63)) - 1;
}

double floatValueOf(int oop) {
    double result;

	assertClassOfis(oop, splObj(9));
	if (successFlag) {
		fetchFloatAtinto(oop + 4, result);
	} else {
		result = 0.0;
	}
	return result;
}

int flushMethodCache(void) {
    int i;

	for (i = 1; i <= 2048; i += 1) {
		methodCache[i] = 0;
	}
	mcProbe = 0;
}

int formatOf(int oop) {
	return (((unsigned) (baseHeader(oop))) >> 8) & 15;
}

int formatOfClass(int classPointer) {
	return (fetchPointerofObject(2, classPointer)) - 1;
}

int fullCompaction(void) {
	compStart = lowestFreeAfter(startOfMemory());
	if (compStart == freeBlock) {
		return initializeMemoryFirstFree(freeBlock);
	}
	while (compStart < freeBlock) {
		compStart = incCompBody();
	}
}

int fullDisplayUpdate(void) {
    int displayObj;
    int dispBits;
    int dispBitsIndex;
    int h;
    int w;
    int d;

	displayObj = splObj(14);
	if ((isPointers(displayObj)) && ((lengthOf(displayObj)) >= 4)) {
		dispBits = fetchPointerofObject(0, displayObj);
		w = fetchIntegerofObject(1, displayObj);
		h = fetchIntegerofObject(2, displayObj);
		d = fetchIntegerofObject(3, displayObj);
		dispBitsIndex = dispBits + 4;
		ioShowDisplay(dispBitsIndex, w, h, d, 0, w, 0, h);
	}
}

int fullGC(void) {
    int startTime;

	/* inline: false */;
	preGCAction(true);
	startTime = ioMicroMSecs();
	clearRootsTable();
	youngStart = startOfMemory();
	markPhase();
	sweepPhase();
	fullCompaction();
	allocationCount = 0;
	statFullGCs += 1;
	statFullGCMSecs += (ioMicroMSecs()) - startTime;
	youngStart = freeBlock;
	postGCAction();
}

int fwdBlockGet(void) {
	fwdTableNext += 8;
	if (fwdTableNext <= fwdTableLast) {
		return fwdTableNext;
	} else {
		return null;
	}
}

int fwdBlockValidate(int addr) {
	if (!((addr > endOfMemory) && ((addr <= fwdTableNext) && ((addr & 3) == 0)))) {
		error("invalid fwd table entry");
	}
}

int fwdTableInit(void) {
	/* inline: false */;
	setSizeOfFreeto(freeBlock, 4);
	endOfMemory = freeBlock + 4;
	setSizeOfFreeto(endOfMemory, 4);
	fwdTableNext = endOfMemory + 4;
	fwdTableLast = memoryLimit - 8;
	if (checkAssertions && ((fwdTableLast & 2147483648U) != 0)) {
		error("fwd table must be in low half of the 32-bit address space");
	}
	return ((int) (fwdTableLast - fwdTableNext) >> 3);
}

int getCurrentBytecode(void) {
	return byteAt(instructionPointer);
}

int getLongFromFileswap(sqImageFile f, int swapFlag) {
    int w;

	sqImageFileRead(&w, sizeof(char), 4, f);
	if (swapFlag) {
		return byteSwapped(w);
	} else {
		return w;
	}
}

int hashBitsOf(int oop) {
	return (((unsigned) (baseHeader(oop))) >> 17) & 4095;
}

int headerOf(int methodPointer) {
	return fetchPointerofObject(0, methodPointer);
}

int headerType(int oop) {
	return (longAt(oop)) & 3;
}

int ignoreSourceOrHalftone(int formPointer) {
	if (formPointer == (nilObject())) {
		return true;
	}
	if (combinationRule == 0) {
		return true;
	}
	if (combinationRule == 5) {
		return true;
	}
	if (combinationRule == 10) {
		return true;
	}
	if (combinationRule == 15) {
		return true;
	}
	return false;
}

int imageFormatVersion(void) {
	return 6502;
}

int incCompBody(void) {
    int bytesFreed;

	/* inline: false */;
	fwdTableInit();
	bytesFreed = incCompMakeFwd();
	mapPointersInObjectsFromto(youngStart, endOfMemory);
	return incCompMove(bytesFreed);
}

int incCompMakeFwd(void) {
    int fwdBlock;
    int oop;
    int bytesFreed;
    int newOop;

	bytesFreed = 0;
	oop = oopFromChunk(compStart);
	while (oop < endOfMemory) {
		if (isFreeObject(oop)) {
			bytesFreed += sizeOfFree(oop);
		} else {
			fwdBlock = fwdBlockGet();
			if (fwdBlock == null) {
				compEnd = chunkFromOop(oop);
				return bytesFreed;
			}
			newOop = oop - bytesFreed;
			initForwardBlockmappingto(fwdBlock, oop, newOop);
		}
		oop = objectAfterWhileForwarding(oop);
	}
	compEnd = endOfMemory;
	return bytesFreed;
}

int incCompMove(int bytesFreed) {
    int sz;
    int header;
    int newOop;
    int newFreeChunk;
    int next;
    int bytesToMove;
    int w;
    int fwdBlock;
    int oop;
    int firstWord;
    int lastWord;

	newOop = null;
	oop = oopFromChunk(compStart);
	while (oop < compEnd) {
		next = objectAfterWhileForwarding(oop);
		if (!(isFreeObject(oop))) {
			fwdBlock = (longAt(oop)) & 2147483644;
			if (checkAssertions) {
				fwdBlockValidate(fwdBlock);
			}
			newOop = longAt(fwdBlock);
			header = longAt(fwdBlock + 4);
			longAtput(oop, header);
			bytesToMove = oop - newOop;
			sz = sizeBitsOf(oop);
			firstWord = oop - (extraHeaderBytes(oop));
			lastWord = (oop + sz) - 4;
			for (w = firstWord; w <= lastWord; w += 4) {
				longAtput(w - bytesToMove, longAt(w));
			}
		}
		oop = next;
	}
	if (newOop == null) {
		oop = oopFromChunk(compStart);
		if ((isFreeObject(oop)) && ((objectAfter(oop)) == (oopFromChunk(compEnd)))) {
			newFreeChunk = oop;
		} else {
			newFreeChunk = freeBlock;
		}
	} else {
		newFreeChunk = newOop + (sizeBitsOf(newOop));
		setSizeOfFreeto(newFreeChunk, bytesFreed);
	}
	if (checkAssertions) {
		if (!((objectAfter(newFreeChunk)) == (oopFromChunk(compEnd)))) {
			error("problem creating free chunk after compaction");
		}
	}
	if ((objectAfter(newFreeChunk)) == endOfMemory) {
		initializeMemoryFirstFree(newFreeChunk);
	} else {
		initializeMemoryFirstFree(freeBlock);
	}
	return newFreeChunk;
}

int incrementalCompaction(void) {
	if (compStart == freeBlock) {
		initializeMemoryFirstFree(freeBlock);
	} else {
		incCompBody();
	}
}

int incrementalGC(void) {
    int startTime;
    int survivorCount;

	/* inline: false */;
	if (rootTableCount >= 1000) {
		statRootTableOverflows += 1;
		return fullGC();
	}
	preGCAction(false);
	startTime = ioMicroMSecs();
	markPhase();
	survivorCount = sweepPhase();
	incrementalCompaction();
	allocationCount = 0;
	statIncrGCs += 1;
	statIncrGCMSecs += (ioMicroMSecs()) - startTime;
	if (survivorCount > tenuringThreshold) {
		statTenures += 1;
		clearRootsTable();
		youngStart = freeBlock;
	}
	postGCAction();
}

int initBBOpTable(void) {
	opTable[0+1] = (int)clearWordwith;
	opTable[1+1] = (int)bitAndwith;
	opTable[2+1] = (int)bitAndInvertwith;
	opTable[3+1] = (int)sourceWordwith;
	opTable[4+1] = (int)bitInvertAndwith;
	opTable[5+1] = (int)destinationWordwith;
	opTable[6+1] = (int)bitXorwith;
	opTable[7+1] = (int)bitOrwith;
	opTable[8+1] = (int)bitInvertAndInvertwith;
	opTable[9+1] = (int)bitInvertXorwith;
	opTable[10+1] = (int)bitInvertDestinationwith;
	opTable[11+1] = (int)bitOrInvertwith;
	opTable[12+1] = (int)bitInvertSourcewith;
	opTable[13+1] = (int)bitInvertOrwith;
	opTable[14+1] = (int)bitInvertOrInvertwith;
	opTable[15+1] = (int)destinationWordwith;
	opTable[16+1] = (int)destinationWordwith;
	opTable[17+1] = (int)destinationWordwith;
	opTable[18+1] = (int)addWordwith;
	opTable[19+1] = (int)subWordwith;
	opTable[20+1] = (int)rgbAddwith;
	opTable[21+1] = (int)rgbSubwith;
	opTable[22+1] = (int)OLDrgbDiffwith;
	opTable[23+1] = (int)OLDtallyIntoMapwith;
	opTable[24+1] = (int)alphaBlendwith;
	opTable[25+1] = (int)pixPaintwith;
	opTable[26+1] = (int)pixMaskwith;
	opTable[27+1] = (int)rgbMaxwith;
	opTable[28+1] = (int)rgbMinwith;
	opTable[29+1] = (int)rgbMinInvertwith;
	opTable[30+1] = (int)alphaBlendConstwith;
	opTable[31+1] = (int)alphaPaintConstwith;
	opTable[32+1] = (int)rgbDiffwith;
	opTable[33+1] = (int)tallyIntoMapwith;
}

int initForwardBlockmappingto(int fwdBlock, int oop, int newOop) {
    int originalHeader;
    int originalHeaderType;

	/* inline: true */;
	originalHeader = longAt(oop);
	if (checkAssertions) {
		if (fwdBlock == null) {
			error("ran out of forwarding blocks in become");
		}
		if ((originalHeader & 2147483648U) != 0) {
			error("object already has a forwarding table entry");
		}
	}
	originalHeaderType = originalHeader & 3;
	longAtput(fwdBlock, newOop);
	longAtput(fwdBlock + 4, originalHeader);
	longAtput(oop, fwdBlock | (2147483648U | originalHeaderType));
}

int initialInstanceOf(int classPointer) {
    int thisClass;
    int thisObj;

	thisObj = firstAccessibleObject();
	while (!(thisObj == null)) {
		thisClass = fetchClassOf(thisObj);
		if (thisClass == classPointer) {
			return thisObj;
		}
		thisObj = accessibleObjectAfter(thisObj);
	}
	return nilObj;
}

int initializeInterpreter(int bytesToShift) {
	initializeObjectMemory(bytesToShift);
	initBBOpTable();
	activeContext = nilObj;
	theHomeContext = nilObj;
	method = nilObj;
	receiver = nilObj;
	messageSelector = nilObj;
	newMethod = nilObj;
	flushMethodCache();
	loadInitialContext();
	interruptCheckCounter = 0;
	nextPollTick = 0;
	nextWakeupTick = 0;
	lastTick = 0;
	interruptKeycode = 2094;
	interruptPending = false;
	semaphoresToSignalCount = 0;
	deferDisplayUpdates = false;
}

int initializeMemoryFirstFree(int firstFree) {
    int fwdBlockBytes;

	fwdBlockBytes = 16000;
	if (!((memoryLimit - fwdBlockBytes) >= (firstFree + 4))) {
		fwdBlockBytes = memoryLimit - (firstFree + 4);
	}
	endOfMemory = memoryLimit - fwdBlockBytes;
	freeBlock = firstFree;
	setSizeOfFreeto(freeBlock, endOfMemory - firstFree);
	setSizeOfFreeto(endOfMemory, 4);
	if (checkAssertions) {
		if (!((freeBlock < endOfMemory) && (endOfMemory < memoryLimit))) {
			error("error in free space computation");
		}
		if (!((oopFromChunk(endOfMemory)) == endOfMemory)) {
			error("header format must have changed");
		}
		if (!((objectAfter(freeBlock)) == endOfMemory)) {
			error("free block not properly initialized");
		}
	}
}

int initializeObjectMemory(int bytesToShift) {
	/* inline: false */;
	checkAssertions = false;
	youngStart = endOfMemory;
	initializeMemoryFirstFree(endOfMemory);
	adjustAllOopsBy(bytesToShift);
	specialObjectsOop += bytesToShift;
	nilObj = splObj(0);
	falseObj = splObj(1);
	trueObj = splObj(2);
	rootTableCount = 0;
	child = 0;
	field = 0;
	parentField = 0;
	freeLargeContexts = 1;
	freeSmallContexts = 1;
	allocationCount = 0;
	lowSpaceThreshold = 0;
	signalLowSpace = false;
	compStart = 0;
	compEnd = 0;
	fwdTableNext = 0;
	fwdTableLast = 0;
	remapBufferCount = 0;
	allocationsBetweenGCs = 4000;
	tenuringThreshold = 2000;
	statFullGCs = 0;
	statFullGCMSecs = 0;
	statIncrGCs = 0;
	statIncrGCMSecs = 0;
	statTenures = 0;
	statRootTableOverflows = 0;
	displayBits = 0;
}

int instanceAfter(int objectPointer) {
    int thisClass;
    int classPointer;
    int thisObj;

	classPointer = fetchClassOf(objectPointer);
	thisObj = accessibleObjectAfter(objectPointer);
	while (!(thisObj == null)) {
		thisClass = fetchClassOf(thisObj);
		if (thisClass == classPointer) {
			return thisObj;
		}
		thisObj = accessibleObjectAfter(thisObj);
	}
	return nilObj;
}

int instantiateClassindexableSize(int classPointer, int size) {
    int sizeHiBits;
    int newObj;
    int binc;
    int hash;
    int header1;
    int header2;
    int header3;
    int hdrSize;
    int byteSize;
    int format;
    int inc;
    int cClass;
    int fillWord;

	/* inline: false */;
	if (checkAssertions) {
		if (size < 0) {
			error("cannot have a negative indexable field count");
		}
	}
	hash = newObjectHash();
	header1 = formatOfClass(classPointer);
	sizeHiBits = ((unsigned) (header1 & 393216)) >> 9;
	header1 = (header1 & 131071) | ((hash << 17) & 536739840);
	header2 = classPointer;
	header3 = 0;
	cClass = header1 & 126976;
	byteSize = (header1 & 252) + sizeHiBits;
	format = (((unsigned) header1) >> 8) & 15;
	if (format < 8) {
		inc = size * 4;
	} else {
		inc = (size + 3) & 536870908;
		binc = 3 - ((size + 3) & 3);
		header1 = header1 | (binc << 8);
	}
	if ((byteSize + inc) > 255) {
		header3 = byteSize + inc;
		header1 -= byteSize & 255;
	} else {
		header1 += inc;
	}
	byteSize += inc;
	if (header3 > 0) {
		hdrSize = 3;
	} else {
		if (cClass == 0) {
			hdrSize = 2;
		} else {
			hdrSize = 1;
		}
	}
	if (format < 4) {
		fillWord = nilObj;
	} else {
		fillWord = 0;
	}
	newObj = allocateheaderSizeh1h2h3fill(byteSize, hdrSize, header1, header2, header3, fillWord);
	return newObj;
}

int instantiateSmallClasssizeInBytesfill(int classPointer, int sizeInBytes, int fillValue) {
    int header1;
    int header2;
    int hdrSize;
    int hash;

	hash = newObjectHash();
	header1 = ((hash << 17) & 536739840) | (formatOfClass(classPointer));
	header1 += sizeInBytes - (header1 & 252);
	header2 = classPointer;
	if ((header1 & 126976) == 0) {
		hdrSize = 2;
	} else {
		hdrSize = 1;
	}
	return allocateheaderSizeh1h2h3fill(sizeInBytes, hdrSize, header1, header2, 0, fillValue);
}

int intToNetAddress(int addr) {
    int netAddressOop;

	netAddressOop = instantiateSmallClasssizeInBytesfill(splObj(26), 8, 0);
	storeByteofObjectwithValue(0, netAddressOop, (((unsigned) addr) >> 24) & 255);
	storeByteofObjectwithValue(1, netAddressOop, (((unsigned) addr) >> 16) & 255);
	storeByteofObjectwithValue(2, netAddressOop, (((unsigned) addr) >> 8) & 255);
	storeByteofObjectwithValue(3, netAddressOop, addr & 255);
	return netAddressOop;
}

int integerObjectOf(int value) {
	if (value < 0) {
		return ((2147483648U + value) << 1) + 1;
	} else {
		return (value << 1) + 1;
	}
}

int integerValueOf(int objectPointer) {
	if ((objectPointer & 2147483648U) != 0) {
		return ((((unsigned) (objectPointer & 2147483647U)) >> 1) - 1073741823) - 1;
	} else {
		return ((unsigned) objectPointer) >> 1;
	}
}

int internalFetchContextRegisters(int activeCntx) {
    int tmp;

	/* inline: true */;
	tmp = fetchPointerofObject(3, activeCntx);
	if ((tmp & 1)) {
		tmp = fetchPointerofObject(5, activeCntx);
		if (tmp < youngStart) {
			beRootIfOld(tmp);
		}
	} else {
		tmp = activeCntx;
	}
	theHomeContext = tmp;
	receiver = fetchPointerofObject(5, tmp);
	method = fetchPointerofObject(3, tmp);
	tmp = quickFetchIntegerofObject(1, activeCntx);
	localIP = ((char *) (((method + tmp) + 4) - 2));
	tmp = quickFetchIntegerofObject(2, activeCntx);
	localSP = ((char *) ((activeCntx + 4) + (((6 + tmp) - 1) * 4)));
}

int internalPop(int nItems) {
	localSP -= nItems * 4;
}

int internalPopthenPush(int nItems, int oop) {
	longAtput(localSP -= (nItems - 1) * 4, oop);
}

int internalPush(int object) {
	longAtput(localSP += 4, object);
}

int internalQuickCheckForInterrupts(void) {
	if ((interruptCheckCounter -= 1) <= 0) {
		externalizeIPandSP();
		checkForInterrupts();
		internalizeIPandSP();
	}
}

int internalStackTop(void) {
	return longAt(localSP);
}

int internalStackValue(int offset) {
	return longAt(localSP - (offset * 4));
}

int internalizeIPandSP(void) {
	localIP = ((char *) instructionPointer);
	localSP = ((char *) stackPointer);
}

int interpret(void) {
    int t1;
    int t2;
    int t3;
    int t4;
    int t5;
    int t6;
    int t7;
    int t8;

	internalizeIPandSP();
	while (true) {
		currentBytecode = fetchByte();
		switch (currentBytecode) {
		case 0:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(0 & 15);
			break;
		case 1:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(1 & 15);
			break;
		case 2:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(2 & 15);
			break;
		case 3:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(3 & 15);
			break;
		case 4:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(4 & 15);
			break;
		case 5:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(5 & 15);
			break;
		case 6:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(6 & 15);
			break;
		case 7:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(7 & 15);
			break;
		case 8:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(8 & 15);
			break;
		case 9:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(9 & 15);
			break;
		case 10:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(10 & 15);
			break;
		case 11:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(11 & 15);
			break;
		case 12:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(12 & 15);
			break;
		case 13:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(13 & 15);
			break;
		case 14:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(14 & 15);
			break;
		case 15:
			/* pushReceiverVariableBytecode */
			pushReceiverVariable(15 & 15);
			break;
		case 16:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(16 & 15);
			break;
		case 17:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(17 & 15);
			break;
		case 18:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(18 & 15);
			break;
		case 19:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(19 & 15);
			break;
		case 20:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(20 & 15);
			break;
		case 21:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(21 & 15);
			break;
		case 22:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(22 & 15);
			break;
		case 23:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(23 & 15);
			break;
		case 24:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(24 & 15);
			break;
		case 25:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(25 & 15);
			break;
		case 26:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(26 & 15);
			break;
		case 27:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(27 & 15);
			break;
		case 28:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(28 & 15);
			break;
		case 29:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(29 & 15);
			break;
		case 30:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(30 & 15);
			break;
		case 31:
			/* pushTemporaryVariableBytecode */
			pushTemporaryVariable(31 & 15);
			break;
		case 32:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(32 & 31);
			break;
		case 33:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(33 & 31);
			break;
		case 34:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(34 & 31);
			break;
		case 35:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(35 & 31);
			break;
		case 36:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(36 & 31);
			break;
		case 37:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(37 & 31);
			break;
		case 38:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(38 & 31);
			break;
		case 39:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(39 & 31);
			break;
		case 40:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(40 & 31);
			break;
		case 41:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(41 & 31);
			break;
		case 42:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(42 & 31);
			break;
		case 43:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(43 & 31);
			break;
		case 44:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(44 & 31);
			break;
		case 45:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(45 & 31);
			break;
		case 46:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(46 & 31);
			break;
		case 47:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(47 & 31);
			break;
		case 48:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(48 & 31);
			break;
		case 49:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(49 & 31);
			break;
		case 50:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(50 & 31);
			break;
		case 51:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(51 & 31);
			break;
		case 52:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(52 & 31);
			break;
		case 53:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(53 & 31);
			break;
		case 54:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(54 & 31);
			break;
		case 55:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(55 & 31);
			break;
		case 56:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(56 & 31);
			break;
		case 57:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(57 & 31);
			break;
		case 58:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(58 & 31);
			break;
		case 59:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(59 & 31);
			break;
		case 60:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(60 & 31);
			break;
		case 61:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(61 & 31);
			break;
		case 62:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(62 & 31);
			break;
		case 63:
			/* pushLiteralConstantBytecode */
			pushLiteralConstant(63 & 31);
			break;
		case 64:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(64 & 31);
			break;
		case 65:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(65 & 31);
			break;
		case 66:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(66 & 31);
			break;
		case 67:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(67 & 31);
			break;
		case 68:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(68 & 31);
			break;
		case 69:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(69 & 31);
			break;
		case 70:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(70 & 31);
			break;
		case 71:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(71 & 31);
			break;
		case 72:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(72 & 31);
			break;
		case 73:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(73 & 31);
			break;
		case 74:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(74 & 31);
			break;
		case 75:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(75 & 31);
			break;
		case 76:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(76 & 31);
			break;
		case 77:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(77 & 31);
			break;
		case 78:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(78 & 31);
			break;
		case 79:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(79 & 31);
			break;
		case 80:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(80 & 31);
			break;
		case 81:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(81 & 31);
			break;
		case 82:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(82 & 31);
			break;
		case 83:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(83 & 31);
			break;
		case 84:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(84 & 31);
			break;
		case 85:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(85 & 31);
			break;
		case 86:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(86 & 31);
			break;
		case 87:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(87 & 31);
			break;
		case 88:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(88 & 31);
			break;
		case 89:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(89 & 31);
			break;
		case 90:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(90 & 31);
			break;
		case 91:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(91 & 31);
			break;
		case 92:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(92 & 31);
			break;
		case 93:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(93 & 31);
			break;
		case 94:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(94 & 31);
			break;
		case 95:
			/* pushLiteralVariableBytecode */
			pushLiteralVariable(95 & 31);
			break;
		case 96:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(96 & 7, t2, t1);
			internalPop(1);
			break;
		case 97:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(97 & 7, t2, t1);
			internalPop(1);
			break;
		case 98:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(98 & 7, t2, t1);
			internalPop(1);
			break;
		case 99:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(99 & 7, t2, t1);
			internalPop(1);
			break;
		case 100:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(100 & 7, t2, t1);
			internalPop(1);
			break;
		case 101:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(101 & 7, t2, t1);
			internalPop(1);
			break;
		case 102:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(102 & 7, t2, t1);
			internalPop(1);
			break;
		case 103:
			/* storeAndPopReceiverVariableBytecode */
			t2 = receiver;
			t1 = internalStackTop();
			if (t2 < youngStart) {
				possibleRootStoreIntovalue(t2, t1);
			}
			storePointerUncheckedofObjectwithValue(103 & 7, t2, t1);
			internalPop(1);
			break;
		case 104:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((104 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 105:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((105 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 106:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((106 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 107:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((107 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 108:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((108 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 109:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((109 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 110:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((110 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 111:
			/* storeAndPopTemporaryVariableBytecode */
			storePointerUncheckedofObjectwithValue((111 & 7) + 6, theHomeContext, internalStackTop());
			internalPop(1);
			break;
		case 112:
			/* pushReceiverBytecode */
			internalPush(receiver);
			break;
		case 113:
			/* pushConstantTrueBytecode */
			internalPush(trueObj);
			break;
		case 114:
			/* pushConstantFalseBytecode */
			internalPush(falseObj);
			break;
		case 115:
			/* pushConstantNilBytecode */
			internalPush(nilObj);
			break;
		case 116:
			/* pushConstantMinusOneBytecode */
			internalPush(4294967295U);
			break;
		case 117:
			/* pushConstantZeroBytecode */
			internalPush(1);
			break;
		case 118:
			/* pushConstantOneBytecode */
			internalPush(3);
			break;
		case 119:
			/* pushConstantTwoBytecode */
			internalPush(5);
			break;
		case 120:
			/* returnReceiver */
			t2 = sender();
			t1 = receiver;
			returnValueto(t1, t2);
			break;
		case 121:
			/* returnTrue */
			t2 = sender();
			t1 = trueObj;
			returnValueto(t1, t2);
			break;
		case 122:
			/* returnFalse */
			t2 = sender();
			t1 = falseObj;
			returnValueto(t1, t2);
			break;
		case 123:
			/* returnNil */
			t2 = sender();
			t1 = nilObj;
			returnValueto(t1, t2);
			break;
		case 124:
			/* returnTopFromMethod */
			t2 = sender();
			t1 = internalStackTop();
			returnValueto(t1, t2);
			break;
		case 125:
			/* returnTopFromBlock */
			t2 = caller();
			t1 = internalStackTop();
			returnValueto(t1, t2);
			break;
		case 126:
		case 127:
			/* unknownBytecode */
			error("Unknown bytecode");
			break;
		case 128:
			/* extendedPushBytecode */
			t1 = fetchByte();
			t2 = (((unsigned) t1) >> 6) & 3;
			t3 = t1 & 63;
			if (t2 == 0) {
				pushReceiverVariable(t3);
				goto l1;
			}
			if (t2 == 1) {
				pushTemporaryVariable(t3);
				goto l1;
			}
			if (t2 == 2) {
				pushLiteralConstant(t3);
				goto l1;
			}
			if (t2 == 3) {
				pushLiteralVariable(t3);
				goto l1;
			}
		l1:	/* end case */;
			break;
		case 129:
			/* extendedStoreBytecode */
			/* inline: true */;
			t1 = fetchByte();
			t2 = (((unsigned) t1) >> 6) & 3;
			t3 = t1 & 63;
			if (t2 == 0) {
				storePointerofObjectwithValue(t3, receiver, internalStackTop());
				goto l2;
			}
			if (t2 == 1) {
				storePointerUncheckedofObjectwithValue(t3 + 6, theHomeContext, internalStackTop());
				goto l2;
			}
			if (t2 == 2) {
				error("illegal store");
			}
			if (t2 == 3) {
				t4 = literal(t3);
				storePointerofObjectwithValue(1, t4, internalStackTop());
				goto l2;
			}
		l2:	/* end case */;
			break;
		case 130:
			/* extendedStoreAndPopBytecode */
			extendedStoreBytecode();
			popStackBytecode();
			break;
		case 131:
			/* singleExtendedSendBytecode */
			t1 = fetchByte();
			messageSelector = literal(t1 & 31);
			argumentCount = ((unsigned) t1) >> 5;
			normalSend();
			break;
		case 132:
			/* doubleExtendedDoAnythingBytecode */
			t1 = fetchByte();
			t2 = fetchByte();
			t4 = ((unsigned) t1) >> 5;
			if (t4 == 0) {
				messageSelector = literal(t2);
				argumentCount = t1 & 31;
				normalSend();
				goto l3;
			}
			if (t4 == 1) {
				messageSelector = literal(t2);
				argumentCount = t1 & 31;
				superclassSend();
				goto l3;
			}
			if (t4 == 2) {
				pushReceiverVariable(t2);
				goto l3;
			}
			if (t4 == 3) {
				pushLiteralConstant(t2);
				goto l3;
			}
			if (t4 == 4) {
				pushLiteralVariable(t2);
				goto l3;
			}
			if (t4 == 5) {
				t3 = internalStackTop();
				storePointerofObjectwithValue(t2, receiver, t3);
				goto l3;
			}
			if (t4 == 6) {
				t3 = internalStackTop();
				internalPop(1);
				storePointerofObjectwithValue(t2, receiver, t3);
				goto l3;
			}
			if (t4 == 7) {
				t3 = internalStackTop();
				storePointerofObjectwithValue(1, literal(t2), t3);
				goto l3;
			}
		l3:	/* end case */;
			break;
		case 133:
			/* singleExtendedSuperBytecode */
			t1 = fetchByte();
			messageSelector = literal(t1 & 31);
			argumentCount = ((unsigned) t1) >> 5;
			superclassSend();
			break;
		case 134:
			/* secondExtendedSendBytecode */
			t1 = fetchByte();
			messageSelector = literal(t1 & 63);
			argumentCount = ((unsigned) t1) >> 6;
			normalSend();
			break;
		case 135:
			/* popStackBytecode */
			internalPop(1);
			break;
		case 136:
			/* duplicateTopBytecode */
			internalPush(internalStackTop());
			break;
		case 137:
			/* pushActiveContextBytecode */
			reclaimableContextCount = 0;
			internalPush(activeContext);
			break;
		case 138:
		case 139:
		case 140:
		case 141:
		case 142:
		case 143:
			/* experimentalBytecode */
			t2 = temporary(currentBytecode - 138);
			t4 = byteAt(localIP + 1);
			t5 = byteAt(localIP + 2);
			t6 = byteAt(localIP + 3);
			if ((t2 & 1)) {
				t1 = (t2 >> 1);
			} else {
				internalPush(t2);
				goto l4;
			}
			if (t4 < 32) {
				t3 = temporary(t4 & 15);
				if ((t3 & 1)) {
					t3 = (t3 >> 1);
				} else {
					internalPush(t2);
					goto l4;
				}
			} else {
				if (t4 > 64) {
					t3 = 1;
				} else {
					t3 = literal(t4 & 31);
					if ((t3 & 1)) {
						t3 = (t3 >> 1);
					} else {
						internalPush(t2);
						goto l4;
					}
				}
			}
			if (t5 < 178) {
				t8 = t1 + t3;
				if (isIntegerValue(t8)) {
					if ((t6 > 103) && (t6 < 112)) {
						localIP += 3;
						storePointerUncheckedofObjectwithValue((t6 & 7) + 6, theHomeContext, ((t8 << 1) | 1));
					} else {
						localIP += 2;
						internalPush(((t8 << 1) | 1));
					}
				} else {
					internalPush(t2);
					goto l4;
				}
			} else {
				t7 = byteAt(localIP + 4);
				if (t1 <= t3) {
					localIP = (localIP + 3) + 1;
				} else {
					localIP = ((localIP + 3) + 1) + t7;
				}
			}
		l4:	/* end case */;
			break;
		case 144:
			/* shortUnconditionalJump */
			jump((144 & 7) + 1);
			break;
		case 145:
			/* shortUnconditionalJump */
			jump((145 & 7) + 1);
			break;
		case 146:
			/* shortUnconditionalJump */
			jump((146 & 7) + 1);
			break;
		case 147:
			/* shortUnconditionalJump */
			jump((147 & 7) + 1);
			break;
		case 148:
			/* shortUnconditionalJump */
			jump((148 & 7) + 1);
			break;
		case 149:
			/* shortUnconditionalJump */
			jump((149 & 7) + 1);
			break;
		case 150:
			/* shortUnconditionalJump */
			jump((150 & 7) + 1);
			break;
		case 151:
			/* shortUnconditionalJump */
			jump((151 & 7) + 1);
			break;
		case 152:
			/* shortConditionalJump */
			jumplfFalseBy((152 & 7) + 1);
			break;
		case 153:
			/* shortConditionalJump */
			jumplfFalseBy((153 & 7) + 1);
			break;
		case 154:
			/* shortConditionalJump */
			jumplfFalseBy((154 & 7) + 1);
			break;
		case 155:
			/* shortConditionalJump */
			jumplfFalseBy((155 & 7) + 1);
			break;
		case 156:
			/* shortConditionalJump */
			jumplfFalseBy((156 & 7) + 1);
			break;
		case 157:
			/* shortConditionalJump */
			jumplfFalseBy((157 & 7) + 1);
			break;
		case 158:
			/* shortConditionalJump */
			jumplfFalseBy((158 & 7) + 1);
			break;
		case 159:
			/* shortConditionalJump */
			jumplfFalseBy((159 & 7) + 1);
			break;
		case 160:
			/* longUnconditionalJump */
			t1 = (((160 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 161:
			/* longUnconditionalJump */
			t1 = (((161 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 162:
			/* longUnconditionalJump */
			t1 = (((162 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 163:
			/* longUnconditionalJump */
			t1 = (((163 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 164:
			/* longUnconditionalJump */
			t1 = (((164 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 165:
			/* longUnconditionalJump */
			t1 = (((165 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 166:
			/* longUnconditionalJump */
			t1 = (((166 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 167:
			/* longUnconditionalJump */
			t1 = (((167 & 7) - 4) * 256) + (fetchByte());
			localIP += t1;
			if (t1 < 0) {
				internalQuickCheckForInterrupts();
			}
			break;
		case 168:
			/* longJumpIfTrue */
			jumplfTrueBy(((168 & 3) * 256) + (fetchByte()));
			break;
		case 169:
			/* longJumpIfTrue */
			jumplfTrueBy(((169 & 3) * 256) + (fetchByte()));
			break;
		case 170:
			/* longJumpIfTrue */
			jumplfTrueBy(((170 & 3) * 256) + (fetchByte()));
			break;
		case 171:
			/* longJumpIfTrue */
			jumplfTrueBy(((171 & 3) * 256) + (fetchByte()));
			break;
		case 172:
			/* longJumpIfFalse */
			jumplfFalseBy(((172 & 3) * 256) + (fetchByte()));
			break;
		case 173:
			/* longJumpIfFalse */
			jumplfFalseBy(((173 & 3) * 256) + (fetchByte()));
			break;
		case 174:
			/* longJumpIfFalse */
			jumplfFalseBy(((174 & 3) * 256) + (fetchByte()));
			break;
		case 175:
			/* longJumpIfFalse */
			jumplfFalseBy(((175 & 3) * 256) + (fetchByte()));
			break;
		case 176:
			/* bytecodePrimAdd */
			t3 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t3, t1)) {
				t2 = ((t3 >> 1)) + ((t1 >> 1));
				if (isIntegerValue(t2)) {
					longAtput(localSP -= 4, ((t2 << 1) | 1));
					goto l5;
				}
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatAdd();
			if (!(successFlag)) {
				successFlag = true;
				primitiveAdd();
			}
			internalizeIPandSP();
		l5:	/* end case */;
			break;
		case 177:
			/* bytecodePrimSubtract */
			t3 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t3, t1)) {
				t2 = ((t3 >> 1)) - ((t1 >> 1));
				if (isIntegerValue(t2)) {
					longAtput(localSP -= 4, ((t2 << 1) | 1));
					goto l6;
				}
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatSubtract();
			if (!(successFlag)) {
				successFlag = true;
				primitiveSubtract();
			}
			internalizeIPandSP();
		l6:	/* end case */;
			break;
		case 178:
			/* bytecodePrimLessThan */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t2, t1)) {
				booleanCheat(t2 < t1);
				goto l7;
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatLessThan();
			if (!(successFlag)) {
				successFlag = true;
				primitiveLessThan();
			}
			internalizeIPandSP();
		l7:	/* end case */;
			break;
		case 179:
			/* bytecodePrimGreaterThan */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t2, t1)) {
				booleanCheat(t2 > t1);
				goto l8;
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatGreaterThan();
			if (!(successFlag)) {
				successFlag = true;
				primitiveGreaterThan();
			}
			internalizeIPandSP();
		l8:	/* end case */;
			break;
		case 180:
			/* bytecodePrimLessOrEqual */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t2, t1)) {
				booleanCheat(t2 <= t1);
				goto l9;
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatLessOrEqual();
			if (!(successFlag)) {
				successFlag = true;
				primitiveLessOrEqual();
			}
			internalizeIPandSP();
		l9:	/* end case */;
			break;
		case 181:
			/* bytecodePrimGreaterOrEqual */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t2, t1)) {
				booleanCheat(t2 >= t1);
				goto l10;
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatGreaterOrEqual();
			if (!(successFlag)) {
				successFlag = true;
				primitiveGreaterOrEqual();
			}
			internalizeIPandSP();
		l10:	/* end case */;
			break;
		case 182:
			/* bytecodePrimEqual */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t2, t1)) {
				booleanCheat(t2 == t1);
				goto l11;
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatEqual();
			if (!(successFlag)) {
				successFlag = true;
				primitiveEqual();
			}
			internalizeIPandSP();
		l11:	/* end case */;
			break;
		case 183:
			/* bytecodePrimNotEqual */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t2, t1)) {
				booleanCheat(t2 != t1);
				goto l12;
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatNotEqual();
			if (!(successFlag)) {
				successFlag = true;
				primitiveNotEqual();
			}
			internalizeIPandSP();
		l12:	/* end case */;
			break;
		case 184:
			/* bytecodePrimMultiply */
			t3 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t3, t1)) {
				t3 = (t3 >> 1);
				t1 = (t1 >> 1);
				t2 = t3 * t1;
				if (((t1 == 0) || ((t2 / t1) == t3)) && (isIntegerValue(t2))) {
					longAtput(localSP -= 4, ((t2 << 1) | 1));
					goto l13;
				}
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatMultiply();
			if (!(successFlag)) {
				successFlag = true;
				primitiveMultiply();
			}
			internalizeIPandSP();
		l13:	/* end case */;
			break;
		case 185:
			/* bytecodePrimDivide */
			t3 = internalStackValue(1);
			t1 = internalStackValue(0);
			if (areIntegersand(t3, t1)) {
				t3 = (t3 >> 1);
				t1 = (t1 >> 1);
				if ((t1 != 0) && ((t3 % t1) == 0)) {
					t2 = t3 / t1;
					if (isIntegerValue(t2)) {
						longAtput(localSP -= 4, ((t2 << 1) | 1));
						goto l14;
					}
				}
			}
			externalizeIPandSP();
			successFlag = true;
			primitiveFloatDivide();
			if (!(successFlag)) {
				successFlag = true;
				primitiveDivide();
			}
			internalizeIPandSP();
		l14:	/* end case */;
			break;
		case 186:
			/* bytecodePrimMod */
			externalizeIPandSP();
			primitiveMod();
			internalizeIPandSP();
			break;
		case 187:
			/* bytecodePrimMakePoint */
			externalizeIPandSP();
			primitiveMakePoint();
			internalizeIPandSP();
			break;
		case 188:
			/* bytecodePrimBitShift */
			externalizeIPandSP();
			primitiveBitShift();
			internalizeIPandSP();
			break;
		case 189:
			/* bytecodePrimDiv */
			externalizeIPandSP();
			primitiveDiv();
			internalizeIPandSP();
			break;
		case 190:
			/* bytecodePrimBitAnd */
			externalizeIPandSP();
			primitiveBitAnd();
			internalizeIPandSP();
			break;
		case 191:
			/* bytecodePrimBitOr */
			externalizeIPandSP();
			primitiveBitOr();
			internalizeIPandSP();
			break;
		case 192:
			/* bytecodePrimAt */
			t2 = internalStackTop();
			t4 = internalStackValue(1);
			successFlag = (t2 & 1);
			if (successFlag) {
				t5 = fetchClassOf(t4);
				t1 = t5 == (splObj(6));
				if (!(t1 || (okArrayClass(t5)))) {
					successFlag = false;
				}
			}
			if (successFlag) {
				t2 = (t2 >> 1);
				externalizeIPandSP();
				t3 = stObjectat(t4, t2);
				internalizeIPandSP();
				if (t1 && (successFlag)) {
					t3 = characterForAscii(t3);
				}
			}
			if (successFlag) {
				internalPopthenPush(2, t3);
			} else {
				messageSelector = specialSelector(16);
				argumentCount = 1;
				normalSend();
			}
			break;
		case 193:
			/* bytecodePrimAtPut */
			t2 = t3 = internalStackTop();
			t4 = internalStackValue(1);
			t5 = internalStackValue(2);
			successFlag = (t4 & 1);
			if (successFlag) {
				t6 = fetchClassOf(t5);
				t1 = t6 == (splObj(6));
				if (!(t1 || (okArrayClass(t6)))) {
					successFlag = false;
				}
			}
			if (successFlag) {
				t4 = (t4 >> 1);
				if (t1) {
					t3 = asciiOfCharacter(t2);
				}
				stObjectatput(t5, t4, t3);
			}
			if (successFlag) {
				internalPopthenPush(3, t2);
			} else {
				messageSelector = specialSelector(17);
				argumentCount = 2;
				normalSend();
			}
			break;
		case 194:
			/* bytecodePrimSize */
			externalizeIPandSP();
			successFlag = true;
			t1 = fetchClassOf(stackValue(0));
			if (okStreamArrayClass(t1)) {
				primitiveSize();
			} else {
				failSpecialPrim(0);
			}
			internalizeIPandSP();
			break;
		case 195:
			/* bytecodePrimNext */
			messageSelector = specialSelector(19);
			argumentCount = 0;
			normalSend();
			break;
		case 196:
			/* bytecodePrimNextPut */
			messageSelector = specialSelector(20);
			argumentCount = 1;
			normalSend();
			break;
		case 197:
			/* bytecodePrimAtEnd */
			messageSelector = specialSelector(21);
			argumentCount = 0;
			normalSend();
			break;
		case 198:
			/* bytecodePrimEquivalent */
			t2 = internalStackValue(1);
			t1 = internalStackValue(0);
			booleanCheat(t2 == t1);
			break;
		case 199:
			/* bytecodePrimClass */
			externalizeIPandSP();
			primitiveClass();
			internalizeIPandSP();
			break;
		case 200:
			/* bytecodePrimBlockCopy */
			t1 = fetchClassOf(internalStackValue(1));
			successFlag = true;
			success((t1 == (splObj(11))) || (t1 == (splObj(10))));
			if (successFlag) {
				externalizeIPandSP();
				primitiveBlockCopy();
				internalizeIPandSP();
			}
			if (!(successFlag)) {
				messageSelector = specialSelector(24);
				argumentCount = 1;
				normalSend();
				goto l15;
			}
		l15:	/* end case */;
			break;
		case 201:
			/* bytecodePrimValue */
			t1 = internalStackTop();
			successFlag = true;
			argumentCount = 0;
			assertClassOfis(t1, splObj(11));
			if (successFlag) {
				externalizeIPandSP();
				primitiveValue();
				internalizeIPandSP();
			}
			if (!(successFlag)) {
				messageSelector = specialSelector(25);
				argumentCount = 0;
				normalSend();
				goto l16;
			}
		l16:	/* end case */;
			break;
		case 202:
			/* bytecodePrimValueWithArg */
			t1 = internalStackValue(1);
			successFlag = true;
			argumentCount = 1;
			assertClassOfis(t1, splObj(11));
			if (successFlag) {
				externalizeIPandSP();
				primitiveValue();
				internalizeIPandSP();
			}
			if (!(successFlag)) {
				messageSelector = specialSelector(26);
				argumentCount = 1;
				normalSend();
				goto l17;
			}
		l17:	/* end case */;
			break;
		case 203:
			/* bytecodePrimDo */
			messageSelector = specialSelector(27);
			argumentCount = 1;
			normalSend();
			break;
		case 204:
			/* bytecodePrimNew */
			messageSelector = specialSelector(28);
			argumentCount = 0;
			normalSend();
			break;
		case 205:
			/* bytecodePrimNewWithArg */
			messageSelector = specialSelector(29);
			argumentCount = 1;
			normalSend();
			break;
		case 206:
			/* bytecodePrimPointX */
			externalizeIPandSP();
			primitivePointX();
			internalizeIPandSP();
			break;
		case 207:
			/* bytecodePrimPointY */
			externalizeIPandSP();
			primitivePointY();
			internalizeIPandSP();
			break;
		case 208:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(208 & 15);
			argumentCount = ((((unsigned) 208) >> 4) & 3) - 1;
			normalSend();
			break;
		case 209:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(209 & 15);
			argumentCount = ((((unsigned) 209) >> 4) & 3) - 1;
			normalSend();
			break;
		case 210:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(210 & 15);
			argumentCount = ((((unsigned) 210) >> 4) & 3) - 1;
			normalSend();
			break;
		case 211:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(211 & 15);
			argumentCount = ((((unsigned) 211) >> 4) & 3) - 1;
			normalSend();
			break;
		case 212:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(212 & 15);
			argumentCount = ((((unsigned) 212) >> 4) & 3) - 1;
			normalSend();
			break;
		case 213:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(213 & 15);
			argumentCount = ((((unsigned) 213) >> 4) & 3) - 1;
			normalSend();
			break;
		case 214:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(214 & 15);
			argumentCount = ((((unsigned) 214) >> 4) & 3) - 1;
			normalSend();
			break;
		case 215:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(215 & 15);
			argumentCount = ((((unsigned) 215) >> 4) & 3) - 1;
			normalSend();
			break;
		case 216:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(216 & 15);
			argumentCount = ((((unsigned) 216) >> 4) & 3) - 1;
			normalSend();
			break;
		case 217:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(217 & 15);
			argumentCount = ((((unsigned) 217) >> 4) & 3) - 1;
			normalSend();
			break;
		case 218:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(218 & 15);
			argumentCount = ((((unsigned) 218) >> 4) & 3) - 1;
			normalSend();
			break;
		case 219:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(219 & 15);
			argumentCount = ((((unsigned) 219) >> 4) & 3) - 1;
			normalSend();
			break;
		case 220:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(220 & 15);
			argumentCount = ((((unsigned) 220) >> 4) & 3) - 1;
			normalSend();
			break;
		case 221:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(221 & 15);
			argumentCount = ((((unsigned) 221) >> 4) & 3) - 1;
			normalSend();
			break;
		case 222:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(222 & 15);
			argumentCount = ((((unsigned) 222) >> 4) & 3) - 1;
			normalSend();
			break;
		case 223:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(223 & 15);
			argumentCount = ((((unsigned) 223) >> 4) & 3) - 1;
			normalSend();
			break;
		case 224:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(224 & 15);
			argumentCount = ((((unsigned) 224) >> 4) & 3) - 1;
			normalSend();
			break;
		case 225:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(225 & 15);
			argumentCount = ((((unsigned) 225) >> 4) & 3) - 1;
			normalSend();
			break;
		case 226:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(226 & 15);
			argumentCount = ((((unsigned) 226) >> 4) & 3) - 1;
			normalSend();
			break;
		case 227:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(227 & 15);
			argumentCount = ((((unsigned) 227) >> 4) & 3) - 1;
			normalSend();
			break;
		case 228:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(228 & 15);
			argumentCount = ((((unsigned) 228) >> 4) & 3) - 1;
			normalSend();
			break;
		case 229:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(229 & 15);
			argumentCount = ((((unsigned) 229) >> 4) & 3) - 1;
			normalSend();
			break;
		case 230:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(230 & 15);
			argumentCount = ((((unsigned) 230) >> 4) & 3) - 1;
			normalSend();
			break;
		case 231:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(231 & 15);
			argumentCount = ((((unsigned) 231) >> 4) & 3) - 1;
			normalSend();
			break;
		case 232:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(232 & 15);
			argumentCount = ((((unsigned) 232) >> 4) & 3) - 1;
			normalSend();
			break;
		case 233:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(233 & 15);
			argumentCount = ((((unsigned) 233) >> 4) & 3) - 1;
			normalSend();
			break;
		case 234:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(234 & 15);
			argumentCount = ((((unsigned) 234) >> 4) & 3) - 1;
			normalSend();
			break;
		case 235:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(235 & 15);
			argumentCount = ((((unsigned) 235) >> 4) & 3) - 1;
			normalSend();
			break;
		case 236:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(236 & 15);
			argumentCount = ((((unsigned) 236) >> 4) & 3) - 1;
			normalSend();
			break;
		case 237:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(237 & 15);
			argumentCount = ((((unsigned) 237) >> 4) & 3) - 1;
			normalSend();
			break;
		case 238:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(238 & 15);
			argumentCount = ((((unsigned) 238) >> 4) & 3) - 1;
			normalSend();
			break;
		case 239:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(239 & 15);
			argumentCount = ((((unsigned) 239) >> 4) & 3) - 1;
			normalSend();
			break;
		case 240:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(240 & 15);
			argumentCount = ((((unsigned) 240) >> 4) & 3) - 1;
			normalSend();
			break;
		case 241:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(241 & 15);
			argumentCount = ((((unsigned) 241) >> 4) & 3) - 1;
			normalSend();
			break;
		case 242:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(242 & 15);
			argumentCount = ((((unsigned) 242) >> 4) & 3) - 1;
			normalSend();
			break;
		case 243:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(243 & 15);
			argumentCount = ((((unsigned) 243) >> 4) & 3) - 1;
			normalSend();
			break;
		case 244:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(244 & 15);
			argumentCount = ((((unsigned) 244) >> 4) & 3) - 1;
			normalSend();
			break;
		case 245:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(245 & 15);
			argumentCount = ((((unsigned) 245) >> 4) & 3) - 1;
			normalSend();
			break;
		case 246:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(246 & 15);
			argumentCount = ((((unsigned) 246) >> 4) & 3) - 1;
			normalSend();
			break;
		case 247:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(247 & 15);
			argumentCount = ((((unsigned) 247) >> 4) & 3) - 1;
			normalSend();
			break;
		case 248:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(248 & 15);
			argumentCount = ((((unsigned) 248) >> 4) & 3) - 1;
			normalSend();
			break;
		case 249:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(249 & 15);
			argumentCount = ((((unsigned) 249) >> 4) & 3) - 1;
			normalSend();
			break;
		case 250:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(250 & 15);
			argumentCount = ((((unsigned) 250) >> 4) & 3) - 1;
			normalSend();
			break;
		case 251:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(251 & 15);
			argumentCount = ((((unsigned) 251) >> 4) & 3) - 1;
			normalSend();
			break;
		case 252:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(252 & 15);
			argumentCount = ((((unsigned) 252) >> 4) & 3) - 1;
			normalSend();
			break;
		case 253:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(253 & 15);
			argumentCount = ((((unsigned) 253) >> 4) & 3) - 1;
			normalSend();
			break;
		case 254:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(254 & 15);
			argumentCount = ((((unsigned) 254) >> 4) & 3) - 1;
			normalSend();
			break;
		case 255:
			/* sendLiteralSelectorBytecode */
			messageSelector = literal(255 & 15);
			argumentCount = ((((unsigned) 255) >> 4) & 3) - 1;
			normalSend();
			break;
		}
	}
	externalizeIPandSP();
}

int isBytes(int oop) {
	return (formatOf(oop)) >= 8;
}

int isEmptyList(int aLinkedList) {
	return (fetchPointerofObject(0, aLinkedList)) == nilObj;
}

int isFreeObject(int oop) {
	return (headerType(oop)) == 2;
}

int isIntegerObject(int objectPointer) {
	return (objectPointer & 1) > 0;
}

int isIntegerValue(int intValue) {
	return (intValue ^ (intValue << 1)) >= 0;
}

int isObjectForwarded(int oop) {
	return ((oop & 1) == 0) && (((longAt(oop)) & 2147483648U) != 0);
}

int isPointers(int oop) {
	return (formatOf(oop)) <= 4;
}

int isWords(int oop) {
	return (formatOf(oop)) == 6;
}

int isWordsOrBytes(int oop) {
    int fmt;

	fmt = formatOf(oop);
	return (fmt == 6) || ((fmt >= 8) && (fmt <= 11));
}

int jump(int offset) {
	localIP += offset;
}

int jumplfFalseBy(int offset) {
    int boolean;

	boolean = internalStackTop();
	if (boolean == falseObj) {
		jump(offset);
	} else {
		if (!(boolean == trueObj)) {
			messageSelector = splObj(25);
			argumentCount = 0;
			return normalSend();
		}
	}
	internalPop(1);
}

int jumplfTrueBy(int offset) {
    int boolean;

	boolean = internalStackTop();
	if (boolean == trueObj) {
		jump(offset);
	} else {
		if (!(boolean == falseObj)) {
			messageSelector = splObj(25);
			argumentCount = 0;
			return normalSend();
		}
	}
	internalPop(1);
}

int lastPointerOf(int objectPointer) {
    int methodHeader;
    int sz;
    int fmt;

	/* inline: true */;
	fmt = formatOf(objectPointer);
	if (fmt < 4) {
		sz = sizeBitsOfSafe(objectPointer);
		return sz - 4;
	}
	if (fmt < 12) {
		return 0;
	}
	methodHeader = longAt(objectPointer + 4);
	return (((((unsigned) methodHeader) >> 10) & 255) * 4) + 4;
}

int lastPointerWhileForwarding(int oop) {
    int methodHeader;
    int size;
    int fwdBlock;
    int fmt;
    int header;

	/* inline: true */;
	header = longAt(oop);
	if ((header & 2147483648U) != 0) {
		fwdBlock = header & 2147483644;
		if (checkAssertions) {
			fwdBlockValidate(fwdBlock);
		}
		header = longAt(fwdBlock + 4);
	}
	fmt = (((unsigned) header) >> 8) & 15;
	if (fmt < 4) {
		if ((header & 3) == 0) {
			size = (sizeHeader(oop)) & 268435452;
		} else {
			size = header & 252;
		}
		return size - 4;
	}
	if (fmt < 12) {
		return 0;
	}
	methodHeader = longAt(oop + 4);
	return (((((unsigned) methodHeader) >> 10) & 255) * 4) + 4;
}

int lengthOf(int oop) {
    int sz;
    int header;
    int fmt;

	/* inline: true */;
	header = baseHeader(oop);
	if ((header & 3) == 0) {
		sz = (sizeHeader(oop)) & 4294967292U;
	} else {
		sz = header & 252;
	}
	fmt = (((unsigned) header) >> 8) & 15;
	if (fmt < 8) {
		return ((unsigned) (sz - 4)) >> 2;
	} else {
		return (sz - 4) - (fmt & 3);
	}
}

int lengthOfbaseHeaderformat(int oop, int hdr, int fmt) {
    int sz;

	/* inline: true */;
	if ((hdr & 3) == 0) {
		sz = (sizeHeader(oop)) & 4294967292U;
	} else {
		sz = hdr & 252;
	}
	if (fmt < 8) {
		return ((unsigned) (sz - 4)) >> 2;
	} else {
		return (sz - 4) - (fmt & 3);
	}
}

int literal(int offset) {
	return literalofMethod(offset, method);
}

int literalofMethod(int offset, int methodPointer) {
	return fetchPointerofObject(offset + 1, methodPointer);
}

int literalCountOf(int methodPointer) {
	return literalCountOfHeader(headerOf(methodPointer));
}

int literalCountOfHeader(int headerPointer) {
	return (((unsigned) headerPointer) >> 10) & 255;
}

int loadBitBltFrom(int bbObj) {
    int destBitsSize;
    int destWidth;
    int destHeight;
    int sourceBitsSize;
    int sourcePixPerWord;
    int halftoneBits;
    int cmSize;

	bitBltOop = bbObj;
	combinationRule = fetchIntegerofObject(3, bitBltOop);
	if ((failed()) || ((combinationRule < 0) || (combinationRule > 33))) {
		return false;
	}
	if ((combinationRule >= 16) && (combinationRule <= 17)) {
		return false;
	}
	sourceForm = fetchPointerofObject(1, bitBltOop);
	noSource = ignoreSourceOrHalftone(sourceForm);
	halftoneForm = fetchPointerofObject(2, bitBltOop);
	noHalftone = ignoreSourceOrHalftone(halftoneForm);
	destForm = fetchPointerofObject(0, bitBltOop);
	if (!((isPointers(destForm)) && ((lengthOf(destForm)) >= 4))) {
		return false;
	}
	destBits = fetchPointerofObject(0, destForm);
	destBitsSize = byteLengthOf(destBits);
	destWidth = fetchIntegerofObject(1, destForm);
	destHeight = fetchIntegerofObject(2, destForm);
	if (!((destWidth >= 0) && (destHeight >= 0))) {
		return false;
	}
	destPixSize = fetchIntegerofObject(3, destForm);
	pixPerWord = 32 / destPixSize;
	destRaster = (destWidth + (pixPerWord - 1)) / pixPerWord;
	if (!((isWordsOrBytes(destBits)) && (destBitsSize == ((destRaster * destHeight) * 4)))) {
		return false;
	}
	destX = fetchIntegerOrTruncFloatofObject(4, bitBltOop);
	destY = fetchIntegerOrTruncFloatofObject(5, bitBltOop);
	width = fetchIntegerOrTruncFloatofObject(6, bitBltOop);
	height = fetchIntegerOrTruncFloatofObject(7, bitBltOop);
	if (failed()) {
		return false;
	}
	if (noSource) {
		sourceX = sourceY = 0;
	} else {
		if (!((isPointers(sourceForm)) && ((lengthOf(sourceForm)) >= 4))) {
			return false;
		}
		sourceBits = fetchPointerofObject(0, sourceForm);
		sourceBitsSize = byteLengthOf(sourceBits);
		srcWidth = fetchIntegerOrTruncFloatofObject(1, sourceForm);
		srcHeight = fetchIntegerOrTruncFloatofObject(2, sourceForm);
		if (!((srcWidth >= 0) && (srcHeight >= 0))) {
			return false;
		}
		sourcePixSize = fetchIntegerofObject(3, sourceForm);
		sourcePixPerWord = 32 / sourcePixSize;
		sourceRaster = (srcWidth + (sourcePixPerWord - 1)) / sourcePixPerWord;
		if (!((isWordsOrBytes(sourceBits)) && (sourceBitsSize == ((sourceRaster * srcHeight) * 4)))) {
			return false;
		}
		colorMap = fetchPointerofObject(14, bitBltOop);
		if (!(colorMap == (nilObject()))) {
			if (isWords(colorMap)) {
				cmSize = lengthOf(colorMap);
				cmBitsPerColor = 0;
				if (cmSize == 512) {
					cmBitsPerColor = 3;
				}
				if (cmSize == 4096) {
					cmBitsPerColor = 4;
				}
				if (cmSize == 32768) {
					cmBitsPerColor = 5;
				}
				if ((primIndex()) != 147) {
					if (sourcePixSize <= 8) {
						if (!(cmSize == (1 << sourcePixSize))) {
							return false;
						}
					} else {
						if (cmBitsPerColor == 0) {
							return false;
						}
					}
				}
			} else {
				return false;
			}
		}
		sourceX = fetchIntegerOrTruncFloatofObject(8, bitBltOop);
		sourceY = fetchIntegerOrTruncFloatofObject(9, bitBltOop);
	}
	if (!(noHalftone)) {
		if ((isPointers(halftoneForm)) && ((lengthOf(halftoneForm)) >= 4)) {
			halftoneBits = fetchPointerofObject(0, halftoneForm);
			halftoneHeight = fetchIntegerofObject(2, halftoneForm);
			if (!(isWords(halftoneBits))) {
				noHalftone = true;
			}
		} else {
			if (!((!(isPointers(halftoneForm))) && (isWords(halftoneForm)))) {
				return false;
			}
			halftoneBits = halftoneForm;
			halftoneHeight = lengthOf(halftoneBits);
		}
		halftoneBase = halftoneBits + 4;
	}
	clipX = fetchIntegerOrTruncFloatofObject(10, bitBltOop);
	clipY = fetchIntegerOrTruncFloatofObject(11, bitBltOop);
	clipWidth = fetchIntegerOrTruncFloatofObject(12, bitBltOop);
	clipHeight = fetchIntegerOrTruncFloatofObject(13, bitBltOop);
	if (failed()) {
		return false;
	}
	if (clipX < 0) {
		clipWidth += clipX;
		clipX = 0;
	}
	if (clipY < 0) {
		clipHeight += clipY;
		clipY = 0;
	}
	if ((clipX + clipWidth) > destWidth) {
		clipWidth = destWidth - clipX;
	}
	if ((clipY + clipHeight) > destHeight) {
		clipHeight = destHeight - clipY;
	}
	return true;
}

int loadInitialContext(void) {
    int sched;
    int proc;

	sched = fetchPointerofObject(1, splObj(3));
	proc = fetchPointerofObject(1, sched);
	activeContext = fetchPointerofObject(1, proc);
	if (activeContext < youngStart) {
		beRootIfOld(activeContext);
	}
	fetchContextRegisters(activeContext);
	reclaimableContextCount = 0;
}

int loadScannerFromstartstopstringrightXstopArraydisplayFlag(int bbObj, int start, int stop, int string, int rightX, int stopArray, int displayFlag) {
	/* inline: false */;
	scanStart = start;
	scanStop = stop;
	scanString = string;
	scanRightX = rightX;
	scanStopArray = stopArray;
	scanDisplayFlag = displayFlag;
	success((isPointers(scanStopArray)) && ((lengthOf(scanStopArray)) >= 1));
	scanXTable = fetchPointerofObject(16, bbObj);
	success((isPointers(scanXTable)) && ((lengthOf(scanXTable)) >= 1));
	storeIntegerofObjectwithValue(6, bbObj, 0);
	storeIntegerofObjectwithValue(8, bbObj, 0);
	if (scanDisplayFlag) {
		success(loadBitBltFrom(bbObj));
	} else {
		bitBltOop = bbObj;
		destX = fetchIntegerOrTruncFloatofObject(4, bbObj);
	}
	return !(failed());
}

int longJumpIfFalse(void) {
	jumplfFalseBy(((currentBytecode & 3) * 256) + (fetchByte()));
}

int longJumpIfTrue(void) {
	jumplfTrueBy(((currentBytecode & 3) * 256) + (fetchByte()));
}

int longUnconditionalJump(void) {
    int offset;

	offset = (((currentBytecode & 7) - 4) * 256) + (fetchByte());
	localIP += offset;
	if (offset < 0) {
		internalQuickCheckForInterrupts();
	}
}

int lookupInMethodCacheSelclass(int selector, int class) {
    int probe;
    int p;
    int hash;

	/* inline: true */;
	hash = ((unsigned) (selector ^ class)) >> 2;
	probe = (hash & 511) + 1;
	for (p = 1; p <= 3; p += 1) {
		if (((methodCache[probe]) == selector) && ((methodCache[probe + 512]) == class)) {
			newMethod = methodCache[probe + (512 * 2)];
			primitiveIndex = methodCache[probe + (512 * 3)];
			return true;
		}
		probe = ((((unsigned) hash) >> p) & 511) + 1;
	}
	return false;
}

int lookupMethodInClass(int class) {
    int dictionary;
    int currentClass;
    int found;
    int rclass;

	currentClass = class;
	while (currentClass != nilObj) {
		dictionary = fetchPointerofObject(1, currentClass);
		found = lookupMethodInDictionary(dictionary);
		if (found) {
			return currentClass;
		}
		currentClass = superclassOf(currentClass);
	}
	if (messageSelector == (splObj(20))) {
		error("Recursive not understood error encountered");
	}
	pushRemappableOop(class);
	createActualMessage();
	rclass = popRemappableOop();
	messageSelector = splObj(20);
	return lookupMethodInClass(rclass);
}

int lookupMethodInDictionary(int dictionary) {
    int methodArray;
    int mask;
    int wrapAround;
    int nextSelector;
    int index;
    int length;

	/* inline: true */;
	length = fetchWordLengthOf(dictionary);
	mask = (length - 2) - 1;
	if ((messageSelector & 1)) {
		index = (mask & ((messageSelector >> 1))) + 2;
	} else {
		index = (mask & (hashBitsOf(messageSelector))) + 2;
	}
	wrapAround = false;
	while (true) {
		nextSelector = fetchPointerofObject(index, dictionary);
		if (nextSelector == nilObj) {
			return false;
		}
		if (nextSelector == messageSelector) {
			methodArray = fetchPointerofObject(1, dictionary);
			newMethod = fetchPointerofObject(index - 2, methodArray);
			primitiveIndex = primitiveIndexOf(newMethod);
			return true;
		}
		index += 1;
		if (index == length) {
			if (wrapAround) {
				return false;
			}
			wrapAround = true;
			index = 2;
		}
	}
}

int lowestFreeAfter(int chunk) {
    int oopHeader;
    int oop;
    int oopHeaderType;
    int oopSize;

	/* inline: false */;
	oop = oopFromChunk(chunk);
	while (oop < endOfMemory) {
		oopHeader = baseHeader(oop);
		oopHeaderType = oopHeader & 3;
		if (oopHeaderType == 2) {
			return oop;
		} else {
			if (oopHeaderType == 0) {
				oopSize = (sizeHeader(oop)) & 4294967292U;
			} else {
				oopSize = oopHeader & 252;
			}
		}
		oop = oopFromChunk(oop + oopSize);
	}
	error("expected to find at least one free object");
}

int makeDirEntryNamesizecreateDatemodDateisDirfileSize(char *entryName, int entryNameSize, int createDate, int modifiedDate, int dirFlag, int fileSize) {
    int modDateOop;
    int i;
    int nameString;
    int createDateOop;
    int results;

	pushRemappableOop(instantiateClassindexableSize(splObj(7), 5));
	pushRemappableOop(instantiateClassindexableSize(splObj(6), entryNameSize));
	pushRemappableOop(positive32BitIntegerFor(createDate));
	pushRemappableOop(positive32BitIntegerFor(modifiedDate));
	modDateOop = popRemappableOop();
	createDateOop = popRemappableOop();
	nameString = popRemappableOop();
	results = popRemappableOop();
	for (i = 0; i <= (entryNameSize - 1); i += 1) {
		storeByteofObjectwithValue(i, nameString, entryName[i]);
	}
	storePointerofObjectwithValue(0, results, nameString);
	storePointerofObjectwithValue(1, results, createDateOop);
	storePointerofObjectwithValue(2, results, modDateOop);
	if (dirFlag) {
		storePointerofObjectwithValue(3, results, trueObj);
	} else {
		storePointerofObjectwithValue(3, results, falseObj);
	}
	storePointerofObjectwithValue(4, results, ((fileSize << 1) | 1));
	return results;
}

int makePointwithxValueyValue(int xValue, int yValue) {
    int pointResult;

	pointResult = instantiateSmallClasssizeInBytesfill(splObj(12), 12, nilObj);
	storePointerofObjectwithValue(0, pointResult, ((xValue << 1) | 1));
	storePointerofObjectwithValue(1, pointResult, ((yValue << 1) | 1));
	return pointResult;
}

int mapInterpreterOops(void) {
    int i;
    int oop;

	nilObj = remap(nilObj);
	falseObj = remap(falseObj);
	trueObj = remap(trueObj);
	specialObjectsOop = remap(specialObjectsOop);
	stackPointer -= activeContext;
	activeContext = remap(activeContext);
	stackPointer += activeContext;
	theHomeContext = remap(theHomeContext);
	instructionPointer -= method;
	method = remap(method);
	instructionPointer += method;
	receiver = remap(receiver);
	messageSelector = remap(messageSelector);
	newMethod = remap(newMethod);
	for (i = 1; i <= remapBufferCount; i += 1) {
		oop = remapBuffer[i];
		if (!((oop & 1))) {
			remapBuffer[i] = (remap(oop));
		}
	}
	flushMethodCache();
}

int mapPointersInObjectsFromto(int memStart, int memEnd) {
    int oop;
    int i;

	/* inline: false */;
	mapInterpreterOops();
	for (i = 1; i <= rootTableCount; i += 1) {
		oop = rootTable[i];
		if ((oop < memStart) || (oop >= memEnd)) {
			remapFieldsAndClassOf(oop);
		}
	}
	oop = oopFromChunk(memStart);
	while (oop < memEnd) {
		if (!(isFreeObject(oop))) {
			remapFieldsAndClassOf(oop);
		}
		oop = objectAfterWhileForwarding(oop);
	}
}

int markAndTrace(int oop) {
    int action;
    int lastFieldOffset;
    int header;

	header = longAt(oop);
	header = (header & 4294967292U) | 2;
	if (oop >= youngStart) {
		header = header | 2147483648U;
	}
	longAtput(oop, header);
	parentField = 3;
	child = oop;
	lastFieldOffset = lastPointerOf(oop);
	field = oop + lastFieldOffset;
	action = 1;
	while (!(action == 4)) {
		if (action == 1) {
			action = startField();
		}
		if (action == 2) {
			action = startObj();
		}
		if (action == 3) {
			action = upward();
		}
	}
}

int markAndTraceInterpreterOops(void) {
    int i;
    int oop;

	markAndTrace(specialObjectsOop);
	markAndTrace(activeContext);
	markAndTrace(messageSelector);
	markAndTrace(newMethod);
	for (i = 1; i <= remapBufferCount; i += 1) {
		oop = remapBuffer[i];
		if (!((oop & 1))) {
			markAndTrace(oop);
		}
	}
}

int markPhase(void) {
    int oop;
    int i;

	/* inline: false */;
	freeSmallContexts = 1;
	freeLargeContexts = 1;
	markAndTraceInterpreterOops();
	for (i = 1; i <= rootTableCount; i += 1) {
		oop = rootTable[i];
		if (!((oop & 1))) {
			markAndTrace(oop);
		}
	}
}

int mergewith(int sourceWord, int destinationWord) {
    int (*mergeFnwith)(int, int);

	mergeFnwith = ((int (*)(int, int)) (opTable[combinationRule + 1]));
	mergeFnwith;
	return mergeFnwith(sourceWord, destinationWord);
}

int methodClassOf(int methodPointer) {
	return fetchPointerofObject(1, literalofMethod((literalCountOf(methodPointer)) - 1, methodPointer));
}

int netAddressToInt(int oop) {
    int sz;

	assertClassOfis(oop, splObj(26));
	if (successFlag) {
		sz = lengthOf(oop);
		if (!(sz == 4)) {
			return primitiveFail();
		}
	}
	if (successFlag) {
		return (((fetchByteofObject(3, oop)) + ((fetchByteofObject(2, oop)) << 8)) + ((fetchByteofObject(1, oop)) << 16)) + ((fetchByteofObject(0, oop)) << 24);
	}
}

int newActiveContext(int aContext) {
	storeContextRegisters(activeContext);
	if (aContext < youngStart) {
		beRootIfOld(aContext);
	}
	activeContext = aContext;
	fetchContextRegisters(aContext);
}

int newObjectHash(void) {
	lastHash = (13849 + (27181 * lastHash)) & 65535;
	return lastHash;
}

int nilObject(void) {
	return nilObj;
}

int normalSend(void) {
    int rcvrClass;

	/* inline: true */;
	/* common code: commonSend */;
	rcvrClass = fetchClassOf(internalStackValue(argumentCount));
	externalizeIPandSP();
	sendSelectorToClass(rcvrClass);
	internalizeIPandSP();
}

int objectAfter(int oop) {
    int sz;

	/* inline: true */;
	if (checkAssertions) {
		if (oop >= endOfMemory) {
			error("no objects after the end of memory");
		}
	}
	if (isFreeObject(oop)) {
		sz = sizeOfFree(oop);
	} else {
		sz = sizeBitsOf(oop);
	}
	return oopFromChunk(oop + sz);
}

int objectAfterWhileForwarding(int oop) {
    int sz;
    int fwdBlock;
    int realHeader;
    int header;

	/* inline: true */;
	header = longAt(oop);
	if ((header & 2147483648U) == 0) {
		return objectAfter(oop);
	}
	fwdBlock = header & 2147483644;
	if (checkAssertions) {
		fwdBlockValidate(fwdBlock);
	}
	realHeader = longAt(fwdBlock + 4);
	if ((realHeader & 3) == 0) {
		sz = (sizeHeader(oop)) & 268435452;
	} else {
		sz = realHeader & 252;
	}
	return oopFromChunk(oop + sz);
}

int okArrayClass(int cl) {
	return (cl == (splObj(7))) || ((cl == (splObj(4))) || (cl == (splObj(26))));
}

int okStreamArrayClass(int cl) {
	return (cl == (splObj(6))) || ((cl == (splObj(7))) || ((cl == (splObj(26))) || (cl == (splObj(4)))));
}

int okayActiveProcessStack(void) {
    int cntxt;

	cntxt = activeContext;
	while (!(cntxt == nilObj)) {
		okayFields(cntxt);
		cntxt = fetchPointerofObject(0, cntxt);
	}
}

int okayFields(int oop) {
    int i;
    int fieldOop;

	if ((oop == null) || (oop == 0)) {
		return true;
	}
	if ((oop & 1)) {
		return true;
	}
	okayOop(oop);
	oopHasOkayClass(oop);
	if (!(isPointers(oop))) {
		return true;
	}
	i = (lengthOf(oop)) - 1;
	while (i >= 0) {
		fieldOop = fetchPointerofObject(i, oop);
		if (!((fieldOop & 1))) {
			okayOop(fieldOop);
			oopHasOkayClass(fieldOop);
		}
		i -= 1;
	}
}

int okayInterpreterObjects(void) {
    int i;
    int oop;
    int oopOrZero;

	okayFields(nilObj);
	okayFields(falseObj);
	okayFields(trueObj);
	okayFields(specialObjectsOop);
	okayFields(activeContext);
	okayFields(method);
	okayFields(receiver);
	okayFields(theHomeContext);
	okayFields(messageSelector);
	okayFields(newMethod);
	for (i = 1; i <= 512; i += 1) {
		oopOrZero = methodCache[i];
		if (!(oopOrZero == 0)) {
			okayFields(methodCache[i]);
			okayFields(methodCache[i + 512]);
			okayFields(methodCache[i + (2 * 512)]);
		}
	}
	for (i = 1; i <= remapBufferCount; i += 1) {
		oop = remapBuffer[i];
		if (!((oop & 1))) {
			okayFields(oop);
		}
	}
	okayActiveProcessStack();
}

int okayOop(int oop) {
    int sz;
    int type;
    int fmt;

	if ((oop & 1)) {
		return true;
	}
	if (!((0 < oop) && (oop < endOfMemory))) {
		error("oop is not a valid address");
	}
	if (!((oop % 4) == 0)) {
		error("oop is not a word-aligned address");
	}
	sz = sizeBitsOf(oop);
	if (!((oop + sz) < endOfMemory)) {
		error("oop size would make it extend beyond the end of memory");
	}
	type = headerType(oop);
	if (type == 2) {
		error("oop is a free chunk, not an object");
	}
	if (type == 3) {
		if (((((unsigned) (baseHeader(oop))) >> 12) & 31) == 0) {
			error("cannot have zero compact class field in a short header");
		}
	}
	if (type == 1) {
		if (!((oop >= 4) && ((headerType(oop - 4)) == type))) {
			error("class header word has wrong type");
		}
	}
	if (type == 0) {
		if (!((oop >= 8) && (((headerType(oop - 8)) == type) && ((headerType(oop - 4)) == type)))) {
			error("class header word has wrong type");
		}
	}
	fmt = formatOf(oop);
	if (((fmt == 4) || (fmt == 5)) || (fmt == 7)) {
		error("oop has an unknown format type");
	}
	if (!(((longAt(oop)) & 536870912) == 0)) {
		error("unused header bit 30 is set; should be zero");
	}
	if ((((longAt(oop)) & 1073741824) == 1) && (oop >= youngStart)) {
		error("root bit is set in a young object");
	}
	return true;
}

int oopFromChunk(int chunk) {
    int extra;

	extra = extraHeaderBytes(chunk);
	return chunk + extra;
}

int oopHasOkayClass(int oop) {
    int behaviorFormatBits;
    int oopClass;
    int formatMask;
    int oopFormatBits;

	okayOop(oop);
	oopClass = fetchClassOf(oop);
	if ((oopClass & 1)) {
		error("a SmallInteger is not a valid class or behavior");
	}
	okayOop(oopClass);
	if (!((isPointers(oopClass)) && ((lengthOf(oopClass)) >= 3))) {
		error("a class (behavior) must be a pointers object of size >= 3");
	}
	if (isBytes(oop)) {
		formatMask = 3072;
	} else {
		formatMask = 3840;
	}
	behaviorFormatBits = (formatOfClass(oopClass)) & formatMask;
	oopFormatBits = (baseHeader(oop)) & formatMask;
	if (!(behaviorFormatBits == oopFormatBits)) {
		error("object and its class (behavior) formats differ");
	}
	return true;
}

int partitionedANDtonBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int mask;
    int i;
    int result;

	mask = (1 << nBits) - 1;
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		if ((word1 & mask) == mask) {
			result = result | (word2 & mask);
		}
		mask = mask << nBits;
	}
	return result;
}

int partitionedAddtonBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int mask;
    int sum;
    int i;
    int result;

	mask = (1 << nBits) - 1;
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		sum = (word1 & mask) + (word2 & mask);
		if (sum <= mask) {
			result = result | sum;
		} else {
			result = result | mask;
		}
		mask = mask << nBits;
	}
	return result;
}

int partitionedMaxwithnBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int mask;
    int i;
    int result;

	mask = (1 << nBits) - 1;
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		result = result | ((((word2 & mask) < (word1 & mask)) ? (word1 & mask) : (word2 & mask)));
		mask = mask << nBits;
	}
	return result;
}

int partitionedMinwithnBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int mask;
    int i;
    int result;

	mask = (1 << nBits) - 1;
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		result = result | ((((word2 & mask) < (word1 & mask)) ? (word2 & mask) : (word1 & mask)));
		mask = mask << nBits;
	}
	return result;
}

int partitionedSubfromnBitsnPartitions(int word1, int word2, int nBits, int nParts) {
    int mask;
    int i;
    int p1;
    int p2;
    int result;

	mask = (1 << nBits) - 1;
	result = 0;
	for (i = 1; i <= nParts; i += 1) {
		p1 = word1 & mask;
		p2 = word2 & mask;
		if (p1 < p2) {
			result = result | (p2 - p1);
		} else {
			result = result | (p1 - p2);
		}
		mask = mask << nBits;
	}
	return result;
}

int pickSourcePixelsnullMapsrcMaskdestMask(int nPix, int nullMap, int sourcePixMask, int destPixMask) {
	/* inline: true */;
	if (sourcePixSize >= 16) {
		return pickSourcePixelsRGBnullMapsrcMaskdestMask(nPix, nullMap, sourcePixMask, destPixMask);
	}
	if (nullMap) {
		return pickSourcePixelsNullMapsrcMaskdestMask(nPix, sourcePixMask, destPixMask);
	}
	return pickSourcePixelssrcMaskdestMask(nPix, sourcePixMask, destPixMask);
}

int pickSourcePixelssrcMaskdestMask(int nPix, int sourcePixMask, int destPixMask) {
    int sourceWord;
    int destWord;
    int sourcePix;
    int destPix;
    int i;

	/* inline: false */;
	sourceWord = longAt(sourceIndex);
	destWord = 0;
	for (i = 1; i <= nPix; i += 1) {
		sourcePix = (((unsigned) sourceWord) >> ((32 - sourcePixSize) - srcBitIndex)) & sourcePixMask;
		destPix = (fetchWordofObject(sourcePix, colorMap)) & destPixMask;
		destWord = (destWord << destPixSize) | destPix;
		if ((srcBitIndex += sourcePixSize) > 31) {
			srcBitIndex -= 32;
			sourceIndex += 4;
			sourceWord = longAt(sourceIndex);
		}
	}
	return destWord;
}

int pickSourcePixelsNullMapsrcMaskdestMask(int nPix, int sourcePixMask, int destPixMask) {
    int sourceWord;
    int destWord;
    int sourcePix;
    int i;

	/* inline: false */;
	sourceWord = longAt(sourceIndex);
	destWord = 0;
	for (i = 1; i <= nPix; i += 1) {
		sourcePix = (((unsigned) sourceWord) >> ((32 - sourcePixSize) - srcBitIndex)) & sourcePixMask;
		destWord = (destWord << destPixSize) | (sourcePix & destPixMask);
		if ((srcBitIndex += sourcePixSize) > 31) {
			srcBitIndex -= 32;
			sourceIndex += 4;
			sourceWord = longAt(sourceIndex);
		}
	}
	return destWord;
}

int pickSourcePixelsRGBnullMapsrcMaskdestMask(int nPix, int nullMap, int sourcePixMask, int destPixMask) {
    int sourceWord;
    int destWord;
    int sourcePix;
    int destPix;
    int i;

	/* inline: false */;
	sourceWord = longAt(sourceIndex);
	destWord = 0;
	for (i = 1; i <= nPix; i += 1) {
		sourcePix = (((unsigned) sourceWord) >> ((32 - sourcePixSize) - srcBitIndex)) & sourcePixMask;
		if (nullMap) {
			if (sourcePixSize == 16) {
				destPix = rgbMapfromto(sourcePix, 5, 8);
			} else {
				destPix = rgbMapfromto(sourcePix, 8, 5);
			}
		} else {
			if (sourcePixSize == 16) {
				sourcePix = rgbMapfromto(sourcePix, 5, cmBitsPerColor);
			} else {
				sourcePix = rgbMapfromto(sourcePix, 8, cmBitsPerColor);
			}
			destPix = (fetchWordofObject(sourcePix, colorMap)) & destPixMask;
		}
		destWord = (destWord << destPixSize) | destPix;
		if ((srcBitIndex += sourcePixSize) > 31) {
			srcBitIndex -= 32;
			sourceIndex += 4;
			sourceWord = longAt(sourceIndex);
		}
	}
	return destWord;
}

int pixMaskwith(int sourceWord, int destinationWord) {
	/* inline: false */;
	return partitionedANDtonBitsnPartitions(~sourceWord, destinationWord, destPixSize, pixPerWord);
}

int pixPaintwith(int sourceWord, int destinationWord) {
	/* inline: false */;
	if (sourceWord == 0) {
		return destinationWord;
	}
	return sourceWord | (partitionedANDtonBitsnPartitions(~sourceWord, destinationWord, destPixSize, pixPerWord));
}

int pop(int nItems) {
	stackPointer -= nItems * 4;
}

int popthenPush(int nItems, int oop) {
    int sp;

	longAtput(sp = stackPointer - ((nItems - 1) * 4), oop);
	stackPointer = sp;
}

double popFloat(void) {
    int top;
    double result;

	top = popStack();
	assertClassOfis(top, splObj(9));
	if (successFlag) {
		fetchFloatAtinto(top + 4, result);
	}
	return result;
}

int popInteger(void) {
    int integerPointer;

	integerPointer = popStack();
	if ((integerPointer & 1)) {
		return (integerPointer >> 1);
	} else {
		successFlag = false;
		return 1;
	}
}

int popPos32BitInteger(void) {
    int top;

	top = popStack();
	return positive32BitValueOf(top);
}

int popRemappableOop(void) {
    int oop;

	oop = remapBuffer[remapBufferCount];
	remapBufferCount -= 1;
	return oop;
}

int popStack(void) {
    int top;

	top = longAt(stackPointer);
	stackPointer -= 4;
	return top;
}

int popStackBytecode(void) {
	internalPop(1);
}

int positive32BitIntegerFor(int integerValue) {
    int newLargeInteger;

	if ((integerValue >= 0) && (isIntegerValue(integerValue))) {
		return ((integerValue << 1) | 1);
	}
	newLargeInteger = instantiateSmallClasssizeInBytesfill(splObj(13), 8, 0);
	storeByteofObjectwithValue(3, newLargeInteger, (((unsigned) integerValue) >> 24) & 255);
	storeByteofObjectwithValue(2, newLargeInteger, (((unsigned) integerValue) >> 16) & 255);
	storeByteofObjectwithValue(1, newLargeInteger, (((unsigned) integerValue) >> 8) & 255);
	storeByteofObjectwithValue(0, newLargeInteger, integerValue & 255);
	return newLargeInteger;
}

int positive32BitValueOf(int oop) {
    int sz;
    int value;

	if ((oop & 1)) {
		value = (oop >> 1);
		if (value < 0) {
			return primitiveFail();
		}
		return value;
	}
	assertClassOfis(oop, splObj(13));
	if (successFlag) {
		sz = lengthOf(oop);
		if (!(sz == 4)) {
			return primitiveFail();
		}
	}
	if (successFlag) {
		return (((fetchByteofObject(0, oop)) + ((fetchByteofObject(1, oop)) << 8)) + ((fetchByteofObject(2, oop)) << 16)) + ((fetchByteofObject(3, oop)) << 24);
	}
}

int possibleRootStoreIntovalue(int oop, int valueObj) {
    int header;

	/* inline: false */;
	if ((valueObj >= youngStart) && (!((valueObj & 1)))) {
		header = longAt(oop);
		if ((header & 1073741824) == 0) {
			if (rootTableCount < 1000) {
				rootTableCount += 1;
				rootTable[rootTableCount] = oop;
				longAtput(oop, header | 1073741824);
			}
		}
	}
}

int postGCAction(void) {
	if (activeContext < youngStart) {
		beRootIfOld(activeContext);
	}
	if (theHomeContext < youngStart) {
		beRootIfOld(theHomeContext);
	}
}

int preGCAction(int fullGCFlag) {
}

int prepareForwardingTableForBecomingwith(int array1, int array2) {
    int entriesAvailable;
    int fwdBlock;
    int fieldOffset;
    int oop1;
    int oop2;
    int entriesNeeded;

	entriesNeeded = 2 * (((int) (lastPointerOf(array1)) >> 2));
	entriesAvailable = fwdTableInit();
	if (entriesAvailable < entriesNeeded) {
		initializeMemoryFirstFree(freeBlock);
		return false;
	}
	fieldOffset = lastPointerOf(array1);
	while (fieldOffset >= 4) {
		oop1 = longAt(array1 + fieldOffset);
		oop2 = longAt(array2 + fieldOffset);
		fwdBlock = fwdBlockGet();
		initForwardBlockmappingto(fwdBlock, oop1, oop2);
		fwdBlock = fwdBlockGet();
		initForwardBlockmappingto(fwdBlock, oop2, oop1);
		fieldOffset -= 4;
	}
	return true;
}

int primIndex(void) {
	return primitiveIndex;
}

int primitiveAdd(void) {
    int arg;
    int result;
    int rcvr;

	rcvr = stackValue(1);
	arg = stackValue(0);
	pop(2);
	success(areIntegersand(rcvr, arg));
	if (successFlag) {
		result = ((rcvr >> 1)) + ((arg >> 1));
	}
	checkIntegerResultfrom(result, 1);
}

int primitiveArctan(void) {
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		pushFloat(atan(rcvr));
	} else {
		unPop(1);
	}
}

int primitiveArrayBecome(void) {
    int arg;
    int rcvr;

	arg = popStack();
	rcvr = stackTop();
	success(becomewith(rcvr, arg));
	flushMethodCache();
	if (!(successFlag)) {
		unPop(1);
	}
}

int primitiveAsFloat(void) {
    int arg;

	arg = popInteger();
	if (successFlag) {
		pushFloat(((double) arg));
	} else {
		unPop(1);
	}
}

int primitiveAsOop(void) {
    int thisReceiver;

	thisReceiver = popStack();
	success(!((thisReceiver & 1)));
	if (successFlag) {
		pushInteger(hashBitsOf(thisReceiver));
	} else {
		unPop(1);
	}
}

int primitiveAsyncFileClose(void) {
    AsyncFile *f;

	f = asyncFileValueOf(stackTop());
	if (successFlag) {
		asyncFileClose(f);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveAsyncFileOpen(void) {
    AsyncFile *f;
    int semaIndex;
    int writeFlag;
    int fileName;
    int fmt;
    int fileNameSize;
    int fOop;

	semaIndex = stackIntegerValue(0);
	writeFlag = booleanValueOf(stackValue(1));
	fileName = stackObjectValue(2);
	if (!(successFlag)) {
		return null;
	}
	fmt = formatOf(fileName);
	success((fmt >= 8) && (fmt <= 11));
	fileNameSize = lengthOf(fileName);
	if (successFlag) {
		fOop = instantiateClassindexableSize(splObj(26), sizeof(AsyncFile));
		f = asyncFileValueOf(fOop);
	}
	if (successFlag) {
		asyncFileOpen(f, fileName + 4, fileNameSize, writeFlag, semaIndex);
	}
	if (successFlag) {
		pop(4);
		push(fOop);
	}
}

int primitiveAsyncFileReadResult(void) {
    AsyncFile *f;
    int startIndex;
    int buffer;
    int bufferPtr;
    int bufferSize;
    int count;
    int fmt;
    int r;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	buffer = stackObjectValue(2);
	f = asyncFileValueOf(stackValue(3));
	if (!(successFlag)) {
		return null;
	}
	fmt = formatOf(buffer);
	success((fmt == 6) || ((fmt >= 8) && (fmt <= 11)));
	bufferSize = lengthOf(buffer);
	if (fmt == 6) {
		count = count * 4;
		startIndex = ((startIndex - 1) * 4) + 1;
		bufferSize = bufferSize * 4;
	}
	success((startIndex >= 1) && (((startIndex + count) - 1) <= bufferSize));
	bufferPtr = ((buffer + 4) + startIndex) - 1;
	if (successFlag) {
		r = asyncFileReadResult(f, bufferPtr, count);
	}
	if (successFlag) {
		pop(5);
		pushInteger(r);
	}
}

int primitiveAsyncFileReadStart(void) {
    AsyncFile *f;
    int fPosition;
    int count;

	count = stackIntegerValue(0);
	fPosition = stackIntegerValue(1);
	f = asyncFileValueOf(stackValue(2));
	if (successFlag) {
		asyncFileReadStart(f, fPosition, count);
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveAsyncFileWriteResult(void) {
    AsyncFile *f;
    int r;

	f = asyncFileValueOf(stackTop());
	if (successFlag) {
		r = asyncFileWriteResult(f);
	}
	if (successFlag) {
		pop(2);
		pushInteger(r);
	}
}

int primitiveAsyncFileWriteStart(void) {
    AsyncFile *f;
    int startIndex;
    int buffer;
    int bufferPtr;
    int bufferSize;
    int count;
    int fPosition;
    int fmt;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	buffer = stackObjectValue(2);
	fPosition = stackIntegerValue(3);
	f = asyncFileValueOf(stackValue(4));
	if (!(successFlag)) {
		return null;
	}
	fmt = formatOf(buffer);
	success((fmt == 6) || ((fmt >= 8) && (fmt <= 11)));
	bufferSize = lengthOf(buffer);
	if (fmt == 6) {
		count = count * 4;
		startIndex = ((startIndex - 1) * 4) + 1;
		bufferSize = bufferSize * 4;
	}
	success((startIndex >= 1) && (((startIndex + count) - 1) <= bufferSize));
	bufferPtr = ((buffer + 4) + startIndex) - 1;
	if (successFlag) {
		asyncFileWriteStart(f, fPosition, bufferPtr, count);
	}
	if (successFlag) {
		pop(5);
	}
}

int primitiveAt(void) {
	commonAt(false);
}

int primitiveAtEnd(void) {
    int array;
    int stream;
    int arrayClass;
    int size;
    int index;
    int limit;

	stream = popStack();
	successFlag = (isPointers(stream)) && ((lengthOf(stream)) >= (2 + 1));
	if (successFlag) {
		array = fetchPointerofObject(0, stream);
		index = fetchIntegerofObject(1, stream);
		limit = fetchIntegerofObject(2, stream);
		arrayClass = fetchClassOf(array);
		success(okStreamArrayClass(arrayClass));
		size = stSizeOf(array);
	}
	if (successFlag) {
		pushBool((index >= limit) || (index >= size));
	} else {
		unPop(1);
	}
}

int primitiveAtPut(void) {
	commonAtPut(false);
}

int primitiveBeCursor(void) {
    int maskObj;
    int maskBitsIndex;
    int depth;
    int bitsObj;
    int extentX;
    int extentY;
    int cursorObj;
    int offsetObj;
    int offsetX;
    int offsetY;
    int cursorBitsIndex;

	if (argumentCount == 0) {
		cursorObj = stackTop();
		maskBitsIndex = null;
	}
	if (argumentCount == 1) {
		cursorObj = stackValue(1);
		maskObj = stackTop();
	}
	success(argumentCount < 2);
	success((isPointers(cursorObj)) && ((lengthOf(cursorObj)) >= 5));
	if (successFlag) {
		bitsObj = fetchPointerofObject(0, cursorObj);
		extentX = fetchIntegerofObject(1, cursorObj);
		extentY = fetchIntegerofObject(2, cursorObj);
		depth = fetchIntegerofObject(3, cursorObj);
		offsetObj = fetchPointerofObject(4, cursorObj);
	}
	success((isPointers(offsetObj)) && ((lengthOf(offsetObj)) >= 2));
	if (successFlag) {
		offsetX = fetchIntegerofObject(0, offsetObj);
		offsetY = fetchIntegerofObject(1, offsetObj);
		success((extentX == 16) && ((extentY == 16) && (depth == 1)));
		success((offsetX >= -16) && (offsetX <= 0));
		success((offsetY >= -16) && (offsetY <= 0));
		success((isWords(bitsObj)) && ((lengthOf(bitsObj)) == 16));
		cursorBitsIndex = bitsObj + 4;
	}
	if (argumentCount == 1) {
		success((isPointers(maskObj)) && ((lengthOf(maskObj)) >= 5));
		if (successFlag) {
			bitsObj = fetchPointerofObject(0, maskObj);
			extentX = fetchIntegerofObject(1, maskObj);
			extentY = fetchIntegerofObject(2, maskObj);
			depth = fetchIntegerofObject(3, maskObj);
		}
		if (successFlag) {
			success((extentX == 16) && ((extentY == 16) && (depth == 1)));
			success((isWords(bitsObj)) && ((lengthOf(bitsObj)) == 16));
			maskBitsIndex = bitsObj + 4;
		}
	}
	if (successFlag) {
		if (argumentCount == 0) {
			ioSetCursor(cursorBitsIndex, offsetX, offsetY);
		} else {
			ioSetCursorWithMask(cursorBitsIndex, maskBitsIndex, offsetX, offsetY);
		}
		pop(argumentCount);
	}
}

int primitiveBeDisplay(void) {
    int rcvr;

	rcvr = stackTop();
	success((isPointers(rcvr)) && ((lengthOf(rcvr)) >= 4));
	if (successFlag) {
		storePointerofObjectwithValue(14, specialObjectsOop, rcvr);
	}
}

int primitiveBeep(void) {
	ioBeep();
}

int primitiveBitAnd(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popPos32BitInteger();
	integerReceiver = popPos32BitInteger();
	if (successFlag) {
		push(positive32BitIntegerFor(integerReceiver & integerArgument));
	} else {
		unPop(2);
		failSpecialPrim(14);
	}
}

int primitiveBitOr(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popPos32BitInteger();
	integerReceiver = popPos32BitInteger();
	if (successFlag) {
		push(positive32BitIntegerFor(integerReceiver | integerArgument));
	} else {
		unPop(2);
		failSpecialPrim(15);
	}
}

int primitiveBitShift(void) {
    int shifted;
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popPos32BitInteger();
	if (successFlag) {
		if (integerArgument >= 0) {
			success(integerArgument <= 31);
			shifted = integerReceiver << integerArgument;
			success((((unsigned) shifted) >> integerArgument) == integerReceiver);
		} else {
			success(integerArgument >= -31);
			shifted = ((integerArgument < 0) ? ((unsigned) integerReceiver >> -integerArgument) : ((unsigned) integerReceiver << integerArgument));
		}
	}
	if (successFlag) {
		push(positive32BitIntegerFor(shifted));
	} else {
		unPop(2);
		failSpecialPrim(17);
	}
}

int primitiveBitXor(void) {
    int integerReceiver;
    int integerArgument;

	integerArgument = popPos32BitInteger();
	integerReceiver = popPos32BitInteger();
	if (successFlag) {
		push(positive32BitIntegerFor(integerReceiver ^ integerArgument));
	} else {
		unPop(2);
	}
}

int primitiveBlockCopy(void) {
    int methodContext;
    int newContext;
    int initialIP;
    int context;
    int contextSize;

	context = stackValue(1);
	if (((fetchPointerofObject(3, context)) & 1)) {
		methodContext = fetchPointerofObject(5, context);
	} else {
		methodContext = context;
	}
	contextSize = sizeBitsOf(methodContext);
	context = null;
	pushRemappableOop(methodContext);
	newContext = instantiateSmallClasssizeInBytesfill(splObj(11), contextSize, nilObj);
	methodContext = popRemappableOop();
	initialIP = (((instructionPointer - method) << 1) | 1);
	storeWordofObjectwithValue(4, newContext, initialIP);
	storeWordofObjectwithValue(1, newContext, initialIP);
	storeStackPointerValueinContext(0, newContext);
	storePointerUncheckedofObjectwithValue(3, newContext, stackValue(0));
	storePointerUncheckedofObjectwithValue(5, newContext, methodContext);
	pop(2);
	push(newContext);
}

int primitiveBytesLeft(void) {
	pop(1);
	pushInteger(sizeOfFree(freeBlock));
}

int primitiveClass(void) {
    int instance;

	instance = popStack();
	push(fetchClassOf(instance));
}

int primitiveClipboardText(void) {
    int sz;
    int s;

	if (argumentCount == 1) {
		s = stackTop();
		assertClassOfis(s, splObj(6));
		if (successFlag) {
			sz = stSizeOf(s);
			clipboardWriteFromAt(sz, s + 4, 0);
			pop(1);
		}
	} else {
		sz = clipboardSize();
		s = instantiateClassindexableSize(splObj(6), sz);
		clipboardReadIntoAt(sz, s + 4, 0);
		pop(1);
		push(s);
	}
}

int primitiveClone(void) {
    int newCopy;

	newCopy = clone(stackTop());
	popthenPush(1, newCopy);
}

int primitiveConstantFill(void) {
    int i;
    int end;
    int rcvrIsBytes;
    int fillValue;
    int rcvr;

	fillValue = positive32BitValueOf(stackTop());
	rcvr = stackValue(1);
	success(isWordsOrBytes(rcvr));
	rcvrIsBytes = isBytes(rcvr);
	if (rcvrIsBytes) {
		success((fillValue >= 0) && (fillValue <= 255));
	}
	if (successFlag) {
		end = rcvr + (sizeBitsOf(rcvr));
		i = rcvr + 4;
		if (rcvrIsBytes) {
			while (i < end) {
				byteAtput(i, fillValue);
				i += 1;
			}
		} else {
			while (i < end) {
				longAtput(i, fillValue);
				i += 4;
			}
		}
		pop(1);
	}
}

int primitiveCopyBits(void) {
    int rcvr;

	rcvr = stackValue(argumentCount);
	success(loadBitBltFrom(rcvr));
	if (successFlag) {
		copyBits();
		showDisplayBits();
	}
}

int primitiveDeferDisplayUpdates(void) {
    int flag;

	flag = stackTop();
	if (flag == trueObj) {
		deferDisplayUpdates = true;
	} else {
		if (flag == falseObj) {
			deferDisplayUpdates = false;
		} else {
			primitiveFail();
		}
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveDirectoryCreate(void) {
    int dirName;
    int dirNameIndex;
    int dirNameSize;

	dirName = stackTop();
	success(isBytes(dirName));
	if (successFlag) {
		dirNameIndex = dirName + 4;
		dirNameSize = lengthOf(dirName);
	}
	if (successFlag) {
		success(dir_Create((char *) dirNameIndex, dirNameSize));
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveDirectoryDelimitor(void) {
    int ascii;

	ascii = asciiDirectoryDelimiter();
	success((ascii >= 0) && (ascii <= 255));
	if (successFlag) {
		pop(1);
		push(fetchPointerofObject(ascii, splObj(24)));
	}
}

int primitiveDirectoryLookup(void) {
    int dirFlag;
    int pathName;
    int pathNameIndex;
    int pathNameSize;
    int status;
    int modifiedDate;
    char entryName[256];
    int entryNameSize;
    int index;
    int createDate;
    int fileSize;

	index = stackIntegerValue(0);
	pathName = stackValue(1);
	success(isBytes(pathName));
	if (successFlag) {
		pathNameIndex = pathName + 4;
		pathNameSize = lengthOf(pathName);
	}
	if (successFlag) {
		status = dir_Lookup(
				(char *) pathNameIndex, pathNameSize, index,
				entryName, &entryNameSize, &createDate, &modifiedDate,
				&dirFlag, &fileSize);
		if (status == 1) {
			pop(3);
			push(nilObj);
			return null;
		}
		if (status == 2) {
			return primitiveFail();
		}
	}
	if (successFlag) {
		pop(3);
		push(makeDirEntryNamesizecreateDatemodDateisDirfileSize(entryName, entryNameSize, createDate, modifiedDate, dirFlag, fileSize));
	}
}

int primitiveDirectorySetMacTypeAndCreator(void) {
    int typeStringIndex;
    int typeString;
    int fileName;
    int creatorString;
    int creatorStringIndex;
    int fileNameIndex;
    int fileNameSize;

	creatorString = stackTop();
	typeString = stackValue(1);
	fileName = stackValue(2);
	success((isBytes(creatorString)) && ((lengthOf(creatorString)) == 4));
	success((isBytes(typeString)) && ((lengthOf(typeString)) == 4));
	success(isBytes(fileName));
	if (successFlag) {
		creatorStringIndex = creatorString + 4;
		typeStringIndex = typeString + 4;
		fileNameIndex = fileName + 4;
		fileNameSize = lengthOf(fileName);
	}
	if (successFlag) {
		success(dir_SetMacFileTypeAndCreator(
				(char *) fileNameIndex, fileNameSize,
				(char *) typeStringIndex, (char *) creatorStringIndex));
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveDiv(void) {
    int arg;
    int posArg;
    int posRcvr;
    int result;
    int rcvr;

	successFlag = true;
	arg = popInteger();
	rcvr = popInteger();
	success(arg != 0);
	if (successFlag) {
		if (rcvr > 0) {
			if (arg > 0) {
				result = rcvr / arg;
			} else {
				posArg = 0 - arg;
				result = 0 - ((rcvr + (posArg - 1)) / posArg);
			}
		} else {
			posRcvr = 0 - rcvr;
			if (arg > 0) {
				result = 0 - ((posRcvr + (arg - 1)) / arg);
			} else {
				posArg = 0 - arg;
				result = posRcvr / posArg;
			}
		}
		checkIntegerResultfrom(result, 12);
	} else {
		checkIntegerResultfrom(0, 12);
	}
}

int primitiveDivide(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	success(integerArgument != 0);
	if (!(successFlag)) {
		integerArgument = 1;
	}
	success((integerReceiver % integerArgument) == 0);
	checkIntegerResultfrom(integerReceiver / integerArgument, 10);
}

int primitiveDoPrimitiveWithArgs(void) {
    int primIdx;
    int argumentArray;
    int arraySize;
    int index;
    int cntxSize;

	argumentArray = stackTop();
	arraySize = fetchWordLengthOf(argumentArray);
	cntxSize = fetchWordLengthOf(activeContext);
	success(((stackPointerIndex()) + arraySize) < cntxSize);
	assertClassOfis(argumentArray, splObj(7));
	primIdx = stackIntegerValue(1);
	if (!(successFlag)) {
		return primitiveFail();
	}
	pop(2);
	primitiveIndex = primIdx;
	argumentCount = arraySize;
	index = 1;
	while (index <= argumentCount) {
		push(fetchPointerofObject(index - 1, argumentArray));
		index += 1;
	}
	pushRemappableOop(argumentArray);
	primitiveResponse();
	argumentArray = popRemappableOop();
	if (!(successFlag)) {
		pop(arraySize);
		pushInteger(primIdx);
		push(argumentArray);
		argumentCount = 2;
	}
}

int primitiveDrawLoop(void) {
    int yDelta;
    int rcvr;
    int xDelta;

	rcvr = stackValue(2);
	xDelta = stackIntegerValue(1);
	yDelta = stackIntegerValue(0);
	success(loadBitBltFrom(rcvr));
	if (successFlag) {
		drawLoopXY(xDelta, yDelta);
		showDisplayBits();
		pop(2);
	}
}

int primitiveEqual(void) {
    int integerReceiver;
    int integerArgument;
    int result;

	successFlag = true;
	integerArgument = popStack();
	integerReceiver = popStack();
	result = compare31or32Bitsequal(integerReceiver, integerArgument);
	checkBooleanResultfrom(result, 7);
}

int primitiveEquivalent(void) {
    int thisObject;
    int otherObject;

	otherObject = popStack();
	thisObject = popStack();
	pushBool(thisObject == otherObject);
}

int primitiveExitToDebugger(void) {
	error("Exit to debugger at user request");
}

int primitiveExp(void) {
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		pushFloat(exp(rcvr));
	} else {
		unPop(1);
	}
}

int primitiveExponent(void) {
    int pwr;
    double frac;
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		frac = frexp(rcvr, &pwr);
		pushInteger(pwr - 1);
	} else {
		unPop(1);
	}
}

int primitiveFail(void) {
	successFlag = false;
}

int primitiveFileAtEnd(void) {
    int atEnd;
    SQFile *file;

	file = fileValueOf(stackTop());
	if (successFlag) {
		atEnd = sqFileAtEnd(file);
	}
	if (successFlag) {
		pop(2);
		pushBool(atEnd);
	}
}

int primitiveFileClose(void) {
    SQFile *file;

	file = fileValueOf(stackTop());
	if (successFlag) {
		sqFileClose(file);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveFileDelete(void) {
    int nameIndex;
    int namePointer;
    int nameSize;

	namePointer = stackTop();
	success(isBytes(namePointer));
	if (successFlag) {
		nameIndex = namePointer + 4;
		nameSize = lengthOf(namePointer);
	}
	if (successFlag) {
		sqFileDeleteNameSize(nameIndex, nameSize);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveFileGetPosition(void) {
    int position;
    SQFile *file;

	file = fileValueOf(stackTop());
	if (successFlag) {
		position = sqFileGetPosition(file);
	}
	if (successFlag) {
		pop(2);
		pushInteger(position);
	}
}

int primitiveFileOpen(void) {
    int writeFlag;
    int nameIndex;
    int namePointer;
    int nameSize;
    int filePointer;
    SQFile *file;

	writeFlag = booleanValueOf(stackTop());
	namePointer = stackValue(1);
	success(isBytes(namePointer));
	if (successFlag) {
		filePointer = instantiateClassindexableSize(splObj(26), fileRecordSize());
		file = fileValueOf(filePointer);
		nameIndex = namePointer + 4;
		nameSize = lengthOf(namePointer);
	}
	if (successFlag) {
		sqFileOpen(file, nameIndex, nameSize, writeFlag);
	}
	if (successFlag) {
		pop(3);
		push(filePointer);
	}
}

int primitiveFileRead(void) {
    int array;
    int startIndex;
    int arrayIndex;
    int bytesRead;
    int byteSize;
    int count;
    SQFile *file;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	array = stackValue(2);
	file = fileValueOf(stackValue(3));
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	} else {
		byteSize = 1;
	}
	success((startIndex >= 1) && (((startIndex + count) - 1) <= (lengthOf(array))));
	if (successFlag) {
		arrayIndex = array + 4;
		bytesRead = sqFileReadIntoAt(file, count * byteSize, arrayIndex, (startIndex - 1) * byteSize);
	}
	if (successFlag) {
		pop(5);
		pushInteger(bytesRead / byteSize);
	}
}

int primitiveFileRename(void) {
    int newNameIndex;
    int newNamePointer;
    int newNameSize;
    int oldNamePointer;
    int oldNameIndex;
    int oldNameSize;

	newNamePointer = stackTop();
	oldNamePointer = stackValue(1);
	success(isBytes(newNamePointer));
	success(isBytes(oldNamePointer));
	if (successFlag) {
		newNameIndex = newNamePointer + 4;
		newNameSize = lengthOf(newNamePointer);
		oldNameIndex = oldNamePointer + 4;
		oldNameSize = lengthOf(oldNamePointer);
	}
	if (successFlag) {
		sqFileRenameOldSizeNewSize(oldNameIndex, oldNameSize, newNameIndex, newNameSize);
	}
	if (successFlag) {
		pop(2);
	}
}

int primitiveFileSetPosition(void) {
    int newPosition;
    SQFile *file;

	newPosition = stackIntegerValue(0);
	file = fileValueOf(stackValue(1));
	if (successFlag) {
		sqFileSetPosition(file, newPosition);
	}
	if (successFlag) {
		pop(2);
	}
}

int primitiveFileSize(void) {
    int size;
    SQFile *file;

	file = fileValueOf(stackTop());
	if (successFlag) {
		size = sqFileSize(file);
	}
	if (successFlag) {
		pop(2);
		pushInteger(size);
	}
}

int primitiveFileWrite(void) {
    int array;
    int startIndex;
    int arrayIndex;
    int bytesWritten;
    int byteSize;
    int count;
    SQFile *file;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	array = stackValue(2);
	file = fileValueOf(stackValue(3));
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	} else {
		byteSize = 1;
	}
	success((startIndex >= 1) && (((startIndex + count) - 1) <= (lengthOf(array))));
	if (successFlag) {
		arrayIndex = array + 4;
		bytesWritten = sqFileWriteFromAt(file, count * byteSize, arrayIndex, (startIndex - 1) * byteSize);
	}
	if (successFlag) {
		pop(5);
		pushInteger(bytesWritten / byteSize);
	}
}

int primitiveFloatAdd(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;
    double result;
    int resultOop;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		result = rcvr + arg;
		resultOop = clone(rcvrOop);
		storeFloatAtfrom(resultOop + 4, result);
		popthenPush(2, resultOop);
	}
}

int primitiveFloatDivide(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;
    double result;
    int resultOop;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		success(arg != 0.0);
		if (successFlag) {
			result = rcvr / arg;
			resultOop = clone(rcvrOop);
			storeFloatAtfrom(resultOop + 4, result);
			popthenPush(2, resultOop);
		}
	}
}

int primitiveFloatEqual(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		pop(2);
		pushBool(rcvr == arg);
	}
}

int primitiveFloatGreaterOrEqual(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		pop(2);
		pushBool(rcvr >= arg);
	}
}

int primitiveFloatGreaterThan(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		pop(2);
		pushBool(rcvr > arg);
	}
}

int primitiveFloatLessOrEqual(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		pop(2);
		pushBool(rcvr <= arg);
	}
}

int primitiveFloatLessThan(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		pop(2);
		pushBool(rcvr < arg);
	}
}

int primitiveFloatMultiply(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;
    double result;
    int resultOop;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		result = rcvr * arg;
		resultOop = clone(rcvrOop);
		storeFloatAtfrom(resultOop + 4, result);
		popthenPush(2, resultOop);
	}
}

int primitiveFloatNotEqual(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		pop(2);
		pushBool(rcvr != arg);
	}
}

int primitiveFloatSubtract(void) {
    double arg;
    int argOop;
    int rcvrOop;
    double rcvr;
    double result;
    int resultOop;

	rcvrOop = stackValue(1);
	argOop = stackTop();
	assertFloatand(rcvrOop, argOop);
	if (successFlag) {
		fetchFloatAtinto(rcvrOop + 4, rcvr);
		fetchFloatAtinto(argOop + 4, arg);
		result = rcvr - arg;
		resultOop = clone(rcvrOop);
		storeFloatAtfrom(resultOop + 4, result);
		popthenPush(2, resultOop);
	}
}

int primitiveFlushCache(void) {
	flushMethodCache();
}

int primitiveFlushCacheSelective(void) {
    int selector;
    int i;
    int nCols;
    int col;

	selector = stackTop();
	nCols = ((int) 2048 >> 9);
	for (i = 1; i <= 512; i += 1) {
		if ((methodCache[i]) == selector) {
			for (col = 0; col <= (nCols - 1); col += 1) {
				methodCache[i + (512 * col)] = 0;
			}
		}
	}
}

int primitiveForceDisplayUpdate(void) {
	ioForceDisplayUpdate();
}

int primitiveFormPrint(void) {
    double vScale;
    int depth;
    int pixelsPerWord;
    int bitsArray;
    double hScale;
    int wordsPerLine;
    int h;
    int w;
    int bitsArraySize;
    int landscapeFlag;
    int ok;
    int rcvr;

	landscapeFlag = booleanValueOf(stackTop());
	vScale = floatValueOf(stackValue(1));
	hScale = floatValueOf(stackValue(2));
	rcvr = stackValue(3);
	if ((rcvr & 1)) {
		success(false);
	}
	if (successFlag) {
		if (!((isPointers(rcvr)) && ((lengthOf(rcvr)) >= 4))) {
			success(false);
		}
	}
	if (successFlag) {
		bitsArray = fetchPointerofObject(0, rcvr);
		w = fetchIntegerofObject(1, rcvr);
		h = fetchIntegerofObject(2, rcvr);
		depth = fetchIntegerofObject(3, rcvr);
		if (!((w > 0) && (h > 0))) {
			success(false);
		}
		pixelsPerWord = 32 / depth;
		wordsPerLine = (w + (pixelsPerWord - 1)) / pixelsPerWord;
		if ((!((rcvr & 1))) && (isWordsOrBytes(bitsArray))) {
			bitsArraySize = byteLengthOf(bitsArray);
			success(bitsArraySize == ((wordsPerLine * h) * 4));
		} else {
			success(false);
		}
	}
	if (successFlag) {
		ok = ioFormPrint(bitsArray + 4, w, h, depth, hScale, vScale, landscapeFlag);
		success(ok);
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveFractionalPart(void) {
    double trunc;
    double frac;
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		frac = modf(rcvr, &trunc);
		pushFloat(frac);
	} else {
		unPop(1);
	}
}

int primitiveFullGC(void) {
	pop(1);
	incrementalGC();
	fullGC();
	pushInteger(sizeOfFree(freeBlock));
}

int primitiveGetAttribute(void) {
    int attr;
    int sz;
    int s;

	attr = stackIntegerValue(0);
	if (successFlag) {
		sz = attributeSize(attr);
	}
	if (successFlag) {
		s = instantiateClassindexableSize(splObj(6), sz);
		getAttributeIntoLength(attr, s + 4, sz);
		pop(2);
		push(s);
	}
}

int primitiveGreaterOrEqual(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	checkBooleanResultfrom(integerReceiver >= integerArgument, 6);
}

int primitiveGreaterThan(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	checkBooleanResultfrom(integerReceiver > integerArgument, 4);
}

int primitiveImageName(void) {
    int sz;
    int s;

	if (argumentCount == 1) {
		s = stackTop();
		assertClassOfis(s, splObj(6));
		if (successFlag) {
			sz = stSizeOf(s);
			imageNamePutLength(s + 4, sz);
			pop(1);
		}
	} else {
		sz = imageNameSize();
		s = instantiateClassindexableSize(splObj(6), sz);
		imageNameGetLength(s + 4, sz);
		pop(1);
		push(s);
	}
}

int primitiveIncrementalGC(void) {
	pop(1);
	incrementalGC();
	pushInteger(sizeOfFree(freeBlock));
}

int primitiveIndexOf(int methodPointer) {
    int primBits;

	primBits = (((unsigned) (headerOf(methodPointer))) >> 1) & 805306879;
	if (primBits > 511) {
		return (primBits & 511) + (((unsigned) primBits) >> 19);
	} else {
		return primBits;
	}
}

int primitiveInitializeNetwork(void) {
    int err;
    int resolverSemaIndex;

	resolverSemaIndex = stackIntegerValue(0);
	if (successFlag) {
		err = sqNetworkInit(resolverSemaIndex);
		success(err == 0);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveInputSemaphore(void) {
    int arg;

	arg = popStack();
	if ((fetchClassOf(arg)) == (splObj(18))) {
		storePointerofObjectwithValue(22, specialObjectsOop, arg);
	} else {
		storePointerofObjectwithValue(22, specialObjectsOop, nilObj);
	}
}

int primitiveInputWord(void) {
	pop(1);
	pushInteger(0);
}

int primitiveInstVarAt(void) {
    int value;
    int hdr;
    int totalLength;
    int index;
    int fmt;
    int rcvr;
    int fixedFields;

	index = popInteger();
	rcvr = popStack();
	if (successFlag) {
		hdr = baseHeader(rcvr);
		fmt = (((unsigned) hdr) >> 8) & 15;
		totalLength = lengthOfbaseHeaderformat(rcvr, hdr, fmt);
		fixedFields = fixedFieldsOfformatlength(rcvr, fmt, totalLength);
		if (!((index >= 1) && (index <= fixedFields))) {
			successFlag = false;
		}
	}
	if (successFlag) {
		value = subscriptwithformat(rcvr, index, fmt);
	}
	if (successFlag) {
		push(value);
	} else {
		unPop(2);
	}
}

int primitiveInstVarAtPut(void) {
    int hdr;
    int newValue;
    int totalLength;
    int index;
    int fmt;
    int rcvr;
    int fixedFields;

	newValue = popStack();
	index = popInteger();
	rcvr = popStack();
	if (successFlag) {
		hdr = baseHeader(rcvr);
		fmt = (((unsigned) hdr) >> 8) & 15;
		totalLength = lengthOfbaseHeaderformat(rcvr, hdr, fmt);
		fixedFields = fixedFieldsOfformatlength(rcvr, fmt, totalLength);
		if (!((index >= 1) && (index <= fixedFields))) {
			successFlag = false;
		}
	}
	if (successFlag) {
		subscriptwithstoringformat(rcvr, index, newValue, fmt);
	}
	if (successFlag) {
		push(newValue);
	} else {
		unPop(3);
	}
}

int primitiveInterruptSemaphore(void) {
    int arg;

	arg = popStack();
	if ((fetchClassOf(arg)) == (splObj(18))) {
		storePointerofObjectwithValue(30, specialObjectsOop, arg);
	} else {
		storePointerofObjectwithValue(30, specialObjectsOop, nilObj);
	}
}

int primitiveKbdNext(void) {
    int keystrokeWord;

	pop(1);
	keystrokeWord = ioGetKeystroke();
	if (keystrokeWord >= 0) {
		pushInteger(keystrokeWord);
	} else {
		push(nilObj);
	}
}

int primitiveKbdPeek(void) {
    int keystrokeWord;

	pop(1);
	keystrokeWord = ioPeekKeystroke();
	if (keystrokeWord >= 0) {
		pushInteger(keystrokeWord);
	} else {
		push(nilObj);
	}
}

int primitiveLessOrEqual(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	checkBooleanResultfrom(integerReceiver <= integerArgument, 5);
}

int primitiveLessThan(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	checkBooleanResultfrom(integerReceiver < integerArgument, 3);
}

int primitiveLoadInstVar(void) {
    int thisReceiver;

	thisReceiver = popStack();
	push(fetchPointerofObject(primitiveIndex - 264, thisReceiver));
}

int primitiveLogN(void) {
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		pushFloat(log(rcvr));
	} else {
		unPop(1);
	}
}

int primitiveLowSpaceSemaphore(void) {
    int arg;

	arg = popStack();
	if ((fetchClassOf(arg)) == (splObj(18))) {
		storePointerofObjectwithValue(17, specialObjectsOop, arg);
	} else {
		storePointerofObjectwithValue(17, specialObjectsOop, nilObj);
	}
}

int primitiveMIDIClosePort(void) {
    int portNum;

	portNum = stackIntegerValue(0);
	if (successFlag) {
		sqMIDIClosePort(portNum);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveMIDIGetClock(void) {
    int clockValue;

	clockValue = (sqMIDIGetClock()) & 536870911;
	if (successFlag) {
		pop(1);
		pushInteger(clockValue);
	}
}

int primitiveMIDIGetPortCount(void) {
    int n;

	n = sqMIDIGetPortCount();
	if (successFlag) {
		pop(1);
		pushInteger(n);
	}
}

int primitiveMIDIGetPortDirectionality(void) {
    int dir;
    int portNum;

	portNum = stackIntegerValue(0);
	if (successFlag) {
		dir = sqMIDIGetPortDirectionality(portNum);
	}
	if (successFlag) {
		pop(2);
		pushInteger(dir);
	}
}

int primitiveMIDIGetPortName(void) {
    char portName[256];
    int portNum;
    int sz;
    int nameObj;
    int namePtr;

	portNum = stackIntegerValue(0);
	if (successFlag) {
		sz = sqMIDIGetPortName(portNum, (int) &portName, 255);
	}
	if (successFlag) {
		nameObj = instantiateClassindexableSize(splObj(6), sz);
		namePtr = nameObj + 4;
		memcpy((char *) namePtr, portName, sz);
	}
	if (successFlag) {
		pop(2);
		push(nameObj);
	}
}

int primitiveMIDIOpenPort(void) {
    int semaIndex;
    int portNum;
    int clockRate;

	clockRate = stackIntegerValue(0);
	semaIndex = stackIntegerValue(1);
	portNum = stackIntegerValue(2);
	if (successFlag) {
		sqMIDIOpenPort(portNum, semaIndex, clockRate);
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveMIDIParameterGetOrSet(void) {
    int whichParameter;
    int newValue;
    int currentValue;

	if (argumentCount == 1) {
		whichParameter = stackIntegerValue(0);
		if (!(successFlag)) {
			return null;
		}
		currentValue = sqMIDIParameter(whichParameter, false, 0);
		if (successFlag) {
			pop(2);
			pushInteger(currentValue);
		}
		return null;
	}
	if (argumentCount == 2) {
		newValue = stackIntegerValue(0);
		whichParameter = stackIntegerValue(1);
		if (!(successFlag)) {
			return null;
		}
		sqMIDIParameter(whichParameter, true, newValue);
		if (successFlag) {
			pop(2);
		}
		return null;
	}
	primitiveFail();
}

int primitiveMIDIRead(void) {
    int array;
    int portNum;
    int arrayLength;
    int bytesRead;
    int fmt;

	array = stackValue(0);
	portNum = stackIntegerValue(1);
	fmt = formatOf(array);
	success((fmt >= 8) && (fmt <= 11));
	if (successFlag) {
		arrayLength = lengthOf(array);
		bytesRead = sqMIDIPortReadInto(portNum, arrayLength, array + 4);
	}
	if (successFlag) {
		pop(3);
		pushInteger(bytesRead);
	}
}

int primitiveMIDIWrite(void) {
    int array;
    int portNum;
    int arrayLength;
    int time;
    int bytesWritten;
    int fmt;

	time = stackIntegerValue(0);
	array = stackValue(1);
	portNum = stackIntegerValue(2);
	fmt = formatOf(array);
	success((fmt >= 8) && (fmt <= 11));
	if (successFlag) {
		arrayLength = lengthOf(array);
		bytesWritten = sqMIDIPortWriteFromAt(portNum, arrayLength, array + 4, time);
	}
	if (successFlag) {
		pop(4);
		pushInteger(bytesWritten);
	}
}

int primitiveMakePoint(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	if (successFlag) {
		push(makePointwithxValueyValue(integerReceiver, integerArgument));
	} else {
		checkIntegerResultfrom(0, 18);
	}
}

int primitiveMillisecondClock(void) {
	pop(1);
	push(((((ioMSecs()) & 536870911) << 1) | 1));
}

int primitiveMod(void) {
    int integerReceiver;
    int integerArgument;
    int integerResult;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	success(integerArgument != 0);
	if (!(successFlag)) {
		integerArgument = 1;
	}
	integerResult = integerReceiver % integerArgument;
	if (integerArgument < 0) {
		if (integerResult > 0) {
			integerResult += integerArgument;
		}
	} else {
		if (integerResult < 0) {
			integerResult += integerArgument;
		}
	}
	checkIntegerResultfrom(integerResult, 11);
}

int primitiveMouseButtons(void) {
    int buttonWord;

	pop(1);
	buttonWord = ioGetButtonState();
	pushInteger(buttonWord);
}

int primitiveMousePoint(void) {
    int y;
    int pointWord;
    int x;

	pop(1);
	pointWord = ioMousePoint();
	x = signExtend16((((unsigned) pointWord) >> 16) & 65535);
	y = signExtend16(pointWord & 65535);
	push(makePointwithxValueyValue(x, y));
}

int primitiveMultiply(void) {
    int arg;
    int result;
    int rcvr;

	rcvr = stackValue(1);
	arg = stackValue(0);
	pop(2);
	success(areIntegersand(rcvr, arg));
	if (successFlag) {
		rcvr = (rcvr >> 1);
		arg = (arg >> 1);
		result = rcvr * arg;
		success((arg == 0) || ((result / arg) == rcvr));
	}
	checkIntegerResultfrom(result, 9);
}

int primitiveNew(void) {
    int spaceOkay;
    int class;

	class = popStack();
	spaceOkay = sufficientSpaceToInstantiateindexableSize(class, 0);
	success(spaceOkay);
	if (successFlag) {
		push(instantiateClassindexableSize(class, 0));
	} else {
		unPop(1);
	}
}

int primitiveNewMethod(void) {
    int size;
    int i;
    int header;
    int theMethod;
    int bytecodeCount;
    int class;
    int literalCount;

	header = popStack();
	bytecodeCount = popInteger();
	success((header & 1));
	if (!(successFlag)) {
		unPop(2);
	}
	class = popStack();
	size = (((literalCountOfHeader(header)) + 1) * 4) + bytecodeCount;
	theMethod = instantiateClassindexableSize(class, size);
	storePointerofObjectwithValue(0, theMethod, header);
	literalCount = literalCountOfHeader(header);
	for (i = 1; i <= literalCount; i += 1) {
		storePointerofObjectwithValue(i, theMethod, nilObj);
	}
	push(theMethod);
}

int primitiveNewWithArg(void) {
    int spaceOkay;
    int size;
    int class;

	size = popInteger();
	class = popStack();
	success(size >= 0);
	if (successFlag) {
		spaceOkay = sufficientSpaceToInstantiateindexableSize(class, size);
		success(spaceOkay);
	}
	if (successFlag) {
		push(instantiateClassindexableSize(class, size));
	} else {
		unPop(2);
	}
}

int primitiveNext(void) {
    int array;
    int stream;
    int stringy;
    int arrayClass;
    int index;
    int limit;
    int result;

	stream = popStack();
	successFlag = (isPointers(stream)) && ((lengthOf(stream)) >= (2 + 1));
	if (successFlag) {
		array = fetchPointerofObject(0, stream);
		index = fetchIntegerofObject(1, stream);
		limit = fetchIntegerofObject(2, stream);
		arrayClass = fetchClassOf(array);
		stringy = arrayClass == (splObj(6));
		if (!(stringy)) {
			success(okStreamArrayClass(arrayClass));
		}
		success(index < limit);
	}
	if (successFlag) {
		index += 1;
		pushRemappableOop(stream);
		result = stObjectat(array, index);
		stream = popRemappableOop();
	}
	if (successFlag) {
		storeIntegerofObjectwithValue(1, stream, index);
	}
	if (successFlag) {
		if (stringy) {
			push(characterForAscii(result));
		} else {
			push(result);
		}
	} else {
		unPop(1);
	}
}

int primitiveNextInstance(void) {
    int object;
    int instance;

	object = popStack();
	instance = instanceAfter(object);
	if (instance == nilObj) {
		unPop(1);
		primitiveFail();
	} else {
		push(instance);
	}
}

int primitiveNextObject(void) {
    int object;
    int instance;

	object = popStack();
	instance = accessibleObjectAfter(object);
	if (instance == null) {
		pushInteger(0);
	} else {
		push(instance);
	}
}

int primitiveNextPut(void) {
    int array;
    int stream;
    int storeVal;
    int value;
    int arrayClass;
    int index;
    int limit;

	value = popStack();
	stream = popStack();
	successFlag = (isPointers(stream)) && ((lengthOf(stream)) >= (3 + 1));
	if (successFlag) {
		array = fetchPointerofObject(0, stream);
		index = fetchIntegerofObject(1, stream);
		limit = fetchIntegerofObject(3, stream);
		arrayClass = fetchClassOf(array);
		success(okStreamArrayClass(arrayClass));
		success(index < limit);
	}
	if (successFlag) {
		index += 1;
		if (arrayClass == (splObj(6))) {
			storeVal = asciiOfCharacter(value);
		} else {
			storeVal = value;
		}
		stObjectatput(array, index, storeVal);
	}
	if (successFlag) {
		storeIntegerofObjectwithValue(1, stream, index);
	}
	if (successFlag) {
		push(value);
	} else {
		unPop(2);
	}
}

int primitiveNoop(void) {
	pop(argumentCount);
}

int primitiveNotEqual(void) {
    int integerReceiver;
    int integerArgument;
    int result;

	successFlag = true;
	integerArgument = popStack();
	integerReceiver = popStack();
	result = !(compare31or32Bitsequal(integerReceiver, integerArgument));
	checkBooleanResultfrom(result, 8);
}

int primitiveObjectAt(void) {
    int thisReceiver;
    int index;

	index = popInteger();
	thisReceiver = popStack();
	success(index > 0);
	success(index <= ((literalCountOf(thisReceiver)) + 1));
	if (successFlag) {
		push(fetchPointerofObject(index - 1, thisReceiver));
	} else {
		unPop(2);
	}
}

int primitiveObjectAtPut(void) {
    int thisReceiver;
    int newValue;
    int index;

	newValue = popStack();
	index = popInteger();
	thisReceiver = popStack();
	success(index > 0);
	success(index <= ((literalCountOf(thisReceiver)) + 1));
	if (successFlag) {
		storePointerofObjectwithValue(index - 1, thisReceiver, newValue);
		push(newValue);
	} else {
		unPop(3);
	}
}

int primitiveObjectPointsTo(void) {
    int i;
    int thang;
    int lastField;
    int rcvr;

	thang = popStack();
	rcvr = popStack();
	if ((rcvr & 1)) {
		return pushBool(false);
	}
	lastField = lastPointerOf(rcvr);
	for (i = 4; i <= lastField; i += 4) {
		if ((longAt(rcvr + i)) == thang) {
			return pushBool(true);
		}
	}
	pushBool(false);
}

int primitivePerform(void) {
    int performSelector;
    int selectorIndex;
    int newReceiver;

	performSelector = messageSelector;
	messageSelector = stackValue(argumentCount - 1);
	newReceiver = stackValue(argumentCount);
	argumentCount -= 1;
	lookupMethodInClass(fetchClassOf(newReceiver));
	success((argumentCountOf(newMethod)) == argumentCount);
	if (successFlag) {
		selectorIndex = (stackPointerIndex()) - argumentCount;
		transferfromIndexofObjecttoIndexofObject(argumentCount, selectorIndex + 1, activeContext, selectorIndex, activeContext);
		pop(1);
		executeNewMethod();
		successFlag = true;
	} else {
		argumentCount += 1;
		messageSelector = performSelector;
	}
}

int primitivePerformWithArgs(void) {
    int argumentArray;
    int performSelector;
    int arraySize;
    int thisReceiver;
    int index;
    int cntxSize;

	argumentArray = popStack();
	arraySize = fetchWordLengthOf(argumentArray);
	cntxSize = fetchWordLengthOf(activeContext);
	success(((stackPointerIndex()) + arraySize) < cntxSize);
	assertClassOfis(argumentArray, splObj(7));
	if (successFlag) {
		performSelector = messageSelector;
		messageSelector = popStack();
		thisReceiver = stackTop();
		argumentCount = arraySize;
		index = 1;
		while (index <= argumentCount) {
			push(fetchPointerofObject(index - 1, argumentArray));
			index += 1;
		}
		lookupMethodInClass(fetchClassOf(thisReceiver));
		success((argumentCountOf(newMethod)) == argumentCount);
		if (successFlag) {
			executeNewMethod();
			successFlag = true;
		} else {
			pop(argumentCount);
			push(messageSelector);
			push(argumentArray);
			argumentCount = 2;
			messageSelector = performSelector;
		}
	} else {
		unPop(1);
	}
}

int primitivePointX(void) {
    int rcvr;

	successFlag = true;
	rcvr = popStack();
	assertClassOfis(rcvr, splObj(12));
	if (successFlag) {
		push(fetchPointerofObject(0, rcvr));
	} else {
		unPop(1);
		failSpecialPrim(0);
	}
}

int primitivePointY(void) {
    int rcvr;

	successFlag = true;
	rcvr = popStack();
	assertClassOfis(rcvr, splObj(12));
	if (successFlag) {
		push(fetchPointerofObject(1, rcvr));
	} else {
		unPop(1);
		failSpecialPrim(0);
	}
}

int primitivePushFalse(void) {
	popStack();
	push(falseObj);
}

int primitivePushMinusOne(void) {
	popStack();
	push(4294967295U);
}

int primitivePushNil(void) {
	popStack();
	push(nilObj);
}

int primitivePushOne(void) {
	popStack();
	push(3);
}

int primitivePushSelf(void) {
}

int primitivePushTrue(void) {
	popStack();
	push(trueObj);
}

int primitivePushTwo(void) {
	popStack();
	push(5);
}

int primitivePushZero(void) {
	popStack();
	push(1);
}

int primitiveQuit(void) {
	ioExit();
}

int primitiveQuo(void) {
    int arg;
    int result;
    int rcvr;

	arg = popInteger();
	rcvr = popInteger();
	success(arg != 0);
	if (successFlag) {
		if (rcvr > 0) {
			if (arg > 0) {
				result = rcvr / arg;
			} else {
				result = 0 - (rcvr / (0 - arg));
			}
		} else {
			if (arg > 0) {
				result = 0 - ((0 - rcvr) / arg);
			} else {
				result = (0 - rcvr) / (0 - arg);
			}
		}
		success(isIntegerValue(result));
	}
	if (successFlag) {
		pushInteger(result);
	} else {
		unPop(2);
	}
}

int primitiveReadJoystick(void) {
    int index;

	index = stackIntegerValue(0);
	if (successFlag) {
		pop(2);
		push(positive32BitIntegerFor(joystickRead(index)));
	}
}

int primitiveRelinquishProcessor(void) {
    int microSecs;

	microSecs = stackIntegerValue(0);
	if (successFlag) {
		ioRelinquishProcessorForMicroseconds(microSecs);
		pop(1);
	}
}

int primitiveResolverAbortLookup(void) {
	sqResolverAbort();
}

int primitiveResolverAddressLookupResult(void) {
    int sz;
    int s;

	sz = sqResolverAddrLookupResultSize();
	if (successFlag) {
		s = instantiateClassindexableSize(splObj(6), sz);
		sqResolverAddrLookupResult(((char *) (s + 4)), sz);
	}
	if (successFlag) {
		popthenPush(1, s);
	}
}

int primitiveResolverError(void) {
    int err;

	err = sqResolverError();
	if (successFlag) {
		popthenPush(1, ((err << 1) | 1));
	}
}

int primitiveResolverLocalAddress(void) {
    int addr;

	addr = sqResolverLocalAddress();
	if (successFlag) {
		popthenPush(1, intToNetAddress(addr));
	}
}

int primitiveResolverNameLookupResult(void) {
    int addr;

	addr = sqResolverNameLookupResult();
	if (successFlag) {
		popthenPush(1, intToNetAddress(addr));
	}
}

int primitiveResolverStartAddressLookup(void) {
    int addr;

	addr = netAddressToInt(stackTop());
	if (successFlag) {
		sqResolverStartAddrLookup(addr);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveResolverStartNameLookup(void) {
    int sz;
    int name;

	name = stackTop();
	assertClassOfis(name, splObj(6));
	if (successFlag) {
		sz = lengthOf(name);
		sqResolverStartNameLookup(((char *) (name + 4)), sz);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveResolverStatus(void) {
    int status;

	status = sqResolverStatus();
	if (successFlag) {
		popthenPush(1, ((status << 1) | 1));
	}
}

int primitiveResponse(void) {
    int startTime;

	if (primitiveIndex > 700) {
		return false;
	}
	if (nextWakeupTick != 0) {
		startTime = ioLowResMSecs();
	}
	successFlag = true;
	switch (primitiveIndex) {
	case 0:
		primitiveFail();
		break;
	case 1:
		primitiveAdd();
		break;
	case 2:
		primitiveSubtract();
		break;
	case 3:
		primitiveLessThan();
		break;
	case 4:
		primitiveGreaterThan();
		break;
	case 5:
		primitiveLessOrEqual();
		break;
	case 6:
		primitiveGreaterOrEqual();
		break;
	case 7:
		primitiveEqual();
		break;
	case 8:
		primitiveNotEqual();
		break;
	case 9:
		primitiveMultiply();
		break;
	case 10:
		primitiveDivide();
		break;
	case 11:
		primitiveMod();
		break;
	case 12:
		primitiveDiv();
		break;
	case 13:
		primitiveQuo();
		break;
	case 14:
		primitiveBitAnd();
		break;
	case 15:
		primitiveBitOr();
		break;
	case 16:
		primitiveBitXor();
		break;
	case 17:
		primitiveBitShift();
		break;
	case 18:
		primitiveMakePoint();
		break;
	case 19:
	case 20:
	case 21:
	case 22:
	case 23:
	case 24:
	case 25:
	case 26:
	case 27:
	case 28:
	case 29:
	case 30:
	case 31:
	case 32:
	case 33:
	case 34:
	case 35:
	case 36:
	case 37:
	case 38:
	case 39:
		primitiveFail();
		break;
	case 40:
		primitiveAsFloat();
		break;
	case 41:
		primitiveFloatAdd();
		break;
	case 42:
		primitiveFloatSubtract();
		break;
	case 43:
		primitiveFloatLessThan();
		break;
	case 44:
		primitiveFloatGreaterThan();
		break;
	case 45:
		primitiveFloatLessOrEqual();
		break;
	case 46:
		primitiveFloatGreaterOrEqual();
		break;
	case 47:
		primitiveFloatEqual();
		break;
	case 48:
		primitiveFloatNotEqual();
		break;
	case 49:
		primitiveFloatMultiply();
		break;
	case 50:
		primitiveFloatDivide();
		break;
	case 51:
		primitiveTruncated();
		break;
	case 52:
		primitiveFractionalPart();
		break;
	case 53:
		primitiveExponent();
		break;
	case 54:
		primitiveTimesTwoPower();
		break;
	case 55:
		primitiveSquareRoot();
		break;
	case 56:
		primitiveSine();
		break;
	case 57:
		primitiveArctan();
		break;
	case 58:
		primitiveLogN();
		break;
	case 59:
		primitiveExp();
		break;
	case 60:
		primitiveAt();
		break;
	case 61:
		primitiveAtPut();
		break;
	case 62:
		primitiveSize();
		break;
	case 63:
		primitiveStringAt();
		break;
	case 64:
		primitiveStringAtPut();
		break;
	case 65:
		primitiveNext();
		break;
	case 66:
		primitiveNextPut();
		break;
	case 67:
		primitiveAtEnd();
		break;
	case 68:
		primitiveObjectAt();
		break;
	case 69:
		primitiveObjectAtPut();
		break;
	case 70:
		primitiveNew();
		break;
	case 71:
		primitiveNewWithArg();
		break;
	case 72:
		primitiveFail();
		break;
	case 73:
		primitiveInstVarAt();
		break;
	case 74:
		primitiveInstVarAtPut();
		break;
	case 75:
		primitiveAsOop();
		break;
	case 76:
		primitiveFail();
		break;
	case 77:
		primitiveSomeInstance();
		break;
	case 78:
		primitiveNextInstance();
		break;
	case 79:
		primitiveNewMethod();
		break;
	case 80:
		primitiveFail();
		break;
	case 81:
		primitiveValue();
		break;
	case 82:
		primitiveValueWithArgs();
		break;
	case 83:
		primitivePerform();
		break;
	case 84:
		primitivePerformWithArgs();
		break;
	case 85:
		primitiveSignal();
		break;
	case 86:
		primitiveWait();
		break;
	case 87:
		primitiveResume();
		break;
	case 88:
		primitiveSuspend();
		break;
	case 89:
		primitiveFlushCache();
		break;
	case 90:
		primitiveMousePoint();
		break;
	case 91:
	case 92:
		primitiveFail();
		break;
	case 93:
		primitiveInputSemaphore();
		break;
	case 94:
		primitiveFail();
		break;
	case 95:
		primitiveInputWord();
		break;
	case 96:
		primitiveCopyBits();
		break;
	case 97:
		primitiveSnapshot();
		break;
	case 98:
	case 99:
	case 100:
		primitiveFail();
		break;
	case 101:
		primitiveBeCursor();
		break;
	case 102:
		primitiveBeDisplay();
		break;
	case 103:
		primitiveScanCharacters();
		break;
	case 104:
		primitiveDrawLoop();
		break;
	case 105:
		primitiveStringReplace();
		break;
	case 106:
		primitiveScreenSize();
		break;
	case 107:
		primitiveMouseButtons();
		break;
	case 108:
		primitiveKbdNext();
		break;
	case 109:
		primitiveKbdPeek();
		break;
	case 110:
		primitiveEquivalent();
		break;
	case 111:
		primitiveClass();
		break;
	case 112:
		primitiveBytesLeft();
		break;
	case 113:
		primitiveQuit();
		break;
	case 114:
		primitiveExitToDebugger();
		break;
	case 115:
	case 116:
	case 117:
		primitiveFail();
		break;
	case 118:
		primitiveDoPrimitiveWithArgs();
		break;
	case 119:
		primitiveFlushCacheSelective();
		break;
	case 120:
		primitiveFail();
		break;
	case 121:
		primitiveImageName();
		break;
	case 122:
		primitiveNoop();
		break;
	case 123:
		primitiveFail();
		break;
	case 124:
		primitiveLowSpaceSemaphore();
		break;
	case 125:
		primitiveSignalAtBytesLeft();
		break;
	case 126:
		primitiveDeferDisplayUpdates();
		break;
	case 127:
		primitiveShowDisplayRect();
		break;
	case 128:
		primitiveArrayBecome();
		break;
	case 129:
		primitiveSpecialObjectsOop();
		break;
	case 130:
		primitiveFullGC();
		break;
	case 131:
		primitiveIncrementalGC();
		break;
	case 132:
		primitiveObjectPointsTo();
		break;
	case 133:
		primitiveSetInterruptKey();
		break;
	case 134:
		primitiveInterruptSemaphore();
		break;
	case 135:
		primitiveMillisecondClock();
		break;
	case 136:
		primitiveSignalAtMilliseconds();
		break;
	case 137:
		primitiveSecondsClock();
		break;
	case 138:
		primitiveSomeObject();
		break;
	case 139:
		primitiveNextObject();
		break;
	case 140:
		primitiveBeep();
		break;
	case 141:
		primitiveClipboardText();
		break;
	case 142:
		primitiveVMPath();
		break;
	case 143:
		primitiveShortAt();
		break;
	case 144:
		primitiveShortAtPut();
		break;
	case 145:
		primitiveConstantFill();
		break;
	case 146:
		primitiveReadJoystick();
		break;
	case 147:
		primitiveWarpBits();
		break;
	case 148:
		primitiveClone();
		break;
	case 149:
		primitiveGetAttribute();
		break;
	case 150:
		primitiveFileAtEnd();
		break;
	case 151:
		primitiveFileClose();
		break;
	case 152:
		primitiveFileGetPosition();
		break;
	case 153:
		primitiveFileOpen();
		break;
	case 154:
		primitiveFileRead();
		break;
	case 155:
		primitiveFileSetPosition();
		break;
	case 156:
		primitiveFileDelete();
		break;
	case 157:
		primitiveFileSize();
		break;
	case 158:
		primitiveFileWrite();
		break;
	case 159:
		primitiveFileRename();
		break;
	case 160:
		primitiveDirectoryCreate();
		break;
	case 161:
		primitiveDirectoryDelimitor();
		break;
	case 162:
		primitiveDirectoryLookup();
		break;
	case 163:
	case 164:
	case 165:
	case 166:
	case 167:
	case 168:
		primitiveFail();
		break;
	case 169:
		primitiveDirectorySetMacTypeAndCreator();
		break;
	case 170:
		primitiveSoundStart();
		break;
	case 171:
		primitiveSoundStartWithSemaphore();
		break;
	case 172:
		primitiveSoundStop();
		break;
	case 173:
		primitiveSoundAvailableSpace();
		break;
	case 174:
		primitiveSoundPlaySamples();
		break;
	case 175:
		primitiveSoundPlaySilence();
		break;
	case 176:
		primWaveTableSoundmixSampleCountintostartingAtpan();
		break;
	case 177:
		primFMSoundmixSampleCountintostartingAtpan();
		break;
	case 178:
		primPluckedSoundmixSampleCountintostartingAtpan();
		break;
	case 179:
		primSampledSoundmixSampleCountintostartingAtpan();
		break;
	case 180:
		primFMSoundmixSampleCountintostartingAtleftVolrightVol();
		break;
	case 181:
		primPluckedSoundmixSampleCountintostartingAtleftVolrightVol();
		break;
	case 182:
		primSampledSoundmixSampleCountintostartingAtleftVolrightVol();
		break;
	case 183:
		primReverbSoundapplyReverbTostartingAtcount();
		break;
	case 184:
		primLoopedSampledSoundmixSampleCountintostartingAtleftVolrightVol();
		break;
	case 185:
	case 186:
	case 187:
	case 188:
		primitiveFail();
		break;
	case 189:
		primitiveSoundInsertSamples();
		break;
	case 190:
		primitiveSoundStartRecording();
		break;
	case 191:
		primitiveSoundStopRecording();
		break;
	case 192:
		primitiveSoundGetRecordingSampleRate();
		break;
	case 193:
		primitiveSoundRecordSamples();
		break;
	case 194:
		primitiveSoundSetRecordLevel();
		break;
	case 195:
	case 196:
	case 197:
	case 198:
	case 199:
		primitiveFail();
		break;
	case 200:
		primitiveInitializeNetwork();
		break;
	case 201:
		primitiveResolverStartNameLookup();
		break;
	case 202:
		primitiveResolverNameLookupResult();
		break;
	case 203:
		primitiveResolverStartAddressLookup();
		break;
	case 204:
		primitiveResolverAddressLookupResult();
		break;
	case 205:
		primitiveResolverAbortLookup();
		break;
	case 206:
		primitiveResolverLocalAddress();
		break;
	case 207:
		primitiveResolverStatus();
		break;
	case 208:
		primitiveResolverError();
		break;
	case 209:
		primitiveSocketCreate();
		break;
	case 210:
		primitiveSocketDestroy();
		break;
	case 211:
		primitiveSocketConnectionStatus();
		break;
	case 212:
		primitiveSocketError();
		break;
	case 213:
		primitiveSocketLocalAddress();
		break;
	case 214:
		primitiveSocketLocalPort();
		break;
	case 215:
		primitiveSocketRemoteAddress();
		break;
	case 216:
		primitiveSocketRemotePort();
		break;
	case 217:
		primitiveSocketConnectToPort();
		break;
	case 218:
		primitiveSocketListenOnPort();
		break;
	case 219:
		primitiveSocketCloseConnection();
		break;
	case 220:
		primitiveSocketAbortConnection();
		break;
	case 221:
		primitiveSocketReceiveDataBufCount();
		break;
	case 222:
		primitiveSocketReceiveDataAvailable();
		break;
	case 223:
		primitiveSocketSendDataBufCount();
		break;
	case 224:
		primitiveSocketSendDone();
		break;
	case 225:
	case 226:
	case 227:
	case 228:
	case 229:
		primitiveFail();
		break;
	case 230:
		primitiveRelinquishProcessor();
		break;
	case 231:
		primitiveForceDisplayUpdate();
		break;
	case 232:
		primitiveFormPrint();
		break;
	case 233:
		primitiveSetFullScreen();
		break;
	case 234:
		primBitmapdecompressfromByteArrayat();
		break;
	case 235:
		primStringcomparewithcollated();
		break;
	case 236:
		primSampledSoundconvert8bitSignedFromto16Bit();
		break;
	case 237:
		primBitmapcompresstoByteArray();
		break;
	case 238:
		primitiveSerialPortOpen();
		break;
	case 239:
		primitiveSerialPortClose();
		break;
	case 240:
		primitiveSerialPortWrite();
		break;
	case 241:
		primitiveSerialPortRead();
		break;
	case 242:
		primitiveFail();
		break;
	case 243:
		primStringtranslatefromtotable();
		break;
	case 244:
		primStringfindFirstInStringinSetstartingAt();
		break;
	case 245:
		primStringindexOfAsciiinStringstartingAt();
		break;
	case 246:
	case 247:
	case 248:
	case 249:
		primitiveFail();
		break;
	case 250:
		clearProfile();
		break;
	case 251:
		dumpProfile();
		break;
	case 252:
		startProfiling();
		break;
	case 253:
		stopProfiling();
		break;
	case 254:
		primitiveVMParameter();
		break;
	case 255:
		primitiveFail();
		break;
	case 256:
		primitivePushSelf();
		break;
	case 257:
		primitivePushTrue();
		break;
	case 258:
		primitivePushFalse();
		break;
	case 259:
		primitivePushNil();
		break;
	case 260:
		primitivePushMinusOne();
		break;
	case 261:
		primitivePushZero();
		break;
	case 262:
		primitivePushOne();
		break;
	case 263:
		primitivePushTwo();
		break;
	case 264:
	case 265:
	case 266:
	case 267:
	case 268:
	case 269:
	case 270:
	case 271:
	case 272:
	case 273:
	case 274:
	case 275:
	case 276:
	case 277:
	case 278:
	case 279:
	case 280:
	case 281:
	case 282:
	case 283:
	case 284:
	case 285:
	case 286:
	case 287:
	case 288:
	case 289:
	case 290:
	case 291:
	case 292:
	case 293:
	case 294:
	case 295:
	case 296:
	case 297:
	case 298:
	case 299:
	case 300:
	case 301:
	case 302:
	case 303:
	case 304:
	case 305:
	case 306:
	case 307:
	case 308:
	case 309:
	case 310:
	case 311:
	case 312:
	case 313:
	case 314:
	case 315:
	case 316:
	case 317:
	case 318:
	case 319:
	case 320:
	case 321:
	case 322:
	case 323:
	case 324:
	case 325:
	case 326:
	case 327:
	case 328:
	case 329:
	case 330:
	case 331:
	case 332:
	case 333:
	case 334:
	case 335:
	case 336:
	case 337:
	case 338:
	case 339:
	case 340:
	case 341:
	case 342:
	case 343:
	case 344:
	case 345:
	case 346:
	case 347:
	case 348:
	case 349:
	case 350:
	case 351:
	case 352:
	case 353:
	case 354:
	case 355:
	case 356:
	case 357:
	case 358:
	case 359:
	case 360:
	case 361:
	case 362:
	case 363:
	case 364:
	case 365:
	case 366:
	case 367:
	case 368:
	case 369:
	case 370:
	case 371:
	case 372:
	case 373:
	case 374:
	case 375:
	case 376:
	case 377:
	case 378:
	case 379:
	case 380:
	case 381:
	case 382:
	case 383:
	case 384:
	case 385:
	case 386:
	case 387:
	case 388:
	case 389:
	case 390:
	case 391:
	case 392:
	case 393:
	case 394:
	case 395:
	case 396:
	case 397:
	case 398:
	case 399:
	case 400:
	case 401:
	case 402:
	case 403:
	case 404:
	case 405:
	case 406:
	case 407:
	case 408:
	case 409:
	case 410:
	case 411:
	case 412:
	case 413:
	case 414:
	case 415:
	case 416:
	case 417:
	case 418:
	case 419:
	case 420:
	case 421:
	case 422:
	case 423:
	case 424:
	case 425:
	case 426:
	case 427:
	case 428:
	case 429:
	case 430:
	case 431:
	case 432:
	case 433:
	case 434:
	case 435:
	case 436:
	case 437:
	case 438:
	case 439:
	case 440:
	case 441:
	case 442:
	case 443:
	case 444:
	case 445:
	case 446:
	case 447:
	case 448:
	case 449:
	case 450:
	case 451:
	case 452:
	case 453:
	case 454:
	case 455:
	case 456:
	case 457:
	case 458:
	case 459:
	case 460:
	case 461:
	case 462:
	case 463:
	case 464:
	case 465:
	case 466:
	case 467:
	case 468:
	case 469:
	case 470:
	case 471:
	case 472:
	case 473:
	case 474:
	case 475:
	case 476:
	case 477:
	case 478:
	case 479:
	case 480:
	case 481:
	case 482:
	case 483:
	case 484:
	case 485:
	case 486:
	case 487:
	case 488:
	case 489:
	case 490:
	case 491:
	case 492:
	case 493:
	case 494:
	case 495:
	case 496:
	case 497:
	case 498:
	case 499:
	case 500:
	case 501:
	case 502:
	case 503:
	case 504:
	case 505:
	case 506:
	case 507:
	case 508:
	case 509:
	case 510:
	case 511:
	case 512:
	case 513:
	case 514:
	case 515:
	case 516:
	case 517:
	case 518:
	case 519:
		primitiveLoadInstVar();
		break;
	case 520:
		primitiveFail();
		break;
	case 521:
		primitiveMIDIClosePort();
		break;
	case 522:
		primitiveMIDIGetClock();
		break;
	case 523:
		primitiveMIDIGetPortCount();
		break;
	case 524:
		primitiveMIDIGetPortDirectionality();
		break;
	case 525:
		primitiveMIDIGetPortName();
		break;
	case 526:
		primitiveMIDIOpenPort();
		break;
	case 527:
		primitiveMIDIParameterGetOrSet();
		break;
	case 528:
		primitiveMIDIRead();
		break;
	case 529:
		primitiveMIDIWrite();
		break;
	case 530:
	case 531:
	case 532:
	case 533:
	case 534:
	case 535:
	case 536:
	case 537:
	case 538:
	case 539:
		primitiveFail();
		break;
	case 540:
		primitiveAsyncFileClose();
		break;
	case 541:
		primitiveAsyncFileOpen();
		break;
	case 542:
		primitiveAsyncFileReadResult();
		break;
	case 543:
		primitiveAsyncFileReadStart();
		break;
	case 544:
		primitiveAsyncFileWriteResult();
		break;
	case 545:
		primitiveAsyncFileWriteStart();
		break;
	case 546:
	case 547:
	case 548:
	case 549:
	case 550:
	case 551:
	case 552:
	case 553:
	case 554:
	case 555:
	case 556:
	case 557:
	case 558:
	case 559:
	case 560:
	case 561:
	case 562:
	case 563:
	case 564:
	case 565:
	case 566:
	case 567:
	case 568:
	case 569:
	case 570:
	case 571:
	case 572:
	case 573:
	case 574:
	case 575:
	case 576:
	case 577:
	case 578:
	case 579:
	case 580:
	case 581:
	case 582:
	case 583:
	case 584:
	case 585:
	case 586:
	case 587:
	case 588:
	case 589:
	case 590:
	case 591:
	case 592:
	case 593:
	case 594:
	case 595:
	case 596:
	case 597:
	case 598:
	case 599:
	case 600:
	case 601:
	case 602:
	case 603:
	case 604:
	case 605:
	case 606:
	case 607:
	case 608:
	case 609:
	case 610:
	case 611:
	case 612:
	case 613:
	case 614:
	case 615:
	case 616:
	case 617:
	case 618:
	case 619:
	case 620:
	case 621:
	case 622:
	case 623:
	case 624:
	case 625:
	case 626:
	case 627:
	case 628:
	case 629:
	case 630:
	case 631:
	case 632:
	case 633:
	case 634:
	case 635:
	case 636:
	case 637:
	case 638:
	case 639:
	case 640:
	case 641:
	case 642:
	case 643:
	case 644:
	case 645:
	case 646:
	case 647:
	case 648:
	case 649:
	case 650:
	case 651:
	case 652:
	case 653:
	case 654:
	case 655:
	case 656:
	case 657:
	case 658:
	case 659:
	case 660:
	case 661:
	case 662:
	case 663:
	case 664:
	case 665:
	case 666:
	case 667:
	case 668:
	case 669:
	case 670:
	case 671:
	case 672:
	case 673:
	case 674:
	case 675:
	case 676:
	case 677:
	case 678:
	case 679:
	case 680:
	case 681:
	case 682:
	case 683:
	case 684:
	case 685:
	case 686:
	case 687:
	case 688:
	case 689:
	case 690:
	case 691:
	case 692:
	case 693:
	case 694:
	case 695:
	case 696:
	case 697:
	case 698:
	case 699:
	case 700:
		primitiveFail();
		break;
	}
	if ((nextWakeupTick != 0) && ((ioLowResMSecs()) != startTime)) {
		if (((ioMSecs()) & 536870911) >= nextWakeupTick) {
			if (successFlag) {
				checkForInterrupts();
			} else {
				interruptCheckCounter = 0;
			}
		}
	}
	return successFlag;
}

int primitiveResume(void) {
    int proc;

	proc = stackTop();
	if (successFlag) {
		resume(proc);
	}
}

int primitiveScanCharacters(void) {
    int stopArray;
    int displayFlag;
    int start;
    int stop;
    int string;
    int rcvr;
    int rightX;

	rcvr = stackValue(6);
	start = stackIntegerValue(5);
	stop = stackIntegerValue(4);
	string = stackValue(3);
	rightX = stackIntegerValue(2);
	stopArray = stackValue(1);
	displayFlag = booleanValueOf(stackValue(0));
	if (!(successFlag)) {
		return null;
	}
	success(loadScannerFromstartstopstringrightXstopArraydisplayFlag(rcvr, start, stop, string, rightX, stopArray, displayFlag));
	if (successFlag) {
		scanCharacters();
	}
	if (successFlag) {
		if (displayFlag) {
			showDisplayBits();
		}
		pop(7);
		push(stopReason());
	}
}

int primitiveScreenSize(void) {
    int pointWord;

	pop(1);
	pointWord = ioScreenSize();
	push(makePointwithxValueyValue((((unsigned) pointWord) >> 16) & 65535, pointWord & 65535));
}

int primitiveSecondsClock(void) {
	pop(1);
	push(positive32BitIntegerFor(ioSeconds()));
}

int primitiveSerialPortClose(void) {
    int portNum;

	portNum = stackIntegerValue(0);
	if (successFlag) {
		serialPortClose(portNum);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveSerialPortOpen(void) {
    int dataBits;
    int parityType;
    int stopBitsType;
    int portNum;
    int baudRate;
    int xOnChar;
    int xOffChar;
    int inFlowControl;
    int outFlowControl;

	xOffChar = stackIntegerValue(0);
	xOnChar = stackIntegerValue(1);
	outFlowControl = stackIntegerValue(2);
	inFlowControl = stackIntegerValue(3);
	dataBits = stackIntegerValue(4);
	parityType = stackIntegerValue(5);
	stopBitsType = stackIntegerValue(6);
	baudRate = stackIntegerValue(7);
	portNum = stackIntegerValue(8);
	if (successFlag) {
		serialPortOpen(
			portNum, baudRate, stopBitsType, parityType, dataBits,
			inFlowControl, outFlowControl, xOnChar, xOffChar);
	}
	if (successFlag) {
		pop(9);
	}
}

int primitiveSerialPortRead(void) {
    int array;
    int startIndex;
    int portNum;
    int bytesRead;
    int count;
    int fmt;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	array = stackValue(2);
	portNum = stackIntegerValue(3);
	fmt = formatOf(array);
	success((fmt >= 8) && (fmt <= 11));
	success((startIndex >= 1) && (((startIndex + count) - 1) <= (lengthOf(array))));
	if (successFlag) {
		bytesRead = serialPortReadInto(portNum, count, ((array + 4) + startIndex) - 1);
	}
	if (successFlag) {
		pop(5);
		pushInteger(bytesRead);
	}
}

int primitiveSerialPortWrite(void) {
    int array;
    int startIndex;
    int portNum;
    int bytesWritten;
    int count;
    int fmt;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	array = stackValue(2);
	portNum = stackIntegerValue(3);
	fmt = formatOf(array);
	success((fmt >= 8) && (fmt <= 11));
	success((startIndex >= 1) && (((startIndex + count) - 1) <= (lengthOf(array))));
	if (successFlag) {
		bytesWritten = serialPortWriteFrom(portNum, count, ((array + 4) + startIndex) - 1);
	}
	if (successFlag) {
		pop(5);
		pushInteger(bytesWritten);
	}
}

int primitiveSetFullScreen(void) {
    int argOop;

	argOop = stackTop();
	if (argOop == trueObj) {
		ioSetFullScreen(true);
	} else {
		if (argOop == falseObj) {
			ioSetFullScreen(false);
		} else {
			primitiveFail();
		}
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveSetInterruptKey(void) {
    int keycode;

	keycode = popInteger();
	if (successFlag) {
		interruptKeycode = keycode;
	} else {
		unPop(1);
	}
}

int primitiveShortAt(void) {
    int addr;
    int sz;
    int value;
    int index;
    int rcvr;

	index = stackIntegerValue(0);
	rcvr = stackValue(1);
	success((!((rcvr & 1))) && (isWordsOrBytes(rcvr)));
	if (!(successFlag)) {
		return null;
	}
	sz = ((int) ((sizeBitsOf(rcvr)) - 4) >> 1);
	success((index >= 1) && (index <= sz));
	if (successFlag) {
		addr = (rcvr + 4) + (2 * (index - 1));
		value = *((short int *) addr);
		pop(2);
		pushInteger(value);
	}
}

int primitiveShortAtPut(void) {
    int addr;
    int sz;
    int value;
    int index;
    int rcvr;

	value = stackIntegerValue(0);
	index = stackIntegerValue(1);
	rcvr = stackValue(2);
	success((!((rcvr & 1))) && (isWordsOrBytes(rcvr)));
	if (!(successFlag)) {
		return null;
	}
	sz = ((int) ((sizeBitsOf(rcvr)) - 4) >> 1);
	success((index >= 1) && (index <= sz));
	success((value >= -32768) && (value <= 32767));
	if (successFlag) {
		addr = (rcvr + 4) + (2 * (index - 1));
		*((short int *) addr) = value;
		pop(2);
	}
}

int primitiveShowDisplayRect(void) {
    int displayObj;
    int dispBits;
    int dispBitsPtr;
    int top;
    int bottom;
    int h;
    int w;
    int d;
    int right;
    int left;

	bottom = stackIntegerValue(0);
	top = stackIntegerValue(1);
	right = stackIntegerValue(2);
	left = stackIntegerValue(3);
	displayObj = splObj(14);
	success((isPointers(displayObj)) && ((lengthOf(displayObj)) >= 4));
	if (successFlag) {
		dispBits = fetchPointerofObject(0, displayObj);
		w = fetchIntegerofObject(1, displayObj);
		h = fetchIntegerofObject(2, displayObj);
		d = fetchIntegerofObject(3, displayObj);
	}
	if (left < 0) {
		left = 0;
	}
	if (right > w) {
		right = w;
	}
	if (top < 0) {
		top = 0;
	}
	if (bottom > h) {
		bottom = h;
	}
	success((left <= right) && (top <= bottom));
	if (successFlag) {
		dispBitsPtr = dispBits + 4;
		ioShowDisplay(dispBitsPtr, w, h, d, left, right, top, bottom);
	}
	if (successFlag) {
		pop(4);
	}
}

int primitiveSignal(void) {
    int sema;

	sema = stackTop();
	assertClassOfis(sema, splObj(18));
	if (successFlag) {
		synchronousSignal(sema);
	}
}

int primitiveSignalAtBytesLeft(void) {
    int bytes;

	bytes = popInteger();
	if (successFlag) {
		lowSpaceThreshold = bytes;
	} else {
		lowSpaceThreshold = 0;
		unPop(1);
	}
}

int primitiveSignalAtMilliseconds(void) {
    int sema;
    int tick;

	tick = popInteger();
	sema = popStack();
	if (successFlag) {
		if ((fetchClassOf(sema)) == (splObj(18))) {
			storePointerofObjectwithValue(29, specialObjectsOop, sema);
			nextWakeupTick = tick;
		} else {
			storePointerofObjectwithValue(29, specialObjectsOop, nilObj);
			nextWakeupTick = 0;
		}
	} else {
		unPop(2);
	}
}

int primitiveSine(void) {
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		pushFloat(sin(rcvr));
	} else {
		unPop(1);
	}
}

int primitiveSize(void) {
    int sz;
    int rcvr;

	rcvr = stackTop();
	if ((rcvr & 1)) {
		sz = 0;
	} else {
		sz = stSizeOf(rcvr);
	}
	if (successFlag) {
		pop(1);
		pushInteger(sz);
	} else {
		failSpecialPrim(62);
	}
}

int primitiveSnapshot(void) {
    int activeProc;
    int dataSize;
    int rcvr;

	storeContextRegisters(activeContext);
	activeProc = fetchPointerofObject(1, schedulerPointer());
	storePointerofObjectwithValue(1, activeProc, activeContext);
	incrementalGC();
	fullGC();
	dataSize = freeBlock - (startOfMemory());
	if (successFlag) {
		rcvr = popStack();
		push(trueObj);
		writeImageFile(dataSize);
		pop(1);
	}
	if (successFlag) {
		push(falseObj);
	} else {
		push(rcvr);
	}
}

int primitiveSocketAbortConnection(void) {
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		sqSocketAbortConnection(s);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveSocketCloseConnection(void) {
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		sqSocketCloseConnection(s);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveSocketConnectToPort(void) {
    int addr;
    int port;
    SocketPtr s;

	port = stackIntegerValue(0);
	addr = netAddressToInt(stackValue(1));
	s = socketValueOf(stackValue(2));
	if (successFlag) {
		sqSocketConnectToPort(s, addr, port);
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveSocketConnectionStatus(void) {
    int status;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		status = sqSocketConnectionStatus(s);
	}
	if (successFlag) {
		popthenPush(2, ((status << 1) | 1));
	}
}

int primitiveSocketCreate(void) {
    int semaIndex;
    int socketType;
    int sendBufSize;
    int socketOop;
    int netType;
    SocketPtr s;
    int recvBufSize;

	semaIndex = stackIntegerValue(0);
	sendBufSize = stackIntegerValue(1);
	recvBufSize = stackIntegerValue(2);
	socketType = stackIntegerValue(3);
	netType = stackIntegerValue(4);
	if (successFlag) {
		socketOop = instantiateClassindexableSize(splObj(26), socketRecordSize());
		s = socketValueOf(socketOop);
		sqSocketCreateNetTypeSocketTypeRecvBytesSendBytesSemaID(s, netType, socketType, recvBufSize, sendBufSize, semaIndex);
		if (successFlag) {
			popthenPush(6, socketOop);
		}
	}
}

int primitiveSocketDestroy(void) {
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		sqSocketDestroy(s);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveSocketError(void) {
    int err;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		err = sqSocketError(s);
	}
	if (successFlag) {
		popthenPush(2, ((err << 1) | 1));
	}
}

int primitiveSocketListenOnPort(void) {
    int port;
    SocketPtr s;

	port = stackIntegerValue(0);
	s = socketValueOf(stackValue(1));
	if (successFlag) {
		sqSocketListenOnPort(s, port);
	}
	if (successFlag) {
		pop(2);
	}
}

int primitiveSocketLocalAddress(void) {
    int addr;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		addr = sqSocketLocalAddress(s);
	}
	if (successFlag) {
		popthenPush(2, intToNetAddress(addr));
	}
}

int primitiveSocketLocalPort(void) {
    int port;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		port = sqSocketLocalPort(s);
	}
	if (successFlag) {
		popthenPush(2, ((port << 1) | 1));
	}
}

int primitiveSocketReceiveDataAvailable(void) {
    int dataIsAvailable;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		dataIsAvailable = sqSocketReceiveDataAvailable(s);
	}
	if (successFlag) {
		pop(2);
		pushBool(dataIsAvailable);
	}
}

int primitiveSocketReceiveDataBufCount(void) {
    int array;
    int startIndex;
    int arrayBase;
    int bytesReceived;
    int bufStart;
    int byteSize;
    SocketPtr s;
    int count;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	array = stackValue(2);
	s = socketValueOf(stackValue(3));
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	} else {
		byteSize = 1;
	}
	success((startIndex >= 1) && ((count >= 0) && (((startIndex + count) - 1) <= (lengthOf(array)))));
	if (successFlag) {
		arrayBase = array + 4;
		bufStart = arrayBase + ((startIndex - 1) * byteSize);
		bytesReceived = sqSocketReceiveDataBufCount(s, bufStart, count * byteSize);
	}
	if (successFlag) {
		pop(5);
		pushInteger(bytesReceived / byteSize);
	}
}

int primitiveSocketRemoteAddress(void) {
    int addr;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		addr = sqSocketRemoteAddress(s);
	}
	if (successFlag) {
		popthenPush(2, intToNetAddress(addr));
	}
}

int primitiveSocketRemotePort(void) {
    int port;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		port = sqSocketRemotePort(s);
	}
	if (successFlag) {
		popthenPush(2, ((port << 1) | 1));
	}
}

int primitiveSocketSendDataBufCount(void) {
    int array;
    int startIndex;
    int arrayBase;
    int bytesSent;
    int bufStart;
    int byteSize;
    SocketPtr s;
    int count;

	count = stackIntegerValue(0);
	startIndex = stackIntegerValue(1);
	array = stackValue(2);
	s = socketValueOf(stackValue(3));
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	} else {
		byteSize = 1;
	}
	success((startIndex >= 1) && ((count >= 0) && (((startIndex + count) - 1) <= (lengthOf(array)))));
	if (successFlag) {
		arrayBase = array + 4;
		bufStart = arrayBase + ((startIndex - 1) * byteSize);
		bytesSent = sqSocketSendDataBufCount(s, bufStart, count * byteSize);
	}
	if (successFlag) {
		pop(5);
		pushInteger(bytesSent / byteSize);
	}
}

int primitiveSocketSendDone(void) {
    int done;
    SocketPtr s;

	s = socketValueOf(stackTop());
	if (successFlag) {
		done = sqSocketSendDone(s);
	}
	if (successFlag) {
		pop(2);
		pushBool(done);
	}
}

int primitiveSomeInstance(void) {
    int instance;
    int class;

	class = popStack();
	instance = initialInstanceOf(class);
	if (instance == nilObj) {
		unPop(1);
		primitiveFail();
	} else {
		push(instance);
	}
}

int primitiveSomeObject(void) {
	pop(1);
	push(firstAccessibleObject());
}

int primitiveSoundAvailableSpace(void) {
    int frames;

	frames = snd_AvailableSpace();
	success(frames >= 0);
	if (successFlag) {
		pop(1);
		push(positive32BitIntegerFor(frames));
	}
}

int primitiveSoundGetRecordingSampleRate(void) {
    double rate;

	rate = snd_GetRecordingSampleRate();
	if (successFlag) {
		pop(1);
		pushFloat(rate);
	}
}

int primitiveSoundInsertSamples(void) {
    int buf;
    int leadTime;
    int frameCount;
    int framesPlayed;

	leadTime = stackIntegerValue(0);
	buf = stackValue(1);
	frameCount = stackIntegerValue(2);
	success(isWords(buf));
	success(frameCount <= (lengthOf(buf)));
	if (successFlag) {
		framesPlayed = snd_InsertSamplesFromLeadTime(frameCount, buf + 4, leadTime);
		success(framesPlayed >= 0);
	}
	if (successFlag) {
		pop(4);
		push(positive32BitIntegerFor(framesPlayed));
	}
}

int primitiveSoundPlaySamples(void) {
    int startIndex;
    int buf;
    int frameCount;
    int framesPlayed;

	startIndex = stackIntegerValue(0);
	buf = stackValue(1);
	frameCount = stackIntegerValue(2);
	success(isWords(buf));
	success((startIndex >= 1) && (((startIndex + frameCount) - 1) <= (lengthOf(buf))));
	if (successFlag) {
		framesPlayed = snd_PlaySamplesFromAtLength(frameCount, buf + 4, startIndex - 1);
		success(framesPlayed >= 0);
	}
	if (successFlag) {
		pop(4);
		push(positive32BitIntegerFor(framesPlayed));
	}
}

int primitiveSoundPlaySilence(void) {
    int framesPlayed;

	framesPlayed = snd_PlaySilence();
	success(framesPlayed >= 0);
	if (successFlag) {
		pop(1);
		push(positive32BitIntegerFor(framesPlayed));
	}
}

int primitiveSoundRecordSamples(void) {
    int startWordIndex;
    int samplesRecorded;
    int bufSizeInBytes;
    int buf;

	startWordIndex = stackIntegerValue(0);
	buf = stackValue(1);
	success(isWords(buf));
	if (successFlag) {
		bufSizeInBytes = (lengthOf(buf)) * 4;
		success((startWordIndex >= 1) && (((startWordIndex - 1) * 2) < bufSizeInBytes));
	}
	if (successFlag) {
		samplesRecorded = snd_RecordSamplesIntoAtLength(buf + 4, startWordIndex - 1, bufSizeInBytes);
	}
	if (successFlag) {
		pop(3);
		push(((samplesRecorded << 1) | 1));
	}
}

int primitiveSoundSetRecordLevel(void) {
    int level;

	level = stackIntegerValue(0);
	if (successFlag) {
		snd_SetRecordLevel(level);
	}
	if (successFlag) {
		pop(1);
	}
}

int primitiveSoundStart(void) {
    int stereoFlag;
    int samplesPerSec;
    int bufFrames;

	stereoFlag = booleanValueOf(stackValue(0));
	samplesPerSec = stackIntegerValue(1);
	bufFrames = stackIntegerValue(2);
	if (successFlag) {
		success(snd_Start(bufFrames, samplesPerSec, stereoFlag, 0));
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveSoundStartRecording(void) {
    int stereoFlag;
    int semaIndex;
    int desiredSamplesPerSec;

	semaIndex = stackIntegerValue(0);
	stereoFlag = booleanValueOf(stackValue(1));
	desiredSamplesPerSec = stackIntegerValue(2);
	if (successFlag) {
		snd_StartRecording(desiredSamplesPerSec, stereoFlag, semaIndex);
	}
	if (successFlag) {
		pop(3);
	}
}

int primitiveSoundStartWithSemaphore(void) {
    int stereoFlag;
    int semaIndex;
    int samplesPerSec;
    int bufFrames;

	semaIndex = stackIntegerValue(0);
	stereoFlag = booleanValueOf(stackValue(1));
	samplesPerSec = stackIntegerValue(2);
	bufFrames = stackIntegerValue(3);
	if (successFlag) {
		success(snd_Start(bufFrames, samplesPerSec, stereoFlag, semaIndex));
	}
	if (successFlag) {
		pop(4);
	}
}

int primitiveSoundStop(void) {
	snd_Stop();
}

int primitiveSoundStopRecording(void) {
	snd_StopRecording();
}

int primitiveSpecialObjectsOop(void) {
	pop(1);
	push(specialObjectsOop);
}

int primitiveSquareRoot(void) {
    double rcvr;

	rcvr = popFloat();
	success(rcvr >= 0.0);
	if (successFlag) {
		pushFloat(sqrt(rcvr));
	} else {
		unPop(1);
	}
}

int primitiveStringAt(void) {
	commonAt(true);
}

int primitiveStringAtPut(void) {
	commonAtPut(true);
}

int primitiveStringReplace(void) {
    int array;
    int srcIndex;
    int start;
    int stop;
    int arrayFmt;
    int arrayInstSize;
    int i;
    int hdr;
    int totalLength;
    int repl;
    int replStart;
    int replFmt;
    int replInstSize;

	array = stackValue(4);
	start = stackIntegerValue(3);
	stop = stackIntegerValue(2);
	repl = stackValue(1);
	replStart = stackIntegerValue(0);
	if (!(successFlag)) {
		return primitiveFail();
	}
	if ((repl & 1)) {
		return primitiveFail();
	}
	hdr = baseHeader(array);
	arrayFmt = (((unsigned) hdr) >> 8) & 15;
	totalLength = lengthOfbaseHeaderformat(array, hdr, arrayFmt);
	arrayInstSize = fixedFieldsOfformatlength(array, arrayFmt, totalLength);
	if (!((start >= 1) && ((start <= stop) && ((stop + arrayInstSize) <= totalLength)))) {
		return primitiveFail();
	}
	hdr = baseHeader(repl);
	replFmt = (((unsigned) hdr) >> 8) & 15;
	totalLength = lengthOfbaseHeaderformat(repl, hdr, replFmt);
	replInstSize = fixedFieldsOfformatlength(repl, replFmt, totalLength);
	if (!((replStart >= 1) && ((((stop - start) + replStart) + replInstSize) <= totalLength))) {
		return primitiveFail();
	}
	if (arrayFmt < 8) {
		if (!(arrayFmt == replFmt)) {
			return primitiveFail();
		}
	} else {
		if (!((arrayFmt & 12) == (replFmt & 12))) {
			return primitiveFail();
		}
	}
	srcIndex = (replStart + replInstSize) - 1;
	if (arrayFmt < 4) {
		for (i = ((start + arrayInstSize) - 1); i <= ((stop + arrayInstSize) - 1); i += 1) {
			storePointerofObjectwithValue(i, array, fetchPointerofObject(srcIndex, repl));
			srcIndex += 1;
		}
	} else {
		if (arrayFmt < 8) {
			for (i = ((start + arrayInstSize) - 1); i <= ((stop + arrayInstSize) - 1); i += 1) {
				storeWordofObjectwithValue(i, array, fetchWordofObject(srcIndex, repl));
				srcIndex += 1;
			}
		} else {
			for (i = ((start + arrayInstSize) - 1); i <= ((stop + arrayInstSize) - 1); i += 1) {
				storeByteofObjectwithValue(i, array, fetchByteofObject(srcIndex, repl));
				srcIndex += 1;
			}
		}
	}
	pop(4);
}

int primitiveSubtract(void) {
    int integerReceiver;
    int integerArgument;

	successFlag = true;
	integerArgument = popInteger();
	integerReceiver = popInteger();
	checkIntegerResultfrom(integerReceiver - integerArgument, 2);
}

int primitiveSuspend(void) {
    int activeProc;

	activeProc = fetchPointerofObject(1, schedulerPointer());
	success((stackTop()) == activeProc);
	if (successFlag) {
		pop(1);
		push(nilObj);
		transferTo(wakeHighestPriority());
	}
}

int primitiveTimesTwoPower(void) {
    int arg;
    double rcvr;

	arg = popInteger();
	rcvr = popFloat();
	if (successFlag) {
		pushFloat(ldexp(rcvr, arg));
	} else {
		unPop(2);
	}
}

int primitiveTruncated(void) {
    double trunc;
    double frac;
    double rcvr;

	rcvr = popFloat();
	if (successFlag) {
		frac = modf(rcvr, &trunc);
		success((-1073741824.0 <= trunc) && (trunc <= 1073741823.0));
	}
	if (successFlag) {
		pushInteger((int) trunc);
	} else {
		unPop(1);
	}
}

int primitiveVMParameter(void) {
    int mem;
    int arg;
    int paramsArraySize;
    int i;
    int index;
    int result;

	mem = ((int) memory);
	if (argumentCount == 0) {
		paramsArraySize = 22;
		result = instantiateClassindexableSize(splObj(7), paramsArraySize);
		for (i = 0; i <= (paramsArraySize - 1); i += 1) {
			storeWordofObjectwithValue(i, result, ((0 << 1) | 1));
		}
		storeWordofObjectwithValue(0, result, (((youngStart - mem) << 1) | 1));
		storeWordofObjectwithValue(1, result, (((freeBlock - mem) << 1) | 1));
		storeWordofObjectwithValue(2, result, (((endOfMemory - mem) << 1) | 1));
		storeWordofObjectwithValue(3, result, ((allocationCount << 1) | 1));
		storeWordofObjectwithValue(4, result, ((allocationsBetweenGCs << 1) | 1));
		storeWordofObjectwithValue(5, result, ((tenuringThreshold << 1) | 1));
		storeWordofObjectwithValue(6, result, ((statFullGCs << 1) | 1));
		storeWordofObjectwithValue(7, result, ((statFullGCMSecs << 1) | 1));
		storeWordofObjectwithValue(8, result, ((statIncrGCs << 1) | 1));
		storeWordofObjectwithValue(9, result, ((statIncrGCMSecs << 1) | 1));
		storeWordofObjectwithValue(10, result, ((statTenures << 1) | 1));
		storeWordofObjectwithValue(20, result, ((rootTableCount << 1) | 1));
		storeWordofObjectwithValue(21, result, ((statRootTableOverflows << 1) | 1));
		popthenPush(1, result);
		return null;
	}
	arg = stackTop();
	if (!((arg & 1))) {
		return primitiveFail();
	}
	arg = (arg >> 1);
	if (argumentCount == 1) {
		if ((arg < 1) || (arg > 22)) {
			return primitiveFail();
		}
		if (arg == 1) {
			result = youngStart - mem;
		}
		if (arg == 2) {
			result = freeBlock - mem;
		}
		if (arg == 3) {
			result = endOfMemory - mem;
		}
		if (arg == 4) {
			result = allocationCount;
		}
		if (arg == 5) {
			result = allocationsBetweenGCs;
		}
		if (arg == 6) {
			result = tenuringThreshold;
		}
		if (arg == 7) {
			result = statFullGCs;
		}
		if (arg == 8) {
			result = statFullGCMSecs;
		}
		if (arg == 9) {
			result = statIncrGCs;
		}
		if (arg == 10) {
			result = statIncrGCMSecs;
		}
		if (arg == 11) {
			result = statTenures;
		}
		if ((arg >= 12) && (arg <= 20)) {
			result = 0;
		}
		if (arg == 21) {
			result = rootTableCount;
		}
		if (arg == 22) {
			result = statRootTableOverflows;
		}
		popthenPush(2, ((result << 1) | 1));
		return null;
	}
	if (!(argumentCount == 2)) {
		return primitiveFail();
	}
	index = stackValue(1);
	if (!((index & 1))) {
		return primitiveFail();
	}
	index = (index >> 1);
	if (index <= 0) {
		return primitiveFail();
	}
	successFlag = false;
	if (index == 5) {
		result = allocationsBetweenGCs;
		allocationsBetweenGCs = arg;
		successFlag = true;
	}
	if (index == 6) {
		result = tenuringThreshold;
		tenuringThreshold = arg;
		successFlag = true;
	}
	if (successFlag) {
		popthenPush(3, ((result << 1) | 1));
		return null;
	}
	primitiveFail();
}

int primitiveVMPath(void) {
    int sz;
    int s;

	sz = vmPathSize();
	s = instantiateClassindexableSize(splObj(6), sz);
	vmPathGetLength(s + 4, sz);
	pop(1);
	push(s);
}

int primitiveValue(void) {
    int blockArgumentCount;
    int initialIP;
    int blockContext;

	blockContext = stackValue(argumentCount);
	blockArgumentCount = argumentCountOfBlock(blockContext);
	success((argumentCount == blockArgumentCount) && ((fetchPointerofObject(0, blockContext)) == nilObj));
	if (successFlag) {
		transferfromIndexofObjecttoIndexofObject(argumentCount, ((stackPointerIndex()) - argumentCount) + 1, activeContext, 6, blockContext);
		pop(argumentCount + 1);
		initialIP = fetchPointerofObject(4, blockContext);
		storePointerUncheckedofObjectwithValue(1, blockContext, initialIP);
		storeStackPointerValueinContext(argumentCount, blockContext);
		storePointerUncheckedofObjectwithValue(0, blockContext, activeContext);
		newActiveContext(blockContext);
	}
}

int primitiveValueWithArgs(void) {
    int argumentArray;
    int arrayArgumentCount;
    int blockArgumentCount;
    int initialIP;
    int blockContext;

	argumentArray = popStack();
	blockContext = popStack();
	blockArgumentCount = argumentCountOfBlock(blockContext);
	assertClassOfis(argumentArray, splObj(7));
	if (successFlag) {
		arrayArgumentCount = fetchWordLengthOf(argumentArray);
		success((arrayArgumentCount == blockArgumentCount) && ((fetchPointerofObject(0, blockContext)) == nilObj));
	}
	if (successFlag) {
		transferfromIndexofObjecttoIndexofObject(arrayArgumentCount, 0, argumentArray, 6, blockContext);
		initialIP = fetchPointerofObject(4, blockContext);
		storePointerUncheckedofObjectwithValue(1, blockContext, initialIP);
		storeStackPointerValueinContext(arrayArgumentCount, blockContext);
		storePointerUncheckedofObjectwithValue(0, blockContext, activeContext);
		newActiveContext(blockContext);
	} else {
		unPop(2);
	}
}

int primitiveWait(void) {
    int sema;
    int activeProc;
    int excessSignals;

	sema = stackTop();
	assertClassOfis(sema, splObj(18));
	if (successFlag) {
		excessSignals = fetchIntegerofObject(2, sema);
		if (excessSignals > 0) {
			storeIntegerofObjectwithValue(2, sema, excessSignals - 1);
		} else {
			activeProc = fetchPointerofObject(1, schedulerPointer());
			addLastLinktoList(activeProc, sema);
			transferTo(wakeHighestPriority());
		}
	}
}

int primitiveWarpBits(void) {
    int rcvr;

	rcvr = stackValue(argCount());
	success(loadBitBltFrom(rcvr));
	if (successFlag) {
		warpBits();
		showDisplayBits();
	}
}

int print(char *s) {
	printf("%s", s);
}

int printCallStack(void) {
    int methodSel;
    int methodClass;
    int home;
    int ctxt;

	ctxt = activeContext;
	while (!(ctxt == nilObj)) {
		if ((fetchClassOf(ctxt)) == (splObj(11))) {
			home = fetchPointerofObject(5, ctxt);
		} else {
			home = ctxt;
		}
		methodClass = findClassOfMethodforReceiver(fetchPointerofObject(3, home), fetchPointerofObject(5, home));
		methodSel = findSelectorOfMethodforReceiver(fetchPointerofObject(3, home), fetchPointerofObject(5, home));
		printNum(ctxt);
		print(" ");
		if (!(ctxt == home)) {
			print("[] in ");
		}
		printNameOfClasscount(methodClass, 5);
		print(">");
		printStringOf(methodSel);
		cr();
		ctxt = fetchPointerofObject(0, ctxt);
	}
}

int printChar(int aByte) {
	putchar(aByte);
}

int printNameOfClasscount(int classOop, int cnt) {
	if (cnt <= 0) {
		return print("bad class");
	}
	if ((sizeBitsOf(classOop)) == 32) {
		printNameOfClasscount(fetchPointerofObject(6, classOop), cnt - 1);
		print(" class");
	} else {
		printStringOf(fetchPointerofObject(6, classOop));
	}
}

int printNum(int n) {
	printf("%ld", (long) n);
}

int printStringOf(int oop) {
    int i;
    int fmt;
    int cnt;

	fmt = formatOf(oop);
	if (fmt < 8) {
		return null;
	}
	cnt = ((100 < (lengthOf(oop))) ? 100 : (lengthOf(oop)));
	i = 0;
	while (i < cnt) {
		printChar(fetchByteofObject(i, oop));
		i += 1;
	}
}

int push(int object) {
    int sp;

	longAtput(sp = stackPointer + 4, object);
	stackPointer = sp;
}

int pushActiveContextBytecode(void) {
	reclaimableContextCount = 0;
	internalPush(activeContext);
}

int pushBool(int trueOrFalse) {
	if (trueOrFalse) {
		push(trueObj);
	} else {
		push(falseObj);
	}
}

int pushConstantFalseBytecode(void) {
	internalPush(falseObj);
}

int pushConstantMinusOneBytecode(void) {
	internalPush(4294967295U);
}

int pushConstantNilBytecode(void) {
	internalPush(nilObj);
}

int pushConstantOneBytecode(void) {
	internalPush(3);
}

int pushConstantTrueBytecode(void) {
	internalPush(trueObj);
}

int pushConstantTwoBytecode(void) {
	internalPush(5);
}

int pushConstantZeroBytecode(void) {
	internalPush(1);
}

int pushFloat(double f) {
    int newFloatObj;

	newFloatObj = instantiateSmallClasssizeInBytesfill(splObj(9), 12, 0);
	storeFloatAtfrom(newFloatObj + 4, f);
	push(newFloatObj);
}

int pushInteger(int integerValue) {
	push(((integerValue << 1) | 1));
}

int pushLiteralConstant(int literalIndex) {
	internalPush(literal(literalIndex));
}

int pushLiteralConstantBytecode(void) {
	pushLiteralConstant(currentBytecode & 31);
}

int pushLiteralVariable(int literalIndex) {
	internalPush(fetchPointerofObject(1, literal(literalIndex)));
}

int pushLiteralVariableBytecode(void) {
	pushLiteralVariable(currentBytecode & 31);
}

int pushReceiverBytecode(void) {
	internalPush(receiver);
}

int pushReceiverVariable(int fieldIndex) {
	internalPush(fetchPointerofObject(fieldIndex, receiver));
}

int pushReceiverVariableBytecode(void) {
	pushReceiverVariable(currentBytecode & 15);
}

int pushRemappableOop(int oop) {
	remapBuffer[remapBufferCount += 1] = oop;
}

int pushTemporaryVariable(int temporaryIndex) {
	internalPush(temporary(temporaryIndex));
}

int pushTemporaryVariableBytecode(void) {
	pushTemporaryVariable(currentBytecode & 15);
}

int putLongtoFile(int n, sqImageFile f) {
    int wordsWritten;

	wordsWritten = sqImageFileWrite(&n, sizeof(int), 1, f);
	success(wordsWritten == 1);
}

int putToSleep(int aProcess) {
    int priority;
    int processLists;
    int processList;

	priority = quickFetchIntegerofObject(2, aProcess);
	processLists = fetchPointerofObject(0, schedulerPointer());
	processList = fetchPointerofObject(priority - 1, processLists);
	addLastLinktoList(aProcess, processList);
}

int quickCheckForInterrupts(void) {
	if ((interruptCheckCounter -= 1) <= 0) {
		checkForInterrupts();
	}
}

int quickFetchIntegerofObject(int fieldIndex, int objectPointer) {
	return ((fetchPointerofObject(fieldIndex, objectPointer)) >> 1);
}

int readImageFromFileHeapSize(sqImageFile f, int desiredHeapSize) {
    int swapBytes;
    int dataSize;
    int minimumMemory;
    int memStart;
    int bytesRead;
    int bytesToShift;
    int headerStart;
    int headerSize;
    int oldBaseAddr;

	swapBytes = checkImageVersionFrom(f);
	headerStart = (sqImageFilePosition(f)) - 4;
	headerSize = getLongFromFileswap(f, swapBytes);
	dataSize = getLongFromFileswap(f, swapBytes);
	oldBaseAddr = getLongFromFileswap(f, swapBytes);
	specialObjectsOop = getLongFromFileswap(f, swapBytes);
	lastHash = getLongFromFileswap(f, swapBytes);
	savedWindowSize = getLongFromFileswap(f, swapBytes);
	fullScreenFlag = getLongFromFileswap(f, swapBytes);
	if (lastHash == 0) {
		lastHash = 999;
	}
	minimumMemory = dataSize + 80000;
	if (desiredHeapSize < minimumMemory) {
		error("Insufficient memory for this image");
	}
	memory = (unsigned char *) sqAllocateMemory(minimumMemory, desiredHeapSize);
	if (memory == null) {
		error("Failed to allocate memory for the heap");
	}
	memStart = startOfMemory();
	memoryLimit = (memStart + desiredHeapSize) - 24;
	endOfMemory = memStart + dataSize;
	sqImageFileSeek(f, headerStart + headerSize);
	bytesRead = sqImageFileRead(memory, sizeof(unsigned char), dataSize, f);
	if (bytesRead != dataSize) {
		error("Read failed or premature end of image file");
	}
	if (swapBytes) {
		reverseBytesInImage();
	}
	bytesToShift = memStart - oldBaseAddr;
	initializeInterpreter(bytesToShift);
	return dataSize;
}

int recycleContextIfPossiblemethodContextClass(int cntxOop, int methodCntxClass) {
    int cntxHeader;
    int ccField;
    int isMethodCntx;

	/* inline: true */;
	if (cntxOop >= youngStart) {
		cntxHeader = baseHeader(cntxOop);
		ccField = cntxHeader & 126976;
		if (ccField == 0) {
			isMethodCntx = ((classHeader(cntxOop)) & 4294967292U) == methodCntxClass;
		} else {
			isMethodCntx = ccField == ((formatOfClass(methodCntxClass)) & 126976);
		}
		if (isMethodCntx) {
			if ((cntxHeader & 252) == 76) {
				storePointerUncheckedofObjectwithValue(0, cntxOop, freeSmallContexts);
				freeSmallContexts = cntxOop;
			} else {
				storePointerUncheckedofObjectwithValue(0, cntxOop, freeLargeContexts);
				freeLargeContexts = cntxOop;
			}
		}
	}
}

int remap(int oop) {
    int fwdBlock;

	/* inline: false */;
	if (isObjectForwarded(oop)) {
		fwdBlock = (longAt(oop)) & 2147483644;
		if (checkAssertions) {
			fwdBlockValidate(fwdBlock);
		}
		return longAt(fwdBlock);
	}
	return oop;
}

int remapClassOf(int oop) {
    int newClassOop;
    int fwdBlock;
    int classHeader;
    int classOop;
    int newClassHeader;

	if ((headerType(oop)) == 3) {
		return null;
	}
	classHeader = longAt(oop - 4);
	classOop = classHeader & 4294967292U;
	if (isObjectForwarded(classOop)) {
		fwdBlock = (longAt(classOop)) & 2147483644;
		if (checkAssertions) {
			fwdBlockValidate(fwdBlock);
		}
		newClassOop = longAt(fwdBlock);
		newClassHeader = newClassOop | (classHeader & 3);
		longAtput(oop - 4, newClassHeader);
		if ((oop < youngStart) && (newClassOop >= youngStart)) {
			beRootWhileForwarding(oop);
		}
	}
}

int remapFieldsAndClassOf(int oop) {
    int fwdBlock;
    int fieldOffset;
    int fieldOop;
    int newOop;

	/* inline: true */;
	fieldOffset = lastPointerWhileForwarding(oop);
	while (fieldOffset >= 4) {
		fieldOop = longAt(oop + fieldOffset);
		if (isObjectForwarded(fieldOop)) {
			fwdBlock = (longAt(fieldOop)) & 2147483644;
			if (checkAssertions) {
				fwdBlockValidate(fwdBlock);
			}
			newOop = longAt(fwdBlock);
			longAtput(oop + fieldOffset, newOop);
			if ((oop < youngStart) && (newOop >= youngStart)) {
				beRootWhileForwarding(oop);
			}
		}
		fieldOffset -= 4;
	}
	remapClassOf(oop);
}

int removeFirstLinkOfList(int aList) {
    int next;
    int first;
    int last;

	first = fetchPointerofObject(0, aList);
	last = fetchPointerofObject(1, aList);
	if (first == last) {
		storePointerofObjectwithValue(0, aList, nilObj);
		storePointerofObjectwithValue(1, aList, nilObj);
	} else {
		next = fetchPointerofObject(0, first);
		storePointerofObjectwithValue(0, aList, next);
	}
	storePointerofObjectwithValue(0, first, nilObj);
	return first;
}

int reportContexts(void) {
    int small;
    int big;
    int cntxt;

	big = 0;
	cntxt = freeLargeContexts;
	while (!(cntxt == 1)) {
		big += 1;
		cntxt = fetchWordofObject(0, cntxt);
	}
	small = 0;
	cntxt = freeSmallContexts;
	while (!(cntxt == 1)) {
		small += 1;
		cntxt = fetchWordofObject(0, cntxt);
	}
	print("Recycled contexts: ");
	printNum(small);
	print(" small, ");
	printNum(big);
	print(" large (");
	printNum((big * 156) + (small * 76));
	print(" bytes)");
	cr();
}

int restoreHeaderOf(int oop) {
    int fwdBlock;
    int fwdHeader;

	fwdHeader = longAt(oop);
	fwdBlock = fwdHeader & 2147483644;
	if (checkAssertions) {
		if ((fwdHeader & 2147483648U) == 0) {
			error("attempting to restore the header of an object that has no forwarding block");
		}
		fwdBlockValidate(fwdBlock);
	}
	longAtput(oop, longAt(fwdBlock + 4));
}

int restoreHeadersAfterBecomingwith(int list1, int list2) {
    int fieldOffset;
    int oop1;
    int oop2;

	fieldOffset = lastPointerOf(list1);
	while (fieldOffset >= 4) {
		oop1 = longAt(list1 + fieldOffset);
		oop2 = longAt(list2 + fieldOffset);
		restoreHeaderOf(oop1);
		restoreHeaderOf(oop2);
		exchangeHashBitswith(oop1, oop2);
		fieldOffset -= 4;
	}
}

int resume(int aProcess) {
    int activeProc;
    int activePriority;
    int newPriority;

	/* inline: false */;
	activeProc = fetchPointerofObject(1, schedulerPointer());
	activePriority = quickFetchIntegerofObject(2, activeProc);
	newPriority = quickFetchIntegerofObject(2, aProcess);
	if (newPriority > activePriority) {
		putToSleep(activeProc);
		transferTo(aProcess);
	} else {
		putToSleep(aProcess);
	}
}

int returnAtlastIndexlefttop(int stopIndex, int lastIndex, int left, int top) {
	stopCode = stObjectat(scanStopArray, stopIndex);
	if (failed()) {
		return null;
	}
	storeIntegerofObjectwithValue(15, bitBltOop, lastIndex);
	if (scanDisplayFlag) {
		affectedL = left;
		affectedR = bbW + dx;
		affectedT = top;
		affectedB = bbH + dy;
	}
}

int returnFalse(void) {
    int val;
    int cntx;

	cntx = sender();
	val = falseObj;
	returnValueto(val, cntx);
}

int returnNil(void) {
    int val;
    int cntx;

	cntx = sender();
	val = nilObj;
	returnValueto(val, cntx);
}

int returnReceiver(void) {
    int val;
    int cntx;

	cntx = sender();
	val = receiver;
	returnValueto(val, cntx);
}

int returnTopFromBlock(void) {
    int val;
    int cntx;

	cntx = caller();
	val = internalStackTop();
	returnValueto(val, cntx);
}

int returnTopFromMethod(void) {
    int val;
    int cntx;

	cntx = sender();
	val = internalStackTop();
	returnValueto(val, cntx);
}

int returnTrue(void) {
    int val;
    int cntx;

	cntx = sender();
	val = trueObj;
	returnValueto(val, cntx);
}

int returnValueto(int resultObj, int returnContext) {
    int methodContextClass;
    int nilOop;
    int thisCntx;
    int contextOfCaller;

	/* inline: true */;
	/* common code: commonReturn */;
	nilOop = nilObj;
	thisCntx = activeContext;
	methodContextClass = splObj(10);
	if ((returnContext == nilOop) || ((fetchPointerofObject(1, returnContext)) == nilOop)) {
		internalPush(activeContext);
		internalPush(resultObj);
		messageSelector = splObj(21);
		argumentCount = 1;
		return normalSend();
	}
	while (!(thisCntx == returnContext)) {
		contextOfCaller = fetchPointerofObject(0, thisCntx);
		storePointerUncheckedofObjectwithValue(0, thisCntx, nilOop);
		storePointerUncheckedofObjectwithValue(1, thisCntx, nilOop);
		if (reclaimableContextCount > 0) {
			reclaimableContextCount -= 1;
			recycleContextIfPossiblemethodContextClass(thisCntx, methodContextClass);
		}
		thisCntx = contextOfCaller;
	}
	activeContext = thisCntx;
	if (thisCntx < youngStart) {
		beRootIfOld(thisCntx);
	}
	internalFetchContextRegisters(thisCntx);
	internalPush(resultObj);
	internalQuickCheckForInterrupts();
}

int reverseBytesFromto(int startAddr, int stopAddr) {
    int addr;

	addr = startAddr;
	while (addr < stopAddr) {
		longAtput(addr, byteSwapped(longAt(addr)));
		addr += 4;
	}
}

int reverseBytesInImage(void) {
	reverseBytesFromto(startOfMemory(), endOfMemory);
	byteSwapByteObjects();
}

int rgbAddwith(int sourceWord, int destinationWord) {
	/* inline: false */;
	if (destPixSize < 16) {
		return partitionedAddtonBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedAddtonBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedAddtonBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedAddtonBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}

int rgbDiffwith(int sourceWord, int destinationWord) {
    int destPixVal;
    int pixMask;
    int destShifted;
    int sourceShifted;
    int sourcePixVal;
    int diff;
    int maskShifted;
    int i;
    int bitsPerColor;
    int rgbMask;

	/* inline: false */;
	pixMask = (1 << destPixSize) - 1;
	if (destPixSize == 16) {
		bitsPerColor = 5;
		rgbMask = 31;
	} else {
		bitsPerColor = 8;
		rgbMask = 255;
	}
	maskShifted = destMask;
	destShifted = destinationWord;
	sourceShifted = sourceWord;
	for (i = 1; i <= pixPerWord; i += 1) {
		if ((maskShifted & pixMask) > 0) {
			destPixVal = destShifted & pixMask;
			sourcePixVal = sourceShifted & pixMask;
			if (destPixSize < 16) {
				if (sourcePixVal == destPixVal) {
					diff = 0;
				} else {
					diff = 1;
				}
			} else {
				diff = partitionedSubfromnBitsnPartitions(sourcePixVal, destPixVal, bitsPerColor, 3);
				diff = ((diff & rgbMask) + ((((unsigned) diff) >> bitsPerColor) & rgbMask)) + ((((unsigned) (((unsigned) diff) >> bitsPerColor)) >> bitsPerColor) & rgbMask);
			}
			bitCount += diff;
		}
		maskShifted = ((unsigned) maskShifted) >> destPixSize;
		sourceShifted = ((unsigned) sourceShifted) >> destPixSize;
		destShifted = ((unsigned) destShifted) >> destPixSize;
	}
	return destinationWord;
}

int rgbMapfromto(int sourcePixel, int nBitsIn, int nBitsOut) {
    int mask;
    int srcPix;
    int destPix;
    int d;

	/* inline: true */;
	if ((d = nBitsOut - nBitsIn) > 0) {
		mask = (1 << nBitsIn) - 1;
		srcPix = sourcePixel << d;
		mask = mask << d;
		destPix = srcPix & mask;
		mask = mask << nBitsOut;
		srcPix = srcPix << d;
		return (destPix + (srcPix & mask)) + ((srcPix << d) & (mask << nBitsOut));
	} else {
		if (d == 0) {
			return sourcePixel;
		}
		if (sourcePixel == 0) {
			return sourcePixel;
		}
		d = nBitsIn - nBitsOut;
		mask = (1 << nBitsOut) - 1;
		srcPix = ((unsigned) sourcePixel) >> d;
		destPix = srcPix & mask;
		mask = mask << nBitsOut;
		srcPix = ((unsigned) srcPix) >> d;
		destPix = (destPix + (srcPix & mask)) + ((((unsigned) srcPix) >> d) & (mask << nBitsOut));
		if (destPix == 0) {
			return 1;
		}
		return destPix;
	}
}

int rgbMaxwith(int sourceWord, int destinationWord) {
	/* inline: false */;
	if (destPixSize < 16) {
		return partitionedMaxwithnBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedMaxwithnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedMaxwithnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedMaxwithnBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}

int rgbMinwith(int sourceWord, int destinationWord) {
	/* inline: false */;
	if (destPixSize < 16) {
		return partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedMinwithnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}

int rgbMinInvertwith(int wordToInvert, int destinationWord) {
    int sourceWord;

	/* inline: false */;
	sourceWord = ~wordToInvert;
	if (destPixSize < 16) {
		return partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedMinwithnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedMinwithnBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}

int rgbSubwith(int sourceWord, int destinationWord) {
	/* inline: false */;
	if (destPixSize < 16) {
		return partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, destPixSize, pixPerWord);
	}
	if (destPixSize == 16) {
		return (partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 5, 3)) + ((partitionedSubfromnBitsnPartitions(((unsigned) sourceWord) >> 16, ((unsigned) destinationWord) >> 16, 5, 3)) << 16);
	} else {
		return partitionedSubfromnBitsnPartitions(sourceWord, destinationWord, 8, 3);
	}
}

int rightType(int headerWord) {
	if ((headerWord & 252) == 0) {
		return 0;
	} else {
		if ((headerWord & 126976) == 0) {
			return 1;
		} else {
			return 3;
		}
	}
}

int scanCharacters(void) {
    int sourceX2;
    int ascii;
    int top;
    int nextDestX;
    int charVal;
    int left;
    int lastIndex;

	if (scanDisplayFlag) {
		clipRange();
		left = dx;
		top = dy;
	}
	lastIndex = scanStart;
	while (lastIndex <= scanStop) {
		charVal = stObjectat(scanString, lastIndex);
		ascii = (charVal >> 1);
		if (failed()) {
			return null;
		}
		stopCode = stObjectat(scanStopArray, ascii + 1);
		if (failed()) {
			return null;
		}
		if (!(stopCode == (nilObject()))) {
			return returnAtlastIndexlefttop(ascii + 1, lastIndex, left, top);
		}
		sourceX = stObjectat(scanXTable, ascii + 1);
		sourceX2 = stObjectat(scanXTable, ascii + 2);
		if (failed()) {
			return null;
		}
		if (((sourceX & 1)) && ((sourceX2 & 1))) {
			sourceX = (sourceX >> 1);
			sourceX2 = (sourceX2 >> 1);
		} else {
			primitiveFail();
			return null;
		}
		nextDestX = destX + (width = sourceX2 - sourceX);
		if (nextDestX > scanRightX) {
			return returnAtlastIndexlefttop(258, lastIndex, left, top);
		}
		if (scanDisplayFlag) {
			copyBits();
		}
		destX = nextDestX;
		storeIntegerofObjectwithValue(4, bitBltOop, destX);
		lastIndex += 1;
	}
	returnAtlastIndexlefttop(257, scanStop, left, top);
}

int schedulerPointer(void) {
	return fetchPointerofObject(1, splObj(3));
}

int secondExtendedSendBytecode(void) {
    int descriptor;

	descriptor = fetchByte();
	messageSelector = literal(descriptor & 63);
	argumentCount = ((unsigned) descriptor) >> 6;
	normalSend();
}

int sendLiteralSelectorBytecode(void) {
	messageSelector = literal(currentBytecode & 15);
	argumentCount = ((((unsigned) currentBytecode) >> 4) & 3) - 1;
	normalSend();
}

int sendSelectorToClass(int classPointer) {
	/* inline: true */;
	findNewMethodInClass(classPointer);
	executeNewMethod();
}

int sender(void) {
	return fetchPointerofObject(0, theHomeContext);
}

int setInterpreter(int anInterpreter) {
	interpreterProxy = anInterpreter;
}

int setSizeOfFreeto(int chunk, int byteSize) {
	longAtput(chunk, (byteSize & 536870908) | 2);
}

int shortConditionalJump(void) {
	jumplfFalseBy((currentBytecode & 7) + 1);
}

int shortUnconditionalJump(void) {
	jump((currentBytecode & 7) + 1);
}

int showDisplayBits(void) {
    int displayObj;
    int dispBits;
    int affectedRectL;
    int affectedRectR;
    int affectedRectT;
    int affectedRectB;
    int dispBitsIndex;
    int h;
    int w;
    int d;

	if (deferDisplayUpdates) {
		return null;
	}
	displayObj = splObj(14);
	if (!((targetForm()) == displayObj)) {
		return null;
	}
	success((isPointers(displayObj)) && ((lengthOf(displayObj)) >= 4));
	if (successFlag) {
		dispBits = fetchPointerofObject(0, displayObj);
		w = fetchIntegerofObject(1, displayObj);
		h = fetchIntegerofObject(2, displayObj);
		d = fetchIntegerofObject(3, displayObj);
	}
	if (successFlag) {
		affectedRectL = affectedLeft();
		affectedRectR = affectedRight();
		affectedRectT = affectedTop();
		affectedRectB = affectedBottom();
		dispBitsIndex = dispBits + 4;
		ioShowDisplay(dispBitsIndex, w, h, d, affectedRectL, affectedRectR, affectedRectT, affectedRectB);
	}
}

int signExtend16(int int16) {
	if ((int16 & 32768) == 0) {
		return int16;
	} else {
		return int16 - 65536;
	}
}

int signalSemaphoreWithIndex(int index) {
    int i;

	if (index <= 0) {
		return null;
	}
	interruptCheckCounter = 0;
	for (i = 1; i <= semaphoresToSignalCount; i += 1) {
		if ((semaphoresToSignal[i]) == index) {
			return null;
		}
	}
	if (semaphoresToSignalCount < 25) {
		semaphoresToSignalCount += 1;
		semaphoresToSignal[semaphoresToSignalCount] = index;
	}
}

int singleExtendedSendBytecode(void) {
    int descriptor;

	descriptor = fetchByte();
	messageSelector = literal(descriptor & 31);
	argumentCount = ((unsigned) descriptor) >> 5;
	normalSend();
}

int singleExtendedSuperBytecode(void) {
    int descriptor;

	descriptor = fetchByte();
	messageSelector = literal(descriptor & 31);
	argumentCount = ((unsigned) descriptor) >> 5;
	superclassSend();
}

int sizeBitsOf(int oop) {
    int header;

	header = baseHeader(oop);
	if ((header & 3) == 0) {
		return (sizeHeader(oop)) & 4294967292U;
	} else {
		return header & 252;
	}
}

int sizeBitsOfSafe(int oop) {
    int header;
    int type;

	header = baseHeader(oop);
	type = rightType(header);
	if (type == 0) {
		return (sizeHeader(oop)) & 4294967292U;
	} else {
		return header & 252;
	}
}

int sizeHeader(int oop) {
	return longAt(oop - 8);
}

int sizeOfFree(int oop) {
	return (longAt(oop)) & 536870908;
}

int sizeOfSTArrayFromCPrimitive(void *cPtr) {
    int oop;

	oop = ((int) cPtr) - 4;
	if (!(isWordsOrBytes(oop))) {
		primitiveFail();
		return 0;
	}
	return lengthOf(oop);
}

int smoothPixatXfyfdxhdyhdxvdyvpixPerWordpixelMasksourceMap(int n, int xf, int yf, int dxh, int dyh, int dxv, int dyv, int srcPixPerWord, int sourcePixMask, int sourceMap) {
    int j;
    int sourcePix;
    int b;
    int x;
    int y;
    int bitsPerColor;
    int nPix;
    int maxPix;
    int i;
    int d;
    int rgb;
    int g;
    int r;

	/* inline: false */;
	r = g = b = 0;
	maxPix = n * n;
	x = xf;
	y = yf;
	nPix = 0;
	for (i = 0; i <= (n - 1); i += 1) {
		for (j = 0; j <= (n - 1); j += 1) {
			sourcePix = (sourcePixAtXypixPerWord(((unsigned) ((x + (dxh * i)) + (dxv * j))) >> 14, ((unsigned) ((y + (dyh * i)) + (dyv * j))) >> 14, srcPixPerWord)) & sourcePixMask;
			if (!((combinationRule == 25) && (sourcePix == 0))) {
				nPix += 1;
				if (sourcePixSize < 16) {
					rgb = (fetchWordofObject(sourcePix, sourceMap)) & 16777215;
				} else {
					if (sourcePixSize == 32) {
						rgb = sourcePix & 16777215;
					} else {
						rgb = rgbMapfromto(sourcePix, 5, 8);
					}
				}
				r += (((unsigned) rgb) >> 16) & 255;
				g += (((unsigned) rgb) >> 8) & 255;
				b += rgb & 255;
			}
		}
	}
	if ((nPix == 0) || ((combinationRule == 25) && (nPix < (((int) maxPix >> 1))))) {
		return 0;
	}
	if (colorMap != (nilObject())) {
		bitsPerColor = cmBitsPerColor;
	} else {
		if (destPixSize == 16) {
			bitsPerColor = 5;
		}
		if (destPixSize == 32) {
			bitsPerColor = 8;
		}
	}
	d = 8 - bitsPerColor;
	rgb = (((((unsigned) (r / nPix)) >> d) << (bitsPerColor * 2)) + ((((unsigned) (g / nPix)) >> d) << bitsPerColor)) + (((unsigned) (b / nPix)) >> d);
	if (rgb == 0) {
		if (((r + g) + b) > 0) {
			rgb = 1;
		}
	}
	if (colorMap != (nilObject())) {
		return fetchWordofObject(rgb, colorMap);
	} else {
		return rgb;
	}
}

int socketRecordSize(void) {
	return sizeof(SQSocket);
}

SQSocket * socketValueOf(int socketOop) {
    int socketIndex;

	success((isBytes(socketOop)) && ((lengthOf(socketOop)) == (socketRecordSize())));
	if (successFlag) {
		socketIndex = socketOop + 4;
		return (SQSocket *) socketIndex;
	} else {
		return null;
	}
}

int sourcePixAtXypixPerWord(int x, int y, int srcPixPerWord) {
    int sourceWord;
    int index;

	/* inline: true */;
	if ((x < 0) || (x >= srcWidth)) {
		return 0;
	}
	if ((y < 0) || (y >= srcHeight)) {
		return 0;
	}
	index = ((y * sourceRaster) + (x / srcPixPerWord)) * 4;
	sourceWord = longAt((sourceBits + 4) + index);
	return ((unsigned) sourceWord) >> ((32 - sourcePixSize) - ((x % srcPixPerWord) * sourcePixSize));
}

int sourceSkewAndPointerInit(void) {
    int dWid;
    int sxLowBits;
    int dxLowBits;
    int pixPerM1;

	pixPerM1 = pixPerWord - 1;
	sxLowBits = sx & pixPerM1;
	dxLowBits = dx & pixPerM1;
	if (hDir > 0) {
		dWid = ((bbW < (pixPerWord - dxLowBits)) ? bbW : (pixPerWord - dxLowBits));
		preload = (sxLowBits + dWid) > pixPerM1;
	} else {
		dWid = ((bbW < (dxLowBits + 1)) ? bbW : (dxLowBits + 1));
		preload = ((sxLowBits - dWid) + 1) < 0;
	}
	skew = (sxLowBits - dxLowBits) * destPixSize;
	if (preload) {
		if (skew < 0) {
			skew += 32;
		} else {
			skew -= 32;
		}
	}
	sourceIndex = (sourceBits + 4) + (((sy * sourceRaster) + (sx / (32 / sourcePixSize))) * 4);
	sourceDelta = 4 * ((sourceRaster * vDir) - (nWords * hDir));
	if (preload) {
		sourceDelta -= 4 * hDir;
	}
}

int sourceWordwith(int sourceWord, int destinationWord) {
	return sourceWord;
}

int specialSelector(int index) {
	return fetchPointerofObject(index * 2, splObj(23));
}

int splObj(int index) {
	return fetchPointerofObject(index, specialObjectsOop);
}

int stObjectat(int array, int index) {
    int hdr;
    int totalLength;
    int fmt;
    int fixedFields;

	/* inline: false */;
	hdr = baseHeader(array);
	fmt = (((unsigned) hdr) >> 8) & 15;
	totalLength = lengthOfbaseHeaderformat(array, hdr, fmt);
	fixedFields = fixedFieldsOfformatlength(array, fmt, totalLength);
	if (!((index >= 1) && (index <= (totalLength - fixedFields)))) {
		successFlag = false;
	}
	if (successFlag) {
		return subscriptwithformat(array, index + fixedFields, fmt);
	} else {
		return 0;
	}
}

int stObjectatput(int array, int index, int value) {
    int hdr;
    int totalLength;
    int fmt;
    int fixedFields;

	/* inline: false */;
	hdr = baseHeader(array);
	fmt = (((unsigned) hdr) >> 8) & 15;
	totalLength = lengthOfbaseHeaderformat(array, hdr, fmt);
	fixedFields = fixedFieldsOfformatlength(array, fmt, totalLength);
	if (!((index >= 1) && (index <= (totalLength - fixedFields)))) {
		successFlag = false;
	}
	if (successFlag) {
		subscriptwithstoringformat(array, index + fixedFields, value, fmt);
	}
}

int stSizeOf(int oop) {
    int hdr;
    int totalLength;
    int fmt;
    int fixedFields;

	/* inline: true */;
	hdr = baseHeader(oop);
	fmt = (((unsigned) hdr) >> 8) & 15;
	totalLength = lengthOfbaseHeaderformat(oop, hdr, fmt);
	fixedFields = fixedFieldsOfformatlength(oop, fmt, totalLength);
	return totalLength - fixedFields;
}

int stackIntegerValue(int offset) {
    int integerPointer;

	integerPointer = longAt(stackPointer - (offset * 4));
	if ((integerPointer & 1)) {
		return (integerPointer >> 1);
	} else {
		primitiveFail();
		return 0;
	}
}

int stackObjectValue(int offset) {
    int oop;

	oop = longAt(stackPointer - (offset * 4));
	if ((oop & 1)) {
		primitiveFail();
		return null;
	}
	return oop;
}

int stackPointerIndex(void) {
	return ((unsigned) ((stackPointer - activeContext) - 4)) >> 2;
}

int stackTop(void) {
	return longAt(stackPointer);
}

int stackValue(int offset) {
	return longAt(stackPointer - (offset * 4));
}

int startField(void) {
    int typeBits;
    int childType;

	child = longAt(field);
	typeBits = child & 3;
	if ((typeBits & 1) == 1) {
		field -= 4;
		return 1;
	}
	if (typeBits == 0) {
		longAtput(field, parentField);
		parentField = field;
		return 2;
	}
	if (typeBits == 2) {
		if ((child & 126976) != 0) {
			child = child & 4294967292U;
			childType = rightType(child);
			longAtput(field, child | childType);
			return 3;
		} else {
			child = longAt(field - 4);
			child = child & 4294967292U;
			longAtput(field - 4, parentField);
			parentField = (field - 4) | 1;
			return 2;
		}
	}
}

int startObj(void) {
    int oop;
    int lastFieldOffset;
    int header;

	oop = child;
	if (oop < youngStart) {
		field = oop;
		return 3;
	}
	header = longAt(oop);
	if ((header & 2147483648U) == 0) {
		header = header & 4294967292U;
		header = (header | 2147483648U) | 2;
		longAtput(oop, header);
		lastFieldOffset = lastPointerOf(oop);
		field = oop + lastFieldOffset;
		return 1;
	} else {
		field = oop;
		return 3;
	}
}

int startOfMemory(void) {
	return (int) memory;
}

int stopReason(void) {
	return stopCode;
}

int storeAndPopReceiverVariableBytecode(void) {
    int top;
    int rcvr;

	rcvr = receiver;
	top = internalStackTop();
	if (rcvr < youngStart) {
		possibleRootStoreIntovalue(rcvr, top);
	}
	storePointerUncheckedofObjectwithValue(currentBytecode & 7, rcvr, top);
	internalPop(1);
}

int storeAndPopTemporaryVariableBytecode(void) {
	storePointerUncheckedofObjectwithValue((currentBytecode & 7) + 6, theHomeContext, internalStackTop());
	internalPop(1);
}

int storeByteofObjectwithValue(int byteIndex, int oop, int valueByte) {
	return byteAtput(((((char *) oop)) + 4) + byteIndex, valueByte);
}

int storeContextRegisters(int activeCntx) {
	/* inline: true */;
	storeWordofObjectwithValue(1, activeCntx, ((((instructionPointer - method) - (4 - 2)) << 1) | 1));
	storeWordofObjectwithValue(2, activeCntx, (((((stackPointerIndex()) - 6) + 1) << 1) | 1));
}

int storeInstructionPointerValueinContext(int value, int contextPointer) {
	storeWordofObjectwithValue(1, contextPointer, ((value << 1) | 1));
}

int storeIntegerofObjectwithValue(int fieldIndex, int objectPointer, int integerValue) {
	if (isIntegerValue(integerValue)) {
		storeWordofObjectwithValue(fieldIndex, objectPointer, ((integerValue << 1) | 1));
	} else {
		primitiveFail();
	}
}

int storePointerofObjectwithValue(int fieldIndex, int oop, int valuePointer) {
	if (oop < youngStart) {
		possibleRootStoreIntovalue(oop, valuePointer);
	}
	return longAtput(((((char *) oop)) + 4) + (fieldIndex << 2), valuePointer);
}

int storePointerUncheckedofObjectwithValue(int fieldIndex, int oop, int valuePointer) {
	return longAtput(((((char *) oop)) + 4) + (fieldIndex << 2), valuePointer);
}

int storeStackPointerValueinContext(int value, int contextPointer) {
	storeWordofObjectwithValue(2, contextPointer, ((value << 1) | 1));
}

int storeWordofObjectwithValue(int fieldIndex, int oop, int valueWord) {
	return longAtput(((((char *) oop)) + 4) + (fieldIndex << 2), valueWord);
}

int subWordwith(int sourceWord, int destinationWord) {
	return sourceWord - destinationWord;
}

int subscriptwithformat(int array, int index, int fmt) {
	/* inline: true */;
	if (fmt < 4) {
		return fetchPointerofObject(index - 1, array);
	}
	if (fmt < 8) {
		return positive32BitIntegerFor(fetchWordofObject(index - 1, array));
	} else {
		return (((fetchByteofObject(index - 1, array)) << 1) | 1);
	}
}

int subscriptwithstoringformat(int array, int index, int oopToStore, int fmt) {
    int valueToStore;

	/* inline: true */;
	if (fmt < 4) {
		storePointerofObjectwithValue(index - 1, array, oopToStore);
	} else {
		if (fmt < 8) {
			valueToStore = positive32BitValueOf(oopToStore);
			if (successFlag) {
				storeWordofObjectwithValue(index - 1, array, valueToStore);
			}
		} else {
			if (!((oopToStore & 1))) {
				successFlag = false;
			}
			valueToStore = (oopToStore >> 1);
			if (!((valueToStore >= 0) && (valueToStore <= 255))) {
				successFlag = false;
			}
			if (successFlag) {
				storeByteofObjectwithValue(index - 1, array, valueToStore);
			}
		}
	}
}

int success(int successValue) {
	successFlag = successValue && successFlag;
}

int sufficientSpaceAfterGC(int minFree) {
	/* inline: false */;
	incrementalGC();
	if ((sizeOfFree(freeBlock)) < minFree) {
		if (signalLowSpace) {
			return false;
		}
		fullGC();
		if ((sizeOfFree(freeBlock)) < (minFree + 15000)) {
			return false;
		}
	}
	return true;
}

int sufficientSpaceToAllocate(int bytes) {
    int minFree;

	/* inline: true */;
	minFree = (lowSpaceThreshold + bytes) + 4;
	if ((sizeOfFree(freeBlock)) >= minFree) {
		return true;
	} else {
		return sufficientSpaceAfterGC(minFree);
	}
}

int sufficientSpaceToInstantiateindexableSize(int classOop, int size) {
    int okay;
    int format;

	/* inline: true */;
	format = (((unsigned) (formatOfClass(classOop))) >> 8) & 15;
	if ((size > 0) && (format < 2)) {
		return false;
	}
	if (format < 8) {
		okay = sufficientSpaceToAllocate(2500 + (size * 4));
	} else {
		okay = sufficientSpaceToAllocate(2500 + size);
	}
	return okay;
}

int superclassOf(int classPointer) {
	return fetchPointerofObject(0, classPointer);
}

int superclassSend(void) {
    int superClass;

	/* inline: true */;
	/* common code: commonSupersend */;
	superClass = superclassOf(methodClassOf(method));
	externalizeIPandSP();
	sendSelectorToClass(superClass);
	internalizeIPandSP();
}

int sweepPhase(void) {
    int entriesAvailable;
    int survivors;
    int firstFree;
    int oopHeader;
    int oop;
    int freeChunk;
    int oopHeaderType;
    int hdrBytes;
    int oopSize;
    int freeChunkSize;

	/* inline: false */;
	entriesAvailable = fwdTableInit();
	survivors = 0;
	freeChunk = null;
	firstFree = null;
	oop = oopFromChunk(youngStart);
	while (oop < endOfMemory) {
		oopHeader = baseHeader(oop);
		oopHeaderType = oopHeader & 3;
		if (oopHeaderType == 3) {
			oopSize = oopHeader & 252;
			hdrBytes = 0;
		} else {
			if (oopHeaderType == 1) {
				oopSize = oopHeader & 252;
				hdrBytes = 4;
			} else {
				if (oopHeaderType == 0) {
					oopSize = (sizeHeader(oop)) & 4294967292U;
					hdrBytes = 8;
				} else {
					oopSize = oopHeader & 536870908;
					hdrBytes = 0;
				}
			}
		}
		if ((oopHeader & 2147483648U) == 0) {
			if (freeChunk != null) {
				freeChunkSize = (freeChunkSize + oopSize) + hdrBytes;
			} else {
				freeChunk = oop - hdrBytes;
				freeChunkSize = oopSize + (oop - freeChunk);
				if (firstFree == null) {
					firstFree = freeChunk;
				}
			}
		} else {
			longAtput(oop, oopHeader & 2147483647U);
			if (entriesAvailable > 0) {
				entriesAvailable -= 1;
			} else {
				firstFree = freeChunk;
			}
			if (freeChunk != null) {
				longAtput(freeChunk, (freeChunkSize & 536870908) | 2);
			}
			freeChunk = null;
			survivors += 1;
		}
		oop = oopFromChunk(oop + oopSize);
	}
	if (freeChunk != null) {
		longAtput(freeChunk, (freeChunkSize & 536870908) | 2);
	}
	if (!(oop == endOfMemory)) {
		error("sweep failed to find exact end of memory");
	}
	if (firstFree == null) {
		error("expected to find at least one free object");
	} else {
		compStart = firstFree;
	}
	if (!(displayBits == 0)) {
		oopHeader = baseHeader(displayBits);
		longAtput(displayBits, oopHeader & 2147483647U);
	}
	return survivors;
}

int synchronousSignal(int aSemaphore) {
    int excessSignals;

	/* inline: false */;
	if (isEmptyList(aSemaphore)) {
		excessSignals = fetchIntegerofObject(2, aSemaphore);
		storeIntegerofObjectwithValue(2, aSemaphore, excessSignals + 1);
	} else {
		resume(removeFirstLinkOfList(aSemaphore));
	}
}

int tallyIntoMapwith(int sourceWord, int destinationWord) {
    int pixVal;
    int mapIndex;
    int pixMask;
    int destShifted;
    int maskShifted;
    int i;

	/* inline: false */;
	if (colorMap == (nilObject())) {
		return destinationWord;
	}
	pixMask = (1 << destPixSize) - 1;
	destShifted = destinationWord;
	maskShifted = destMask;
	for (i = 1; i <= pixPerWord; i += 1) {
		if ((maskShifted & pixMask) > 0) {
			pixVal = destShifted & pixMask;
			if (destPixSize < 16) {
				mapIndex = pixVal;
			} else {
				if (destPixSize == 16) {
					mapIndex = rgbMapfromto(pixVal, 5, cmBitsPerColor);
				} else {
					mapIndex = rgbMapfromto(pixVal, 8, cmBitsPerColor);
				}
			}
			storeWordofObjectwithValue(mapIndex, colorMap, (fetchWordofObject(mapIndex, colorMap)) + 1);
		}
		maskShifted = ((unsigned) maskShifted) >> destPixSize;
		destShifted = ((unsigned) destShifted) >> destPixSize;
	}
	return destinationWord;
}

int targetForm(void) {
	return destForm;
}

int temporary(int offset) {
	return fetchPointerofObject(offset + 6, theHomeContext);
}

int transferfromIndexofObjecttoIndexofObject(int count, int firstFrom, int fromOop, int firstTo, int toOop) {
    int toIndex;
    int fromIndex;
    int lastFrom;

	/* inline: true */;
	fromIndex = fromOop + (firstFrom * 4);
	toIndex = toOop + (firstTo * 4);
	lastFrom = fromIndex + (count * 4);
	while (fromIndex < lastFrom) {
		fromIndex += 4;
		toIndex += 4;
		longAtput(toIndex, longAt(fromIndex));
	}
}

int transferTo(int newProc) {
    int sched;
    int oldProc;

	sched = schedulerPointer();
	oldProc = fetchPointerofObject(1, sched);
	storePointerofObjectwithValue(1, oldProc, activeContext);
	storePointerofObjectwithValue(1, sched, newProc);
	newActiveContext(fetchPointerofObject(1, newProc));
	reclaimableContextCount = 0;
}

int unPop(int nItems) {
	stackPointer += nItems * 4;
}

int unknownBytecode(void) {
	error("Unknown bytecode");
}

int upward(void) {
    int header;
    int type;

	if ((parentField & 1) == 1) {
		if (parentField == 3) {
			header = (longAt(field)) & 4294967292U;
			type = rightType(header);
			longAtput(field, header + type);
			return 4;
		} else {
			child = field;
			field = parentField - 1;
			parentField = longAt(field);
			header = longAt(field + 4);
			type = rightType(header);
			longAtput(field, child + type);
			field += 4;
			header = header & 4294967292U;
			longAtput(field, header + type);
			return 3;
		}
	} else {
		child = field;
		field = parentField;
		parentField = longAt(field);
		longAtput(field, child);
		field -= 4;
		return 1;
	}
}

int wakeHighestPriority(void) {
    int schedLists;
    int processList;
    int p;

	schedLists = fetchPointerofObject(0, schedulerPointer());
	p = fetchWordLengthOf(schedLists);
	p -= 1;
	processList = fetchPointerofObject(p, schedLists);
	while (isEmptyList(processList)) {
		p -= 1;
		if (p < 0) {
			error("scheduler could not find a runnable process");
		}
		processList = fetchPointerofObject(p, schedLists);
	}
	return removeFirstLinkOfList(processList);
}

int warpBits(void) {
    int ns;

	ns = noSource;
	noSource = true;
	clipRange();
	noSource = ns;
	if (noSource || ((bbW <= 0) || (bbH <= 0))) {
		affectedL = affectedR = affectedT = affectedB = 0;
		return null;
	}
	destMaskAndPointerInit();
	warpLoop();
	if (hDir > 0) {
		affectedL = dx;
		affectedR = dx + bbW;
	} else {
		affectedL = (dx - bbW) + 1;
		affectedR = dx + 1;
	}
	if (vDir > 0) {
		affectedT = dy;
		affectedB = dy + bbH;
	} else {
		affectedT = (dy - bbH) + 1;
		affectedB = dy + 1;
	}
}

int warpLoop(void) {
    int skewWord;
    int mergeWord;
    int startBits;
    int yDelta;
    int smoothingCount;
    int sourceMapOop;
    int t;
    int i;
    int nSteps;
    int word;
    int halftoneWord;
    int deltaP12x;
    int deltaP12y;
    int deltaP43x;
    int deltaP43y;
    int pAx;
    int pAy;
    int pBx;
    int xDelta;
    int pBy;

	if (!((fetchWordLengthOf(bitBltOop)) >= (15 + 12))) {
		return primitiveFail();
	}
	nSteps = height - 1;
	if (nSteps <= 0) {
		nSteps = 1;
	}
	pAx = fetchIntegerOrTruncFloatofObject(15, bitBltOop);
	t = fetchIntegerOrTruncFloatofObject(15 + 3, bitBltOop);
	deltaP12x = deltaFromtonSteps(pAx, t, nSteps);
	if (deltaP12x < 0) {
		pAx = t - (nSteps * deltaP12x);
	}
	pAy = fetchIntegerOrTruncFloatofObject(15 + 1, bitBltOop);
	t = fetchIntegerOrTruncFloatofObject(15 + 4, bitBltOop);
	deltaP12y = deltaFromtonSteps(pAy, t, nSteps);
	if (deltaP12y < 0) {
		pAy = t - (nSteps * deltaP12y);
	}
	pBx = fetchIntegerOrTruncFloatofObject(15 + 9, bitBltOop);
	t = fetchIntegerOrTruncFloatofObject(15 + 6, bitBltOop);
	deltaP43x = deltaFromtonSteps(pBx, t, nSteps);
	if (deltaP43x < 0) {
		pBx = t - (nSteps * deltaP43x);
	}
	pBy = fetchIntegerOrTruncFloatofObject(15 + 10, bitBltOop);
	t = fetchIntegerOrTruncFloatofObject(15 + 7, bitBltOop);
	deltaP43y = deltaFromtonSteps(pBy, t, nSteps);
	if (deltaP43y < 0) {
		pBy = t - (nSteps * deltaP43y);
	}
	if (failed()) {
		return false;
	}
	if ((argCount()) == 2) {
		smoothingCount = stackIntegerValue(1);
		sourceMapOop = stackValue(0);
		if (sourceMapOop == (nilObject())) {
			if (sourcePixSize < 16) {
				return primitiveFail();
			}
		} else {
			if ((fetchWordLengthOf(sourceMapOop)) < (1 << sourcePixSize)) {
				return primitiveFail();
			}
		}
	} else {
		smoothingCount = 1;
		sourceMapOop = nilObject();
	}
	startBits = pixPerWord - (dx & (pixPerWord - 1));
	nSteps = width - 1;
	if (nSteps <= 0) {
		nSteps = 1;
	}
	for (i = destY; i <= (clipY - 1); i += 1) {
		pAx += deltaP12x;
		pAy += deltaP12y;
		pBx += deltaP43x;
		pBy += deltaP43y;
	}
	for (i = 1; i <= bbH; i += 1) {
		xDelta = deltaFromtonSteps(pAx, pBx, nSteps);
		if (xDelta >= 0) {
			sx = pAx;
		} else {
			sx = pBx - (nSteps * xDelta);
		}
		yDelta = deltaFromtonSteps(pAy, pBy, nSteps);
		if (yDelta >= 0) {
			sy = pAy;
		} else {
			sy = pBy - (nSteps * yDelta);
		}
		for (word = destX; word <= (clipX - 1); word += 1) {
			sx += xDelta;
			sy += yDelta;
		}
		if (noHalftone) {
			halftoneWord = 4294967295U;
		} else {
			halftoneWord = longAt(halftoneBase + ((((dy + i) - 1) % halftoneHeight) * 4));
		}
		destMask = mask1;
		if (bbW < startBits) {
			skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(bbW, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
			skewWord = ((((startBits - bbW) * destPixSize) < 0) ? ((unsigned) skewWord >> -((startBits - bbW) * destPixSize)) : ((unsigned) skewWord << ((startBits - bbW) * destPixSize)));
		} else {
			skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(startBits, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
		}
		for (word = 1; word <= nWords; word += 1) {
			mergeWord = mergewith(skewWord & halftoneWord, (longAt(destIndex)) & destMask);
			longAtput(destIndex, (destMask & mergeWord) | ((~destMask) & (longAt(destIndex))));
			destIndex += 4;
			if (word >= (nWords - 1)) {
				if (!(word == nWords)) {
					destMask = mask2;
					skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(pixPerWord, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
				}
			} else {
				destMask = 4294967295U;
				skewWord = warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(pixPerWord, xDelta, yDelta, deltaP12x, deltaP12y, smoothingCount, sourceMapOop);
			}
		}
		pAx += deltaP12x;
		pAy += deltaP12y;
		pBx += deltaP43x;
		pBy += deltaP43y;
		destIndex += destDelta;
	}
}

int warpSourcePixelsxDeltahyDeltahxDeltavyDeltavsmoothingsourceMap(int nPix, int xDeltah, int yDeltah, int xDeltav, int yDeltav, int n, int sourceMapOop) {
    int destWord;
    int sourcePix;
    int sourcePixMask;
    int destPixMask;
    int srcPixPerWord;
    int destPix;
    int i;

	/* inline: false */;
	if (sourcePixSize == 32) {
		sourcePixMask = -1;
	} else {
		sourcePixMask = (1 << sourcePixSize) - 1;
	}
	if (destPixSize == 32) {
		destPixMask = -1;
	} else {
		destPixMask = (1 << destPixSize) - 1;
	}
	srcPixPerWord = 32 / sourcePixSize;
	destWord = 0;
	for (i = 1; i <= nPix; i += 1) {
		if (n > 1) {
			destPix = (smoothPixatXfyfdxhdyhdxvdyvpixPerWordpixelMasksourceMap(n, sx, sy, xDeltah / n, yDeltah / n, xDeltav / n, yDeltav / n, srcPixPerWord, sourcePixMask, sourceMapOop)) & destPixMask;
		} else {
			sourcePix = (sourcePixAtXypixPerWord(((unsigned) sx) >> 14, ((unsigned) sy) >> 14, srcPixPerWord)) & sourcePixMask;
			if (colorMap == (nilObject())) {
				if (destPixSize == sourcePixSize) {
					destPix = sourcePix;
				} else {
					if (sourcePixSize >= 16) {
						if (sourcePixSize == 16) {
							destPix = rgbMapfromto(sourcePix, 5, 8);
						} else {
							destPix = rgbMapfromto(sourcePix, 8, 5);
						}
					} else {
						destPix = sourcePix & destPixMask;
					}
				}
			} else {
				if (sourcePixSize >= 16) {
					if (sourcePixSize == 16) {
						sourcePix = rgbMapfromto(sourcePix, 5, cmBitsPerColor);
					} else {
						sourcePix = rgbMapfromto(sourcePix, 8, cmBitsPerColor);
					}
				}
				destPix = (fetchWordofObject(sourcePix, colorMap)) & destPixMask;
			}
		}
		destWord = (destWord << destPixSize) | destPix;
		sx += xDeltah;
		sy += yDeltah;
	}
	return destWord;
}

int writeImageFile(int imageBytes) {
    sqImageFile f;
    int i;
    int bytesWritten;
    int headerStart;
    int headerSize;

	headerStart = 0;
	headerSize = 64;
	f = sqImageFileOpen(imageName, "wb");
	if (f == null) {
		success(false);
		return null;
	}
	/* Note: on Unix systems one could put an exec command here, padded to 512 bytes */;
	sqImageFileSeek(f, headerStart);
	putLongtoFile(imageFormatVersion(), f);
	putLongtoFile(headerSize, f);
	putLongtoFile(imageBytes, f);
	putLongtoFile(startOfMemory(), f);
	putLongtoFile(specialObjectsOop, f);
	putLongtoFile(lastHash, f);
	putLongtoFile(ioScreenSize(), f);
	putLongtoFile(fullScreenFlag, f);
	for (i = 1; i <= 8; i += 1) {
		putLongtoFile(0, f);
	}
	if (!(successFlag)) {
		sqImageFileClose(f);
		return null;
	}
	sqImageFileSeek(f, headerStart + headerSize);
	bytesWritten = sqImageFileWrite(memory, sizeof(unsigned char), imageBytes, f);
	success(bytesWritten == imageBytes);
	sqImageFileClose(f);
	dir_SetMacFileTypeAndCreator(imageName, strlen(imageName), "STim", "FAST");
}
