'From Squeak 2.2 of Sept 23, 1998 on 20 December 1998 at 12:59:53 pm'!
Object subclass: #EmbeddedSystem
	instanceVariableNames: ''
	classVariableNames: 'EmbeddedProcess EmbeddedSerialPort '
	poolDictionaries: ''
	category: 'Embedded-Support'!
!EmbeddedSystem commentStamp: '<historical>' prior: 0!
Originally developed by Paul Fernhout
(pdfernhout@kurtz-fernhout.com)
http://www.kurtz-fernhout.com
Put under the Squeak license as a base class.!


"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

EmbeddedSystem class
	instanceVariableNames: ''!

!EmbeddedSystem class methodsFor: 'input processing' stamp: 'pdf 12/20/1998 07:31'!
addCharacter: character toLine: line

character asInteger == 8 ifTrue: 
	[line size <= 1 ifTrue: [^String new].
	^line copyFrom: 1 to: line size - 1].
^line , character asString.
! !

!EmbeddedSystem class methodsFor: 'input processing' stamp: 'pdf 12/20/1998 07:27'!
collectInputLine
	| line character |
	line := String new.
	[true]
		whileTrue: 
			[character := self readCharacter.
			character notNil ifTrue:
                 [
			  character == Character cr ifTrue: [^line].
			  self echoCharacter: character.
			  line := self addCharacter: character toLine: line.
			].
			Processor yield].
	^line! !

!EmbeddedSystem class methodsFor: 'input processing' stamp: 'pdf 12/19/1998 21:34'!
evaluateString: aString

"| aString |
aString := 'xxxx [[[ foo'."

	^[(Compiler evaluate: aString) printString] ifError: [:err :rcvr | err printString].


! !

!EmbeddedSystem class methodsFor: 'input processing' stamp: 'pdf 12/20/1998 06:59'!
forkProcessInputAndReportProcess

	self embeddedProcess: [self processInputAndReport] newProcess.
	self embeddedProcess priority: Processor userSchedulingPriority.
	self embeddedProcessResume.
! !

!EmbeddedSystem class methodsFor: 'input processing' stamp: 'pdf 12/19/1998 12:56'!
processInputAndReport

	[true] whileTrue: [self processInputLine].
! !

!EmbeddedSystem class methodsFor: 'input processing' stamp: 'pdf 12/20/1998 07:23'!
processInputLine
	| inputLine |
	self serialPort nextPutAll: 'Squeak>>'.
	inputLine := self collectInputLine.
	"self report: inputLine printString."
	self reportCR.
	[self report: (self evaluateString: inputLine).
	self reportCR.] fork.
	Processor yield.! !


!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 07:01'!
echoCharacter: aCharacter
	self serialPort nextPutAll: aCharacter asString.
! !

!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 07:16'!
readCharacter
	"Answer a character read from a serial port. Answer nil if no data is available. The port must be open."

	| buf count |
	buf _ String new: 2.
	count _ self serialPort primReadPort: self serialPortDefaultPortNumber into: buf startingAt: 1 count: 1.
     count == 0 ifTrue: [^nil].
	^ (buf at: 1) asCharacter
! !

!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 06:28'!
serialPort

^EmbeddedSerialPort! !

!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 06:31'!
serialPortDefaultBaudRate

^115200.
! !

!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 10:21'!
serialPortDefaultPortNumber

^ 2.! !

!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 10:40'!
serialPortFinalize

self serialPort notNil ifTrue: 
	[self serialPort close.
	EmbeddedSerialPort := nil.]
! !

!EmbeddedSystem class methodsFor: 'serial port handling' stamp: 'pdf 12/20/1998 06:31'!
serialPortInitialize

EmbeddedSerialPort := SerialPort new.
self serialPort baudRate: self serialPortDefaultBaudRate.
self serialPort openPort: self serialPortDefaultPortNumber.
! !


!EmbeddedSystem class methodsFor: 'reporting' stamp: 'pdf 12/20/1998 06:43'!
report: aStringOrByteArray

	"Send the given bytes out this serial port (kludged to printf in VM). For embedded reporting."
	self serialPort nextPutAll: aStringOrByteArray.! !

!EmbeddedSystem class methodsFor: 'reporting' stamp: 'pdf 12/19/1998 12:35'!
reportCR

self report: Character cr asString, Character lf asString.! !


!EmbeddedSystem class methodsFor: 'start up / shut down' stamp: 'pdf 12/20/1998 10:44'!
setPreferencesForEmbeddedSystem

Preferences 
		enable: #embeddedSystem;	
		disable: #cautionBeforeClosing;	
		disable: #confirmFirstUseOfStyle;
		enable: #disableSounds;
		disable: #logDebuggerStackToFile;
		disable: #warnIfNoChangesFile;
		disable: #warnIfNoSourcesFile.! !

!EmbeddedSystem class methodsFor: 'start up / shut down' stamp: 'pdf 12/20/1998 11:17'!
shutDown

(Preferences valueOfFlag: #embeddedSystem)  ifFalse: [^self].
self embeddedProcessTerminate.
self serialPortFinalize.! !

!EmbeddedSystem class methodsFor: 'start up / shut down' stamp: 'pdf 12/20/1998 12:59'!
startUp

"EmbeddedSystem startUp"
"EmbeddedSystem shutDown."

"(Preferences valueOfFlag: #embeddedSystem)  ifFalse: [^self]."
self setPreferencesForEmbeddedSystem.
self beep.
self serialPortInitialize.
self report: 'Starting Embedded Squeak (Squeak-e)...'.
self reportCR.
self forkProcessInputAndReportProcess.! !


!EmbeddedSystem class methodsFor: 'image preparing' stamp: 'pdf 12/20/1998 10:29'!
prepareImageHeaderFile

|file count first lines outputFile |
file := FileStream readOnlyFileNamed: 'embedded.image'.
outputFile := FileStream newFileNamed: 'ImageFileInMemory.c'.
count := 0.
first := true.
lines := 0.
outputFile nextPutAll: 'unsigned char ImageFileInMemory[] = {'; cr; nextPut: Character lf.
file do: [:each | 
      first 
		ifTrue: [first := false]
		ifFalse: [outputFile nextPutAll: ','].
	outputFile nextPutAll: each asInteger printString.
	count := count + 1.
	count == 30 ifTrue: 
		[outputFile nextPutAll: ','.
		outputFile cr; nextPut: Character lf. 
		first := true. 
		count := 0. 
		lines := lines + 1.
		lines \\ 30 == 0 ifTrue: [Transcript show: (lines * 30) printString; cr.]. 
		].
	].
outputFile nextPutAll: '};'.


! !


!EmbeddedSystem class methodsFor: 'process handling' stamp: 'pdf 12/20/1998 06:40'!
embeddedProcess

^EmbeddedProcess! !

!EmbeddedSystem class methodsFor: 'process handling' stamp: 'pdf 12/20/1998 06:40'!
embeddedProcess: aProcess

EmbeddedProcess := aProcess! !

!EmbeddedSystem class methodsFor: 'process handling' stamp: 'pdf 12/20/1998 06:42'!
embeddedProcessResume

self embeddedProcess resume.! !

!EmbeddedSystem class methodsFor: 'process handling' stamp: 'pdf 12/20/1998 06:42'!
embeddedProcessSuspend

self embeddedProcess suspend.! !

!EmbeddedSystem class methodsFor: 'process handling' stamp: 'pdf 12/20/1998 06:47'!
embeddedProcessTerminate

"EmbeddedSystem embeddedProcessTerminate"

self embeddedProcess isNil ifTrue: [^self].
self embeddedProcess terminate.
self embeddedProcess: nil.! !
