#include "sq.h"

/***
	The state of a file is kept in the following structure,
	which is stored directly in a Squeak bytes object.
	NOTE: The Squeak side is responsible for creating an
	object with enough room to store sizeof(SQFile) bytes.

	The session ID is used to detect stale file objects--
	files that were still open when an image was written.
	The file pointer of such files is meaningless.

	Files are always opened in binary mode; Smalltalk code
	does (or someday will do) line-end conversion if needed.

	Writeable files are opened read/write. The stdio spec
	requires that a positioning operation be done when
	switching between reading and writing of a read/write
	filestream. The lastOp field records whether the last
	operation was a read or write operation, allowing this
	positioning operation to be done automatically if needed.

	typedef struct {
		File	*file;
		int		sessionID;
		int		writable;
		int		fileSize;
		int		lastOp;  // 0 = uncommitted, 1 = read, 2 = write //
	} SQFile;

***/

/*** Constants ***/
#define UNCOMMITTED	0
#define READ_OP		1
#define WRITE_OP	2

#ifndef SEEK_SET
#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2
#endif

#define STUBBED_OUT { success(false); }

/*** Variables ***/
int thisSession = 0;

int sqFileAtEnd(SQFile *f) STUBBED_OUT

int sqFileClose(SQFile *f) STUBBED_OUT

int sqFileDeleteNameSize(int sqFileNameIndex, int sqFileNameSize) STUBBED_OUT

int sqFileGetPosition(SQFile *f) STUBBED_OUT

int sqFileInit(void) {
	/* Create a session ID that is unlikely to be repeated.
	   Zero is never used for a valid session number.
	   Should be called once at startup time.
	*/

//	thisSession = clock() + time(NULL);
//	if (thisSession == 0) thisSession = 1;	/* don't use 0 */
}

int sqFileOpen(SQFile *f, int sqFileNameIndex, int sqFileNameSize, int writeFlag) 
	{
	f->sessionID = 0;
	f->fileSize = 0;
	return success(false);
	}

int sqFileReadIntoAt(SQFile *f, int count, int byteArrayIndex, int startIndex) STUBBED_OUT

int sqFileRenameOldSizeNewSize(int oldNameIndex, int oldNameSize, int newNameIndex, int newNameSize) STUBBED_OUT

int sqFileSetPosition(SQFile *f, int position) STUBBED_OUT

int sqFileSize(SQFile *f) STUBBED_OUT

int sqFileValid(SQFile *f) 
	{
	return success(false);
	}

int sqFileWriteFromAt(SQFile *f, int count, int byteArrayIndex, int startIndex) STUBBED_OUT
